/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.CASRewriter;
import chemaxon.naming.n2s.lex.data.AminoAcidStr;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.BridgeStr;
import chemaxon.naming.n2s.lex.data.EndingToken;
import chemaxon.naming.n2s.lex.data.EtherStr;
import chemaxon.naming.n2s.lex.data.HydrazoneStr;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.NonStdValenceLocant;
import chemaxon.naming.n2s.lex.data.Number;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.SpecialStr;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.Acetal;
import chemaxon.naming.n2s.parse.AggregateStr;
import chemaxon.naming.n2s.parse.BenzoFusedStr;
import chemaxon.naming.n2s.parse.Bridge;
import chemaxon.naming.n2s.parse.Compound;
import chemaxon.naming.n2s.parse.Cycle;
import chemaxon.naming.n2s.parse.EsterStr;
import chemaxon.naming.n2s.parse.FusedStr;
import chemaxon.naming.n2s.parse.HantzschWidmanStr;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.naming.n2s.parse.HeteroChainStr;
import chemaxon.naming.n2s.parse.MonoCyclicSpiroSytem;
import chemaxon.naming.n2s.parse.MultipliedSpiroStr;
import chemaxon.naming.n2s.parse.MultipliedSystemStr;
import chemaxon.naming.n2s.parse.ParserUtilLegacy;
import chemaxon.naming.n2s.parse.PhenoIneStr;
import chemaxon.naming.n2s.parse.PolyCyclicSpiroSystem;
import chemaxon.naming.n2s.parse.PolyMethylene;
import chemaxon.naming.n2s.parse.Radical;
import chemaxon.naming.n2s.parse.SaltEnding;
import chemaxon.naming.n2s.parse.SecChainStr;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.naming.n2s.parse.TertChainStr;
import chemaxon.naming.n2s.parse.VonBaeyerStr;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class RevolutionParser {
    public static boolean debug = false;
    final Rewriter[] rewriters = new Rewriter[]{new LocantEater(), new NumberGreekRewriter(), new SpiroLocantsBeforeLocants(), new ComplexSpiro(), new BracketRewriter(), new Epi(), new AcidModifier(), new Tolyl(), new AcidAmide(), new Carbox(), new Methylene(), new MethyleneDioxy(), new EthyleneGlycol(), new Phosphoro(), new CasMultiplierAtEnd(), new MultiplierDash(), new OxyRewriter(), new AtomModifierRewriter().pass(1), new Disulfide(), new Hydrogen(), new DoubleLocantBeforeRewriter(), new HeteroChainRewriter(), new PhenoIne(), new HeterAnthrene(), new SpecialPolyFused(), new FusedLocantsBeforeLocants(), new BenzoFused(), new HantzschWidman(), new AnnuleneRewriter(), new Ano(), new SecTert(), new Cyclo(), new Fused(), new SimpleSpiro(), new ComplexSpiro(), new SpiroMulStruct(), new MultiplierDashRemover(), new Biphenyl(), new LocantsBeforeRewriter().pass(0), new StereoRewriter().pass(1), new HydroRewriter(), new IndicatedHydroRewriter(), new EndingWithoutLocant(), new EndingWithLocant(), new AtomModifierRewriter().pass(2), new SubstituentWithLocant().pass(0), new SubstituentWithoutLocant().pass(0), new StereoRewriter().pass(2), new ExplicitSalt(), new SaltRewriter(), new MultipliedSystemRewriter(), new AggregateRewriter(), new ExplicitEster().pass(1), new ImplicitEsterRewriter(), new DiDiEther(), new SpaceClass(), new AlcoholRewriter(), new StructureSuffixRewriter(), new SuffixWithHydro(), new Ion(), new Lambda(), new MultipliedAcid(), new NumberAsChain(), new EndingAsStructure(), new DashRemover(), new NbSpRemover(), new MonoRemover(), new MultipliedStructureAfter().pass(0), new Poly(), new ThiolBreaker(), new Benzo(), new Mustard(), new LocantsBeforeRewriter().pass(1), new AcetalRw(), new MultipliedStructure(), new DetachedSubstituent(), new DetachedSuffix(), new SpaceSubstituent(), new BracketRewriter().pass(2), new BracketedLocants(), new SubLocantInsideBrackets(), new LocantsBeforeRewriter().pass(2), new SubstituentWithLocant().pass(1), new LocantsBeforeRewriter().pass(3), new ExplicitEster().pass(2), new MultipliedStructureAfter().pass(1), new SubstituentWithoutLocant().pass(1), new BracketRemover(), new IndicatedHydrogenSwapper(), new SpaceClass().pass(2), new StereoAtRadical()};
    private Rewriter lastRewriter;
    List<Str> components = new ArrayList<Str>();
    static final String nbsp = "\u200b";
    public static final int NO_MUL = -1;

    private Str parse0(ArrayList<Token> tokens) {
        String initialList = tokens.toString();
        do {
            this.debugPrintStep(tokens);
        } while (this.rewriteOnce(tokens, false));
        if (tokens.size() == 1) {
            return (Str)tokens.get(0);
        }
        if (tokens.size() >= 2 || tokens.size() == 1) {
            throw new NameImportException.ParseException("Could not parse: " + tokens + " in " + initialList);
        }
        return null;
    }

    private void debugPrintStep(ArrayList<Token> tokens) {
        if (debug) {
            System.out.println(tokens + (this.lastRewriter == null ? "" : " <- " + this.lastRewriter.getName()));
        }
    }

    public Str parse(ArrayList<Token> tokens, boolean dataMining) {
        Str res = Compound.parseRatio(tokens = new CASRewriter(tokens, dataMining).reorder(), dataMining);
        if (res != null) {
            return res;
        }
        res = this.parse0(tokens);
        if (res != null) {
            this.components.add(res);
        }
        for (Str s : this.components) {
            s.isRoot = true;
            if (!debug) continue;
            System.out.println(s.display());
        }
        if (this.components.size() == 1) {
            return this.components.get(0);
        }
        return new AggregateStr(this.components);
    }

    boolean rewriteOnce(ArrayList<Token> tokens, boolean insideBrackets) {
        if (tokens.isEmpty()) {
            return false;
        }
        if (tokens.get(tokens.size() - 1) instanceof Str) {
            ((Str)tokens.get((int)(tokens.size() - 1))).isRoot = true;
        }
        for (Rewriter w : this.rewriters) {
            if (!w.rewriteSomewhere(tokens, insideBrackets)) continue;
            ++Rewriter.applications;
            if (w.outsideComponent != null) {
                this.components.add(w.outsideComponent);
            }
            if (!(w instanceof BracketRewriter)) {
                this.lastRewriter = w;
            }
            return true;
        }
        return false;
    }

    static int parseHeteros(List<Token> tokens, int cur, ArrayList<HeteroAtomStr> heteros) {
        while (true) {
            if (RevolutionParser.name(tokens, cur, "imid")) {
                heteros.add(new HeteroAtomStr("imid", 7));
            } else if (cur == 0 && (RevolutionParser.name(tokens, cur, "pyr") || RevolutionParser.name(tokens, cur, "pyrr"))) {
                heteros.add(new HeteroAtomStr(tokens.get(cur).getName(), 7));
            } else {
                int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur));
                if (mul == -1) {
                    mul = 1;
                } else {
                    String name = tokens.get(cur).getName();
                    if (name.endsWith("s") || name.equals("bi")) {
                        return -1;
                    }
                    ++cur;
                }
                if (RevolutionParser.get(tokens, cur) instanceof Str) {
                    Str atom = (Str)tokens.get(cur);
                    if (!(atom.isMonoAtomic() || atom.is("azo") || atom.is("thi"))) {
                        return -1;
                    }
                    if (atom.getValue().startsWith("C") || atom.is("oxy") || atom.is("hydroxy") || atom.getValue().indexOf("Radical:") != -1) {
                        return -1;
                    }
                    if (atom.isModified()) {
                        return -1;
                    }
                    String name = atom.getName();
                    if (!atom.is("thio") && !atom.is("azo") && name.endsWith("o")) {
                        return -1;
                    }
                    for (int i = 0; i < mul; ++i) {
                        HeteroAtomStr a = atom.is("azo") ? new HeteroAtomStr("azo", 7) : (atom.is("thi") ? new HeteroAtomStr("thi", 16) : HeteroAtomStr.create(atom));
                        heteros.add(a);
                    }
                } else {
                    if (mul > 1) {
                        return -1;
                    }
                    return cur;
                }
            }
            ++cur;
        }
    }

    public static boolean setLocants(ArrayList<HeteroAtomStr> heteros, LocantList locants, int ringSize) {
        if (locants != null) {
            locants = locants.expandOMP(heteros.size());
            if (heteros.size() != locants.size()) {
                return false;
            }
        } else if (heteros.size() == 2 && ringSize == 6) {
            locants = LocantList.simpleList(1, 4);
        } else if (heteros.size() == 2 && ringSize > 3) {
            locants = LocantList.simpleList(1, 3);
        } else if (heteros.size() == 3 && ringSize == 6) {
            locants = LocantList.simpleList(1, 3, 5);
        }
        int locant = 0;
        for (HeteroAtomStr a : heteros) {
            Locant locant2;
            if (locants != null) {
                locant2 = locants.getLocant(locant++);
            } else {
                ++locant;
                locant2 = new SimpleLocant(locant);
            }
            Locant l = locant2;
            a.setLocantInParent(l);
        }
        return true;
    }

    static boolean stereo(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList locants = (LocantList)t;
        if (locants.getType() != 12) {
            return false;
        }
        for (Locant l : locants.getLocantsList()) {
            if (l instanceof StereoNumber) continue;
            return false;
        }
        return true;
    }

    public void printStats() {
        for (Rewriter w : this.rewriters) {
            System.out.println(w.getName() + "\t" + Rewriter.applications + " apps");
        }
    }

    static boolean cannotBeParent(Token t) {
        if (t.cannotBeParent()) {
            return true;
        }
        String name = t.getName();
        return name.equals("epi") || name.equals("hydroxy") || name.equals("oxo") || name.equals("oxa") || name.equals("thioxo") || name.equals("chloro") || name.equals("iodo") || name.equals("bromo") || name.equals("fluoro") || name.equals("imido") || name.equals("nitro") || name.equals("nitroso") || name.equals("cyano");
    }

    static boolean cannotHaveSuffix(Token t) {
        if (RevolutionParser.cannotBeParent(t)) {
            return true;
        }
        return t.is("oxo") || t.is("oxy");
    }

    static Token get(List<Token> tokens, int i) {
        if (i < tokens.size()) {
            return tokens.get(i);
        }
        return null;
    }

    static boolean shouldReplaceSuffix(String suffix, String defaultSuffix) {
        if (suffix.equals(defaultSuffix)) {
            return true;
        }
        return suffix.startsWith("yl") && defaultSuffix.startsWith("yl");
    }

    static Suffix suffix(EndingToken ending, LocantList locants, int multiplier) {
        return Suffix.create(ending, locants, multiplier);
    }

    static boolean sep(Token t, String separator) {
        if (!(t instanceof Separator)) {
            return false;
        }
        String name = ((Separator)t).getName();
        return name.equals(separator);
    }

    static boolean val(List<Token> l, int rank, String val) {
        Token t = RevolutionParser.get(l, rank);
        if (t == null) {
            return false;
        }
        return t.isVal(val);
    }

    static boolean name(List<Token> l, int rank, String name) {
        return RevolutionParser.name(RevolutionParser.get(l, rank), name);
    }

    static boolean name(Token t, String name) {
        if (t == null) {
            return false;
        }
        return UtilLegacy.isName(t.getName(), name);
    }

    static boolean tok(Token t, String name) {
        if (t == null) {
            return false;
        }
        return t.getName().equals(name);
    }

    static boolean hetero(List<Token> l, int rank) {
        return RevolutionParser.hetero(RevolutionParser.get(l, rank));
    }

    static boolean hetero(Token t) {
        if (!(t instanceof Str)) {
            return false;
        }
        if (t.is("thi")) {
            return true;
        }
        if (t.is("meth")) {
            return false;
        }
        Str st = (Str)t;
        return st.isMonoAtomic() && !st.isModified();
    }

    static Locant simpleLocant(Token t) {
        if (!(t instanceof LocantList)) {
            return null;
        }
        LocantList ll = (LocantList)t;
        if (ll.size() != 1) {
            return null;
        }
        Locant l = ll.getLocant(0);
        if (l instanceof SimpleLocant || l instanceof AtomLocant || l == SpecialLocant.n) {
            return l;
        }
        return null;
    }

    static boolean simpleLocants(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList l = (LocantList)t;
        return l.getType() == 12;
    }

    static boolean isNLocantList(Token t) {
        if (!(t instanceof LocantList)) {
            return false;
        }
        LocantList locants = (LocantList)t;
        for (Locant l : locants.getLocantsList()) {
            if (l.toString().startsWith("N")) continue;
            return false;
        }
        return true;
    }

    static boolean hasPrime(LocantList locants) {
        for (Locant l : locants.getLocantsList()) {
            if (l.getParent() == 0) continue;
            return true;
        }
        return false;
    }

    static boolean hasOne(LocantList locants) {
        for (Locant l : locants.getLocantsList()) {
            if (l.isOne()) {
                return true;
            }
            if (l.isOrthoMetaPara()) {
                return true;
            }
            if (l != SpecialLocant.sym && l != SpecialLocant.asym && l != SpecialLocant.vicinal) continue;
            return true;
        }
        return false;
    }

    static int multiplier(Token t) {
        if (!(t instanceof Number)) {
            return -1;
        }
        Number n = (Number)t;
        int type = n.getType();
        if (type == 1 || type == 0) {
            return n.getData();
        }
        return -1;
    }

    static int chainLength(Token t) {
        if (!(t instanceof Number)) {
            return -1;
        }
        Number n = (Number)t;
        int type = n.getType();
        if (type == 2 || type == 0) {
            return n.getData();
        }
        return -1;
    }

    static Str structureMaybeInBrackets(Token t) {
        if (t == null) {
            return null;
        }
        if (t.isVal("ester")) {
            return null;
        }
        if (t instanceof Str) {
            return (Str)t;
        }
        if (t instanceof BracketToken) {
            BracketToken b = (BracketToken)t;
            if (b.inside.size() == 1 && b.inside.get(0) instanceof Str) {
                Str res = (Str)b.inside.get(0);
                res.isRoot = true;
                return res;
            }
        }
        return null;
    }

    static boolean beforeDash(Token t) {
        return t instanceof Str || t instanceof BracketToken || t instanceof EndingToken;
    }

    static boolean isEnding(Token t) {
        if (t instanceof EndingToken) {
            return true;
        }
        if (t == null) {
            return false;
        }
        if (t instanceof Str) {
            Str st = (Str)t;
            if (st.suffixes != null || st.substituents != null) {
                return false;
            }
        }
        if (t.is("amine")) {
            return true;
        }
        String name = t.getName();
        return name.equals("sulfinamide") || name.equals("sulfonamide") || name.equals("carboxamide") || name.equals("carbohydrazide");
    }

    static EndingToken asEnding(Token t) {
        if (t instanceof EndingToken) {
            return (EndingToken)t;
        }
        if (t instanceof Str) {
            Str st = (Str)t;
            return new EndingToken(st.getName(), st.getValue());
        }
        return null;
    }

    static String removeAndGetName(List<Token> tokens, int from, int to) {
        String name = "";
        for (int i = to; i >= 0; --i) {
            name = tokens.remove(i).getName() + name;
        }
        return name;
    }

    static boolean anyStructureHas(LocantList locants, List<Token> tokens) {
        block0: for (Token t : tokens) {
            for (Locant l : locants.getLocantsList()) {
                if (t.hasLocant(l)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    static boolean anyStructureHas(Locant locant, List<Token> tokens) {
        for (Token t : tokens) {
            if (RevolutionParser.tok(t, " ")) break;
            if (!(t instanceof Str) || !((Str)t).hasLocant(locant)) continue;
            return true;
        }
        return false;
    }

    private static Str str(Str x) {
        return x;
    }

    static class StereoAtRadical
    extends PrettyRewriter {
        StereoAtRadical() {
        }

        @Override
        boolean rewrite() {
            Str parent = this.structure();
            if (parent == null || !this.sep("-")) {
                return false;
            }
            LocantList locants = this.locants();
            if (locants == null || locants.size() != 1 || !(locants.getLocant(0) instanceof SimpleLocant)) {
                return false;
            }
            SimpleLocant locant = (SimpleLocant)locants.getLocant(0);
            LocantList stereo = this.locants();
            if (stereo == null || stereo.size() != 1 || !stereo.isStereo()) {
                return false;
            }
            StereoNumber sn = (StereoNumber)stereo.getLocant(0);
            if (sn.isEmpty()) {
                sn.setLocant(locant);
            }
            parent.addStereo(stereo);
            this.remove(this.current - 1);
            this.remove(this.current - 2);
            return true;
        }
    }

    static class EndingWithLocant
    extends Rewriter {
        EndingWithLocant() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Token tok1 = RevolutionParser.get(tokens, 1);
            if (!(tokens.get(0) instanceof Str) || !RevolutionParser.sep(tok1, "-")) {
                return false;
            }
            Str base = (Str)tokens.get(0);
            if (RevolutionParser.cannotHaveSuffix(base)) {
                return false;
            }
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(tokens.get(3), "-") && RevolutionParser.isEnding(tokens.get(4))) {
                if (((LocantList)RevolutionParser.get(tokens, 2)).isStereo()) {
                    return false;
                }
                EndingToken ending = RevolutionParser.asEnding(tokens.remove(4));
                tokens.remove(3);
                LocantList locants = (LocantList)tokens.remove(2);
                tokens.remove(1);
                base.addSuffix(RevolutionParser.suffix(ending, locants, 1));
                return true;
            }
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(tokens.get(3), "-") && RevolutionParser.multiplier(tokens.get(4)) != -1 && RevolutionParser.isEnding(tokens.get(5))) {
                if (RevolutionParser.name(tokens, 5, "yl") && RevolutionParser.multiplier(RevolutionParser.get(tokens, 6)) != -1) {
                    return false;
                }
                EndingToken ending = RevolutionParser.asEnding(tokens.remove(5));
                int multiplier = RevolutionParser.multiplier(tokens.remove(4));
                tokens.remove(3);
                LocantList locants = (LocantList)tokens.remove(2);
                locants = locants.expandOMP(multiplier);
                tokens.remove(1);
                if (multiplier != locants.size()) {
                    throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + tokens);
                }
                base.addSuffix(RevolutionParser.suffix(ending, locants, multiplier));
                return true;
            }
            return false;
        }
    }

    static class SubstituentWithoutLocant
    extends PrettyRewriter {
        SubstituentWithoutLocant() {
        }

        @Override
        boolean rewrite() {
            Str sub;
            int start = 0;
            boolean per = false;
            int multiplier = this.multiplier();
            if (multiplier == -1) {
                multiplier = 1;
                if (this.name("per")) {
                    per = true;
                    start = 1;
                }
            } else {
                LocantList locantsBefore;
                if (this.sep(this.get(-1), "-") && this.get(-2) instanceof LocantList && (locantsBefore = (LocantList)this.get(-2)).size() == multiplier && !locantsBefore.isStereo()) {
                    return false;
                }
                start = 1;
            }
            if ((sub = RevolutionParser.structureMaybeInBrackets(this.get(start))) == null && multiplier == 1 && this.get(start) instanceof BracketToken) {
                BracketToken bracket = (BracketToken)this.get(start);
                if (bracket.inside.size() != 2) {
                    return false;
                }
                multiplier = RevolutionParser.multiplier(bracket.inside.get(0));
                if (multiplier == -1) {
                    return false;
                }
                sub = RevolutionParser.structureMaybeInBrackets(bracket.inside.get(1));
            }
            if (this.name(start + 1, "-") && this.get(start + 2) instanceof AminoAcidStr) {
                ++start;
            }
            if (sub != null && this.get(start + 1) instanceof Str) {
                int i;
                boolean hasMoreTokens;
                Str parent = (Str)this.get(start + 1);
                boolean bl = hasMoreTokens = start + 1 < this.length() - 1;
                if (RevolutionParser.cannotBeParent(parent) && hasMoreTokens) {
                    return false;
                }
                if (this.pass == 0 && sub.isChain() && parent.isChain() && hasMoreTokens) {
                    return false;
                }
                if (this.get(start) instanceof BracketToken && this.get(start - 1) instanceof Str && RevolutionParser.structureMaybeInBrackets(this.get(start + 2)) != null) {
                    return false;
                }
                if (this.pass == 0 && parent.needsLocant()) {
                    return false;
                }
                if (multiplier > 1 && (parent.is("oxy") || parent.is("oxo")) && parent.substituents == null) {
                    return false;
                }
                if (sub.is("amino") && parent.is("imino") && hasMoreTokens) {
                    return false;
                }
                if (this.nameE(start + 2, "amine")) {
                    int offset = 0;
                    if (multiplier == 1 && RevolutionParser.multiplier(this.get(-1)) != -1) {
                        offset = -1;
                    }
                    if (RevolutionParser.isNLocantList(this.get(offset - 2)) && this.name(offset - 1, "-")) {
                        return false;
                    }
                }
                if (sub.is("sulfone") || sub.getName().endsWith("ano!")) {
                    return false;
                }
                if (sub.is("oximeXXX")) {
                    return false;
                }
                if (sub instanceof HydrazoneStr && multiplier == 1 || parent.is("oxime")) {
                    parent.setSpaceSeparated(true);
                    sub.addSubstituent(null, parent);
                    this.remove(start + 1);
                    --start;
                } else if (sub.is("oxime")) {
                    sub.multiplicity = multiplier;
                    parent.addSubstituent(null, sub);
                } else if (per) {
                    parent.addSubstituent(Locant.Per, sub);
                } else {
                    for (i = 0; i < multiplier; ++i) {
                        if (multiplier > 1) {
                            sub = sub.cloneMe();
                        }
                        parent.addSubstituent(null, sub);
                    }
                }
                for (i = start; i >= 0; --i) {
                    this.remove(i);
                }
                return true;
            }
            return false;
        }
    }

    static class SubLocantInsideBrackets
    extends PrettyRewriter {
        SubLocantInsideBrackets() {
        }

        @Override
        boolean rewrite() {
            BracketToken b = this.bracket();
            if (b == null || b.inside.size() != 3) {
                return false;
            }
            Str parent = this.structure();
            if (parent == null) {
                return false;
            }
            Token t0 = b.inside.get(0);
            Token t1 = b.inside.get(1);
            Token t2 = b.inside.get(2);
            if (!(t0 instanceof LocantList && t1.is("-") && t2 instanceof Str)) {
                return false;
            }
            LocantList locants = (LocantList)t0;
            if (locants.size() != 1 || !parent.hasLocants(locants)) {
                return false;
            }
            Str substituent = (Str)t2;
            parent.addSubstituent(locants.getLocant(0), substituent);
            this.remove(0);
            return true;
        }
    }

    static class SubstituentWithLocant
    extends PrettyRewriter {
        SubstituentWithLocant() {
            this.removeDashBefore = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean rewrite() {
            int i;
            LocantList locants;
            int multiplier = this.multiplier();
            if (multiplier != -1) {
                this.sep("-");
            }
            if ((locants = this.simpleLocants()) == null || locants.isStereo()) {
                return false;
            }
            if (multiplier != -1 && locants.size() != multiplier) {
                return false;
            }
            LocantList stereo = null;
            if (RevolutionParser.stereo(this.get(this.current)) && this.sep(this.get(this.current + 1), "-")) {
                stereo = (LocantList)this.get(this.current);
                this.current += 2;
            }
            if (multiplier == -1) {
                multiplier = this.multiplier();
            }
            if (multiplier == -1) {
                multiplier = 1;
            } else {
                this.optional(this.sep(" "));
            }
            AtomLocant atomLocant = null;
            if (this.sep("-") && ((atomLocant = this.atomLocant()) == null || !this.sep("-"))) {
                return false;
            }
            Str sub = this.structure();
            if (sub == null) {
                return false;
            }
            boolean subInBrackets = this.get(this.current - 1) instanceof BracketToken;
            this.optional(this.sep("-"));
            this.optional(this.sep(RevolutionParser.nbsp));
            if (this.pass == 1 && !this.sep(" ")) {
                return false;
            }
            Str parent = this.structureNoBracket();
            if (parent == null || parent.is("oxy") || parent.is("oxo") || RevolutionParser.cannotBeParent(parent)) {
                return false;
            }
            if (this.pass == 1 && parent.is("ester")) {
                return false;
            }
            int removeBottom = 0;
            if (multiplier != (locants = locants.expandOMP(multiplier)).size()) {
                if (multiplier == 2 && locants.is(SpecialLocant.sym) && parent.hasLocant(SpecialLocant.loc2)) {
                    locants = LocantList.create(SpecialLocant.loc1, SpecialLocant.loc2);
                } else {
                    if (!this.eol()) return false;
                    if (multiplier == 2 && locants.size() == 1 && this.name(-1, "-") && this.get(-2) instanceof LocantList && ((LocantList)this.get(-2)).size() == 1) {
                        removeBottom = -2;
                        locants.addFirstLocant(((LocantList)this.get(-2)).getLocant(0));
                    } else if (locants.size() == 1 && parent.hasLocant(locants.getLocant(0))) {
                        for (i = 1; i < multiplier; ++i) {
                            locants.addLocant(locants.getLocant(0));
                        }
                    } else {
                        if (!sub.tryAddLocantsBefore(locants, true)) throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + this.tokens());
                        locants = null;
                    }
                }
            }
            if (locants != null) {
                for (Locant locant : locants.getLocantsList()) {
                    if (parent.hasLocantForSubstituent(locant)) continue;
                    if (subInBrackets || !sub.hasLocant(locant) || locants.size() != 1) return false;
                    if (sub.is("acet") || sub.is("benzyl") || sub.is("benzoyl") || sub.is("phen") || sub.is("meth")) {
                        return false;
                    }
                    if (!sub.tryAddLocantsBefore(LocantList.simpleList(locant), true)) {
                        if (RevolutionParser.anyStructureHas(locant, this.remainingTokens())) {
                            return false;
                        }
                        if (!sub.tryAddLocantsBefore(LocantList.simpleList(locant), false)) {
                            sub.setLocantBefore(locant);
                        }
                    }
                    this.remove(1);
                    this.remove(0);
                    return true;
                }
            }
            if (stereo != null) {
                parent.addStereo(stereo);
            }
            i = this.current - 1;
            while (--i >= removeBottom) {
                this.remove(i);
            }
            if (locants == null) {
                for (i = 0; i < multiplier; ++i) {
                    parent.addSubstituent(null, sub.cloneMe());
                }
                return true;
            } else {
                for (Locant l : locants.getLocantsList()) {
                    parent.addSubstituent(this.merge(l, atomLocant), sub.cloneMe());
                }
            }
            return true;
        }

        private Locant merge(Locant l, AtomLocant atomLocant) {
            if (atomLocant == null) {
                return l;
            }
            AtomLocant res = AtomLocant.create(l.getValue(), atomLocant.getPrimes(), atomLocant.getAtno());
            return res;
        }
    }

    static class EndingWithoutLocant
    extends PrettyRewriter {
        EndingWithoutLocant() {
        }

        @Override
        boolean rewrite() {
            Token ending;
            Token endingTok;
            Str parent = this.structureNoBracket();
            if (parent == null) {
                return false;
            }
            int multiplier = this.multiplier();
            if (multiplier == -1) {
                multiplier = 1;
            }
            if (!RevolutionParser.isEnding(endingTok = this.nextToken())) {
                return false;
            }
            if (multiplier > 1 && endingTok.is("yl") && this.multiplier() != -1) {
                return false;
            }
            if (RevolutionParser.cannotHaveSuffix(parent)) {
                return false;
            }
            if (parent.hasSuffixName("yl") && !(endingTok instanceof EndingToken) && !endingTok.is("amine")) {
                return false;
            }
            if (endingTok instanceof Str) {
                ending = (Str)endingTok;
                if (ending.substituents != null) {
                    return false;
                }
            }
            if (endingTok.is("amine") && multiplier == 1 && (RevolutionParser.multiplier(this.get(-1)) != -1 || parent.is("meth") && parent.hasSuffixName("yl") || parent.isCyclic())) {
                return false;
            }
            if (UtilLegacy.isName(endingTok.getName(), "ane")) {
                if (multiplier > 1) {
                    return false;
                }
                if (!parent.acceptsAne()) {
                    return false;
                }
            }
            if (!endingTok.is("amine") || !parent.hasSuffixName("yl") || multiplier == 1) {
                // empty if block
            }
            ending = RevolutionParser.asEnding(endingTok);
            int end = this.current;
            LocantList locants = null;
            if (this.sep("-")) {
                locants = this.rawLocants();
                if (locants != null && this.eol()) {
                    end = this.current;
                } else {
                    locants = null;
                }
            }
            int i = end;
            while (--i > 0) {
                this.remove(i);
            }
            parent.addSuffix(RevolutionParser.suffix((EndingToken)ending, locants, multiplier));
            return true;
        }
    }

    static class IndicatedHydroRewriter
    extends PrettyRewriter {
        IndicatedHydroRewriter() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite() {
            Hydro h = this.indicatedH();
            if (h == null) {
                return false;
            }
            this.optional(this.sep("-"));
            Str parent = this.structure();
            if (parent == null || !parent.isCyclic()) {
                return false;
            }
            parent.addHydro(h);
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class HydroRewriter
    extends PrettyRewriter {
        HydroRewriter() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite() {
            int i;
            LocantList locants = this.locants();
            int mul = this.multiplierOrPer();
            if (mul == -1) {
                mul = 1;
            } else if (mul == -2) {
                if (locants != null) {
                    return false;
                }
                locants = Locant.Pers;
            }
            Hydro h = this.hydro();
            if (h == null) {
                return false;
            }
            this.optional(this.sep("-"));
            this.optional(this.sep(" "));
            Str parent = this.normalStructure();
            if (parent == null) {
                return false;
            }
            if (!parent.hasLocants(locants)) {
                return false;
            }
            if (this.nameE("ide") || parent.isSaltIde()) {
                return false;
            }
            if (locants != null) {
                if (locants != Locant.Pers && mul != locants.size()) {
                    return false;
                }
                parent.addHydros(locants, h);
            } else {
                for (i = 0; i < mul; ++i) {
                    parent.addHydro(h);
                }
            }
            i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class ComplexSpiro
    extends Rewriter {
        ComplexSpiro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.name(tokens, 0, "spiro")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 1) instanceof BracketToken)) {
                return false;
            }
            ArrayList<Token> inside = ((BracketToken)RevolutionParser.get(tokens, (int)1)).inside;
            if (inside.size() != 5) {
                return false;
            }
            if (!(RevolutionParser.get(inside, 0) instanceof Str && RevolutionParser.sep(RevolutionParser.get(inside, 1), "-") && RevolutionParser.get(inside, 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(inside, 3), "-") && RevolutionParser.get(inside, 4) instanceof Str)) {
                return false;
            }
            Str first = (Str)RevolutionParser.get(inside, 0);
            Str second = (Str)RevolutionParser.get(inside, 4);
            LocantList locants = (LocantList)RevolutionParser.get(inside, 2);
            if (!RevolutionParser.hasPrime(locants)) {
                return false;
            }
            ArrayList<Str> structures = new ArrayList<Str>();
            structures.add(first);
            structures.add(second);
            PolyCyclicSpiroSystem spiro = new PolyCyclicSpiroSystem(structures, locants);
            tokens.remove(1);
            tokens.remove(0);
            tokens.add(0, RevolutionParser.str(spiro));
            return true;
        }
    }

    static class SpiroMulStruct
    extends PrettyRewriter {
        SpiroMulStruct() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            if (!this.name("spiro")) {
                return false;
            }
            int mul = this.multiplier();
            Str component = this.structure();
            if (locants == null || mul == -1 || component == null) {
                return false;
            }
            MultipliedSpiroStr s = new MultipliedSpiroStr(component, mul, locants);
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, RevolutionParser.str(s));
            return true;
        }
    }

    static class SimpleSpiro
    extends Rewriter {
        SimpleSpiro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            HeteroChainStr h;
            Str second;
            int cur = -1;
            int mul = RevolutionParser.multiplier(tokens.get(0));
            if (mul == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (!RevolutionParser.name(tokens, ++cur, "spiro")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, ++cur) instanceof LocantList)) {
                return false;
            }
            LocantList numbering = (LocantList)RevolutionParser.get(tokens, cur);
            if (numbering.getType() != 0) {
                return false;
            }
            if ((second = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, ++cur))) == null) {
                return false;
            }
            if (mul > 1) {
                // empty if block
            }
            for (int i = cur; i >= 0; --i) {
                tokens.remove(i);
            }
            MonoCyclicSpiroSytem s = second instanceof HeteroChainStr ? ((h = (HeteroChainStr)second).hasBoth() ? new MonoCyclicSpiroSytem(numbering, h.getAtom(), h.getAtom2()) : new MonoCyclicSpiroSytem(numbering, h.getAtom())) : new MonoCyclicSpiroSytem(numbering, 6);
            tokens.add(0, RevolutionParser.str(s));
            return true;
        }
    }

    static class Fused
    extends PrettyRewriter {
        Fused() {
        }

        @Override
        boolean rewrite() {
            int mul = this.multiplier();
            Str first = this.structure();
            if (first == null) {
                return false;
            }
            this.optional(this.sep("o"));
            this.optional(this.sep(" ") || this.sep("-"));
            LocantList fusion = this.fusion();
            if (fusion == null) {
                return false;
            }
            if (mul != -1 && mul != fusion.size()) {
                return false;
            }
            this.optional(this.sep(" ") || this.sep("-"));
            Str second = this.structure();
            if (second == null) {
                return false;
            }
            while (this.get(0) != second) {
                this.remove(0);
            }
            this.remove(0);
            FusedStr fused = new FusedStr(first, second, fusion);
            this.add(0, RevolutionParser.str(fused));
            return true;
        }
    }

    static class FusedLocantsBeforeLocants
    extends Rewriter {
        FusedLocantsBeforeLocants() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof LocantList)) {
                return false;
            }
            LocantList fusion = (LocantList)RevolutionParser.get(tokens, 0);
            if (fusion.getType() != 5) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 1) instanceof BracketToken)) {
                return false;
            }
            BracketToken bracket = (BracketToken)RevolutionParser.get(tokens, 1);
            if (bracket.inside.size() != 1) {
                return false;
            }
            Token inside = bracket.inside.get(0);
            if (!(inside instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)bracket.inside.get(0);
            tokens.remove(1);
            tokens.add(1, locants);
            tokens.add(2, new Separator('-'));
            return true;
        }
    }

    static class SpiroLocantsBeforeLocants
    extends Rewriter {
        SpiroLocantsBeforeLocants() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof LocantList)) {
                return false;
            }
            LocantList spiroLocants = (LocantList)RevolutionParser.get(tokens, 0);
            if (!RevolutionParser.hasPrime(spiroLocants)) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 2) instanceof BracketToken)) {
                return false;
            }
            BracketToken bracket = (BracketToken)RevolutionParser.get(tokens, 2);
            if (bracket.inside.size() != 1) {
                return false;
            }
            Token inside = bracket.inside.get(0);
            if (!(inside instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)bracket.inside.get(0);
            tokens.remove(2);
            tokens.add(2, locants);
            tokens.add(3, new Separator('-'));
            return true;
        }
    }

    static class NumberGreekRewriter
    extends PrettyRewriter {
        NumberGreekRewriter() {
        }

        @Override
        boolean rewrite() {
            LocantList locants1 = this.simpleLocants();
            if (locants1 == null) {
                return false;
            }
            this.sep("-");
            LocantList locants2 = this.simpleLocants();
            if (locants2 == null) {
                return false;
            }
            Locant l1 = locants1.getLocant(locants1.size() - 1);
            Locant l2 = locants2.getLocant(0);
            if (!l2.isGreekLetter()) {
                return false;
            }
            if (!l1.isSimpleNumber()) {
                return false;
            }
            ((SimpleLocant)l1).greekLetter = ((SimpleLocant)l2).getAsGreekLetter();
            int i = this.current;
            while (--i >= 2) {
                this.remove(i);
            }
            if (locants2.size() > 1) {
                locants2.removeLocant(0);
                for (Locant l : locants2.getLocantsList()) {
                    locants1.addLocant(l);
                }
            }
            return true;
        }
    }

    static class LocantEater
    extends PrettyRewriter {
        LocantEater() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locantsFlex();
            int mul = this.multiplier();
            Str s = this.structure();
            if (locants == null || s == null) {
                return false;
            }
            if (!s.consume(locants, mul)) {
                return false;
            }
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Cyclo
    extends Rewriter {
        Cyclo() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int cur = 0;
            int multiplier = RevolutionParser.multiplier(tokens.get(cur));
            if (multiplier != -1) {
                cur = 1;
            }
            if (!RevolutionParser.name(tokens, cur++, "cyclo")) {
                return false;
            }
            LocantList ringNumbering = null;
            if (RevolutionParser.get(tokens, cur) instanceof LocantList && (ringNumbering = (LocantList)RevolutionParser.get(tokens, cur++)).getType() != 0) {
                return false;
            }
            if (multiplier != -1 && ringNumbering == null) {
                return false;
            }
            HeteroChainStr heteroChain = null;
            if (RevolutionParser.get(tokens, cur) instanceof HeteroChainStr) {
                heteroChain = (HeteroChainStr)RevolutionParser.get(tokens, cur);
            }
            int length = -1;
            if (ringNumbering == null) {
                if (heteroChain != null) {
                    length = heteroChain.getMultiplicity();
                } else if (RevolutionParser.get(tokens, cur) instanceof StructureToken) {
                    StructureToken s = (StructureToken)tokens.get(cur);
                    if (multiplier == -1 && s.getName().endsWith("ylene")) {
                        tokens.remove(0);
                        return true;
                    }
                    if (!s.isChain()) {
                        return false;
                    }
                    length = s.basicSmiles().length();
                } else {
                    length = RevolutionParser.chainLength(RevolutionParser.get(tokens, cur));
                    if (length == -1) {
                        return false;
                    }
                }
            }
            int atom = 6;
            int atom2 = -1;
            if (RevolutionParser.hetero(tokens, cur + 1) && !RevolutionParser.get(tokens, cur).endsWith("an")) {
                atom = HeteroAtomStr.create(tokens.get(++cur)).getAtno();
            } else if (heteroChain != null) {
                atom = heteroChain.getAtom();
                atom2 = heteroChain.getAtom2();
            }
            Str cycle = ringNumbering != null ? new VonBaeyerStr(ringNumbering, atom, atom2) : new Cycle(length, atom, atom2);
            int i = cur + 1;
            while (--i >= 0) {
                tokens.remove(i);
            }
            tokens.add(0, RevolutionParser.str(cycle));
            return true;
        }
    }

    static class StereoRewriter
    extends PrettyRewriter {
        StereoRewriter() {
        }

        @Override
        boolean rewrite() {
            LocantList stereos = this.locantsFlex();
            if (stereos == null) {
                return false;
            }
            LocantList locants = this.locants();
            if (locants != null) {
                LocantList tmp = stereos;
                stereos = locants;
                locants = tmp;
            }
            if (!RevolutionParser.stereo(stereos)) {
                return false;
            }
            if (locants != null && stereos.isStereoDL() && !locants.isGreek()) {
                return false;
            }
            Str parent = this.structure();
            if (parent == null) {
                return false;
            }
            if (!(this.pass != 1 || !RevolutionParser.anyStructureHas(stereos, this.remainingTokens()) || stereos.isStereoDL() && parent instanceof AminoAcidStr)) {
                return false;
            }
            if (locants != null && !stereos.addLocantsToStereo(locants)) {
                return false;
            }
            parent.addStereo(stereos);
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    class BracketRewriter
    extends PrettyRewriter {
        BracketRewriter() {
        }

        @Override
        boolean rewrite() {
            Token whole = this.nextToken();
            if (!(whole instanceof BracketToken)) {
                return false;
            }
            boolean onlyOneStep = this.name(-1, "spiro");
            ArrayList<Token> inside = ((BracketToken)whole).inside;
            boolean doneSomething = false;
            while (inside.size() > 1) {
                boolean step = RevolutionParser.this.rewriteOnce(inside, true);
                if (!step) {
                    if (this.eol()) {
                        throw new RuntimeException("Could not parse: " + inside);
                    }
                    return doneSomething;
                }
                if (onlyOneStep) {
                    return true;
                }
                doneSomething = true;
                RevolutionParser.this.debugPrintStep(inside);
            }
            Token t = inside.get(0);
            if (this.canRemoveSingle(t)) {
                this.remove(0);
                this.add(0, t);
                RevolutionParser.this.lastRewriter = this;
                return true;
            }
            return doneSomething;
        }

        private boolean canRemoveSingle(Token t) {
            if (t instanceof BracketToken) {
                return true;
            }
            return t instanceof Str && (this.pass >= 2 || t instanceof MultipliedSystemStr);
        }
    }

    static class SaltRewriter
    extends Rewriter {
        SaltRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.multiplier(this.before) != -1) {
                return false;
            }
            if (tokens.size() < 3) {
                return false;
            }
            if (!(tokens.get(0) instanceof Str)) {
                return false;
            }
            Str s = (Str)tokens.get(0);
            if (s.is("hydrogen")) {
                return false;
            }
            int atomPos = 1;
            if (RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                ++atomPos;
            }
            if (RevolutionParser.name(tokens, atomPos, "hydrate")) {
                s.addSuffix(RevolutionParser.suffix((EndingToken)tokens.get(atomPos), null, 1));
                for (int i = atomPos; i > 0; --i) {
                    tokens.remove(i);
                }
                return true;
            }
            boolean hydro = false;
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, atomPos));
            if (mul != -1) {
                ++atomPos;
            }
            if (RevolutionParser.get(tokens, atomPos) instanceof Hydro) {
                hydro = true;
                ++atomPos;
            }
            if (RevolutionParser.get(tokens, atomPos) instanceof Str) {
                Str atom = (Str)RevolutionParser.get(tokens, atomPos);
                if (!atom.isMonoAtomic()) {
                    return false;
                }
                if (atom.suffixes == null || atom.suffixes.size() != 1 || atom.substituents != null) {
                    return false;
                }
                Suffix suffix = atom.suffixes.get(0);
                if (suffix.getType() != 3 || suffix instanceof SaltEnding) {
                    return false;
                }
                if ((atom.is("sulf") || atom.is("selen")) && suffix.is("ide") && s.hasExplicitRadical()) {
                    return false;
                }
                for (int i = 2; i < atomPos; ++i) {
                    tokens.remove(2);
                }
                tokens.remove(2);
                tokens.remove(1);
                SaltEnding salt = new SaltEnding(suffix.getName(), suffix.getValue(), mul, atom.getValue(), hydro);
                s.addSuffix(salt);
                return true;
            }
            return false;
        }

        private boolean isEne(Str s) {
            if (s instanceof PolyMethylene) {
                return true;
            }
            return s.hasSuffixName("ene") || s.hasSuffixName("ylene");
        }
    }

    static class ExplicitSalt
    extends PrettyRewriter {
        ExplicitSalt() {
            this.removeSpaceBefore = true;
        }

        @Override
        boolean rewrite() {
            Str s;
            if (!(this.get(-1) == null || this.name(-1, " ") || this.name(-1, ",") || this.name(-1, RevolutionParser.nbsp))) {
                return false;
            }
            int multiplier = this.multiplier();
            if (multiplier == -1) {
                multiplier = 1;
            }
            if ((s = this.structure()) != null && this.sep(" ") && this.name("salt")) {
                --this.current;
                EndingToken salt = this.ending();
                s.addSuffix(RevolutionParser.suffix(salt, null, 1));
                this.outsideComponent = s;
                this.outsideComponent.multiplicity = multiplier;
                int i = this.current;
                while (--i >= 0) {
                    this.remove(i);
                }
                return true;
            }
            return false;
        }
    }

    static class Disulfide
    extends GlobalRewriter {
        Disulfide() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            Str disulfide;
            int mul;
            int cur = 0;
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                LocantList locants = (LocantList)RevolutionParser.get(tokens, 0);
                if (locants.size() != 2) {
                    return false;
                }
                if (!locants.getLocant(0).equals(Locant.One) || !locants.getLocant(1).equals(Locant.OnePrime)) {
                    return false;
                }
                cur = 2;
            }
            if ((mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur))) == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, cur)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, cur + 1), " ")) {
                return false;
            }
            Str sub = RevolutionParser.structureMaybeInBrackets(tokens.get(cur));
            if (RevolutionParser.name(tokens, cur + 2, "disulfide")) {
                disulfide = (Str)RevolutionParser.get(tokens, cur + 2);
            } else if (RevolutionParser.name(tokens, cur + 2, "di") && (RevolutionParser.name(tokens, cur + 3, "selen") || RevolutionParser.name(tokens, cur + 3, "tellur")) && RevolutionParser.name(tokens, cur + 4, "ide")) {
                disulfide = (Str)tokens.get(cur + 3);
                disulfide.setValue(disulfide.getValue() + disulfide.getValue() + " |$ester;ester$|");
                disulfide.setName("di" + disulfide.getName() + "ide");
                tokens.remove(cur + 4);
                tokens.remove(cur + 2);
            } else {
                return false;
            }
            for (i = cur + 1; i >= 0; --i) {
                tokens.remove(i);
            }
            for (i = 0; i < mul; ++i) {
                if (mul > 1) {
                    sub = sub.cloneMe();
                }
                sub.setSpaceSeparated(true);
                disulfide.addSubstituent(null, sub);
            }
            return true;
        }
    }

    static class LocantsBeforeRewriter
    extends BackwardsRewriter {
        LocantsBeforeRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (this.pass == 0 && !(this.before instanceof LocantList)) {
                return false;
            }
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            int pos = 1;
            if (RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || RevolutionParser.sep(RevolutionParser.get(tokens, 1), RevolutionParser.nbsp)) {
                ++pos;
            }
            if (RevolutionParser.get(tokens, pos) instanceof Str) {
                Str s = (Str)RevolutionParser.get(tokens, pos);
                if (s.isMonoAtomic() && !s.is("oxy") && !s.isMarkush()) {
                    return false;
                }
                LocantList ll = (LocantList)tokens.get(0);
                if (ll.getType() == 5) {
                    return false;
                }
                if (!s.tryAddLocantsBefore(ll, true)) {
                    if (this.pass < 2) {
                        return false;
                    }
                    if (this.pass < 3 && !s.hasLocants(ll)) {
                        return false;
                    }
                    if (!s.addLocantsBefore(ll)) {
                        return false;
                    }
                }
                int i = pos;
                while (--i >= 0) {
                    tokens.remove(i);
                }
                return true;
            }
            return false;
        }
    }

    static class BracketedLocants
    extends PrettyRewriter {
        BracketedLocants() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.bracketedLocants();
            Str s = this.structure();
            if (locants == null || s == null || !this.eol()) {
                return false;
            }
            if (!s.addLocantsBefore(locants)) {
                return false;
            }
            this.remove(0);
            return true;
        }
    }

    static class StructureSuffixRewriter
    extends GlobalRewriter {
        StructureSuffixRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() != 5) {
                return false;
            }
            if (RevolutionParser.get(tokens, 0) instanceof Str && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.simpleLocant(RevolutionParser.get(tokens, 2)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-") && RevolutionParser.get(tokens, 4) instanceof Str) {
                Str first = (Str)RevolutionParser.get(tokens, 0);
                Str second = (Str)RevolutionParser.get(tokens, 4);
                if (!first.isCyclic()) {
                    return false;
                }
                if (first.radical != null && !first.radical.hasLocant()) {
                    LocantList locants;
                    Token sep = tokens.remove(3);
                    first.radical.locant = locants = (LocantList)tokens.remove(2);
                    return true;
                }
                tokens.add(4, new EndingToken("yl", "^1"));
                return true;
            }
            return false;
        }
    }

    static class DoubleLocantBeforeRewriter
    extends BackwardsRewriter {
        DoubleLocantBeforeRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 5) {
                return false;
            }
            if (RevolutionParser.simpleLocant(tokens.get(0)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") && RevolutionParser.simpleLocant(tokens.get(2)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-") && RevolutionParser.get(tokens, 4) instanceof Str && (RevolutionParser.get(tokens, 5) instanceof EndingToken || RevolutionParser.get(tokens, 5) instanceof Separator)) {
                Str s = (Str)RevolutionParser.get(tokens, 4);
                Token sep = tokens.remove(3);
                LocantList ll = (LocantList)tokens.remove(2);
                if (RevolutionParser.get(tokens, 3) instanceof EndingToken && !s.hasDefaultLocants()) {
                    tokens.add(3, sep);
                    tokens.add(4, ll);
                    tokens.add(5, sep);
                } else {
                    s.addLocantsBefore(ll);
                }
                return true;
            }
            return false;
        }
    }

    static class SecTert
    extends PrettyRewriter {
        SecTert() {
        }

        @Override
        boolean rewrite() {
            boolean sec;
            if (this.tok("SEC")) {
                sec = true;
            } else if (this.tok("TERT")) {
                sec = false;
            } else {
                return false;
            }
            Str chain = this.structure();
            if (chain == null) {
                return false;
            }
            if (sec && !this.peek(this.name("yl"))) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            Str s = sec ? SecChainStr.create(chain) : TertChainStr.create(chain);
            this.add(0, RevolutionParser.str(s));
            return true;
        }
    }

    static class Epi
    extends PrettyRewriter {
        Epi() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            int mul = this.multiplier();
            if (!this.name("epi")) {
                return false;
            }
            BridgeStr epi = (BridgeStr)this.get(this.current - 1);
            if (epi.substituents != null) {
                return false;
            }
            Str bridge = this.structure();
            if (bridge == null) {
                return false;
            }
            if (locants != null) {
                epi.locantsBefore = locants;
            }
            epi.multiplier = mul;
            bridge.setName("epi" + bridge.getName());
            epi.addSubstituent(null, bridge);
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, epi);
            return true;
        }
    }

    static class Ano
    extends PrettyRewriter {
        Ano() {
        }

        @Override
        boolean rewrite() {
            Str s;
            LocantList locants = this.locants();
            int mul = this.multiplier();
            if (mul != -1) {
                String structure = "";
                for (int i = 0; i < mul; ++i) {
                    structure = structure + "C";
                }
                s = new StructureToken(mul + "ano", structure);
            } else {
                s = this.structure();
                if (s == null) {
                    return false;
                }
            }
            if (!this.name("ano")) {
                return false;
            }
            Str parent = this.structure();
            if (parent == null) {
                return false;
            }
            String name = RevolutionParser.removeAndGetName(this.tokens(), 0, this.current - 2) + "!";
            Bridge b = new Bridge(name, locants, s);
            parent.addSubstituent(b);
            return true;
        }
    }

    static class SpecialPolyFused
    extends Rewriter {
        SpecialPolyFused() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int multiplier = RevolutionParser.multiplier(tokens.get(0));
            if (multiplier == -1) {
                return false;
            }
            return false;
        }
    }

    static class HeterAnthrene
    extends Rewriter {
        HeterAnthrene() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.hetero(tokens, 0) || !RevolutionParser.name(tokens, 1, "anthrene")) {
                return false;
            }
            tokens.remove(1);
            HeteroAtomStr hetero = HeteroAtomStr.create(tokens.remove(0));
            tokens.add(0, RevolutionParser.str(PhenoIneStr.create(hetero, null)));
            return true;
        }
    }

    static class PhenoIne
    extends PrettyRewriter {
        PhenoIne() {
        }

        @Override
        boolean rewrite() {
            HeteroAtomStr hetero2;
            if (!this.nameUnchanged("phen")) {
                return false;
            }
            this.optional(this.sep("o"));
            HeteroAtomStr hetero1 = this.hetero();
            if (hetero1 == null) {
                return false;
            }
            if (this.nameE("phosphine")) {
                hetero2 = new HeteroAtomStr("phosphine", 15);
            } else if (this.nameE("arsine")) {
                hetero2 = new HeteroAtomStr("arsine", 33);
            } else {
                hetero2 = this.hetero();
                if (!this.nameE("ine")) {
                    return false;
                }
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, RevolutionParser.str(PhenoIneStr.create(hetero1, hetero2)));
            return true;
        }
    }

    static class AnnuleneRewriter
    extends PrettyRewriter {
        AnnuleneRewriter() {
        }

        @Override
        boolean rewrite() {
            LocantList locants;
            boolean benzo = false;
            if (this.name("benz")) {
                if (this.sep("o")) {
                    benzo = true;
                } else {
                    return false;
                }
            }
            if ((locants = this.bracketedLocants()) == null) {
                return false;
            }
            SimpleLocant l = locants.getSimpleLocant();
            if (l == null) {
                return false;
            }
            if (!this.nameE("annulene")) {
                return false;
            }
            throw new RuntimeException("TODO");
        }
    }

    static class HantzschWidman
    extends PrettyRewriter {
        HantzschWidman() {
        }

        @Override
        boolean rewrite() {
            HantzschWidmanStr hw;
            boolean iso = false;
            if (this.name("is") || this.name("iso")) {
                iso = true;
            }
            if (this.name(0, "ox") && this.nameE(1, "ine")) {
                this.remove(1);
                this.remove(0);
                this.add(0, StructureToken.create("oxine", "OC1=CC=CC2=C1N=CC=C2 |$;;7;;5;;;;;;$|"));
                return true;
            }
            LocantList locants = this.locants();
            if (locants != null) {
                if (locants.isStereo() || RevolutionParser.hasPrime(locants)) {
                    return false;
                }
                if (!RevolutionParser.hasOne(locants)) {
                    return false;
                }
            }
            ArrayList<HeteroAtomStr> heteros = new ArrayList<HeteroAtomStr>();
            this.current = RevolutionParser.parseHeteros(this.tokens(), this.current, heteros);
            if (this.current == -1 || heteros.isEmpty()) {
                return false;
            }
            EndingToken ending = this.ending();
            String endingString = null;
            if (ending != null) {
                if (ending.equalsName("ol")) {
                    if (this.nameE("ine")) {
                        endingString = "oline";
                    } else if (this.name("id")) {
                        endingString = "olid";
                    }
                }
                if (endingString == null) {
                    endingString = ending.getName();
                }
            }
            if ((hw = HantzschWidmanStr.create(locants, heteros, endingString, iso)) == null) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, RevolutionParser.str(hw));
            return true;
        }
    }

    static class BenzoFused
    extends PrettyRewriter {
        BenzoFused() {
        }

        @Override
        boolean rewrite() {
            BenzoFusedStr.Type type;
            LocantList locants = this.locants();
            if (!(this.name("benz") && this.optional(this.sep("o")) || this.name("benzo") || this.name("benzoyl"))) {
                return false;
            }
            if (locants == null && this.sep("-") && (locants = this.locants()) == null) {
                return false;
            }
            boolean iso = false;
            if (this.name("iso") || this.name("is")) {
                iso = true;
            }
            ArrayList<HeteroAtomStr> heteros = new ArrayList<HeteroAtomStr>();
            if (this.nameE("thiole")) {
                --this.current;
                this.add(this.current, StructureToken.create("thi", "S"));
                this.get(this.current + 1).setName("ol");
            } else if (this.nameUnchanged("thien")) {
                --this.current;
                this.add(this.current, StructureToken.create("thi", "S"));
                this.remove(this.current + 1);
                this.add(this.current + 1, new EndingToken("ole", ""));
            }
            this.current = RevolutionParser.parseHeteros(this.tokens(), this.current, heteros);
            if (this.current == -1 || heteros.isEmpty()) {
                return false;
            }
            if (this.nameE("ole")) {
                type = this.nameE("ine") ? BenzoFusedStr.Type.Oline : BenzoFusedStr.Type.Ole;
            } else if (this.name("yl")) {
                type = BenzoFusedStr.Type.Ole;
                --this.current;
            } else if (this.nameE("ine")) {
                type = BenzoFusedStr.Type.Ine;
            } else if (this.nameE("epine")) {
                type = BenzoFusedStr.Type.Epine;
            } else if (this.nameE("ocine")) {
                type = BenzoFusedStr.Type.Ocine;
            } else if (this.nameE("onine")) {
                type = BenzoFusedStr.Type.Onine;
            } else {
                return false;
            }
            if (locants == null) {
                switch (heteros.size()) {
                    case 1: {
                        locants = LocantList.simpleList(1);
                        break;
                    }
                    case 2: {
                        if (iso) {
                            locants = LocantList.simpleList(1, 2);
                            break;
                        }
                        if (type == BenzoFusedStr.Type.Epine) {
                            locants = LocantList.simpleList(1, 4);
                            break;
                        }
                        locants = LocantList.simpleList(1, 3);
                        break;
                    }
                    case 3: {
                        locants = LocantList.simpleList(1, 2, 3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (!RevolutionParser.setLocants(heteros, locants, type.ringSize)) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            BenzoFusedStr s = new BenzoFusedStr(type, heteros, locants);
            this.add(0, RevolutionParser.str(s));
            return true;
        }
    }

    static class AlcoholRewriter
    extends GlobalRewriter {
        AlcoholRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (tokens.get(0) instanceof Str && RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ") && RevolutionParser.name(tokens, 2, "alcohol")) {
                Str parent = (Str)RevolutionParser.get(tokens, 2);
                tokens.remove(1);
                Str sub = (Str)tokens.remove(0);
                sub.setSpaceSeparated(true);
                parent.addSubstituent(null, sub);
                return true;
            }
            return false;
        }
    }

    static class SpaceClass
    extends PrettyRewriter {
        SpaceClass() {
        }

        static boolean isSpaceClass(Token t) {
            if (!(t instanceof Str)) {
                return false;
            }
            String name = t.getName();
            if (name.endsWith("oxide") || name.endsWith("one") || name.equals("ketoxime") || name.equals("ketone oxime") || name.endsWith("ether") || name.equals("anhydride")) {
                return true;
            }
            Str st = (Str)t;
            if (st.suffixes != null && st.suffixes.size() == 1) {
                String suff = st.suffixes.get(0).getName();
                if (suff.equals("salt")) {
                    return true;
                }
                if ((name.equals("sulf") || name.equals("selen")) && suff.equals("ide")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean rewrite() {
            Str parent;
            Str sub;
            int subMul;
            boolean explicitSingle;
            LocantList locants;
            if (this.get(-1) != null && !this.sep(this.get(-1), " ")) {
                return false;
            }
            Locant locant = null;
            if (this.pass >= 2 && (locants = this.locants()) != null) {
                if (locants.size() == 1) {
                    locant = locants.getLocant(0);
                } else {
                    return false;
                }
            }
            boolean bl = explicitSingle = (subMul = this.multiplier()) == 1;
            if (subMul == -1) {
                subMul = 1;
            }
            if ((sub = this.structure()) == null || !this.sep(" ")) {
                return false;
            }
            if (sub.is("hydrogen")) {
                return false;
            }
            int multiplicity = 1;
            if (!this.name("mon") && !this.name("mono") && this.name("di")) {
                multiplicity = 2;
            }
            if ((parent = this.structure()) == null) {
                return false;
            }
            if (!(SpaceClass.isSpaceClass(parent) || sub.is("sodium") && multiplicity == 1)) {
                return false;
            }
            if (locant != null && !parent.hasLocant(locant)) {
                return false;
            }
            if (parent.is("sulf") || parent.is("selen")) {
                if (!sub.hasExplicitRadical()) {
                    return false;
                }
                if (!parent.hasSubstituents()) {
                    Molecule m = parent.getParentMol();
                    assert (m.getAtomCount() == 1);
                    parent = new EtherStr(parent.getName() + "ide", m.getAtom(0).getAtno());
                }
            }
            parent.multiplicity = multiplicity;
            String name = parent.getName();
            if (subMul == 1 && !explicitSingle && this.get(-1) == null && (parent.isSimpleEther() || parent.is("ketone") || parent.is("sulfone") || name.endsWith("oxide") && !name.equals("hydroxide")) && parent.substituents == null) {
                subMul = 2;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, parent);
            if (parent.is("ether") && sub.getName().endsWith("ethylene glycol")) {
                ((EtherStr)parent).setEther(sub);
                return true;
            }
            if (sub.is("oxime") || sub.is("monoxime") || sub.is("monooxime")) {
                sub.explicitSingle = explicitSingle;
                sub.multiplicity = subMul;
                parent.addSubstituent(locant, sub);
            } else {
                for (i = 0; i < subMul; ++i) {
                    if (subMul > 1) {
                        sub = sub.cloneMe();
                    }
                    sub.setSpaceSeparated(true);
                    sub.explicitSingle = explicitSingle;
                    parent.addSubstituent(locant, sub);
                }
            }
            return true;
        }
    }

    static class DiDiEther
    extends PrettyRewriter {
        DiDiEther() {
        }

        @Override
        boolean rewrite() {
            int mul1 = this.multiplier();
            if (mul1 != 2) {
                return false;
            }
            Str s1 = this.structure();
            if (s1 == null) {
                return false;
            }
            int mul2 = this.multiplier();
            if (mul2 != 2) {
                return false;
            }
            Str s2 = this.structure();
            if (s2 == null) {
                return false;
            }
            if (!this.sep(" ") || !this.name("ether")) {
                return false;
            }
            this.remove(3);
            this.remove(2);
            this.remove(1);
            BracketToken b = new BracketToken(s1, s2);
            this.add(1, b);
            return true;
        }
    }

    static class SpaceSubstituent
    extends GlobalRewriter {
        SpaceSubstituent() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int start;
            for (start = tokens.size() - 3; start >= 0 && !RevolutionParser.sep(tokens.get(start + 1), " "); --start) {
            }
            if (start < 0) {
                return false;
            }
            if (RevolutionParser.structureMaybeInBrackets(tokens.get(start)) == null) {
                return false;
            }
            Str sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
            if (!(RevolutionParser.get(tokens, start + 2) instanceof Str)) {
                return false;
            }
            Str parent = (Str)RevolutionParser.get(tokens, start + 2);
            if (!sub.is("hydrogen") && (SpaceClass.isSpaceClass(parent) || parent.is("disulfide") || parent.is("ester") || parent.isEsterParent() || parent.is("acetal"))) {
                return false;
            }
            sub.setSpaceSeparated(true);
            tokens.remove(start + 1);
            return true;
        }
    }

    static class ImplicitEsterRewriter
    extends Rewriter {
        ImplicitEsterRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int multiplier;
            boolean explicitSingle;
            if (this.before != null && !RevolutionParser.sep(this.before, " ") && !RevolutionParser.sep(this.before, RevolutionParser.nbsp)) {
                return false;
            }
            LocantList locants = null;
            int start = 0;
            if (RevolutionParser.simpleLocants(tokens.get(0)) && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                locants = (LocantList)tokens.get(0);
                if (locants.isOrthoMetaPara()) {
                    return false;
                }
                start = 2;
            }
            boolean bl = explicitSingle = (multiplier = RevolutionParser.multiplier(tokens.get(start))) == 1;
            if (multiplier != -1) {
                ++start;
            } else {
                multiplier = 1;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start)) != null && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ") && RevolutionParser.get(tokens, start + 2) instanceof Str) {
                Str sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
                Str parent = (Str)RevolutionParser.get(tokens, start + 2);
                if (RevolutionParser.name(tokens, start + 4, "ether")) {
                    return false;
                }
                if (parent instanceof SpecialStr) {
                    return false;
                }
                if (locants != null && !parent.hasLocants(locants)) {
                    return false;
                }
                if (!parent.isEsterParent()) {
                    if (!SpaceClass.isSpaceClass(parent) && sub.isEsterParent() && multiplier == 1 && locants == null && !sub.isSeparateFragment()) {
                        Str tmp = parent;
                        parent = sub;
                        sub = tmp;
                    } else {
                        return false;
                    }
                }
                if (locants != null && multiplier != locants.size()) {
                    throw new NameImportException.ParseException("Number of locants (" + locants.size() + ") does not match multiplier (" + multiplier + ") in " + tokens);
                }
                tokens.remove(start + 1);
                tokens.remove(start);
                while (start >= 0) {
                    tokens.remove(start--);
                }
                tokens.add(0, parent);
                for (int i = 0; i < multiplier; ++i) {
                    if (multiplier > 1) {
                        sub = sub.cloneMe();
                    }
                    sub.setSpaceSeparated(true);
                    sub.explicitSingle = explicitSingle;
                    Locant locant = locants == null ? null : locants.getLocant(i);
                    parent.addSubstituent(locant, sub);
                }
                return true;
            }
            return false;
        }
    }

    static class ExplicitEster
    extends GlobalRewriter {
        ExplicitEster() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Str acid;
            if (tokens.size() < 5) {
                return false;
            }
            int start = 0;
            ArrayList<Str> subs = new ArrayList<Str>();
            ArrayList<Locant> subLocants = new ArrayList<Locant>();
            while (!RevolutionParser.val(tokens, start, "ester")) {
                int multiplier;
                boolean explicitSingle;
                LocantList locants = null;
                if (RevolutionParser.get(tokens, start) instanceof LocantList) {
                    locants = (LocantList)RevolutionParser.get(tokens, start++);
                    if (RevolutionParser.name(tokens, start, "-")) {
                        ++start;
                    }
                }
                boolean bl = explicitSingle = (multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, start))) == 1;
                if (multiplier == -1) {
                    multiplier = 1;
                } else {
                    if (locants != null && multiplier != locants.size()) {
                        return false;
                    }
                    ++start;
                }
                if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ")) break;
                Str sub = RevolutionParser.structureMaybeInBrackets(tokens.get(start));
                if (sub.isSalt()) {
                    return false;
                }
                for (int i = 0; i < multiplier; ++i) {
                    if (multiplier > 1) {
                        sub = sub.cloneMe();
                    }
                    sub.explicitSingle = explicitSingle;
                    subs.add(sub);
                    Locant l = null;
                    if (locants != null) {
                        l = locants.getLocant(i);
                        if (this.pass < 2 && !this.isEsterLocant(l)) {
                            return false;
                        }
                    }
                    subLocants.add(l);
                }
                start += 2;
            }
            if (subs.isEmpty()) {
                return false;
            }
            if (!RevolutionParser.val(tokens, start, "ester")) {
                return false;
            }
            EsterStr ester = new EsterStr();
            if (RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), " ")) {
                if (RevolutionParser.get(tokens, start + 2) instanceof Str) {
                    acid = (Str)RevolutionParser.get(tokens, start + 2);
                    if (!acid.isEsterParent()) {
                        return false;
                    }
                } else {
                    return false;
                }
                tokens.remove(start + 2);
                tokens.remove(start + 1);
            } else if (((Str)subs.get(0)).isEsterParent()) {
                acid = (Str)subs.remove(0);
                if (subLocants.remove(0) != null) {
                    return false;
                }
            } else {
                return false;
            }
            int i = start + 1;
            while (--i >= 0) {
                tokens.remove(i);
            }
            tokens.add(0, ester);
            int loc = 0;
            for (Str sub : subs) {
                sub.setSpaceSeparated(true);
                sub.setLocantInParent((Locant)subLocants.get(loc++));
                ester.addSubstituent(null, sub);
            }
            ester.addSubstituent(null, acid);
            return true;
        }

        private boolean isEsterLocant(Locant l) {
            return l instanceof AtomLocant || l.isGreekLetter();
        }
    }

    static class AggregateRewriter
    extends PrettyRewriter {
        AggregateRewriter() {
        }

        @Override
        boolean rewrite() {
            Str s1 = this.structure();
            if (s1 == null) {
                return false;
            }
            this.optional(this.sep(" "));
            int mul2 = this.multiplier();
            Str s2 = this.structure();
            if (s2 == null) {
                return false;
            }
            if (!s1.isSeparateFragment() && !s2.isSeparateFragment()) {
                return false;
            }
            if (s1.hasExplicitRadical() || s2.hasExplicitRadical()) {
                return false;
            }
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            if (mul2 == -1) {
                this.add(0, new AggregateStr(s1, s2));
            } else {
                ArrayList<Str> components = new ArrayList<Str>(1 + mul2);
                components.add(s1);
                for (int i2 = 0; i2 < mul2; ++i2) {
                    components.add(s2.clone());
                }
                this.add(0, new AggregateStr(components));
            }
            return true;
        }
    }

    static class Oxide
    extends PrettyRewriter {
        Oxide() {
        }

        @Override
        boolean rewrite() {
            Str s1 = this.structure();
            if (!(s1 != null && this.sep(" ") && this.name("peroxide") && this.sep(" "))) {
                return false;
            }
            Str s2 = this.structure();
            if (s2 == null) {
                return false;
            }
            Str oxide = (Str)this.get(2);
            oxide.addSubstituent(null, s1);
            oxide.addSubstituent(null, s2);
            s1.setSpaceSeparated(true);
            s2.setSpaceSeparated(true);
            int i = this.current;
            while (--i >= 0) {
                if (i == 2) continue;
                this.remove(i);
            }
            return true;
        }
    }

    static class MultipliedStructure
    extends PrettyRewriter {
        MultipliedStructure() {
        }

        @Override
        boolean rewrite() {
            if (this.insideBrackets) {
                return false;
            }
            if (!this.atBeginningOrAfterSpace()) {
                return false;
            }
            int mul = this.multiplier();
            if (mul == -1) {
                return false;
            }
            Str st = this.structure();
            if (st == null) {
                return false;
            }
            if (st.substituents != null) {
                return false;
            }
            if (!this.atEndOrBeforeSpace()) {
                return false;
            }
            if (st.isSalt()) {
                return false;
            }
            throw new RuntimeException("Multiplied Structure");
        }
    }

    static class AcetalRw
    extends PrettyRewriter {
        AcetalRw() {
        }

        @Override
        boolean rewrite() {
            int mul = this.multiplier();
            if (mul == -1) {
                return false;
            }
            Str str = this.structure();
            if (str == null) {
                return false;
            }
            if (!this.sep(" ") || !this.nameUnchanged("acetal")) {
                return false;
            }
            Acetal acetal = new Acetal(mul, str);
            int i = this.current;
            while (--i >= 0) {
                this.remove(i);
            }
            this.add(0, acetal);
            return true;
        }
    }

    static class MultipliedSystemRewriter
    extends Rewriter {
        MultipliedSystemRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() != 4) {
                return false;
            }
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList locants = (LocantList)tokens.get(0);
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            int multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, 2));
            if (multiplier == -1) {
                return false;
            }
            if (locants.size() != multiplier) {
                return false;
            }
            Str parent = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 3));
            if (parent == null || parent.substituents != null) {
                return false;
            }
            MultipliedSystemStr s = new MultipliedSystemStr(multiplier, parent, locants);
            for (int i = 3; i >= 0; --i) {
                tokens.remove(i);
            }
            tokens.add(0, RevolutionParser.str(s));
            return true;
        }
    }

    static class Mustard
    extends PrettyRewriter {
        Mustard() {
        }

        @Override
        boolean rewrite() {
            Str s = this.structure();
            if (s == null || !(s instanceof AminoAcidStr) || s.substituents != null || !this.sep(" ")) {
                return false;
            }
            if (!this.nameUnchanged("mustard") && !this.nameUnchanged("nitrogen mustard")) {
                return false;
            }
            if (s.isCyclic()) {
                return false;
            }
            this.remove(2);
            this.remove(1);
            StructureToken sub = new StructureToken("mustard-sub", "CCCl |$def$|");
            sub.setLocantInParent(Locant.N);
            s.addSubstituent(sub);
            s.addSubstituent(sub.clone());
            return true;
        }
    }

    static class Benzo
    extends PrettyRewriter {
        Benzo() {
        }

        @Override
        boolean rewrite() {
            Str s = this.structure();
            if (s == null || !s.is("benz")) {
                return false;
            }
            if (!this.sep("o")) {
                return false;
            }
            this.remove(1);
            s.setValue("Cc1ccccc1 |$1;;2;3;4;5;6;$|");
            return true;
        }
    }

    static class ThiolBreaker
    extends Rewriter {
        ThiolBreaker() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "thiole")) {
                tokens.remove(0);
                tokens.add(0, StructureToken.create("thi", "S"));
                tokens.add(1, new EndingToken("ol", "O"));
                return true;
            }
            return false;
        }
    }

    static class Poly
    extends PrettyRewriter {
        Poly() {
        }

        @Override
        boolean rewrite() {
            if (!this.name("poly")) {
                return false;
            }
            BracketToken b = this.bracket();
            if (b == null || b.inside.size() != 1) {
                return false;
            }
            this.remove(1);
            this.remove(0);
            this.add(0, b.inside.get(0));
            N2S.getState().warnApproximation("polymer not represented");
            return true;
        }
    }

    static class BracketRemover
    extends PrettyRewriter {
        BracketRemover() {
        }

        @Override
        boolean rewrite() {
            BracketToken b = this.bracket();
            if (b == null) {
                return false;
            }
            if (b.inside.size() != 1) {
                return false;
            }
            Token t = b.inside.get(0);
            if (!(t instanceof EndingToken)) {
                return false;
            }
            this.remove(0);
            this.add(0, t);
            return true;
        }
    }

    static class MonoRemover
    extends PrettyRewriter {
        MonoRemover() {
        }

        @Override
        boolean rewrite() {
            if (this.name("mono")) {
                if (this.name("anhydride")) {
                    throw new NameImportException.ParseException("monoanhydride not supported yet");
                }
                this.remove(0);
                return true;
            }
            return false;
        }
    }

    static class NbSpRemover
    extends Rewriter {
        NbSpRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.sep(RevolutionParser.get(tokens, 0), RevolutionParser.nbsp)) {
                if (this.before instanceof LocantList && ((LocantList)this.before).isAllNumGreek()) {
                    return false;
                }
                tokens.remove(0);
                return true;
            }
            return false;
        }
    }

    static class MultiplierDashRemover
    extends Rewriter {
        MultiplierDashRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !(RevolutionParser.get(tokens, 2) instanceof Str)) {
                return false;
            }
            if (RevolutionParser.multiplier(RevolutionParser.get(tokens, 0)) != -1) {
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class DashRemover
    extends BackwardsRewriter {
        DashRemover() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 3) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                return false;
            }
            Token after = RevolutionParser.get(tokens, 2);
            if (!(after instanceof Str) && !(after instanceof EndingToken)) {
                return false;
            }
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 0)) != null) {
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class EndingAsStructure
    extends Rewriter {
        EndingAsStructure() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(RevolutionParser.get(tokens, 0) instanceof EndingToken)) {
                return false;
            }
            EndingToken ending = (EndingToken)RevolutionParser.get(tokens, 0);
            if (ending.getType() == 2) {
                tokens.remove(0);
                Str s = StructureToken.create(ending.getName(), ending.getValue());
                tokens.add(0, s);
                return true;
            }
            return false;
        }
    }

    static class EthyleneGlycol
    extends PrettyRewriter {
        EthyleneGlycol() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean rewrite() {
            String atom;
            int num = this.multiplier();
            if (num == -1) {
                num = 1;
            }
            if (!this.name("eth") || !this.nameE("ylene")) {
                return false;
            }
            if (this.sep(" ")) {
                if (!this.name("glycol")) return false;
                atom = "O";
            } else {
                int mulAmine = this.multiplier();
                if (mulAmine == -1 || !this.nameE("amine")) return false;
                if (mulAmine != num + 1) {
                    throw new NameImportException.ParseException("Invalid ethylene");
                }
                atom = "N";
            }
            String name = this.removeAllAndGetName();
            String locs = " |$def";
            if (atom == "N") {
                locs = locs + ",N";
            } else if (atom == "O") {
                locs = locs + ",ester,mergeWithN";
            }
            String struc = atom;
            while (num-- > 0) {
                struc = struc + "CC" + atom;
                locs = locs + ";;;";
            }
            if (atom == "N") {
                locs = locs + "N'";
            } else if (atom == "O") {
                locs = locs + "ester,mergeWithN";
            }
            locs = locs + "$|";
            Str s = StructureToken.create(name, struc + locs);
            this.add(0, s);
            return true;
        }
    }

    static class MethyleneDioxy
    extends PrettyRewriter {
        MethyleneDioxy() {
        }

        @Override
        boolean rewrite() {
            if (!(this.name("meth") && this.nameE("ylene") && this.name("di") && this.name("oxy"))) {
                return false;
            }
            String name = this.removeAllAndGetName();
            Str methylenedioxy = StructureToken.create(name, "OCO |$end1;;end2$|");
            this.add(0, methylenedioxy);
            return true;
        }
    }

    static class MethyleneSuffix
    extends PrettyRewriter {
        MethyleneSuffix() {
        }

        @Override
        boolean rewrite() {
            Str methylene = this.structure();
            if (methylene == null || !methylene.nameEndsWith("methylene")) {
                return false;
            }
            this.optional(this.sep(" "));
            Str suffix = this.structure();
            if (suffix == null) {
                return false;
            }
            String value = suffix.getMolPublic().toFormat("smiles");
            Suffix s = new Suffix(suffix.getName(), value, null, 1, -1);
            methylene.addSuffix(s);
            int i = this.current;
            while (--i > 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Methylene
    extends PrettyRewriter {
        Methylene() {
        }

        @Override
        boolean rewrite() {
            int num = this.multiplier();
            if (num == -1) {
                return false;
            }
            if (!this.name("meth")) {
                return false;
            }
            if (!this.nameE("ylene")) {
                return false;
            }
            String name = this.removeAllAndGetName();
            Str methylene = PolyMethylene.create(name, num);
            this.add(0, methylene);
            this.current = 1;
            if (this.sep(" ") && this.name("glycol")) {
                this.remove(2);
                this.remove(1);
                methylene.addSuffix(new Suffix("glycol", "O", null, 2, -1));
            }
            return true;
        }
    }

    static class HeteroChainRewriter
    extends PrettyRewriter {
        HeteroChainRewriter() {
        }

        @Override
        boolean rewrite() {
            int mul = this.multiplier();
            if (mul == -1) {
                return false;
            }
            HeteroAtomStr atom1 = this.hetero();
            if (atom1 == null || atom1.isModified()) {
                return false;
            }
            if (!ParserUtilLegacy.isHeteroChainAtom(atom1)) {
                return false;
            }
            HeteroAtomStr atom2 = this.hetero();
            if (atom2 != null && !ParserUtilLegacy.isHeteroChainAtom(atom2)) {
                atom2 = null;
                --this.current;
            }
            String name1 = atom1.getName();
            if (atom2 == null && (name1.endsWith("ane") || name1.endsWith("an"))) {
                LocantList locants;
                if (this.get(-2) instanceof LocantList && (locants = (LocantList)this.get(-2)).size() == 2 && !(locants.getLocant(0) instanceof NonStdValenceLocant)) {
                    return false;
                }
            } else {
                if (Chem.isChalcogen(atom1.getAtno())) {
                    return false;
                }
                if (!(atom2 != null && atom2.getName().endsWith("ane") || this.nameE("ane") || this.peek(this.nameE("ene")) || atom1.hasSuffixName("ane") || atom1.hasSuffixName("ene"))) {
                    return false;
                }
            }
            for (int i = this.current - 1; i >= 0; --i) {
                this.remove(i);
            }
            HeteroChainStr h = atom2 == null ? new HeteroChainStr(atom1, mul) : new HeteroChainStr(atom2, atom1, mul);
            h.addSuffixes((atom2 != null ? atom2 : atom1).suffixes);
            this.add(0, RevolutionParser.str(h));
            return true;
        }
    }

    static class NumberAsChain
    extends Rewriter {
        NumberAsChain() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            Token t = tokens.get(0);
            int num = RevolutionParser.multiplier(t);
            if (num == -1 || num < 5) {
                return false;
            }
            if (!this.canFollowParent(num, tokens, 1)) {
                return false;
            }
            tokens.remove(0);
            StringBuilder struc = new StringBuilder();
            int i = num;
            while (--i >= 0) {
                struc.append("C");
            }
            struc.append(" |$loc1,");
            i = 0;
            while (++i <= num) {
                if (i > 1) {
                    struc.append(';');
                }
                struc.append(Integer.toString(i));
            }
            struc.append(",loc2$|");
            tokens.add(0, StructureToken.create(t.getName(), struc.toString()));
            return true;
        }

        private boolean canFollowParent(int num, List<Token> tokens, int cur) {
            LocantList locants;
            Token next = RevolutionParser.get(tokens, cur);
            String name = next.getName();
            if (name.equals("oic acid") || name.equals("amide") || name.equals("oate") || next instanceof Number) {
                return true;
            }
            return RevolutionParser.sep(next, "-") && RevolutionParser.get(tokens, cur + 1) instanceof LocantList && (locants = (LocantList)RevolutionParser.get(tokens, cur + 1)).size() != num;
        }
    }

    static class MultipliedAcid
    extends PrettyRewriter {
        MultipliedAcid() {
        }

        @Override
        boolean rewrite() {
            int i;
            int mul = this.multiplier();
            Str acid = this.structure();
            if (mul == -1 || acid == null || !acid.isAcid()) {
                return false;
            }
            if (!acid.is("phosphate")) {
                return false;
            }
            String acidSmi = "P(=O)([O-])O";
            StringBuilder smiles = new StringBuilder("[O-]");
            int i2 = mul;
            while (--i2 >= 0) {
                smiles.append(acidSmi);
            }
            smiles.deleteCharAt(smiles.length() - 1);
            smiles.append("[O-]");
            smiles.append(" |$ester;");
            int sp = mul + 2;
            for (i = 0; i < 2 * mul; i += 2) {
                String s = ";;" + sp + ",ester;";
                if (i == 0) {
                    s = "defCon" + s;
                }
                smiles.append(s);
                if (i + 2 < 2 * mul) {
                    smiles.append(";");
                }
                --sp;
            }
            smiles.append(sp).append(",ester");
            smiles.append("$|");
            acid.setName(Chem.diMultiplier(mul) + acid.getName());
            acid.setValue(smiles.toString());
            i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Hydrogen
    extends PrettyRewriter {
        Hydrogen() {
        }

        @Override
        boolean rewrite() {
            int mulH = this.multiplier();
            if (mulH == -1 || !this.name("hydrogen") || !this.sep(" ")) {
                return false;
            }
            int removeStart = this.current;
            this.optional(this.multiplier());
            Str acid = this.structure();
            if (acid == null || !acid.isAcid()) {
                return false;
            }
            StructureToken h = new StructureToken("hydro", "[H+]").cloneMe();
            h.setSpaceSeparated(true);
            int i = mulH;
            while (--i >= 0) {
                acid.addSubstituent(null, h.cloneMe());
            }
            i = removeStart;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Lambda
    extends PrettyRewriter {
        Lambda() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            if (locants == null || locants.size() != 1) {
                return false;
            }
            if (!(locants.getLocant(0) instanceof NonStdValenceLocant)) {
                return false;
            }
            Str s = this.structure();
            if (s == null) {
                return false;
            }
            if (!s.hasLocants(locants)) {
                return false;
            }
            if (!s.addLocantsBefore(locants)) {
                return false;
            }
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }
    }

    static class Ion
    extends PrettyRewriter {
        Ion() {
        }

        @Override
        boolean rewrite() {
            String value;
            if (!(this.get(0) instanceof Str)) {
                return false;
            }
            Str parent = (Str)this.get(0);
            if (!(this.get(1) instanceof BracketToken)) {
                return false;
            }
            BracketToken b = (BracketToken)this.get(1);
            if (b.inside.size() != 1 || !(b.inside.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList l = (LocantList)b.inside.get(0);
            if (l.getType() != 4) {
                return false;
            }
            int charge = l.getLocant(0).getValue();
            if (charge < 0) {
                value = "-";
                charge = -charge;
            } else {
                value = "+";
            }
            Suffix ion = new Suffix("ion", value, null, charge, 7);
            parent.addSuffix(ion);
            this.remove(1);
            if (this.sep(this.get(1), " ") && this.name(2, "ion")) {
                this.remove(2);
                this.remove(1);
            }
            return true;
        }
    }

    static class IndicatedHydrogenSwapper
    extends PrettyRewriter {
        IndicatedHydrogenSwapper() {
        }

        @Override
        boolean rewrite() {
            LocantList locants = this.locants();
            if (locants == null) {
                return false;
            }
            Hydro h = this.indicatedH();
            if (h == null) {
                return false;
            }
            if (this.sep("-")) {
                this.remove(--this.current);
            }
            this.remove(this.current - 1);
            this.add(0, h);
            return true;
        }
    }

    static class SuffixWithHydro
    extends PrettyRewriter {
        SuffixWithHydro() {
        }

        @Override
        boolean rewrite() {
            Token t;
            int start;
            Str parent = this.structure();
            if (parent == null || !this.sep("-")) {
                return false;
            }
            if (parent.suffixes != null || !parent.isCyclic()) {
                return false;
            }
            int end = start = this.current;
            while ((t = this.get(end)) instanceof Hydro) {
                ++this.current;
                ++end;
            }
            if (end == start) {
                return false;
            }
            this.optional(this.sep("-"));
            if (this.locants() == null) {
                return false;
            }
            if (this.get(end).is("-")) {
                this.remove(end);
            }
            int i = end;
            while (--i >= start) {
                Token t2 = this.get(i);
                Hydro h = (Hydro)t2;
                parent.addHydro(h);
                this.remove(i);
            }
            return true;
        }
    }

    static class MultipliedStructureAfter
    extends Rewriter {
        MultipliedStructureAfter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            boolean toParentSubstituents;
            int multiplier;
            Str parent;
            int start = 0;
            LocantList locants = null;
            LocantList secondLocants = null;
            int ylLocantsBondType = 1;
            if (RevolutionParser.get(tokens, 0) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                locants = (LocantList)RevolutionParser.get(tokens, 0);
                if (locants.isStereo()) {
                    return false;
                }
                start = 2;
            }
            if (RevolutionParser.get(tokens, start) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), "-")) {
                secondLocants = (LocantList)RevolutionParser.get(tokens, start);
                start += 2;
            }
            if ((parent = RevolutionParser.structureMaybeInBrackets(tokens.get(start))) != null && RevolutionParser.name(tokens, start + 1, "o")) {
                ++start;
            }
            if (parent == null) {
                if (RevolutionParser.name(tokens, start, "di") && RevolutionParser.name(tokens, start + 1, "thio") && RevolutionParser.multiplier(RevolutionParser.get(tokens, start + 2)) != -1) {
                    if (secondLocants == null) {
                        secondLocants = LocantList.simpleList(1, 2);
                    }
                    parent = (Str)tokens.get(start + 1);
                    parent.setValue("SS |$1;2$|");
                    ++start;
                } else {
                    return false;
                }
            }
            if (secondLocants == null && RevolutionParser.sep(RevolutionParser.get(tokens, start + 1), "-") && RevolutionParser.get(tokens, start + 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, start + 3), "-")) {
                secondLocants = (LocantList)RevolutionParser.get(tokens, start + 2);
                start += 3;
            }
            if ((multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, start + 1))) == -1) {
                return false;
            }
            int multiplierYl = -1;
            if (RevolutionParser.name(tokens, start + 2, "yl")) {
                multiplierYl = multiplier;
                multiplier = RevolutionParser.multiplier(RevolutionParser.get(tokens, (start += 2) + 1));
                if (multiplier == -1) {
                    return false;
                }
            }
            if (this.pass == 0 && multiplierYl == -1 && locants == null) {
                return false;
            }
            Str after = RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, start + 2));
            if (after == null) {
                return false;
            }
            if (secondLocants != null && (secondLocants = secondLocants.expandOMP(multiplier)).size() != multiplier) {
                return false;
            }
            if (locants != null && multiplier != (locants = locants.expandOMP(multiplier)).size()) {
                return false;
            }
            for (int i = start + 2; i >= 0; --i) {
                tokens.remove(i);
            }
            tokens.add(0, parent);
            if (parent.getName().equals("ethylene")) {
                parent.setValue("CC");
            }
            parent.removeSuffixName("ylene");
            parent.setName(parent.getName() + "bis");
            Radical yl = null;
            if ((multiplierYl != -1 || after.is("oxy") || after.is("acetonitrile")) && secondLocants == null) {
                secondLocants = locants;
                locants = null;
            }
            if (secondLocants == null && locants != null && locants.isOrthoMetaPara()) {
                secondLocants = locants;
                locants = null;
            }
            boolean bl = toParentSubstituents = parent.substituents != null && parent.substituents.size() == multiplier;
            if (secondLocants == null) {
                Suffix parentYl = parent.getSuffix("yl");
                if (parentYl != null && parentYl.hasLocant() && parentYl.getLocant().size() == multiplier) {
                    secondLocants = parentYl.getLocant();
                    parent.removeSuffix(parentYl);
                    toParentSubstituents = false;
                } else {
                    int i;
                    parentYl = parent.getSuffix("ylidene");
                    if (parentYl != null) {
                        if (!parentYl.hasLocant() || parentYl.getLocant().size() * 2 == multiplier) {
                            if (!parentYl.hasLocant()) {
                                secondLocants = LocantList.simpleList(1, 1);
                            } else {
                                secondLocants = new LocantList();
                                for (Locant l : parentYl.getLocant().getLocantsList()) {
                                    for (i = 0; i < 2; ++i) {
                                        secondLocants.addLocant(l);
                                    }
                                }
                            }
                            parent.removeSuffix(parentYl);
                            toParentSubstituents = false;
                        } else if (parentYl.getLocant().size() == multiplier) {
                            secondLocants = new LocantList();
                            for (Locant l : parentYl.getLocant().getLocantsList()) {
                                secondLocants.addLocant(l);
                            }
                            parent.removeSuffix(parentYl);
                            toParentSubstituents = false;
                            ylLocantsBondType = 2;
                        }
                    } else {
                        parentYl = parent.getSuffix("ylidyne");
                        if (!(parentYl == null || parentYl.hasLocant() && parentYl.getLocant().size() * 3 != multiplier)) {
                            if (!parentYl.hasLocant()) {
                                secondLocants = LocantList.simpleList(1, 1);
                                secondLocants.tryAddLocant(new SimpleLocant(1));
                            } else {
                                secondLocants = new LocantList();
                                for (Locant l : parentYl.getLocant().getLocantsList()) {
                                    for (i = 0; i < 3; ++i) {
                                        secondLocants.addLocant(l);
                                    }
                                }
                            }
                            parent.removeSuffix(parentYl);
                            toParentSubstituents = false;
                        }
                    }
                }
            }
            if (secondLocants == null && parent.is("ethbis")) {
                secondLocants = LocantList.simpleList(1, 2);
            }
            after.cloneMe();
            for (int i = 0; i < multiplier; ++i) {
                Locant l;
                Str currentAfter = after.cloneMe();
                if (locants != null) {
                    Locant ylLocant = locants.getLocant(i);
                    ylLocant.removePrimes();
                    LocantList ylLocants = LocantList.create(ylLocant);
                    if (ylLocantsBondType == 1) {
                        yl = new Radical("yl", "1", ylLocants, 1);
                    } else if (ylLocantsBondType == 2) {
                        yl = new Radical("ylidene", "2", ylLocants, 1);
                    } else {
                        throw new RuntimeException();
                    }
                    currentAfter.addSuffix(yl);
                }
                l = null;
                if (secondLocants != null) {
                    l = secondLocants.getLocant(i);
                }
                if (toParentSubstituents) {
                    Str sub = parent.substituents.get(i);
                    sub.removeSuffixName("ylene");
                    sub.addSubstituent(l, currentAfter);
                    continue;
                }
                parent.addSubstituent(l, currentAfter);
            }
            return true;
        }
    }

    static class AcidStructureEndingRewriter
    extends Rewriter {
        AcidStructureEndingRewriter() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 2) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 0) instanceof Str) || !(RevolutionParser.get(tokens, 1) instanceof Str)) {
                return false;
            }
            Str parent = (Str)tokens.get(0);
            Str ending = (Str)tokens.get(1);
            if (!parent.isCyclic()) {
                return false;
            }
            if (!ending.getName().endsWith(" acid")) {
                return false;
            }
            Suffix acid = new Suffix(ending.getName(), ending.getValue(), null, 1, 0);
            parent.addSuffix(acid);
            tokens.remove(1);
            return true;
        }
    }

    static class AtomModifierRewriter
    extends PrettyRewriter {
        AtomModifierRewriter() {
        }

        @Override
        boolean rewrite() {
            Str atom = this.structure();
            if (this.sep("-") && !this.sep(RevolutionParser.nbsp)) {
                return false;
            }
            Str parent = this.structure();
            if (atom == null || parent == null) {
                return false;
            }
            if (atom.isModified()) {
                return false;
            }
            if ((this.name(-1, "-") && this.get(-2) instanceof LocantList || this.get(-1) instanceof Number) && !parent.is("phen") && !this.atomLocant(this.get(-2))) {
                return false;
            }
            if (!(atom.is("thio") || atom.is("seleno") || atom.is("telluro"))) {
                return false;
            }
            if (!parent.consumeAtom(atom, this.get(-1) == null)) {
                if (this.pass > 1 && parent.is("phen")) {
                    parent.setName(atom.getName() + "phene");
                    parent.setValue(atom.getValue() + "1cccc1 |$1;2;3;4;5$|");
                } else {
                    return false;
                }
            }
            int i = this.current - 1;
            while (--i >= 0) {
                this.remove(i);
            }
            return true;
        }

        private boolean atomLocant(Token token) {
            if (!(token instanceof LocantList)) {
                return false;
            }
            LocantList l = (LocantList)token;
            if (l.size() != 1) {
                return false;
            }
            return l.getLocant(0) instanceof AtomLocant;
        }
    }

    static class OxyRewriter
    extends Rewriter {
        OxyRewriter() {
        }

        boolean isOxyUnit(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "meth") && RevolutionParser.name(tokens, 1, "oxy")) {
                return true;
            }
            return RevolutionParser.name(tokens, 0, "thi") && RevolutionParser.name(tokens, 1, "oxo");
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (tokens.size() < 2) {
                return false;
            }
            if (RevolutionParser.name(tokens, 0, "carbo") && RevolutionParser.name(tokens, 1, "meth") && RevolutionParser.name(tokens, 2, "oxy")) {
                Str oxy = (Str)tokens.get(2);
                oxy.setValue("COC=O |$;;1;;$|");
                oxy.setName("carbomethoxy");
                tokens.remove(1);
                tokens.remove(0);
                return true;
            }
            if (this.isOxyUnit(tokens)) {
                Str sub = (Str)tokens.remove(0);
                ((Str)tokens.get(0)).addSubstituent(null, sub);
                return true;
            }
            return false;
        }
    }

    static class Carbox
    extends Rewriter {
        Carbox() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.name(tokens, 0, "carbox") && RevolutionParser.get(tokens, 1) instanceof EndingToken) {
                EndingToken acid = (EndingToken)tokens.get(1);
                if (acid.getType() != 2) {
                    return false;
                }
                if (acid.getValue().indexOf("Radical:") != -1) {
                    acid.setValue(acid.getValue().replaceAll("Radical:[ ]*0", "Radical:1"));
                }
                tokens.remove(0);
                return true;
            }
            return false;
        }
    }

    static class AcidAmide
    extends Rewriter {
        AcidAmide() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            Token acid = tokens.get(0);
            if (!acid.getName().endsWith("ic acid")) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                return false;
            }
            int cur = 2;
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur));
            if (mul == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (!RevolutionParser.name(tokens, cur, "amide")) {
                return false;
            }
            String value = acid.getValue();
            for (i = 0; i < mul; ++i) {
                if (value.startsWith("O") && !value.startsWith("O=")) {
                    value = "N" + value.substring(1);
                    continue;
                }
                if (value.matches(".*([^=])O.*")) {
                    value = value.replaceFirst("([^=])O", "$1N");
                    continue;
                }
                return false;
            }
            acid.setValue(value);
            acid.setName(acid.getName() + " amide");
            for (i = cur; i > 0; --i) {
                tokens.remove(i);
            }
            return true;
        }
    }

    static class Tolyl
    extends Rewriter {
        Tolyl() {
            this.removeDashBefore = true;
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!(tokens.get(0) instanceof LocantList)) {
                return false;
            }
            LocantList locant = (LocantList)tokens.get(0);
            if (!locant.isOrthoMetaPara()) {
                return false;
            }
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !RevolutionParser.name(tokens, 2, "tol")) {
                return false;
            }
            Str tolyl = (Str)tokens.get(2);
            if (!tolyl.addLocantsBefore(locant)) {
                return false;
            }
            tokens.remove(1);
            tokens.remove(0);
            return true;
        }
    }

    static class AcidModifier
    extends PrettyRewriter {
        AcidModifier() {
        }

        @Override
        boolean rewrite() {
            int mul = RevolutionParser.multiplier(this.get(-1));
            if (mul != -1 || this.name(-1, "per")) {
                return false;
            }
            HeteroAtomStr modifier = this.hetero();
            Str acid = this.structureNoBracket();
            if (modifier == null || acid == null) {
                return false;
            }
            if (modifier.getAtno() == 7) {
                return false;
            }
            if (modifier.substituents != null) {
                return false;
            }
            if (!acid.isAcid()) {
                return false;
            }
            if (acid.firstAtomSubstituable()) {
                return false;
            }
            if (!(acid instanceof StructureToken)) {
                return false;
            }
            if (!((StructureToken)acid).replaceLastO(modifier)) {
                return false;
            }
            this.remove(0);
            return true;
        }
    }

    static class DetachedSubstituent
    extends PrettyRewriter {
        DetachedSubstituent() {
        }

        @Override
        boolean rewrite() {
            Str parent = this.structure();
            if (!this.sep(" ")) {
                return false;
            }
            LocantList locants = this.locants();
            Str sub = this.structure();
            if (parent == null || sub == null || locants == null) {
                return false;
            }
            if (parent.hasSuffixName("yl")) {
                return false;
            }
            SimpleLocant locant = locants.getSimpleLocant();
            if (locant == null) {
                return false;
            }
            if (!this.eol() && !this.peek(this.sep(" "))) {
                return false;
            }
            parent.addSubstituent(locant, sub);
            int i = this.current;
            while (--i > 0) {
                this.remove(i);
            }
            this.current = 1;
            if (this.sep(" ") && this.name("ester")) {
                sub.setSpaceSeparated(true);
                i = this.current;
                while (--i > 0) {
                    this.remove(i);
                }
            }
            return true;
        }
    }

    static class DetachedSuffix
    extends Rewriter {
        DetachedSuffix() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int mul;
            if (RevolutionParser.structureMaybeInBrackets(RevolutionParser.get(tokens, 0)) == null || !RevolutionParser.sep(RevolutionParser.get(tokens, 1), " ")) {
                return false;
            }
            LocantList locants = null;
            int cur = 2;
            if (RevolutionParser.get(tokens, 2) instanceof LocantList && RevolutionParser.sep(RevolutionParser.get(tokens, 3), "-")) {
                locants = (LocantList)tokens.get(2);
                cur = 4;
            }
            if ((mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, cur))) == -1) {
                mul = 1;
            } else {
                ++cur;
            }
            if (RevolutionParser.get(tokens, cur) instanceof Suffix) {
                Suffix suffix = (Suffix)tokens.get(cur);
                for (int i = cur; i > 0; --i) {
                    tokens.remove(i);
                }
                Str parent = RevolutionParser.structureMaybeInBrackets(tokens.get(0));
                suffix.setSpaceSeparated(true);
                parent.addSuffix(suffix);
            }
            if (RevolutionParser.get(tokens, cur) instanceof EndingToken) {
                EndingToken ending = (EndingToken)tokens.get(cur);
                for (int i = cur; i > 0; --i) {
                    tokens.remove(i);
                }
                Str parent = RevolutionParser.structureMaybeInBrackets(tokens.get(0));
                Suffix suffix = RevolutionParser.suffix(ending, locants, mul);
                suffix.setSpaceSeparated(true);
                parent.addSuffix(suffix);
                return true;
            }
            return false;
        }
    }

    static class Phosphoro
    extends Rewriter {
        Phosphoro() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            int i;
            String ending;
            if (!RevolutionParser.name(tokens, 0, "phosphoro")) {
                return false;
            }
            int mul = RevolutionParser.multiplier(RevolutionParser.get(tokens, 1));
            if (mul == -1) {
                return false;
            }
            if (!(RevolutionParser.get(tokens, 2) instanceof Str)) {
                return false;
            }
            Str atom = (Str)RevolutionParser.get(tokens, 2);
            if (!atom.isMonoAtomic()) {
                return false;
            }
            int max = 3;
            if (RevolutionParser.name(tokens, 3, "ite")) {
                ending = " |$0;0;0;0;$|";
            } else if (RevolutionParser.name(tokens, 3, "id") && RevolutionParser.name(tokens, 4, "ite")) {
                ending = "  |$0;0;0;0;$|";
                max = 4;
            } else if (RevolutionParser.name(tokens, 3, "ate")) {
                ending = "=O  |$0;0;0;0;$|";
            } else if (RevolutionParser.name(tokens, 3, "id") && RevolutionParser.name(tokens, 4, "ate")) {
                ending = "=O  |$0;0;0;0;$|";
                max = 4;
            } else {
                return false;
            }
            String name = tokens.get(0).toString() + tokens.get(1) + tokens.get(2) + tokens.get(max);
            for (int i2 = max; i2 >= 0; --i2) {
                tokens.remove(i2);
            }
            String s = "P";
            for (i = 0; i < mul; ++i) {
                s = s + "([" + atom.getValue() + "])";
            }
            for (i = mul; i < 3; ++i) {
                s = s + "(O)";
            }
            s = s + ending;
            tokens.add(0, StructureToken.create(name, s));
            return true;
        }
    }

    static class Biphenyl
    extends Rewriter {
        Biphenyl() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.name(tokens, 0, "bi")) {
                return false;
            }
            if (RevolutionParser.name(tokens, 1, "phen") && RevolutionParser.name(tokens, 2, "yl")) {
                Str biphenyl = (Str)tokens.get(1);
                tokens.remove(2);
                tokens.remove(0);
                biphenyl.setName("biphenyl");
                biphenyl.setValue("c1ccc(cc1)c1ccccc1 |$4;3;2;1;6;5;1';2';3';4';5';6'$|");
                return true;
            }
            return false;
        }
    }

    static class CasMultiplierAtEnd
    extends Rewriter {
        CasMultiplierAtEnd() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (!RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-") || !RevolutionParser.sep(RevolutionParser.get(tokens, 2), RevolutionParser.nbsp)) {
                return false;
            }
            if (tokens.get(0) instanceof LocantList) {
                tokens.remove(2);
                return true;
            }
            if (RevolutionParser.multiplier(tokens.get(0)) != -1) {
                tokens.remove(2);
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static class MultiplierDash
    extends Rewriter {
        MultiplierDash() {
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            if (RevolutionParser.multiplier(RevolutionParser.get(tokens, 0)) != -1 && RevolutionParser.sep(RevolutionParser.get(tokens, 1), "-")) {
                if (RevolutionParser.get(tokens, 2) instanceof LocantList) {
                    return false;
                }
                tokens.remove(1);
                return true;
            }
            return false;
        }
    }

    static abstract class GlobalRewriter
    extends Rewriter {
        GlobalRewriter() {
        }

        @Override
        boolean rewriteSomewhere(ArrayList<Token> tokens) {
            this.before = null;
            return this.rewrite(tokens);
        }
    }

    static abstract class BackwardsRewriter
    extends Rewriter {
        BackwardsRewriter() {
        }

        @Override
        boolean rewriteSomewhere(ArrayList<Token> tokens) {
            int i = tokens.size() - 1;
            while (--i >= 1) {
                this.before = tokens.get(i - 1);
                if (!this.rewrite(tokens.subList(i, tokens.size()))) continue;
                return true;
            }
            this.before = null;
            return this.rewrite(tokens);
        }
    }

    static abstract class PrettyRewriter
    extends Rewriter {
        private ArrayList<Token> tokens;
        private int currentStart;
        int current;
        static final int PER = -2;

        PrettyRewriter() {
        }

        abstract boolean rewrite();

        @Override
        public String toString() {
            return this.tokens.toString() + " [start=" + this.currentStart + "]";
        }

        int length() {
            return this.tokens.size() - this.currentStart;
        }

        Token get(int offset) {
            if ((offset += this.currentStart) < 0 || offset >= this.tokens.size()) {
                return null;
            }
            return this.tokens.get(offset);
        }

        Token remove(int offset) {
            return this.tokens.remove(this.currentStart + offset);
        }

        List<Token> tokens() {
            return this.tokens.subList(this.currentStart, this.tokens.size());
        }

        List<Token> remainingTokens() {
            return this.tokens.subList(this.currentStart + this.current, this.tokens.size());
        }

        String removeAllAndGetName() {
            return RevolutionParser.removeAndGetName(this.tokens(), 0, this.current - 1);
        }

        boolean sep(String name) {
            Token t = this.get(this.current);
            if (t != null && t.getName().equals(name)) {
                ++this.current;
                return true;
            }
            return false;
        }

        final boolean sep(Token t, String name) {
            return RevolutionParser.sep(t, name);
        }

        boolean tok(String value) {
            Token t = this.get(this.current);
            if (!t.isVal(value)) {
                return false;
            }
            ++this.current;
            return true;
        }

        boolean name(String name) {
            if (this.name(this.current, name)) {
                ++this.current;
                return true;
            }
            return false;
        }

        boolean nameE(String name) {
            if (this.nameE(this.current, name)) {
                ++this.current;
                return true;
            }
            return false;
        }

        boolean nameUnchanged(String name) {
            if (!this.nameE(name)) {
                return false;
            }
            Token t = this.get(this.current - 1);
            if (!(t instanceof Str)) {
                return true;
            }
            Str str = (Str)t;
            if (str.suffixes == null && str.substituents == null) {
                return true;
            }
            --this.current;
            return false;
        }

        boolean name(int offset, String name) {
            Token t = this.get(offset);
            return t != null && t.getName().equals(name);
        }

        boolean nameE(int offset, String name) {
            return RevolutionParser.name(this.get(offset), name);
        }

        int multiplier() {
            int res = RevolutionParser.multiplier(this.get(this.current));
            if (res != -1) {
                ++this.current;
            }
            return res;
        }

        int multiplierOrPer() {
            if (this.name("per")) {
                return -2;
            }
            return this.multiplier();
        }

        boolean peek(boolean res) {
            if (res) {
                --this.current;
            }
            return res;
        }

        boolean peek(Token t) {
            return this.peek(t != null);
        }

        boolean optional(Object o) {
            return true;
        }

        boolean eol() {
            return this.current + this.currentStart == this.tokens.size();
        }

        boolean atBeginningOrAfterSpace() {
            return this.get(-1) == null || this.name(-1, " ");
        }

        boolean atEndOrBeforeSpace() {
            return this.get(this.current) == null || this.name(this.current, " ");
        }

        void add(int offset, Token t) {
            this.tokens.add(this.currentStart + offset, t);
        }

        void set(int offset, Token t) {
            this.tokens.set(this.currentStart + offset, t);
        }

        Token nextToken() {
            return this.get(this.current++);
        }

        LocantList fusion() {
            if (!(this.get(this.current) instanceof LocantList)) {
                return null;
            }
            LocantList res = (LocantList)this.get(this.current);
            if (res.getType() != 5) {
                return null;
            }
            ++this.current;
            return res;
        }

        LocantList simpleLocants() {
            int oldCurrent = this.current;
            LocantList res = this.locants(false, false);
            if (RevolutionParser.simpleLocants(res)) {
                return res;
            }
            this.current = oldCurrent;
            return null;
        }

        LocantList rawLocants() {
            Token cur = this.get(this.current);
            if (!(cur instanceof LocantList)) {
                return null;
            }
            ++this.current;
            return (LocantList)cur;
        }

        LocantList locantsFlex() {
            LocantList res = this.rawLocants();
            if (res == null) {
                return null;
            }
            this.sep("-");
            return res;
        }

        LocantList locants() {
            return this.locants(true, false);
        }

        LocantList locants(boolean allowBrackets, boolean allowNbSp) {
            if (this.get(this.current) instanceof LocantList) {
                Token next = this.get(this.current + 1);
                if (this.sep(next, "-") || this.sep(next, RevolutionParser.nbsp)) {
                    this.current += 2;
                    return (LocantList)this.get(this.current - 2);
                }
                return null;
            }
            if (allowBrackets) {
                return this.bracketedLocants();
            }
            return null;
        }

        LocantList bracketedLocants() {
            if (this.get(this.current) instanceof BracketToken) {
                BracketToken b = (BracketToken)this.get(this.current);
                if (b.inside.size() == 1 && b.inside.get(0) instanceof LocantList) {
                    ++this.current;
                    return (LocantList)b.inside.get(0);
                }
            }
            return null;
        }

        AtomLocant atomLocant() {
            if (this.get(this.current) instanceof LocantList) {
                LocantList l = (LocantList)this.get(this.current);
                if (l.size() != 1 || !(l.getLocant(0) instanceof AtomLocant)) {
                    return null;
                }
                ++this.current;
                return (AtomLocant)l.getLocant(0);
            }
            return null;
        }

        Str structure() {
            Str res = RevolutionParser.structureMaybeInBrackets(this.get(this.current));
            if (res != null) {
                ++this.current;
            }
            return res;
        }

        Str normalStructure() {
            Str res = RevolutionParser.structureMaybeInBrackets(this.get(this.current));
            if (res instanceof SpecialStr || res instanceof BridgeStr || res instanceof HeteroAtomStr) {
                return null;
            }
            if (res != null) {
                ++this.current;
            }
            return res;
        }

        Str structureNoBracket() {
            Token t = this.get(this.current);
            if (t instanceof Str) {
                ++this.current;
                return (Str)t;
            }
            return null;
        }

        Hydro hydro() {
            Hydro h;
            Token t = this.get(this.current);
            if (t instanceof Hydro && (h = (Hydro)t).getLocants() == null) {
                ++this.current;
                return h;
            }
            return null;
        }

        Hydro indicatedH() {
            Hydro h;
            Token t = this.get(this.current);
            if (t instanceof Hydro && (h = (Hydro)t).getLocants() != null) {
                ++this.current;
                return h;
            }
            return null;
        }

        HeteroAtomStr hetero() {
            Token t = this.get(this.current);
            if (!RevolutionParser.hetero(t)) {
                return null;
            }
            ++this.current;
            return HeteroAtomStr.create(t);
        }

        EndingToken ending() {
            Token t = this.get(this.current);
            if (t instanceof EndingToken) {
                ++this.current;
                return (EndingToken)t;
            }
            return null;
        }

        BracketToken bracket() {
            Token t = this.get(this.current);
            if (t instanceof BracketToken) {
                ++this.current;
                return (BracketToken)t;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean rewriteSomewhere(ArrayList<Token> tokens) {
            ArrayList<Token> previousTokens = this.tokens;
            int previousCurrentStart = this.currentStart;
            int previousCurrent = this.current;
            try {
                this.tokens = tokens;
                int i = 0;
                while (i < tokens.size()) {
                    this.currentStart = i++;
                    this.current = 0;
                    if (!this.rewrite()) continue;
                    if (this.removeSpaceBefore && this.name(-1, " ")) {
                        this.remove(-1);
                    }
                    if (this.removeDashBefore && this.name(-1, "-") && RevolutionParser.beforeDash(this.get(-2))) {
                        this.remove(-1);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.tokens = previousTokens;
                this.currentStart = previousCurrentStart;
                this.current = previousCurrent;
            }
        }

        @Override
        boolean rewrite(List<Token> tokens) {
            throw new NameImportException.Failure("Not used in PrettyRewriter");
        }
    }

    static abstract class Rewriter {
        int pass = -1;
        static int applications = 0;
        Token before;
        boolean insideBrackets;
        boolean removeDashBefore = false;
        boolean removeSpaceBefore = false;
        Str outsideComponent;

        Rewriter() {
        }

        Rewriter pass(int pass) {
            this.pass = pass;
            return this;
        }

        abstract boolean rewrite(List<Token> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean rewriteSomewhere(ArrayList<Token> tokens, boolean insideBrackets) {
            boolean previousInsideBrackets = this.insideBrackets;
            this.insideBrackets = insideBrackets;
            try {
                boolean bl = this.rewriteSomewhere(tokens);
                return bl;
            }
            finally {
                this.insideBrackets = previousInsideBrackets;
            }
        }

        boolean rewriteSomewhere(ArrayList<Token> tokens) {
            this.before = null;
            if (this.rewrite(tokens)) {
                return true;
            }
            for (int i = 1; i < tokens.size(); ++i) {
                this.before = tokens.get(i - 1);
                if (!this.rewrite(tokens.subList(i, tokens.size()))) continue;
                if (this.removeDashBefore && RevolutionParser.sep(this.before, "-") && (i == 1 || RevolutionParser.beforeDash(tokens.get(i - 2)))) {
                    tokens.remove(i - 1);
                }
                if (this.removeSpaceBefore && RevolutionParser.sep(this.before, " ")) {
                    tokens.remove(i - 1);
                }
                return true;
            }
            return false;
        }

        public String getName() {
            return this.getClass().getSimpleName() + (this.pass == -1 ? "" : "(pass " + this.pass + ")");
        }

        public String toString() {
            return this.getName();
        }
    }
}

