/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.struc.Molecule;
import java.util.LinkedHashMap;
import java.util.Map;

public class StructureLegacy {
    static int MAX_CACHE_SIZE = 200;
    private static final LinkedHashMap<String, Molecule> molCache = new LinkedHashMap<String, Molecule>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Molecule> eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    };

    public static Molecule readMol(String smiles) {
        Molecule mol = molCache.get(smiles);
        if (mol != null) {
            return mol.cloneMolecule();
        }
        try {
            mol = MolImporter.importMol(smiles, "cxsmiles");
            molCache.put(smiles, mol);
            return mol.cloneMolecule();
        }
        catch (MolFormatException e) {
            throw new NameImportException.Failure(e);
        }
    }

    public static String removeHydrogens(String atom) {
        if (atom == null || atom.length() < 3) {
            return atom;
        }
        if (atom.indexOf(72) > 0 && Character.isDigit(atom.charAt(atom.length() - 2))) {
            int digit = Character.getNumericValue(atom.charAt(atom.length() - 2));
            char digi = ("" + digit).charAt(0);
            char digi2 = ("" + (digit - 1)).charAt(0);
            atom = atom.replace(digi, digi2);
        }
        return atom;
    }
}

