/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.struc.Molecule;

public class TertChainStr
extends StructureToken {
    public static Str create(Str chain) {
        String smiles = chain.is("oct") ? "C(C)(C)CC(C)(C)C |$defaultRadical$|" : "C(C)(C)" + chain.getValue().substring(3);
        chain.setValue(smiles);
        chain.getLocantMap().put("beta", chain.getAtom(new SimpleLocant(4)));
        return chain;
    }

    private TertChainStr(String name, String struc) {
        super("tert" + name, TertChainStr.makeTert(struc, name));
    }

    private static String makeTert(String struc, String name) {
        return "C(C)(C)" + struc.substring(3);
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = super.createParentMolecule();
        this.addLocant(res.getAtom(3), "beta");
        return res;
    }
}

