/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.RingNumber;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.RingUtil;
import chemaxon.naming.n2s.parse.StructureLegacy;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class VonBaeyerStr
extends Str {
    protected LocantList numbering;
    protected int atom;
    protected int atom2 = -1;
    protected boolean aromatic = false;

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = StructureLegacy.readMol(this.toSmiles());
        for (MolAtom a : res.getAtomArray()) {
            a.setValenceProp(-1);
        }
        return res;
    }

    public VonBaeyerStr(LocantList numbering, int atom, int atom2) {
        this.name = "VonBaeyer";
        this.numbering = numbering;
        this.atom = atom;
        this.atom2 = atom2;
    }

    public VonBaeyerStr(LocantList numbering, int atom) {
        this.name = "VonBaeyer";
        this.numbering = numbering;
        this.atom = atom;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    protected String printValue() {
        String atom2 = this.atom2 == -1 ? "" : " " + this.atom2;
        return '\"' + this.numbering.toString() + " " + this.atom + atom2 + '\"';
    }

    private String toSmiles() {
        String smiles = this.getComplexRing();
        if (this.aromatic) {
            smiles = smiles.toLowerCase();
        }
        return smiles;
    }

    private String getComplexRing() {
        String exmsg = "Invalid ring-numbering";
        try {
            String retVal = this.atom2 != -1 ? this.buildSmiles(this.numbering, this.atom2, this.atom) : this.buildSmiles(this.numbering, this.atom);
            return retVal;
        }
        catch (Exception e) {
            throw new NameImportException(exmsg);
        }
    }

    private String buildSmiles(LocantList numbering, int a) {
        int i;
        String atom = PeriodicSystem.getSymbol(a);
        if (atom.length() == 2) {
            int valence = Chem.standardValence(a) - 1;
            atom = "[" + atom + "H" + valence + "]";
        }
        StringBuffer retVal = new StringBuffer();
        StringBuffer numbers = new StringBuffer("|$");
        int locant = 0;
        int ringIndex = 1;
        RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        retVal.append(ringIndex);
        for (i = 0; i < numbering.getLocant(0).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        }
        RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        for (i = 0; i < numbering.getLocant(1).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atom, ++locant);
        }
        retVal.append(ringIndex);
        RingUtil.appendBridge(retVal, numbers, 1, numbering.getLocant(0).getValue() + 2, numbering.getLocant(2).getValue(), ++ringIndex, atom, ++locant);
        locant += numbering.getLocant(2).getValue() - 1;
        for (i = 3; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            RingUtil.appendBridge(retVal, numbers, ringnum.getSecond(), ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atom, ++locant);
            locant += ringnum.getValue() - 1;
        }
        numbers.deleteCharAt(numbers.length() - 1);
        numbers.append("$|");
        return retVal.toString() + " " + numbers.toString();
    }

    private String buildSmiles(LocantList numbering, int a1, int a2) {
        int i;
        String atom1 = PeriodicSystem.getSymbol(a1);
        String atom2 = PeriodicSystem.getSymbol(a2);
        StringBuffer retVal = new StringBuffer();
        StringBuffer numbers = new StringBuffer("|$");
        int locant = 0;
        int shift = 1;
        int ringIndex = 1;
        String[] atoms = new String[]{atom1, atom2};
        RingUtil.appendAtom(retVal, numbers, atoms[0], ++locant);
        retVal.append(ringIndex);
        for (i = 0; i < numbering.getLocant(0).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        }
        RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        for (i = 0; i < numbering.getLocant(1).getValue(); ++i) {
            RingUtil.appendAtom(retVal, numbers, atoms[locant % 2], ++locant);
        }
        retVal.append(ringIndex);
        RingUtil.appendBridge(retVal, numbers, 1, numbering.getLocant(0).getValue() + 2, numbering.getLocant(2).getValue(), ++ringIndex, atoms, ++locant, shift);
        locant += numbering.getLocant(2).getValue() - 1;
        for (i = 3; i < numbering.size(); ++i) {
            RingNumber ringnum = (RingNumber)numbering.getLocant(i);
            String tmp = retVal.toString();
            shift = tmp.lastIndexOf(atom1) > tmp.lastIndexOf(atom2) ? 0 : 1;
            RingUtil.appendBridge(retVal, numbers, ringnum.getSecond(), ringnum.getFirst(), ringnum.getValue(), ++ringIndex, atoms, ++locant, shift);
            locant += ringnum.getValue() - 1;
        }
        numbers.deleteCharAt(numbers.length() - 1);
        numbers.append("$|");
        return retVal.toString() + " " + numbers.toString();
    }
}

