/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.util;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.RunAutomaton;
import java.util.HashMap;

public class AutomatonRewriter {
    private RunAutomaton automaton;
    private HashMap<String, String> replacements = new HashMap();

    public AutomatonRewriter(String ... rules) {
        this.automaton = this.buildAutomaton(rules);
    }

    public String rewrite(String input) {
        AutomatonMatcher matcher = this.automaton.newMatcher((CharSequence)input);
        if (!matcher.find()) {
            return input;
        }
        StringBuilder res = new StringBuilder(input.length());
        int added = 0;
        do {
            res.append(input, added, matcher.start());
            String replaced = this.replacements.get(matcher.group());
            res.append(replaced);
            added = matcher.end();
        } while (matcher.find());
        res.append(input, added, input.length());
        return res.toString();
    }

    public String rewriteOverlapping(String input) {
        int steps = 0;
        while (++steps < 10) {
            AutomatonMatcher matcher = this.automaton.newMatcher((CharSequence)input);
            if (!matcher.find()) {
                return input;
            }
            String replaced = this.replacements.get(matcher.group());
            input = input.substring(0, matcher.start()) + replaced + input.substring(matcher.end());
        }
        return input;
    }

    private RunAutomaton buildAutomaton(String[] rules) {
        assert (rules.length % 2 == 0);
        int n = rules.length / 2;
        CharSequence[] inputs = new String[n];
        for (int i = 0; i < n; ++i) {
            String in = rules[i * 2];
            String out = rules[i * 2 + 1];
            inputs[i] = in;
            this.replacements.put(in, out);
        }
        Automaton a = BasicAutomata.makeStringUnion((CharSequence[])inputs);
        return new RunAutomaton(a);
    }
}

