/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.util;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;

public class MoleculeDoctor {
    public static boolean check(MoleculeGraph m) {
        MoleculeDoctor.checkAtomNeighbours(m);
        return true;
    }

    private static void checkAtomNeighbours(MoleculeGraph m) {
        for (MolAtom a : m.getAtomArray()) {
            MoleculeDoctor.checkContains(m, a);
            for (MolAtom neighbour : a.getLigands()) {
                MoleculeDoctor.checkContains(m, neighbour);
            }
        }
    }

    private static void checkContains(MoleculeGraph m, MolAtom a) {
        if (m.indexOf(a) == -1) {
            throw new MoleculeInternalStateException("Atom missing from the molecule: " + MoleculeDoctor.display(a));
        }
    }

    private static String display(MolAtom a) {
        return a.toString() + " alias=" + a.getAliasstr();
    }

    public static class MoleculeInternalStateException
    extends RuntimeException {
        private static final long serialVersionUID = -8406475459228255607L;

        MoleculeInternalStateException(String message) {
            super(message);
        }
    }
}

