/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep;

import chemaxon.nfunk.jep.ASTArrayElementNode;
import chemaxon.nfunk.jep.ASTAssignNode;
import chemaxon.nfunk.jep.ASTConstant;
import chemaxon.nfunk.jep.ASTFunNode;
import chemaxon.nfunk.jep.ASTStart;
import chemaxon.nfunk.jep.ASTVarNode;
import chemaxon.nfunk.jep.ASTVectorNode;
import chemaxon.nfunk.jep.Node;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.ParserVisitor;
import chemaxon.nfunk.jep.SimpleNode;
import chemaxon.nfunk.jep.SymbolTable;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class EvaluatorVisitor
implements ParserVisitor,
Serializable {
    public static final Object UNDECIDED = PostfixMathCommandI.UNDECIDED;
    private Stack stack = new Stack();
    private Vector errorList = null;
    private SymbolTable symTab = null;
    private boolean errorFlag;
    private static final boolean debug = false;

    public void clear() {
        if (this.errorList != null) {
            this.errorList.removeAllElements();
        }
        this.errorFlag = false;
        this.stack.removeAllElements();
    }

    private void addToErrorList(Exception e) {
        if (this.errorList != null) {
            this.errorList.addElement(e);
        }
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public Exception getError(int i) {
        return (Exception)this.errorList.elementAt(i);
    }

    public Throwable[] getErrors() {
        if (this.errorList == null || this.errorList.isEmpty()) {
            return null;
        }
        Throwable[] errors = new Throwable[this.errorList.size()];
        this.errorList.toArray(errors);
        return errors;
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws ParseException {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        int n = topNode.jjtGetNumChildren();
        ArrayList results = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            try {
                topNode.jjtGetChild(i).jjtAccept(this, null);
            }
            catch (Exception e) {
                this.addToErrorList(e);
                throw new ParseException(this.getErrors());
            }
            if (this.stack.size() == 1) {
                results.add(this.stack.pop());
            }
            if (!this.errorFlag && this.stack.size() <= 0) continue;
            if (this.errorFlag) {
                throw new ParseException(this.getErrors());
            }
            throw new ParseException("Error - stack size: " + this.stack.size());
        }
        return results.size() == 1 ? results.get(0) : results.toArray();
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return data;
    }

    public Object visitLazy(ASTFunNode node, Object data) {
        PostfixMathCommandI pfmc = node.getPFMC();
        Object result = null;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i <= n; ++i) {
            if (i < n) {
                node.jjtGetChild(i).jjtAccept(this, data);
                if (this.stack.peek() == UNDECIDED) {
                    result = this.stack.pop();
                    continue;
                }
            } else {
                if (result != null) {
                    this.stack.push(result);
                    break;
                }
                this.stack.push(null);
            }
            try {
                pfmc.run(this.stack);
            }
            catch (ParseException e) {
                this.addToErrorList(e);
                this.errorFlag = true;
                break;
            }
            if (this.stack.peek() != null) break;
            this.stack.pop();
        }
        return data;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        if (node.isLazy()) {
            return this.visitLazy(node, data);
        }
        data = node.childrenAccept(this, data);
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            this.addToErrorList(new ParseException("No function class associated with " + node.getName()));
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            if (pfmc.check(this.stack)) {
                pfmc.run(this.stack);
            }
        }
        catch (ParseException e) {
            this.addToErrorList(e);
            this.errorFlag = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) {
        String message = "Could not evaluate " + node.getName() + ": ";
        if (this.symTab == null) {
            message = message + "the symbol table is null";
            this.addToErrorList(new ParseException(message));
            return data;
        }
        Object temp = this.symTab.get(node.getName());
        if (temp == null) {
            message = message + "the variable was not found in the symbol table";
            this.addToErrorList(new ParseException(message));
            this.errorFlag = true;
        } else if (temp instanceof Exception) {
            this.addToErrorList((Exception)temp);
            this.errorFlag = true;
        } else {
            this.stack.push(temp);
        }
        return data;
    }

    @Override
    public Object visit(ASTArrayElementNode node, Object data) {
        data = node.childrenAccept(this, data);
        int n = node.jjtGetNumChildren();
        if (n < 2) {
            this.addToErrorList(new ParseException("Array node should have at least 2 child nodes instead of " + n + "."));
            return data;
        }
        int[] indices = new int[n - 1];
        for (int i = indices.length - 1; i >= 0; --i) {
            Object index = this.stack.pop();
            if (!(index instanceof Number)) {
                this.addToErrorList(new ParseException("The variable index is not a Number: " + index));
                return data;
            }
            try {
                indices[i] = ((Number)index).intValue();
                continue;
            }
            catch (NumberFormatException e) {
                this.addToErrorList(new ParseException("The variable index is not an Integer: " + index));
                return data;
            }
        }
        Object array = this.stack.pop();
        Object element = array;
        for (int i = 0; i < indices.length; ++i) {
            int k = indices[i];
            if (element instanceof Object[]) {
                element = ((Object[])element)[k];
                continue;
            }
            if (element instanceof List) {
                element = ((List)element).get(k);
                continue;
            }
            if (element instanceof int[]) {
                element = new Integer(((int[])element)[k]);
                continue;
            }
            if (element instanceof double[]) {
                element = new Double(((double[])element)[k]);
                continue;
            }
            this.addToErrorList(new ParseException("Array type is not implemented for: " + element.getClass()));
        }
        this.stack.push(element);
        return data;
    }

    @Override
    public Object visit(ASTVectorNode node, Object data) {
        int n = node.jjtGetNumChildren();
        Vector result = new Vector(n);
        for (int i = 0; i < n; ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
            result.add(this.stack.pop());
        }
        this.stack.push(result);
        return data;
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }

    @Override
    public Object visit(ASTAssignNode node, Object data) {
        data = node.childrenAccept(this, data);
        Object value = this.stack.pop();
        this.symTab.put(node.getIdentifier(), value);
        return data;
    }
}

