/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Stack;

public class Comparative
extends PostfixMathCommand {
    int id;
    double tolerance;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        if (param1 instanceof String) {
            if (param2 != null && !(param2 instanceof String)) {
                param2 = param2.toString();
            }
        } else if (param2 instanceof String && param1 != null) {
            param1 = param1.toString();
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            boolean r;
            double x = ((Number)param1).doubleValue();
            double y = ((Number)param2).doubleValue();
            switch (this.id) {
                case 0: {
                    r = x < y;
                    break;
                }
                case 1: {
                    r = x > y;
                    break;
                }
                case 2: {
                    r = x <= y;
                    break;
                }
                case 3: {
                    r = x >= y;
                    break;
                }
                case 4: {
                    r = x != y;
                    break;
                }
                case 5: {
                    r = x == y;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator");
                }
            }
            inStack.push(r ? TRUE : FALSE);
        } else if (param1 instanceof Complex && param2 instanceof Complex) {
            boolean r;
            switch (this.id) {
                case 4: {
                    r = !((Complex)param1).equals((Complex)param2, this.tolerance);
                    break;
                }
                case 5: {
                    r = ((Complex)param1).equals((Complex)param2, this.tolerance);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            inStack.push(r ? TRUE : FALSE);
        } else if (param1 instanceof String && param2 instanceof String) {
            boolean r;
            switch (this.id) {
                case 4: {
                    r = !((String)param1).equals((String)param2);
                    break;
                }
                case 5: {
                    r = ((String)param1).equals((String)param2);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            inStack.push(r ? TRUE : FALSE);
        } else {
            throw new ParseException("Invalid parameter type");
        }
    }
}

