/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Stack;
import java.util.Vector;

public class Divide
extends PostfixMathCommand {
    public Divide() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.div(param1, param2));
    }

    public Object div(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.div((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Number)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Number)param1, (Vector)param2);
            }
            if (param2 instanceof double[]) {
                return this.div((double[])param2, (Number)param1);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.div((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Complex)param1, (Vector)param2);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Number) {
                return this.div((Vector)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Vector)param1, (Complex)param2);
            }
        } else if (param1 instanceof double[]) {
            if (param2 instanceof Number) {
                return this.div((double[])param1, (Number)param2);
            }
            if (param2 instanceof double[]) {
                return this.div((double[])param1, (double[])param2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double div(Number d1, Number d2) {
        return new Double(d1.doubleValue() / d2.doubleValue());
    }

    public Complex div(Complex c1, Complex c2) {
        return c1.div(c2);
    }

    public Complex div(Number d, Complex c) {
        Complex c1 = new Complex(d.doubleValue(), 0.0);
        return c1.div(c);
    }

    public Complex div(Complex c, Number d) {
        return new Complex(c.re() / d.doubleValue(), c.im() / d.doubleValue());
    }

    public Vector div(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div((Number)v.elementAt(i), d));
        }
        return result;
    }

    public Vector div(Number d, Vector v) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div(d, (Number)v.elementAt(i)));
        }
        return result;
    }

    public Vector div(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div((Number)v.elementAt(i), c));
        }
        return result;
    }

    public Vector div(Complex c, Vector v) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div(c, (Number)v.elementAt(i)));
        }
        return result;
    }

    public double[] div(double[] a1, double[] a2) {
        if (a1.length > a2.length) {
            double[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        double[] r = new double[a2.length];
        for (int i = 0; i < a1.length; ++i) {
            r[i] = a1[i] / a2[i];
        }
        return r;
    }

    public double[] div(double[] a, Number d) {
        double[] r = new double[a.length];
        double v = d.doubleValue();
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] / v;
        }
        return r;
    }
}

