/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object product = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            product = this.mul(product, param);
        }
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.mul((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Complex)param2, (Number)param1);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Number)param1);
            }
            if (param2 instanceof double[]) {
                return this.mul((double[])param2, (Number)param1);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.mul((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.mul((Vector)param2, (Complex)param1);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Number) {
                return this.mul((Vector)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.mul((Vector)param1, (Complex)param2);
            }
        } else if (param1 instanceof double[]) {
            if (param2 instanceof Number) {
                return this.mul((double[])param1, (Number)param2);
            }
            if (param2 instanceof double[]) {
                return this.mul((double[])param1, (double[])param2);
            }
        }
        if (param1 instanceof Collection && param2 instanceof Collection) {
            return this.mul((Collection)param1, (Collection)param2);
        }
        throw new ParseException("Invalid parameter types: " + (param1 != null ? param1.getClass().getName() : "null") + " * " + (param2 != null ? param2.getClass().getName() : "null"));
    }

    public Double mul(Number d1, Number d2) {
        return new Double(d1.doubleValue() * d2.doubleValue());
    }

    public Complex mul(Complex c1, Complex c2) {
        return c1.mul(c2);
    }

    public Complex mul(Complex c, Number d) {
        return c.mul(d.doubleValue());
    }

    public Vector mul(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.mul((Number)v.elementAt(i), d));
        }
        return result;
    }

    public Vector mul(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.mul(c, (Number)v.elementAt(i)));
        }
        return result;
    }

    public double[] mul(double[] a1, double[] a2) {
        if (a1.length > a2.length) {
            double[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        double[] r = new double[a2.length];
        for (int i = 0; i < a1.length; ++i) {
            r[i] = a1[i] * a2[i];
        }
        return r;
    }

    public double[] mul(double[] a, Number d) {
        double[] r = new double[a.length];
        double v = d.doubleValue();
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] * v;
        }
        return r;
    }

    public Collection mul(Collection coll1, Collection coll2) {
        HashSet coll = new HashSet();
        for (Object o : coll2) {
            if (!coll1.contains(o)) continue;
            coll.add(o);
        }
        return coll;
    }
}

