/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Stack;

public class SquareRoot
extends PostfixMathCommand {
    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.sqrt(param));
    }

    public Object sqrt(Object param) throws ParseException {
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            if (value < 0.0) {
                return new Complex(value).sqrt();
            }
            return new Double(Math.sqrt(value));
        }
        if (param instanceof Complex) {
            return ((Complex)param).sqrt();
        }
        if (param instanceof double[]) {
            return this.sqrt((double[])param);
        }
        throw new ParseException("Invalid parameter type");
    }

    public double[] sqrt(double[] a) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = Math.sqrt(a[i]);
        }
        return r;
    }
}

