/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.pharmacophore;

import chemaxon.util.HTMLTools;
import java.awt.Color;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ColorDecoder {
    private Color[] colors = null;
    private ArrayList colorKeysIn = null;
    private ArrayList colorValues = null;
    private ArrayList colorKeys = null;

    public ColorDecoder(ArrayList colorKeys, ArrayList colorValues) {
        this.colorKeysIn = colorKeys;
        this.colorValues = colorValues;
        this.init();
    }

    public ColorDecoder(Properties colorProp) {
        Enumeration<Object> e = colorProp.keys();
        ArrayList<String> symbols = new ArrayList<String>();
        ArrayList<String> colorStrings = new ArrayList<String>();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            symbols.add(key);
            colorStrings.add((String)colorProp.get(key));
            ++i;
        }
        this.colorKeysIn = symbols;
        this.colorValues = colorStrings;
        this.init();
    }

    public Color[] getColors() {
        return this.colors;
    }

    public String[][] getSetProperties() {
        String[][] result = new String[62][];
        for (int x = 0; x < this.colorKeys.size(); ++x) {
            String props = (String)this.colorKeys.get(x);
            StringTokenizer st = new StringTokenizer(props, "/");
            int num = st.countTokens();
            result[x] = new String[num];
            for (int y = 0; y < num; ++y) {
                result[x][y] = st.nextToken();
            }
        }
        return result;
    }

    public String[] getColorsAsHTMLString() {
        if (this.colors == null) {
            return null;
        }
        String[] hc = new String[this.colors.length];
        for (int x = 0; x < this.colors.length; ++x) {
            hc[x] = HTMLTools.getHTMLColorString(this.colors[x]);
        }
        return hc;
    }

    public int[] getAtomSetIndexes(String symbols) {
        StringTokenizer st = new StringTokenizer(symbols, ";", true);
        ArrayList<String> atoms = new ArrayList<String>();
        boolean lastWasDelim = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(";")) {
                if (lastWasDelim) {
                    atoms.add(new String());
                }
                lastWasDelim = true;
                continue;
            }
            lastWasDelim = false;
            atoms.add(token);
        }
        if (lastWasDelim) {
            atoms.add(new String());
        }
        int[] setSeq = new int[atoms.size()];
        for (int x = 0; x < atoms.size(); ++x) {
            String atomSt = (String)atoms.get(x);
            if (atomSt.length() <= 0) continue;
            String newAtomSt = ColorDecoder.orderTokens(atomSt, "/");
            atoms.set(x, newAtomSt);
            int num = this.colorKeys.indexOf(newAtomSt);
            setSeq[x] = num != -1 ? num + 1 : 63;
        }
        return setSeq;
    }

    private void init() {
        this.colors = new Color[64];
        this.colorKeys = new ArrayList();
        for (int x = 0; x < this.colorKeysIn.size(); ++x) {
            String key = (String)this.colorKeysIn.get(x);
            String colorSt = (String)this.colorValues.get(x);
            Color color = HTMLTools.getColor(colorSt);
            if (color == null) {
                System.err.println("Unknown color string: \"" + colorSt + "\".");
                color = Color.black;
            }
            if (key.equals("other")) {
                this.colors[63] = color;
                continue;
            }
            if (key.equals("empty")) {
                this.colors[0] = color;
                continue;
            }
            this.colors[this.colorKeys.size() + 1] = color;
            this.colorKeys.add(ColorDecoder.orderTokens(key, "/"));
        }
    }

    private static String orderTokens(String input, String delimiter) {
        StringTokenizer st = null;
        if (delimiter == null) {
            return null;
        }
        if (delimiter.length() == 0) {
            return null;
        }
        st = new StringTokenizer(input, delimiter.substring(0, 1));
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        String newSt = "";
        for (int y = 0; y < list.size(); ++y) {
            if (y > 0) {
                newSt = newSt + delimiter;
            }
            newSt = newSt + (String)list.get(y);
        }
        return newSt;
    }

    public static void main(String[] args) {
        try {
            int x;
            Properties p = new Properties();
            p.load(new FileInputStream("c:\\cvs\\jchem\\test\\pharmacophore\\Colors.ini"));
            Enumeration<Object> e = p.keys();
            ArrayList<String> symbols = new ArrayList<String>();
            ArrayList<String> colorStrings = new ArrayList<String>();
            int i = 0;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                symbols.add(key);
                colorStrings.add((String)p.get(key));
                ++i;
            }
            ColorDecoder u = new ColorDecoder(symbols, colorStrings);
            Color[] colors = u.getColors();
            int[] seq = u.getAtomSetIndexes(";;a/d;");
            System.out.println("Colors:");
            for (x = 0; x < colors.length; ++x) {
                System.out.println(x + " : " + colors[x] + " " + HTMLTools.getHTMLColorString(colors[x]));
            }
            System.out.println("Sequences:");
            for (x = 0; x < seq.length; ++x) {
                System.out.println(x + " : " + seq[x]);
            }
            System.out.println("\n--------------\n");
            String[][] setProps = u.getSetProperties();
            for (int x2 = 0; x2 < setProps.length; ++x2) {
                String[] row = setProps[x2];
                if (row == null) continue;
                System.out.print(x2 + " : ");
                for (int y = 0; y < row.length; ++y) {
                    System.out.print(row[y] + " ");
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

