/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.pharmacophore;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.pharmacophore.PMap;
import chemaxon.pharmacophore.PSymbols;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.MolEvaluator;
import chemaxon.util.expression.MultipleExpression;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PMapper
implements Licensable {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = lineSep + "PMapper " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Determination of pharmacophore properties." + lineSep + lineSep + "Usage:" + lineSep + "  pmapper [options] [input files]" + lineSep + lineSep + "Options: " + lineSep + "  -h, --help                    this help message" + lineSep + "  -c, --config <filepath>       path of the XML configuration file" + lineSep + "  -o, --output <filepath>       output file path (default: stdout)" + lineSep + "  -t, --tag                     name of the SDFile tag to store the" + lineSep + "                                Pharmacophore Map (default: PMAP)" + lineSep + "  -S, --sdf-output              SDF output (otherwise only PMAP list)" + lineSep + "  -g, --ignore-error                  continue with next molecule on error" + lineSep + "  -v, --verbose                 print calculation warnings to the console" + lineSep + lineSep + "Examples:" + lineSep + "  pmapper -c Pharmacophores.xml m.mol" + lineSep + "  pmapper -S -t PHARMACOPHORES -c Pharmacophores.xml m.mol -o o.sdf" + lineSep;
    public static final String DEFAULT_TAG_NAME = "PMAP";
    private PSymbols symbols = null;
    private Properties symbol2id = null;
    private Standardizer standardizer = null;
    private MultipleExpression expression = null;
    private ArrayList atomList = null;
    private int[] atomIndexMap = null;
    private int atomIndexMapLength = 0;
    private String licenseEnvironment = "";

    public PMapper(File config) throws IOException, ParseException, StandardizerException {
        this(config, null);
    }

    public PMapper(File config, Standardizer standardizer) throws IOException, ParseException, StandardizerException {
        Element defelem;
        Element stelem;
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(config);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new ParseException(e);
        }
        if (standardizer == null && (stelem = (Element)root.selectSingleNode("Standardizer | StandardizerConfiguration")) != null) {
            standardizer = new Standardizer(stelem, config.getParent());
        }
        if ((defelem = (Element)root.selectSingleNode("PharmacophoreDefinition")) != null) {
            root = defelem;
        }
        this.init(root, standardizer, config.getParent());
    }

    public PMapper(String config) throws IOException, ParseException, StandardizerException {
        this(config, null);
    }

    public PMapper(String config, Standardizer standardizer) throws IOException, ParseException, StandardizerException {
        Element root = null;
        try {
            StringReader sR = new StringReader(config);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)sR);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new ParseException(e);
        }
        Element defelem = (Element)root.selectSingleNode("PharmacophoreDefinition");
        if (defelem != null) {
            root = defelem;
        }
        this.init(root, standardizer, null);
    }

    public PMapper(Element config, String dir) throws IOException, ParseException {
        this(config, (Standardizer)null, dir);
    }

    public PMapper(Element config) throws IOException, ParseException {
        this(config, (Standardizer)null);
    }

    public PMapper(Element config, Standardizer standardizer, String dir) throws IOException, ParseException {
        this.init(config, standardizer, dir);
    }

    public PMapper(Element config, Standardizer standardizer) throws IOException, ParseException {
        this.init(config, standardizer);
    }

    public PMapper(Element config, Element stconfig, String dir) throws IOException, ParseException, StandardizerException {
        this.init(config, new Standardizer(stconfig, dir), dir);
    }

    public PMapper(Element config, Element stconfig) throws IOException, ParseException, StandardizerException {
        this.init(config, new Standardizer(stconfig));
    }

    private void init(Element config, Standardizer standardizer) throws IOException, ParseException {
        this.init(config, standardizer, null);
    }

    private void init(Element config, Standardizer standardizer, String dir) throws IOException, ParseException {
        this.standardizer = standardizer;
        if (standardizer != null) {
            this.atomList = new ArrayList();
        }
        MolEvaluator me = new MolEvaluator();
        me.setConfig(config, dir);
        me.setFunctions();
        Element expressionRoot = (Element)config.selectSingleNode("Pharmacophores");
        this.setFeatureData(expressionRoot);
        this.expression = new MultipleExpression(me.getStaticContext());
        this.expression.setDynamicContext(new DynamicContext());
        this.expression.compile(expressionRoot);
    }

    private void setFeatureData(Element expressionRoot) throws ParseException {
        if (expressionRoot == null) {
            throw new ParseException("invalid XML configuration");
        }
        this.symbol2id = new Properties();
        List atomsetNodes = expressionRoot.selectNodes("AtomSet");
        int size = atomsetNodes.size();
        ArrayList<String> v = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Element atomsetElement = (Element)atomsetNodes.get(i);
            String id = atomsetElement.attributeValue("ID");
            String symbol = atomsetElement.attributeValue("Symbol");
            if (id == null || symbol == null) continue;
            this.symbol2id.put(symbol, id);
            v.add(symbol);
        }
        this.symbols = new PSymbols(v);
    }

    public void setVerbose(boolean verbose) {
        this.expression.getStaticContext().setVerbose(verbose);
    }

    public Molecule getMolConstant(String id) {
        try {
            return (Molecule)this.expression.getStaticContext().getVariable(id);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public PSymbols getSymbols() {
        return this.symbols;
    }

    public String getID(String symbol) {
        return this.symbol2id.getProperty(symbol);
    }

    public PMap createFeatureMap(Molecule target) throws SearchException, ParseException, LicenseException {
        this.checkLicense();
        if (this.standardizer != null) {
            this.standardize(target);
        }
        this.expression.getDynamicContext().setInputMolecule(target);
        HashMap result = (HashMap)this.expression.evaluate();
        if (this.standardizer != null) {
            this.reorderBitSets(result);
        }
        int count = this.standardizer != null ? this.atomIndexMapLength : target.getAtomCount();
        return new PMap(count, this.getFeatureArray(result));
    }

    private void standardize(Molecule target) throws SearchException {
        int i;
        this.atomIndexMapLength = target.getAtomCount();
        for (i = 0; i < this.atomIndexMapLength; ++i) {
            this.atomList.add(target.getAtom(i));
        }
        this.standardizer.standardize(target);
        if (this.atomIndexMap == null || this.atomIndexMap.length < this.atomIndexMapLength) {
            this.atomIndexMap = new int[this.atomIndexMapLength];
        }
        for (i = 0; i < this.atomIndexMapLength; ++i) {
            MolAtom atom = (MolAtom)this.atomList.get(i);
            this.atomIndexMap[i] = target.indexOf(atom);
        }
        this.atomList.clear();
    }

    private void reorderBitSets(HashMap fmap) {
        for (Object key : fmap.keySet()) {
            BitSet bitset = (BitSet)fmap.get(key);
            if (bitset == null) continue;
            this.reorderBitSet(bitset);
        }
    }

    private void reorderBitSet(BitSet bitset) {
        int i;
        BitSet bs = (BitSet)bitset.clone();
        int length = bitset.length();
        for (i = 0; i < length; ++i) {
            bitset.clear(i);
        }
        for (i = 0; i < this.atomIndexMapLength; ++i) {
            if (this.atomIndexMap[i] == -1 || !bs.get(this.atomIndexMap[i])) continue;
            bitset.set(i);
        }
    }

    private BitSet[] getFeatureArray(HashMap fmap) {
        int size = this.symbols.getSymbolCount();
        BitSet[] farray = new BitSet[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (BitSet)fmap.get(this.symbol2id.get(this.symbols.getSymbol(i)));
        }
        return farray;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Pharmacophore Recognition", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Pharmacophore Recognition", this.licenseEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CLQ clq = new CLQ(args, null);
        Object input = null;
        Object is = null;
        PrintStream os = null;
        String tag = null;
        Object st = null;
        if (clq.lookup("-h", "--help", "", 1, false, false) != null || args.length == 0) {
            System.out.println(helptext);
            return;
        }
        File config = new File(clq.lookup("-c", "--config", "", 2, true, false).getString());
        boolean onlyPMAP = clq.lookup("-S", "--sdf-output", "", 1, false, false) == null;
        boolean ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        boolean verbose = clq.lookup("-v", "--verbose", "", 1, false, false) != null;
        CLQ.Parameter t = clq.lookup("-t", "--tag", "", 2, false, false);
        tag = t != null ? t.getString() : DEFAULT_TAG_NAME;
        PMapper pm = null;
        try {
            pm = new PMapper(config);
            pm.setVerbose(verbose);
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
        CLQ.Parameter out = clq.lookup("-o", "--output", "", 2, false, false);
        os = out != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(out.getString()))) : new PrintStream(new BufferedOutputStream(System.out));
        PMap pmap = null;
        String result = null;
        PSymbols symbols = pm.getSymbols();
        boolean cloning = !onlyPMAP && pm.standardizer != null;
        Molecule target = null;
        int molCount = 0;
        MolExporter exporter = onlyPMAP ? null : new MolExporter(os, "sdf");
        MolImporter[] ins = ConfigTools.getTargetMolImporters(clq);
        try {
            for (int i = 0; i < ins.length; ++i) {
                MolImporter importer = ins[i];
                MolImporter molimp = ins[i];
                while ((target = ConfigTools.readMol(molimp, ignoreError)) != null) {
                    Molecule target2 = target;
                    if (cloning) {
                        target2 = (Molecule)target.clone();
                    }
                    pmap = pm.createFeatureMap(target);
                    result = pmap.toString(symbols);
                    if (onlyPMAP) {
                        os.println(result);
                        if (ConfigTools.isReadErrorMol(target)) {
                            System.err.println("Import error when reading molecule " + (molCount + 1) + ": " + ConfigTools.getReadErrorMessage(target));
                        }
                        os.println();
                    } else {
                        target2.setProperty(tag, result);
                        ConfigTools.writeMol(target2, exporter, ignoreError);
                    }
                    ++molCount;
                }
            }
        }
        catch (LicenseException e) {
            System.err.println(e);
        }
        finally {
            if (exporter != null) {
                exporter.close();
            } else {
                os.flush();
            }
        }
        if (out != null) {
            os.close();
        }
    }
}

