/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.pharmacophore;

import java.util.Arrays;
import java.util.Collection;

public class PSymbols {
    private String[] symbols;

    public PSymbols(String[] psymbols) {
        this.symbols = new String[psymbols.length];
        System.arraycopy(psymbols, 0, this.symbols, 0, psymbols.length);
        Arrays.sort(this.symbols);
    }

    public PSymbols(Collection psymbols) {
        this.symbols = new String[psymbols.size()];
        psymbols.toArray(this.symbols);
        Arrays.sort(this.symbols);
    }

    public int getSymbolCount() {
        return this.symbols.length;
    }

    public String getSymbol(int i) {
        if (i >= 0 && i < this.symbols.length) {
            return this.symbols[i];
        }
        throw new IllegalArgumentException("Symbol index is out-of-range: " + i + " is not in [0," + this.symbols.length + "].");
    }

    public int getIndex(String symbol) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].equals(symbol)) continue;
            return i;
        }
        throw new IllegalArgumentException("Symbol is not found: " + symbol);
    }
}

