/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.pharmacophore;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.util.BondTable;
import chemaxon.struc.Molecule;

public class RotBondCounter
extends BondClassifier {
    private Molecule mol = null;
    private BondTable bTab = null;

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.bTab = m.getBondTable();
        this.classify(this.mol);
    }

    public int calcRotBonds(int[] nodes, int nodesLength) {
        int rbc = 0;
        for (int i = 0; i < nodesLength - 1; ++i) {
            if (this.isRingBond(nodes[i], nodes[i + 1]) || !this.rotBond(nodes[i], nodes[i + 1])) continue;
            ++rbc;
        }
        return rbc;
    }

    private boolean rotBond(int a, int b) {
        return this.mol.getBond(this.bTab.getBondIndex(a, b)).getType() == 1 && this.ctab[a].length > 1 && this.ctab[b].length > 1;
    }
}

