/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

class ConcurrentDuplicateFilter<E> {
    private Set<E> chs = null;
    private ConcurrentProcessor cwup;
    private int workerThreadCount = 0;
    private boolean ended = false;
    private Iterator<E> it = null;

    private static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public ConcurrentDuplicateFilter(Iterator<E> it) {
        this.it = it;
        this.chs = ConcurrentDuplicateFilter.newSetFromMap(new ConcurrentHashMap());
        this.init();
    }

    private void init() {
        if (this.cwup == null) {
            this.cwup = ConcurrentProcessors.create(1, new ElementIterator(this.it), new FilterWorkUnitFactory());
            this.cwup.setWorkerThreadCount(this.workerThreadCount);
            try {
                this.cwup.start();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized boolean hasNext() {
        if (this.ended) {
            return false;
        }
        try {
            return this.cwup.hasNext();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Object next() {
        if (this.ended) {
            return null;
        }
        Object next = null;
        try {
            if (this.cwup.hasNext()) {
                next = this.cwup.getNext();
                if (next == null) {
                    return this.next();
                }
                return next;
            }
            this.ended = true;
            this.cwup.cleanup();
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private class FilterWorkUnitFactory
    implements WorkUnitFactory {
        private FilterWorkUnitFactory() {
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            return new FilterWorkUnit();
        }
    }

    private class FilterWorkUnit
    implements WorkUnit {
        private Object obj = null;

        private FilterWorkUnit() {
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            this.obj = obj;
        }

        public Object call() throws Exception {
            boolean added = ConcurrentDuplicateFilter.this.chs.add(this.obj);
            if (!added) {
                return null;
            }
            return this.obj;
        }
    }

    private class ElementIterator
    implements InputProducer {
        private Iterator<E> it = null;

        public ElementIterator(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            return this.it.hasNext();
        }

        @Override
        public Object getNext() throws InterruptedException, ExecutionException {
            return this.it.next();
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.s).equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }
}

