/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.EqualableMolecule;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionResultEnumerator;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.ReactorOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;

class FusedReactionEnumerator
implements ReactionResultEnumerator {
    private ReactionResultEnumerator reactIterator = null;
    private Molecule[] reactants = null;
    private ReactorOptions options = null;
    private Properties reactantProperties = null;

    public FusedReactionEnumerator(ReactionResultEnumerator reactIterator) {
        this.reactIterator = reactIterator;
    }

    @Override
    public void setReactants(Molecule[] reactants) throws ReactionException {
        this.reactants = reactants;
        this.reactIterator.setReactants(reactants);
        if (this.options.getReactantPropertiesToCopy() != null) {
            this.reactantProperties = ReactionUtil.getSelectedMoleculeProperties(reactants, this.options.isCopyAllReactantProperties(), this.options.getReactantPropertiesToCopy(), this.options.getTargetProperties());
        }
    }

    @Override
    public Molecule[] react() throws ReactionException {
        ArrayList<Molecule[]> resultList = new ArrayList<Molecule[]>();
        Molecule[] result = null;
        while ((result = this.reactIterator.react()) != null) {
            resultList.add(result);
        }
        return !resultList.isEmpty() ? FusedReactionEnumerator.createFusedReactionOutput(this.reactants, resultList, this.getProductIDProperyNames(), this.reactantProperties) : null;
    }

    @Override
    public void setOptions(ReactorOptions options) {
        this.options = options;
        this.reactIterator.setOptions(options);
    }

    private String[] getProductIDProperyNames() {
        return this.options != null && this.options.getProductIDProps() != null ? this.options.getProductIDProps() : this.options.getReactantIDProps();
    }

    private static Molecule[] createFusedReactionOutput(Molecule[] reactants, ArrayList<Molecule[]> productSetList, String[] productIDProperyNames, Properties reactantProperties) {
        ArrayList indexedProductLists = new ArrayList();
        for (Molecule[] products : productSetList) {
            for (int i = 0; i < products.length; ++i) {
                if (indexedProductLists.size() <= i) {
                    indexedProductLists.add(i, new ArrayList());
                }
                ((ArrayList)indexedProductLists.get(i)).add(products[i]);
            }
        }
        LinkedHashSet<EqualableMolecule> productFilter = new LinkedHashSet<EqualableMolecule>();
        for (ArrayList arrayList : indexedProductLists) {
            for (Molecule product : arrayList) {
                productFilter.add(new EqualableMolecule(product));
            }
        }
        if (productFilter.isEmpty()) {
            return null;
        }
        Molecule[] allProducts = new Molecule[productFilter.size()];
        boolean bl = false;
        for (EqualableMolecule emol : productFilter) {
            allProducts[++var7_11] = emol.getMolecule();
        }
        RxnMolecule fusedReaction = ReactionUtil.createReactionMolecule(reactants, allProducts, null, false);
        if (productIDProperyNames != null) {
            String idProperyName = productIDProperyNames[0];
            String productID = allProducts[0].getProperty(idProperyName);
            fusedReaction.setProperty(idProperyName, FusedReactionEnumerator.convertProductIDtoFusedReactionID(productID));
        }
        ReactionUtil.setProperties(fusedReaction, reactantProperties);
        return new Molecule[]{fusedReaction};
    }

    private static String convertProductIDtoFusedReactionID(String productID) {
        return productID.substring(0, productID.lastIndexOf(58));
    }
}

