/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.peptide.AminoAcidSource;
import chemaxon.reaction.GroupDefinition;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class GroupList
implements Serializable {
    private static final long serialVersionUID = 7511499720792606114L;
    private List<GroupDefinition> abbreviations = new ArrayList<GroupDefinition>();
    private List<GroupDefinition> aminoAcids = new ArrayList<GroupDefinition>();
    private static final String DEFAULT_ABBREVGROUP_FILE = "/chemaxon/marvin/templates/default.abbrevgroup";
    private static List<GroupDefinition> defaultAbbrevGroup;
    private static List<GroupDefinition> defaultAminoAcids;

    public List<GroupDefinition> getAbbreviations() {
        return this.abbreviations;
    }

    public void setAbbreviations(List<GroupDefinition> abbreviations) {
        this.abbreviations = abbreviations;
    }

    public List<GroupDefinition> getAminoAcids() {
        return this.aminoAcids;
    }

    public void setAminoAcids(List<GroupDefinition> aminoAcids) {
        this.aminoAcids = aminoAcids;
    }

    public boolean parseString(String text) throws StandardizerException {
        String[] elements = text.split(",");
        for (int i = 0; i < elements.length; ++i) {
            File listFile = null;
            String entry = elements[i].trim();
            if (entry.startsWith("file") && entry.indexOf("=") > 0) {
                listFile = new File(entry.substring(entry.indexOf("=") + 1));
                this.parseFile(listFile);
                return true;
            }
            GroupDefinition definition = new GroupDefinition();
            if (definition.parse(entry, GroupList.getDefaultAbbrevgroup())) {
                this.abbreviations.add(definition);
            }
            if (!(definition = new GroupDefinition()).parse(entry, GroupList.getDefaultAminoAcids())) continue;
            this.aminoAcids.add(definition);
        }
        return true;
    }

    private boolean parseFile(File listFile) throws StandardizerException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(listFile);
        }
        catch (FileNotFoundException e) {
            throw new StandardizerException("Group definition file is not valid: " + listFile.getAbsolutePath());
        }
        this.abbreviations.addAll(GroupList.readGroupDefinitions(is));
        return false;
    }

    public static List<GroupDefinition> getDefaultAminoAcids() {
        if (defaultAminoAcids == null) {
            defaultAminoAcids = new ArrayList<GroupDefinition>();
            AminoAcidSource source = AminoAcidSource.getInstance();
            Vector<Molecule> aminoAcids = source.getExportMols(true);
            for (Molecule molecule : aminoAcids) {
                for (int i = 0; i < molecule.getAtomCount(); ++i) {
                    MolAtom atom = molecule.getAtom(i);
                    if (atom.getAttach() != 0 && atom.getAtno() == 7) {
                        atom.setAttach(0);
                    }
                    if (atom.getAttach() != 0) {
                        atom.setQProp("s", atom.getBondCount() - atom.getExplicitHcount() + 1);
                        atom.setAttach(0);
                        continue;
                    }
                    atom.setQProp("s", atom.getBondCount() - atom.getExplicitHcount());
                }
                defaultAminoAcids.add(new GroupDefinition(molecule.getProperty("long"), molecule));
            }
        }
        return defaultAminoAcids;
    }

    public static List<GroupDefinition> getDefaultAbbrevgroup() throws StandardizerException {
        if (defaultAbbrevGroup == null) {
            defaultAbbrevGroup = new ArrayList<GroupDefinition>();
            InputStream is = null;
            is = BasicEnvironment.getResourceAsStream(StructureCheckerHelper.class, DEFAULT_ABBREVGROUP_FILE);
            try {
                defaultAbbrevGroup.addAll(GroupList.readGroupDefinitions(is));
            }
            catch (StandardizerException e1) {
                throw new StandardizerException("The default.abbrevgroup can not be loaded!", e1);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return defaultAbbrevGroup;
    }

    private static List<GroupDefinition> readGroupDefinitions(InputStream stream) throws StandardizerException {
        ArrayList<GroupDefinition> result = new ArrayList<GroupDefinition>();
        MolImporter importer = null;
        try {
            importer = new MolImporter(stream);
            Molecule mol = null;
            while ((mol = importer.read()) != null) {
                mol.expandSgroups();
                for (int i = 0; i < mol.getAtomCount(); ++i) {
                    MolAtom atom = mol.getAtom(i);
                    if (atom.getAttach() != 0) {
                        atom.setQProp("s", atom.getBondCount() - atom.getExplicitHcount() + 1);
                        atom.setAttach(0);
                        continue;
                    }
                    atom.setQProp("s", atom.getBondCount() - atom.getExplicitHcount());
                    atom.setQProp("h", atom.getImplicitHcount());
                    atom.setQProp("H", atom.getImplicitHcount() + atom.getExplicitHcount());
                }
                mol.contractSgroups();
                mol.setGUIContracted(true);
                SgroupAtom sgroupAtom = (SgroupAtom)mol.getAtom(0);
                result.add(new GroupDefinition(mol.getName(), mol));
                if (sgroupAtom.getLeftName() != null && !mol.getName().equals(sgroupAtom.getLeftName())) {
                    result.add(new GroupDefinition(sgroupAtom.getLeftName(), mol));
                }
                if (sgroupAtom.getRightName() == null || mol.getName().equals(sgroupAtom.getRightName())) continue;
                result.add(new GroupDefinition(sgroupAtom.getRightName(), mol));
            }
        }
        catch (MolFormatException me) {
            throw new StandardizerException("Could not process group definition list. ", me);
        }
        catch (IOException ioe) {
            throw new StandardizerException("Could not process group definition list. ", ioe);
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return result;
    }

    public List<List<GroupDefinition>> getGroups() {
        ArrayList<List<GroupDefinition>> result = new ArrayList<List<GroupDefinition>>();
        result.add(this.abbreviations);
        result.add(this.aminoAcids);
        return result;
    }

    public void setAll() throws StandardizerException {
        this.abbreviations = GroupList.getDefaultAbbrevgroup();
        this.aminoAcids = GroupList.getDefaultAminoAcids();
    }

    public void parseXML(Element actionNode) throws StandardizerException {
        if (actionNode.elements().size() == 0) {
            this.setAll();
        } else {
            Iterator groupDefinitions = actionNode.elementIterator();
            while (groupDefinitions.hasNext()) {
                Element groupDefinition = (Element)groupDefinitions.next();
                if (groupDefinition.attribute("abbr") != null) {
                    GroupDefinition definition = new GroupDefinition();
                    String abbreviation = groupDefinition.attribute("abbr").getText();
                    if (groupDefinition.getText() == null || groupDefinition.getText().isEmpty()) {
                        if (definition.parse(abbreviation, GroupList.getDefaultAbbrevgroup())) {
                            this.abbreviations.add(definition);
                        }
                        if (!(definition = new GroupDefinition()).parse(abbreviation, GroupList.getDefaultAminoAcids())) continue;
                        this.aminoAcids.add(definition);
                        continue;
                    }
                    String smiles = groupDefinition.getText();
                    Molecule molecule = null;
                    try {
                        molecule = MolImporter.importMol(smiles);
                        definition.setAbbreviation(abbreviation);
                        definition.setGroup(molecule);
                        this.abbreviations.add(definition);
                        continue;
                    }
                    catch (MolFormatException e) {
                        throw new StandardizerException("Could not process group definition of create group: " + smiles, e);
                    }
                }
                throw new StandardizerException("Could not process group definition from XML. " + groupDefinition.asXML());
            }
        }
    }
}

