/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

class HitData
implements Serializable {
    private ArrayList<Map2Atom> ma = null;

    HitData() {
        this.ma = new ArrayList();
    }

    HitData(int initialCapacity) {
        this.ma = new ArrayList(initialCapacity);
    }

    int size() {
        return this.ma.size();
    }

    void add(int map, int targetAtomIndex) {
        this.ma.add(new Map2Atom(map, targetAtomIndex));
    }

    int getMap(int index) {
        return this.ma.get(index).getMap();
    }

    int getAtomIndex(int index) {
        return this.ma.get(index).getAtomIndex();
    }

    public int hashCode() {
        return this.ma.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HitData)) {
            return false;
        }
        HitData other = (HitData)obj;
        return this.ma.equals(other.ma);
    }

    public String toString() {
        return this.ma.toString();
    }

    private class Map2Atom
    implements Serializable {
        private int map;
        private int targetAtomIndex;

        Map2Atom(int map, int targetAtomIndex) {
            this.map = map;
            this.targetAtomIndex = targetAtomIndex;
        }

        int getMap() {
            return this.map;
        }

        int getAtomIndex() {
            return this.targetAtomIndex;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{this.targetAtomIndex, this.map});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map2Atom)) {
                return false;
            }
            Map2Atom other = (Map2Atom)obj;
            return this.targetAtomIndex == other.targetAtomIndex && this.map == other.map;
        }

        public String toString() {
            return this.targetAtomIndex + ":" + this.map;
        }
    }
}

