/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.struc.Molecule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternProperty
implements Serializable {
    private static final long serialVersionUID = -3617253669859174882L;
    private static final String VARIABLE_PREFIX = "#{";
    private static final String VARIABLE_POSTFIX = "}";
    private static final String PROPERTY_SEPARATOR = ".";
    private static final String PARAMETER_SEPARATOR = "=";
    private static final String PATTERN_SEPARATOR = "..";
    private String representation;

    public PatternProperty() {
    }

    public PatternProperty(String representation) {
        this.representation = representation;
    }

    public boolean isValid() {
        if (this.representation == null || this.representation.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(String.format("(.*)(\\Q%s\\E([\\p{Alnum}_-]*)\\Q%s\\E([\\p{Alnum}_-]*)\\Q%s\\E(.*))+", VARIABLE_PREFIX, PROPERTY_SEPARATOR, VARIABLE_POSTFIX));
        Matcher matcher = pattern.matcher(this.representation);
        return matcher.matches();
    }

    String getValue(Molecule reaction, Molecule[] reactants) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        try {
            String[] splits = this.representation.split("\\Q#{\\E");
            String definition = null;
            String reactant = null;
            String propertyName = null;
            Molecule target = null;
            int firstNumeric = -1;
            int index = 0;
            result.append(splits[index]);
            ++index;
            while (index < splits.length) {
                definition = splits[index].substring(0, splits[index].indexOf(VARIABLE_POSTFIX));
                reactant = definition.substring(0, definition.indexOf(PROPERTY_SEPARATOR));
                char[] reactantDef = reactant.toCharArray();
                firstNumeric = reactantDef.length - 1;
                boolean isDigit = Character.isDigit(reactantDef[firstNumeric]);
                while (firstNumeric > 0 && isDigit) {
                    isDigit = Character.isDigit(reactantDef[--firstNumeric]);
                }
                target = firstNumeric + 1 == reactant.length() ? reaction : reactants[Integer.parseInt(reactant.substring(firstNumeric + 1)) - 1];
                propertyName = definition.substring(definition.indexOf(PROPERTY_SEPARATOR) + 1, definition.length());
                result.append(target.getProperty(propertyName));
                result.append(splits[index].substring(splits[index].indexOf(VARIABLE_POSTFIX) + 1));
                ++index;
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Map<String, String> parsePatternsOfProperties(String patternList, String separator) {
        if (patternList.startsWith("sep=")) {
            int start = patternList.indexOf("'") + 1;
            int end = patternList.indexOf("'", start);
            separator = patternList.substring(start, end);
            patternList = patternList.substring(end);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] patterns = patternList.split("\\Q" + separator + "\\E");
        for (int i = 0; i < patterns.length; ++i) {
            int separatorIndex = patterns[i].indexOf(PARAMETER_SEPARATOR);
            parameters.put(patterns[i].substring(0, separatorIndex), patterns[i].substring(separatorIndex + 1, patterns[i].length()));
        }
        return parameters;
    }

    public static Map<String, String> parsePatternsOfProperties(String patternList) {
        return PatternProperty.parsePatternsOfProperties(patternList, PATTERN_SEPARATOR);
    }
}

