/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.CombinatorialModeReactantSetEnumerator;
import chemaxon.reaction.ReactantSetEnumeration;
import chemaxon.reaction.SequentialModeReactantSetEnumerator;
import chemaxon.reaction.SingleFileReactantSetEnumerator;
import chemaxon.reaction.Standardizer;
import chemaxon.util.MolFilter;
import chemaxon.util.iterator.MoleculeIterator;

class ReactantSetEnumeratorFactory {
    public static final int MODE_SEQUENTIAL = 0;
    public static final int MODE_COMBINATORIAL = 1;
    public static final int MODE_SINGLE_FILE = 2;

    ReactantSetEnumeratorFactory() {
    }

    public static ReactantSetEnumeration createReactantSetEnumerator(MoleculeIterator[] reactantIterators, int numberOfReactants, int mode, MolFilter[] filters, Standardizer standardizer, String cacheFormat, double reservedMemorySize, boolean ignoreError) {
        if (numberOfReactants != 0 && reactantIterators.length == 1 && numberOfReactants != reactantIterators.length) {
            return ReactantSetEnumeratorFactory.createSingleFileReactantSetEnumerator(reactantIterators, numberOfReactants);
        }
        if (mode == 1) {
            return ReactantSetEnumeratorFactory.createCombinatorialModeReactantSetEnumerator(reactantIterators, filters, standardizer, cacheFormat, reservedMemorySize, ignoreError);
        }
        return ReactantSetEnumeratorFactory.createSequentialModeReactantSetEnumerator(reactantIterators, ignoreError);
    }

    public static ReactantSetEnumeration createCombinatorialModeReactantSetEnumerator(MoleculeIterator[] reactantIterators, MolFilter[] filters, Standardizer standardizer, String cacheFormat, double reservedMemorySize, boolean ignoreError) {
        return new CombinatorialModeReactantSetEnumerator(reactantIterators, filters, standardizer, cacheFormat, reservedMemorySize, ignoreError);
    }

    public static ReactantSetEnumeration createSequentialModeReactantSetEnumerator(MoleculeIterator[] reactantIterators, boolean ignoreError) {
        return new SequentialModeReactantSetEnumerator(reactantIterators, ignoreError);
    }

    public static ReactantSetEnumeration createSingleFileReactantSetEnumerator(MoleculeIterator[] reactantIterators, int numberOfReactants) {
        return new SingleFileReactantSetEnumerator(reactantIterators, numberOfReactants);
    }
}

