/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.HitData;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.ReactorOptions;
import chemaxon.reaction.SearchData;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

class ReactionSearcher
implements Serializable {
    private static final String STRUCTURE_SEARCH_FOR_INTERNAL_MOLSEARCH_LICENSE_ENVIRONMENT = "StructureSearchForInternalMolSearchLicenseEnvironment";
    static String RID_PREFIX = "RXN_";
    private Reaction reaction = null;
    private transient MolSearch[] searchers = null;
    private MolSearchOptions searchOptions = null;
    private Molecule[] queries = null;
    private Molecule[] targets = null;
    private boolean[] qset = null;
    private boolean[] tset = null;
    private boolean[] restarting = null;
    private SearchData[] sd = null;
    private HitData[] hd = null;
    private int[] hitinds = null;
    private boolean start = true;
    private boolean inited = false;
    private HashSet<MolAtom>[] excludeAtomSets = null;
    private int[] excludeAtomIndices = null;
    private ReactorOptions options;

    ReactionSearcher(Reaction reaction, ReactorOptions options) {
        this.setReaction(reaction);
        this.setOptions(options);
    }

    void setDoubleBondStereoMatchingMode(int ctmode) {
        this.searchOptions = this.getSearchOptions();
        this.searchOptions.setDoubleBondStereoMatchingMode(ctmode);
        this.updateSearchers();
    }

    void setOptions(ReactorOptions options) {
        this.options = options;
        this.updateSearchers();
    }

    private void reset() {
        this.inited = false;
        this.searchers = null;
        this.qset = null;
        this.tset = null;
        this.restarting = null;
    }

    void setSearchOptions(String optionString) {
        this.options.setSearchOptionsString(optionString);
        this.searchOptions.setOptions(optionString);
        this.updateSearchers();
    }

    MolSearchOptions getSearchOptions() {
        if (this.searchOptions == null) {
            this.searchOptions = ReactionSearcher.getDefaultSearchOptions();
        }
        return this.searchOptions;
    }

    private static MolSearchOptions getDefaultSearchOptions() {
        MolSearchOptions mso = new MolSearchOptions(2);
        mso.setHitIncludesRNodes(true);
        mso.setOrderSensitiveSearch(true);
        mso.setDoubleBondStereoMatchingMode(0);
        mso.setMarkushEnabled(false);
        mso.setUndefinedRAtom(0);
        return mso;
    }

    private void updateSearchers() {
        this.searchOptions = ReactionUtil.setSearchAttributes(this.getSearchOptions(), this.options.getSearchAttributes());
        this.searchOptions.setOptions(this.options.getSearchOptionsString());
        if (this.searchers != null) {
            for (MolSearch searcher : this.searchers) {
                searcher.setSearchOptions(this.getSearchOptions());
            }
        }
    }

    private void setReaction(Reaction reaction) {
        this.reaction = reaction;
        this.reset();
    }

    void setReverse(boolean reverse) {
        if (reverse != this.options.isReverse()) {
            this.options.setReverse(reverse);
            this.reset();
        }
    }

    boolean isReverse() {
        return this.options.isReverse();
    }

    HitData[] getHitData() {
        return this.hd;
    }

    void setTargets(Molecule[] targets) {
        this.targets = targets;
        if (!this.inited) {
            this.init();
        }
        Arrays.fill(this.tset, false);
        if (this.options.isExcludeOverlappingHits()) {
            this.excludeAtomSets = new HashSet[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.excludeAtomSets[i] = new HashSet();
            }
        } else {
            this.excludeAtomSets = null;
            this.excludeAtomIndices = null;
        }
        this.restart();
    }

    private void init() {
        int n = this.options.isReverse() ? this.reaction.getProductCount() : this.reaction.getReactantCount();
        this.sd = new SearchData[n];
        this.hd = new HitData[n];
        this.hitinds = new int[n];
        for (int i = 0; i < n; ++i) {
            this.hd[i] = new HitData();
        }
        this.initSearchers();
        this.qset = new boolean[this.queries.length];
        this.tset = new boolean[this.queries.length];
        this.restarting = new boolean[this.queries.length];
        this.inited = true;
    }

    private MolSearch[] initSearchers() {
        if (this.searchers == null) {
            this.queries = this.options.isReverse() ? this.reaction.getProducts() : this.reaction.getReactants();
            this.searchers = new MolSearch[this.queries.length];
            for (int i = 0; i < this.queries.length; ++i) {
                this.searchers[i] = new MolSearch();
                this.searchers[i].setLicenseEnvironment(STRUCTURE_SEARCH_FOR_INTERNAL_MOLSEARCH_LICENSE_ENVIRONMENT);
                this.searchers[i].setStandardizer(null, true, true);
                this.searchers[i].setSearchOptions(this.getSearchOptions());
                this.searchers[i].setQuery(this.queries[i]);
            }
        }
        return this.searchers;
    }

    MolSearch[] getSearchers() {
        return this.initSearchers();
    }

    void restart() {
        int i;
        this.start = true;
        if (this.targets != null) {
            for (i = 0; i < this.targets.length; ++i) {
                String rid = this.getRID(i);
                if (!this.options.isCached()) continue;
                long grinvCC = this.targets[i].getGrinvCC();
                this.sd[i] = (SearchData)this.targets[i].getPropertyObject(rid);
                if (this.sd[i] != null && this.sd[i].getGrinvCC() == grinvCC) continue;
                this.sd[i] = new SearchData(grinvCC);
                this.targets[i].setPropertyObject(rid, this.sd[i]);
            }
        }
        if (this.sd != null) {
            for (i = 0; i < this.sd.length; ++i) {
                this.restart(i);
            }
        }
    }

    void restart(int i) {
        this.hitinds[i] = 0;
        this.restarting[i] = true;
        if (this.options.isExcludeOverlappingHits()) {
            this.excludeAtomSets[i].clear();
        }
    }

    boolean find() throws SearchException {
        if (this.start) {
            for (int i = 0; i < this.sd.length; ++i) {
                if (this.find(i)) continue;
                return false;
            }
            this.start = false;
            return true;
        }
        for (int i = this.sd.length - 1; i >= 0; --i) {
            if (this.find(i)) {
                return true;
            }
            this.restart(i);
            this.find(i);
        }
        return false;
    }

    private boolean find(int i) throws SearchException {
        int[] hit = null;
        if (this.sd[i] != null) {
            if (this.hitinds[i] < this.sd[i].size()) {
                this.hd[i] = this.sd[i].get(this.hitinds[i]);
                int n = i;
                this.hitinds[n] = this.hitinds[n] + 1;
                return true;
            }
            if (this.sd[i].isComplete()) {
                return false;
            }
        }
        if (this.searchers == null) {
            this.initSearchers();
        }
        if (!this.qset[i]) {
            this.searchers[i].setQuery(this.queries[i]);
            this.qset[i] = true;
        }
        if (!this.tset[i]) {
            this.searchers[i].setTarget(this.targets[i]);
            this.tset[i] = true;
        } else if (this.options.isExcludeOverlappingHits()) {
            this.searchers[i].setTarget(this.targets[i], this.getExcludeAtomIndices(i));
        }
        if (this.restarting[i]) {
            hit = this.searchers[i].findFirst();
            this.restarting[i] = false;
        } else {
            hit = this.searchers[i].findNext();
        }
        if (hit != null) {
            if (this.options.isExcludeOverlappingHits()) {
                this.exclude(i, hit);
            }
            HitData hitData = this.reaction.convert(hit, i, this.options.isReverse());
            if (this.sd[i] != null) {
                this.sd[i].add(hitData);
            }
            this.hd[i] = hitData;
            int n = i;
            this.hitinds[n] = this.hitinds[n] + 1;
            return true;
        }
        if (this.options.isExcludeOverlappingHits()) {
            this.excludeAtomSets[i].clear();
        }
        if (this.sd[i] != null) {
            this.sd[i].close();
        } else {
            this.restarting[i] = true;
        }
        return false;
    }

    private void exclude(int i, int[] hit) {
        for (int j = 0; j < hit.length; ++j) {
            if (hit[j] < 0) continue;
            this.excludeAtomSets[i].add(this.targets[i].getAtom(hit[j]));
        }
    }

    void exclude(int i, MolAtom a) {
        this.excludeAtomSets[i].add(a);
    }

    private int[] getExcludeAtomIndices(int i) {
        if (this.excludeAtomIndices == null || this.excludeAtomIndices.length < this.excludeAtomSets[i].size()) {
            this.excludeAtomIndices = new int[this.excludeAtomSets[i].size()];
        }
        Arrays.fill(this.excludeAtomIndices, -1);
        int j = 0;
        for (MolAtom atom : this.excludeAtomSets[i]) {
            this.excludeAtomIndices[j++] = this.targets[i].indexOf(atom);
        }
        return this.excludeAtomIndices;
    }

    private String getRID(int i) {
        String rp = this.options.isReverse() ? "P" : "R";
        return RID_PREFIX + this.reaction.getID() + "(" + rp + "," + i + ")";
    }
}

