/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.formats.MolImporter;
import chemaxon.jep.Evaluator;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.ConcurrentReactorProcessor;
import chemaxon.reaction.FusedReactionEnumerator;
import chemaxon.reaction.ProductSet;
import chemaxon.reaction.ReactantFilter;
import chemaxon.reaction.ReactantRatioHandlerEnumerator;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionPerformer;
import chemaxon.reaction.ReactionResultEnumerator;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.ReactorOptions;
import chemaxon.reaction.SerializationUtils;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.ConfigTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Reactor
implements Licensable,
Serializable {
    private String licenseEnvironment = "ReactorLicenseEnvironmentForProfessionalUse";
    public static final int PRODUCT_OUTPUT = 0;
    public static final int REACTION_OUTPUT = 1;
    public static final int FUSED_REACTION_OUTPUT = 4;
    public static final int NO_DUPLICATE_FILTERING = 0;
    public static final int ORDER_SENSITIVE_DUPLICATE_FILTERING = 1;
    public static final int ORDER_INSENSITIVE_DUPLICATE_FILTERING = 2;
    public static final int MAPPING_STYLE_NONE = 0;
    public static final int MAPPING_STYLE_CHANGING = 1;
    public static final int MAPPING_STYLE_COMPLETE = 2;
    public static final int MAPPING_STYLE_MATCHING = 3;
    public static final int IGNORE_REACTIVITY = 1;
    public static final int IGNORE_SELECTIVITY = 2;
    public static final int IGNORE_TOLERANCE = 4;
    public static final double DEF_TOLERANCE = 1.0E-4;
    private static final String REACTANT_STANDARDIZER_TASK_GROUP_PREFIX = "reactant";
    public static final int DEF_MAX_TRANSFORM_COUNT = 100;
    private static Logger logger = Logger.getLogger(Reactor.class.getName());
    private ReactionResultEnumerator rre = null;
    private Reaction reaction = null;
    private ReactionPerformer performer = null;
    private Standardizer standardizer = null;
    private Standardizer reactionDefinedStandardizer = null;
    private boolean ignoreReactionDefinedStandardizer = false;
    private Standardizer productStandardizer = null;
    private int outputReactionMappingStyle = 0;
    private int fakeResultType = 0;
    private boolean skipReactionMappingCheck = false;
    private Molecule[] originalInputReactants = null;
    private Molecule[] reactants = null;
    private boolean first = true;
    private int pieces = Integer.MAX_VALUE;
    private int currentPieces = 0;
    private ReactorOptions options = new ReactorOptions(0, 1, 0, null, null, false, false, false, false, false, false, false, null, null, null, null, null);

    Reactor newInstance() {
        try {
            return (Reactor)SerializationUtils.clone(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setTransform(boolean transform) {
        this.options.setTransform(transform);
        this.options.setExcludeOverlappingHits(transform);
    }

    public String getReactionID() {
        if (this.reaction != null) {
            return this.reaction.getID();
        }
        return null;
    }

    private void setOptions(ReactorOptions options) {
        this.options = options;
    }

    public void setIgnoreRules(int type) {
        this.options.setIgnoreRules(type);
    }

    public void setSkipReactionMappingCheck(boolean skip) {
        this.skipReactionMappingCheck = skip;
    }

    public void setSingle(boolean single) {
        this.options.setSingle(single);
    }

    public boolean isSingle() {
        return this.options.isSingle();
    }

    public void setShowUnsuccessfulReactions(boolean showUnsuccessfulReactions) {
        this.options.setShowUnsuccessfulReactions(showUnsuccessfulReactions);
    }

    boolean isShowUnsuccessfulReactions() {
        return this.options.isShowUnsuccessfulReactions();
    }

    public void setDuplicateFiltering(int duplicateFilteringMethod) {
        this.options.setDuplicateFilteringMethod(duplicateFilteringMethod);
    }

    public void setMaxNumberOfProductSets(int pieces) {
        if (pieces == -1) {
            pieces = Integer.MAX_VALUE;
        }
        this.pieces = pieces;
        this.resetNumberOfReturnedProductSets();
    }

    private void resetNumberOfReturnedProductSets() {
        this.currentPieces = 0;
    }

    public void setProductIndexes(int[] inds) {
        if (inds != null) {
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = inds[i] - 1;
            }
            this.options.setProductIndexes(inds);
        } else {
            this.options.setProductIndexes(null);
        }
    }

    public void setResultType(int type) {
        if (type == 4) {
            this.fakeResultType = 4;
            this.options.setResultType(0);
            this.restart();
        } else {
            this.fakeResultType = 0;
            this.options.setResultType(type);
            this.restart();
        }
    }

    public void setOutputReactionMappingStyle(int style) {
        this.outputReactionMappingStyle = style;
        if (style == 0 && this.options.isMapResult() || style != 0 && !this.options.isMapResult()) {
            this.options.setMapResult(!this.options.isMapResult());
        }
    }

    public void setStandardizer(Standardizer standardizer) {
        this.standardizer = standardizer;
    }

    public Standardizer getStandardizer() {
        return this.standardizer;
    }

    private void setReactionDefinedStandardizer(Standardizer standardizer) {
        this.reactionDefinedStandardizer = standardizer;
    }

    private static Standardizer readReactionDefinedStandardizer(Molecule rxmol) throws ReactionException {
        if (rxmol == null || !rxmol.isReaction()) {
            throw new ReactionException("reaction is not in rxn format");
        }
        try {
            String standardization = rxmol.getProperty("STANDARDIZATION");
            return standardization != null ? new Standardizer(standardization) : null;
        }
        catch (StandardizerException e) {
            throw new ReactionException(e);
        }
    }

    public void setIgnoreReactionDefinedStandardizer(boolean ignore) {
        this.ignoreReactionDefinedStandardizer = ignore;
    }

    private void standardizeReactant(Molecule reactant, int index) throws ReactionException {
        Standardizer reactantStandardizer;
        Standardizer standardizer = this.standardizer != null ? this.standardizer : (reactantStandardizer = this.ignoreReactionDefinedStandardizer ? null : this.reactionDefinedStandardizer);
        if (reactantStandardizer != null && reactant != null) {
            reactantStandardizer.setLicenseEnvironment(this.licenseEnvironment);
            reactantStandardizer.setActiveGroup(REACTANT_STANDARDIZER_TASK_GROUP_PREFIX + Integer.toString(index + 1));
            try {
                reactantStandardizer.standardize(reactant);
            }
            catch (SearchException e) {
                throw new ReactionException(e);
            }
        }
    }

    public void setProductStandardizer(Standardizer productStandardizer) {
        this.productStandardizer = productStandardizer;
    }

    public Standardizer getProductStandardizer() {
        return this.productStandardizer;
    }

    private void standardizeProduct(Molecule product, int index) throws ReactionException {
        if (this.productStandardizer != null && product != null) {
            this.productStandardizer.setLicenseEnvironment(this.licenseEnvironment);
            this.productStandardizer.setActiveGroup("product" + Integer.toString(index + 1));
            try {
                this.productStandardizer.standardize(product);
            }
            catch (SearchException e) {
                throw new ReactionException(e);
            }
        }
    }

    private void standardizeProducts(Molecule[] mols) throws ReactionException {
        if (mols == null) {
            return;
        }
        Molecule[] products = mols;
        if (mols.length == 0 && mols[0].isReaction()) {
            products = ((RxnMolecule)mols[0]).getProducts();
        }
        for (int i = 0; i < products.length; ++i) {
            this.standardizeProduct(products[i], i);
        }
    }

    public void setReverse(boolean reverse) {
        this.options.setReverse(reverse);
    }

    public boolean isReverse() {
        return this.options.isReverse();
    }

    public void setSearchOptions(String searchOptions) {
        this.options.setSearchOptionsString(searchOptions);
    }

    public void setCached(boolean cached) {
        this.options.setCached(cached);
    }

    public boolean isCached() {
        return this.options.isCached();
    }

    public void setReactionIDPropertyName(String reactionIDProp) {
        this.options.setReactionIDProp(reactionIDProp);
    }

    public String getReactionIDPropertyName() {
        return this.options.getReactionIDProp();
    }

    public void setComponentIDPropertyNames(String reactantIDProp, String productIDProp) {
        this.setComponentIDPropertyNames(new String[]{reactantIDProp}, new String[]{productIDProp});
    }

    public void setComponentIDPropertyNames(String[] reactantIDProps, String[] productIDProps) {
        this.options.setReactantIDProps(reactantIDProps);
        this.options.setProductIDProps(productIDProps);
    }

    public void setCopyAllReactantProperties(boolean c) {
        this.options.setCopyAllReactantProperties(c);
    }

    public void setCopyReactantProperties(String[][] reactantPropertiesToCopy) {
        this.options.setCopyReactantProperties(reactantPropertiesToCopy, null);
    }

    public void setCopyReactantProperties(Map<String, String> patternBasedProperties) {
        this.options.setPatternBasedProperties(patternBasedProperties);
    }

    public void setCopyReactantProperties(String[][] sourceProperties, String[][] targetProperties) {
        this.options.setCopyReactantProperties(sourceProperties, targetProperties);
    }

    public void setRatio(int[] ratio) {
        this.options.setRatio(ratio);
        this.restart();
    }

    public void setReaction(Reaction reaction) {
        this.setReaction(reaction, reaction.getID());
    }

    private void setReaction(Reaction reaction, String id) {
        this.reaction = reaction;
        reaction.setID(id);
        this.performer = new ReactionPerformer(reaction, this.options);
        this.rre = null;
        this.first = true;
        this.resetNumberOfReturnedProductSets();
    }

    public void setReaction(Molecule rxmol) throws ReactionException {
        this.setReaction(rxmol, null);
    }

    public void setReaction(Molecule rxmol, String rid) throws ReactionException {
        this.setReactionDefinedStandardizer(Reactor.readReactionDefinedStandardizer(rxmol));
        this.setReaction(this.createReactionObject(rxmol, rid));
    }

    public void setReaction(Molecule rxmol, String rid, String reactivity, String selectivity, String tolerances) throws ReactionException {
        this.setReaction(rxmol, rid, reactivity, selectivity, Reaction.getTolerances(tolerances));
    }

    public void setReaction(Molecule rxmol, String rid, String reactivity, String selectivity, double[] tolerances) throws ReactionException {
        this.setReactionDefinedStandardizer(Reactor.readReactionDefinedStandardizer(rxmol));
        this.setReaction(this.createReactionObject(rxmol, rid, reactivity, selectivity, tolerances));
    }

    public RxnMolecule getReaction() {
        return this.reaction == null ? null : this.reaction.getReaction();
    }

    private Reaction createReactionObject(Molecule rxmol) throws ReactionException {
        return this.createReactionObject(rxmol, null);
    }

    private Reaction createReactionObject(Molecule rxmol, String rid) throws ReactionException {
        String reactivity = rxmol.getProperty("REACTIVITY");
        reactivity = reactivity == null || reactivity.equals("") ? null : reactivity;
        String exclude = rxmol.getProperty("EXCLUDE");
        exclude = exclude == null || exclude.equals("") ? null : exclude;
        String selectivity = rxmol.getProperty("SELECTIVITY");
        selectivity = selectivity == null || selectivity.equals("") ? null : selectivity;
        String tolerance = rxmol.getProperty("TOLERANCE");
        tolerance = tolerance == null || tolerance.equals("") ? null : tolerance;
        return this.createReactionObject(rxmol, rid, Reaction.getReactivity(reactivity, exclude), selectivity, tolerance);
    }

    public Reaction createReactionObject(Molecule rxmol, String rid, String reactivity, String selectivity, String tolerances) throws ReactionException {
        return this.createReactionObject(rxmol, rid, reactivity, selectivity, Reaction.getTolerances(tolerances));
    }

    public Reaction createReactionObject(Molecule rxmol, String rid, String reactivity, String selectivity, double[] tolerances) throws ReactionException {
        Evaluator evaluator = null;
        Reaction r = new Reaction(rid);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Reaction: " + ReactionUtil.toFormat(rxmol, new String[]{"smarts", "cxsmarts", "mrv"}));
        }
        r.setReaction(rxmol, this.options.isTransform(), this.skipReactionMappingCheck);
        if (reactivity != null) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Reactivity rule: " + reactivity.replaceAll("\n", " "));
            }
            try {
                evaluator = new Evaluator();
                evaluator.setLicenseEnvironment(this.licenseEnvironment);
            }
            catch (ParseException e) {
                throw new ReactionException(e);
            }
            r.setReactivityRule(reactivity, evaluator);
        }
        if (selectivity != null) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Selectivity rule: " + selectivity.replaceAll("\n", " "));
            }
            if (evaluator == null) {
                try {
                    evaluator = new Evaluator();
                    evaluator.setLicenseEnvironment(this.licenseEnvironment);
                }
                catch (ParseException e) {
                    throw new ReactionException(e);
                }
            }
            r.setSelectivityRule(selectivity, tolerances, evaluator);
        }
        return r;
    }

    public void setReactionString(String str) throws ReactionException {
        this.setReactionString(str, null);
    }

    public void setReactionString(String str, String rid) throws ReactionException {
        String[] items = ConfigTools.getItems(str);
        String structure = items[0];
        Molecule mol = null;
        try {
            mol = ConfigTools.getQueryMolecule(structure, "string", null);
        }
        catch (IOException e) {
            throw new ReactionException(e);
        }
        String reactivity = null;
        String selectivity = null;
        String tolerances = null;
        block7: for (int i = 1; i < items.length; ++i) {
            String item = items[i];
            if (item.length() < 3 || item.charAt(1) != ':') {
                throw new ReactionException("Invalid rule string: " + item);
            }
            char code = item.charAt(0);
            item = item.substring(2);
            switch (code) {
                case 'r': {
                    reactivity = item;
                    continue block7;
                }
                case 's': {
                    selectivity = item;
                    continue block7;
                }
                case 't': {
                    tolerances = item;
                    continue block7;
                }
                default: {
                    throw new ReactionException("Invalid rule code: " + code);
                }
            }
        }
        this.setReaction(mol, rid, reactivity, selectivity, Reaction.getTolerances(tolerances));
    }

    public int getReactantCount() {
        return this.options.isReverse() ? this.reaction.getProductCount() : this.reaction.getReactantCount();
    }

    public int getProductCount() {
        return this.options.isReverse() ? this.reaction.getReactantCount() : this.reaction.getProductCount();
    }

    public Molecule getReactionReactant(int i) {
        return this.options.isReverse() ? this.reaction.getProducts()[i] : this.reaction.getReactants()[i];
    }

    public Molecule getReactionProduct(int i) {
        return this.options.isReverse() ? this.reaction.getReactants()[i] : this.reaction.getProducts()[i];
    }

    public Molecule[] getReactants() {
        return this.originalInputReactants;
    }

    public void restart() {
        if (this.performer != null) {
            this.performer.restart();
        }
        this.rre = null;
        this.first = true;
        this.resetNumberOfReturnedProductSets();
    }

    ReactantFilter[] getReactantFilters() {
        MolSearch[] searchers;
        MolSearch[] molSearchArray = searchers = this.performer != null ? this.performer.getReactantSearchers() : null;
        if (searchers != null) {
            ReactantFilter[] reactantFilters = new ReactantFilter[searchers.length];
            for (int i = 0; i < reactantFilters.length; ++i) {
                reactantFilters[i] = new ReactantFilter();
                reactantFilters[i].setMolSearch(searchers[i]);
            }
            return reactantFilters;
        }
        return null;
    }

    public void setReactant(Molecule mol) throws ReactionException {
        this.setReactants(new Molecule[]{mol});
    }

    public void setReactants(String molstr) throws ReactionException {
        StringTokenizer st = new StringTokenizer(molstr, ".");
        Molecule[] mols = new Molecule[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                MolImporter importer = new MolImporter(new ByteArrayInputStream(st.nextToken().getBytes()));
                mols[i++] = importer.read();
                importer.close();
            }
        }
        catch (IOException e) {
            throw new ReactionException(e);
        }
        this.setReactants(mols);
    }

    public void setReactants(Molecule[] mols) throws ReactionException {
        if (this.reaction == null) {
            throw new ReactionException("Reaction is not set.");
        }
        if (mols == null) {
            throw new ReactionException("Reactant array should not be null.");
        }
        if (mols.length != this.getReactantCount()) {
            throw new ReactionException("Number of reactants should be " + this.getReactantCount() + " instead of " + mols.length + ".");
        }
        if (Arrays.asList(mols).contains(null)) {
            throw new ReactionException("None of the reactants can be null.");
        }
        this.originalInputReactants = mols;
        this.reactants = ReactionUtil.cloneMoleculeArray(mols);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Reactants: " + ReactionUtil.toFormat(this.reactants, new String[]{"smiles", "cxsmiles", "mrv"}));
        }
        for (Molecule reactant : this.reactants) {
            if (reactant.getDim() == 0) continue;
            reactant.setDim(0);
        }
        this.first = true;
        this.resetNumberOfReturnedProductSets();
    }

    public Molecule[] react() throws ReactionException {
        Molecule[] result;
        this.checkLicense();
        if (!this.first && this.options.isTransform()) {
            return null;
        }
        if (this.currentPieces < this.pieces) {
            ++this.currentPieces;
        } else {
            return null;
        }
        if (this.rre == null) {
            if (this.reaction == null) {
                throw new ReactionException("Reaction is not set.");
            }
            this.rre = this.performer;
            if (this.options.getRatio() != null) {
                this.rre = new ReactantRatioHandlerEnumerator(this.rre);
            }
            if (this.fakeResultType == 4) {
                this.rre = new FusedReactionEnumerator(this.rre);
            }
            this.rre.setOptions(this.options);
        }
        if (this.first) {
            this.first = false;
            Molecule[] reactants = ReactionUtil.cloneMoleculeArray(this.reactants);
            for (int i = 0; i < reactants.length; ++i) {
                this.standardizeReactant(reactants[i], i);
            }
            this.rre.setReactants(reactants);
        }
        if ((result = this.rre.react()) != null) {
            this.standardizeProducts(result);
            ReactionUtil.clearCachedInfo(result);
            if (!this.options.isTransform() && this.options.getDuplicateFilteringMethod() != 0) {
                result = ReactionUtil.cloneMoleculeArray(result);
            }
            if (this.options.getResultType() == 1 && this.outputReactionMappingStyle != 0) {
                this.mapOutputReactions(result);
            }
            return result;
        }
        if (this.options.isShowUnsuccessfulReactions() && this.currentPieces == 1 && (this.options.getResultType() == 1 || this.fakeResultType == 4)) {
            return ProductSet.createProductSet(ReactionUtil.cloneMoleculeArray(this.reactants), (Molecule[])null, 0).getResultAsMoleculeArray();
        }
        return null;
    }

    private void mapOutputReactions(Molecule[] rxns) throws ReactionException {
        for (Molecule mol : rxns) {
            RxnMolecule rxn = RxnMolecule.getReaction(mol);
            if (rxn == null) continue;
            try {
                AutoMapper mapper = new AutoMapper();
                switch (this.outputReactionMappingStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        mapper.setMappingStyle(2);
                        mapper.map(rxn);
                        break;
                    }
                    case 3: {
                        mapper.setMappingStyle(3);
                        mapper.map(rxn);
                    }
                }
            }
            catch (AutoMapperException e) {
                throw new ReactionException("Mapping of output reaction failed. Reaction: " + ReactionUtil.toFormat(this.reaction.rxn, new String[]{"smarts", "cxsmarts", "mrv"}), e);
            }
        }
    }

    public void setRemoveDuplicateProductReferences(boolean rmduprefs) {
        this.options.setRemoveDuplicateProductReferences(rmduprefs);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Reactor", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Reactor", this.licenseEnvironment);
    }

    public static void main(String[] args) throws Exception {
        ConcurrentReactorProcessor.main(args);
    }
}

