/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.jep.Evaluator;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.ConfigTools;
import chemaxon.util.SearchAttributes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class ReactorConfiguration
implements Serializable {
    private static final String REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE = "ReactorLicenseEnvironmentForProfessionalUse";
    public static final String RULES_TAG = "RULES";
    public static final String REACTIVITY_TAG = "REACTIVITY";
    public static final String EXCLUDE_TAG = "EXCLUDE";
    public static final String SELECTIVITY_TAG = "SELECTIVITY";
    public static final String TOLERANCE_TAG = "TOLERANCE";
    public static final String STANDARDIZATION_TAG = "STANDARDIZATION";
    protected String dir = null;
    protected Element root = null;
    private Evaluator evaluator = null;
    private Standardizer standardizer = null;
    private Standardizer productStandardizer = null;
    private boolean unique = true;
    private boolean cached = false;
    private boolean stset = false;
    private boolean pstset = false;
    protected boolean addRules = true;
    protected String rootElementName = "Reactions";

    public ReactorConfiguration() {
    }

    public ReactorConfiguration(File file) throws ReactionException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            this.root = doc.getRootElement();
            this.dir = file.getParent();
        }
        catch (DocumentException e) {
            throw new ReactionException(e);
        }
        catch (Exception e) {
            throw new ReactionException(e);
        }
        this.setParams();
    }

    public ReactorConfiguration(InputStream is) throws ReactionException {
        this(is, null);
    }

    public ReactorConfiguration(InputStream is, String dir) throws ReactionException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            this.root = doc.getRootElement();
            this.dir = dir;
            this.setParams();
        }
        catch (DocumentException e) {
            throw new ReactionException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ReactionException(e);
            }
        }
    }

    public ReactorConfiguration(Element root, String dir) throws ReactionException {
        this.root = root;
        this.dir = dir;
        this.setParams();
    }

    public ReactorConfiguration(Element root) throws ReactionException {
        this(root, null);
    }

    public ReactorConfiguration(String dir) {
        this.dir = dir;
    }

    public void setAddRules(boolean addRules) {
        this.addRules = addRules;
    }

    private void setParams() throws ReactionException {
        XPath path = DocumentHelper.createXPath((String)"Params");
        Element element = (Element)path.selectSingleNode((Object)this.root);
        if (element != null) {
            this.unique = !"false".equalsIgnoreCase(element.attributeValue("Unique"));
            this.cached = "true".equalsIgnoreCase(element.attributeValue("Cached"));
            try {
                this.getStandardizer();
                this.getProductStandardizer();
            }
            catch (StandardizerException e) {
                throw new ReactionException(e);
            }
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isCached() {
        return this.cached;
    }

    protected final Element getRoot() {
        return this.root;
    }

    public String[] getReactionIDs() {
        XPath path = DocumentHelper.createXPath((String)(this.rootElementName + "/Reaction | " + this.rootElementName + "/Sequence"));
        List list = path.selectNodes((Object)this.root);
        int size = list.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = ((Element)list.get(i)).attributeValue("ID");
        }
        return ids;
    }

    public Evaluator getEvaluator() throws ParseException {
        if (this.evaluator == null) {
            try {
                this.evaluator = new Evaluator(this.getStandardizer());
            }
            catch (StandardizerException e) {
                throw new ParseException(e);
            }
        }
        this.evaluator.setLicenseEnvironment(REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE);
        return this.evaluator;
    }

    protected void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Standardizer getStandardizer() throws StandardizerException {
        Element stnode;
        if (this.stset) {
            if (this.standardizer != null) {
                this.standardizer.setLicenseEnvironment(REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE);
            }
            return this.standardizer;
        }
        this.stset = true;
        if (this.root != null && (stnode = (Element)this.root.selectSingleNode("Standardizer")) != null) {
            this.standardizer = new Standardizer(stnode, this.dir);
            this.standardizer.setLicenseEnvironment(REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE);
            return this.standardizer;
        }
        return null;
    }

    protected void setStandardizer(Standardizer standardizer) {
        this.standardizer = standardizer;
        this.stset = true;
    }

    public Standardizer getProductStandardizer() throws StandardizerException {
        Element prodstnode;
        if (this.pstset) {
            if (this.productStandardizer != null) {
                this.productStandardizer.setLicenseEnvironment(REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE);
            }
            return this.productStandardizer;
        }
        this.pstset = true;
        if (this.root != null && (prodstnode = (Element)this.root.selectSingleNode("ProductStandardizer")) != null) {
            this.productStandardizer = new Standardizer(prodstnode, this.dir);
            this.productStandardizer.setLicenseEnvironment(REACTOR_LICENSE_ENVIRONMENT_FOR_PROFESSIONAL_USE);
            return this.productStandardizer;
        }
        return null;
    }

    protected void setProductStandardizer(Standardizer productStandardizer) {
        this.productStandardizer = productStandardizer;
        this.pstset = true;
    }

    public SearchAttributes getReactionSearchAttributes() {
        return this.getSearchAttributes(this.root, "Search");
    }

    private SearchAttributes getSearchAttributes(Element element, String xmlpath) {
        XPath path = DocumentHelper.createXPath((String)xmlpath);
        Element elem = (Element)path.selectSingleNode((Object)element);
        if (elem != null) {
            SearchAttributes sa = new SearchAttributes();
            String v = elem.attributeValue("StereoSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setStereoSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setStereoSearch(false);
            }
            v = elem.attributeValue("DoubleBondStereoMatchingMode");
            if ("none".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(2);
            } else if ("marked".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(1);
            } else if ("all".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(0);
            }
            v = elem.attributeValue("SubgraphSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setSubgraphSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setSubgraphSearch(false);
            }
            v = elem.attributeValue("ExactAtomMatching");
            if ("true".equalsIgnoreCase(v)) {
                sa.setExactAtomMatching(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setExactAtomMatching(false);
            }
            v = elem.attributeValue("ExactStereoMatching");
            if ("true".equalsIgnoreCase(v)) {
                sa.setExactStereoMatching(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setExactStereoMatching(false);
            }
            v = elem.attributeValue("OrderSensitiveSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setOrderSensitiveSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setOrderSensitiveSearch(false);
            }
            return sa;
        }
        return null;
    }

    private Element getReactionElement(String id) throws ReactionException {
        XPath path = DocumentHelper.createXPath((String)(this.rootElementName + "/Reaction[@ID='" + id + "']"));
        Element element = (Element)path.selectSingleNode((Object)this.root);
        if (element == null) {
            throw new ReactionException("No reaction is defined with ID: " + id);
        }
        return element;
    }

    private Element getLibraryElement(String id) throws ReactionException {
        XPath path = DocumentHelper.createXPath((String)(this.rootElementName + "/Library[@ID='" + id + "']"));
        Element element = (Element)path.selectSingleNode((Object)this.root);
        return element;
    }

    private Element getSequenceElement(String id) throws ReactionException {
        XPath path = DocumentHelper.createXPath((String)(this.rootElementName + "/Sequence[@ID='" + id + "'] | " + this.rootElementName + "/Reaction[@ID='" + id + "']"));
        Element element = (Element)path.selectSingleNode((Object)this.root);
        if (element == null) {
            throw new ReactionException("No sequence is defined with ID: " + id);
        }
        return element;
    }

    private String getReactionDir(Element element) throws ReactionException {
        String structure = element.attributeValue("Structure");
        if (structure == null) {
            throw new ReactionException("Structure attributes is mandatory for Reaction elements");
        }
        String type = element.attributeValue("Type");
        return ConfigTools.getMolDir(structure, type, this.dir);
    }

    private RxnMolecule getReactionMolecule(Element element) throws ReactionException {
        String structure = element.attributeValue("Structure");
        if (structure == null) {
            throw new ReactionException("Structure attributes is mandatory for Reaction elements");
        }
        String type = element.attributeValue("Type");
        Molecule mol = null;
        try {
            mol = ConfigTools.getQueryMolecule(structure, type, this.dir);
        }
        catch (IOException e) {
            throw new ReactionException("Could not read reaction: " + structure, e);
        }
        RxnMolecule rxn = RxnMolecule.getReaction(mol);
        if (rxn == null) {
            throw new ReactionException("reaction is not in rxn format");
        }
        return rxn;
    }

    private RxnMolecule[] getReactionMolecules(Element element) throws ReactionException {
        String structure = element.attributeValue("Structure");
        if (structure == null) {
            throw new ReactionException("Structure attributes is mandatory for Reaction elements");
        }
        String type = element.attributeValue("Type");
        Molecule[] mols = null;
        try {
            mols = ConfigTools.getQueryMolecules(structure, type, this.dir);
        }
        catch (IOException e) {
            throw new ReactionException("Could not read reaction library: " + structure, e);
        }
        RxnMolecule[] rxns = new RxnMolecule[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            RxnMolecule rxn = RxnMolecule.getReaction(mols[i]);
            if (rxn == null) {
                throw new ReactionException("reaction is not in rxn format");
            }
            rxns[i] = rxn;
        }
        return rxns;
    }

    public RxnMolecule getReactionMolecule(String id) throws ReactionException {
        String lid;
        Element element;
        int k = id.indexOf(" : ");
        if (k != -1 && (element = this.getLibraryElement(lid = id.substring(0, k))) != null) {
            RxnMolecule[] rxns = this.getReactionMolecules(element);
            String rid = id.substring(k + 3);
            if (rid.charAt(0) == '(' && rid.charAt(rid.length() - 1) == ')') {
                int index = Integer.parseInt(rid.substring(1, rid.length() - 1)) - 1;
                return rxns[index];
            }
            for (int i = 0; i < rxns.length; ++i) {
                if (!rid.equals(rxns[i].getProperty("NAME"))) continue;
                return rxns[i];
            }
            throw new ReactionException("No reaction " + rid + " in library " + lid);
        }
        Element element2 = this.getSequenceElement(id);
        if (element2.getName().equals("Reaction")) {
            return this.getReactionMolecule(element2);
        }
        XPath path = DocumentHelper.createXPath((String)"Reaction");
        List list = path.selectNodes((Object)element2);
        int n = list.size();
        if (n == 0) {
            throw new ReactionException("Empty reaction sequence, id = " + id);
        }
        RxnMolecule rxn = new RxnMolecule();
        for (int i = 0; i < n; ++i) {
            int j;
            RxnMolecule rxmol = this.getReactionMolecule((Element)list.get(i));
            if (i == 0) {
                int r = rxmol.getReactantCount();
                for (j = 0; j < r; ++j) {
                    rxn.addComponent(rxmol.getReactant(j), 0);
                }
            }
            int a = rxmol.getAgentCount();
            for (j = 0; j < a; ++j) {
                rxn.addComponent(rxmol.getAgent(j), 2);
            }
            if (i != n - 1) continue;
            int p = rxmol.getProductCount();
            for (int j2 = 0; j2 < p; ++j2) {
                rxn.addComponent(rxmol.getProduct(j2), 1);
            }
        }
        return rxn;
    }

    public Reaction[] getReactionSequence(String id) throws ReactionException {
        Element element = this.getSequenceElement(id);
        if (element.getName().equals("Reaction")) {
            return new Reaction[]{this.getReaction(element, id)};
        }
        XPath path = DocumentHelper.createXPath((String)"Reaction");
        List list = path.selectNodes((Object)element);
        Reaction[] reactions = new Reaction[list.size()];
        for (int i = 0; i < reactions.length; ++i) {
            reactions[i] = this.getReaction((Element)list.get(i));
        }
        return reactions;
    }

    public Reaction getReaction(String id) throws ReactionException {
        return this.getReaction(this.getReactionElement(id));
    }

    public Reaction getReaction(Element element) throws ReactionException {
        return this.getReaction(element, element.attributeValue("ID"));
    }

    public Reaction getReaction(String id, boolean fuse) throws ReactionException {
        return this.getReaction(this.getReactionElement(id), fuse);
    }

    public Reaction getReaction(Element element, boolean fuse) throws ReactionException {
        return this.getReaction(element, element.attributeValue("ID"), fuse);
    }

    private Reaction getReaction(Element element, String id) throws ReactionException {
        return this.getReaction(element, id, false);
    }

    private Reaction getReaction(Element element, String id, boolean fuse) throws ReactionException {
        RxnMolecule rxn = this.getReactionMolecule(element);
        if (fuse) {
            rxn = ReactionUtil.fuseReactionMolecule(rxn);
        }
        Reaction reaction = null;
        reaction = new Reaction(id);
        reaction.setReaction(rxn);
        if (this.addRules && !this.setRules(reaction, element)) {
            String rules = rxn.getProperty(RULES_TAG);
            String reactivity = rxn.getProperty(REACTIVITY_TAG);
            reactivity = reactivity == null || reactivity.equals("") ? null : reactivity;
            String exclude = rxn.getProperty(EXCLUDE_TAG);
            exclude = exclude == null || exclude.equals("") ? null : exclude;
            String selectivity = rxn.getProperty(SELECTIVITY_TAG);
            selectivity = selectivity == null || selectivity.equals("") ? null : selectivity;
            String tolerance = rxn.getProperty(TOLERANCE_TAG);
            String string = tolerance = tolerance == null || tolerance.equals("") ? null : tolerance;
            if (rules != null || reactivity != null || exclude != null || selectivity != null) {
                ReactorConfiguration rctemp = ReactorConfiguration.createConfig(this, rules, this.getReactionDir(element));
                rctemp.setRules(reaction, reactivity, exclude, selectivity, tolerance);
            }
        }
        return reaction;
    }

    public Reaction[] getReactionLibrary(String id) throws ReactionException {
        return this.getReactionLibrary(this.getLibraryElement(id));
    }

    public Reaction[] getReactionLibrary(Element element) throws ReactionException {
        return this.getReactionLibrary(element, element.attributeValue("ID"));
    }

    public Reaction[] getReactionLibrary(String id, boolean fuse) throws ReactionException {
        return this.getReactionLibrary(this.getLibraryElement(id), fuse);
    }

    public Reaction[] getReactionLibrary(Element element, boolean fuse) throws ReactionException {
        return this.getReactionLibrary(element, element.attributeValue("ID"), fuse);
    }

    private Reaction[] getReactionLibrary(Element element, String id) throws ReactionException {
        return this.getReactionLibrary(element, id, false);
    }

    private Reaction[] getReactionLibrary(Element element, String id, boolean fuse) throws ReactionException {
        RxnMolecule[] rxns = this.getReactionMolecules(element);
        if (fuse) {
            for (int i = 0; i < rxns.length; ++i) {
                rxns[i] = ReactionUtil.fuseReactionMolecule(rxns[i]);
            }
        }
        Reaction[] reactions = new Reaction[rxns.length];
        for (int i = 0; i < rxns.length; ++i) {
            String name = rxns[i].getProperty("NAME");
            if (name == null) {
                name = "(" + (i + 1) + ")";
            }
            String rid = "" + id + " : " + name;
            reactions[i] = new Reaction(rid);
            reactions[i].setReaction(rxns[i]);
            if (!this.addRules) continue;
            String rules = rxns[i].getProperty(RULES_TAG);
            String reactivity = rxns[i].getProperty(REACTIVITY_TAG);
            reactivity = reactivity == null || reactivity.equals("") ? null : reactivity;
            String exclude = rxns[i].getProperty(EXCLUDE_TAG);
            exclude = exclude == null || exclude.equals("") ? null : exclude;
            String selectivity = rxns[i].getProperty(SELECTIVITY_TAG);
            selectivity = selectivity == null || selectivity.equals("") ? null : selectivity;
            String tolerance = rxns[i].getProperty(TOLERANCE_TAG);
            String string = tolerance = tolerance == null || tolerance.equals("") ? null : tolerance;
            if (rules == null && reactivity == null && exclude == null && selectivity == null) continue;
            ReactorConfiguration rctemp = ReactorConfiguration.createConfig(this, rules, this.getReactionDir(element));
            rctemp.setRules(reactions[i], reactivity, exclude, selectivity, tolerance);
        }
        return reactions;
    }

    protected static ReactorConfiguration createConfig(ReactorConfiguration rc, String rules, String cdir) throws ReactionException {
        ReactorConfiguration rcnew = null;
        if (rules != null) {
            BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(rules.getBytes()));
            rcnew = new ReactorConfiguration(is, cdir);
        } else {
            rcnew = new ReactorConfiguration(cdir);
        }
        try {
            if (rc != null) {
                rcnew.setStandardizer(rc.getStandardizer());
                rcnew.setProductStandardizer(rc.getProductStandardizer());
                rcnew.setEvaluator(rc.getEvaluator());
            }
        }
        catch (StandardizerException e) {
            throw new ReactionException(e);
        }
        catch (ParseException e) {
            throw new ReactionException(e);
        }
        return rcnew;
    }

    protected boolean setRules(Reaction reaction, Element element) throws ReactionException {
        return this.setRules(reaction, element, null, null, null, null);
    }

    protected boolean setRules(Reaction reaction, Element element, String reactivity, String exclude, String selectivity, String tolerance) throws ReactionException {
        try {
            XPath spath;
            Element selem;
            XPath epath;
            Element eelem;
            XPath rpath;
            Element relem;
            if (reactivity == null && (relem = (Element)(rpath = DocumentHelper.createXPath((String)"Reactivity")).selectSingleNode((Object)element)) != null) {
                reactivity = relem.getText();
            }
            if (exclude == null && (eelem = (Element)(epath = DocumentHelper.createXPath((String)"Exclude")).selectSingleNode((Object)element)) != null) {
                exclude = eelem.getText();
            }
            if ((reactivity = Reaction.getReactivity(reactivity, exclude)) != null) {
                reaction.setReactivityRule(reactivity, this.getEvaluator());
            }
            if (selectivity == null && (selem = (Element)(spath = DocumentHelper.createXPath((String)"Selectivity")).selectSingleNode((Object)element)) != null) {
                selectivity = selem.getText();
                tolerance = selem.attributeValue("Tolerance");
            }
            if (selectivity != null) {
                if (tolerance != null) {
                    reaction.setSelectivityRule(selectivity, tolerance, this.getEvaluator());
                } else {
                    reaction.setSelectivityRule(selectivity, (double[])null, this.getEvaluator());
                }
            }
        }
        catch (ParseException e) {
            throw new ReactionException(e);
        }
        return reactivity != null || selectivity != null;
    }

    protected void setRules(Reaction reaction, String reactivity, String exclude, String selectivity, String tolerance) throws ReactionException {
        this.setRules(reaction, this.root, reactivity, exclude, selectivity, tolerance);
    }
}

