/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

class SerializationUtils {
    SerializationUtils() {
    }

    public static Object clone(Serializable o) throws IOException, ClassNotFoundException {
        return SerializationUtils.deserialize(SerializationUtils.serialize(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Serializable o) throws IOException {
        byte[] byArray;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(512);
            oos = new ObjectOutputStream(os);
            oos.writeObject(o);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            SerializationUtils.close(oos);
            throw throwable;
        }
        SerializationUtils.close(oos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStreamExt is = null;
        try {
            is = new ObjectInputStreamExt(new ByteArrayInputStream(data));
            object = is.readObject();
        }
        catch (Throwable throwable) {
            SerializationUtils.close(is);
            throw throwable;
        }
        SerializationUtils.close(is);
        return object;
    }

    private static void close(Closeable oos) {
        if (oos == null) {
            return;
        }
        try {
            oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ObjectInputStreamExt
    extends ObjectInputStream {
        public ObjectInputStreamExt(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (Thread.currentThread().getContextClassLoader() != null) {
                try {
                    return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.resolveClass(desc);
        }
    }
}

