/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.GroupList;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionPerformer;
import chemaxon.reaction.ReactorConfiguration;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerData;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.ConfigTools;
import chemaxon.util.SearchAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class StandardizerConfiguration
extends ReactorConfiguration {
    private ArrayList data = null;

    public StandardizerConfiguration() {
        this.rootElementName = "Actions";
        this.data = new ArrayList();
    }

    public StandardizerData[] getData() {
        StandardizerData[] res = new StandardizerData[this.data.size()];
        this.data.toArray(res);
        return res;
    }

    public void read(String str) throws StandardizerException {
        if (ConfigTools.isXML(str, "Standardizer")) {
            this.readXML(new BufferedInputStream(new ByteArrayInputStream(str.getBytes())));
        } else {
            String[] items = str.trim().indexOf("\n") == -1 ? ConfigTools.getItems(str) : ConfigTools.getItems(str, "\r\n");
            this.read(items);
        }
    }

    public void read(File file) throws StandardizerException {
        this.dir = file.getParent();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            this.read(ConfigTools.getContent(br));
        }
        catch (IOException e) {
            throw new StandardizerException(e);
        }
    }

    public void read(InputStream is) throws StandardizerException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            this.read(ConfigTools.getContent(br));
        }
        catch (IOException e) {
            throw new StandardizerException(e);
        }
    }

    private void readXML(InputStream is) throws StandardizerException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            Element root = doc.getRootElement();
            this.read(root);
        }
        catch (DocumentException e) {
            throw new StandardizerException("Error occured during XML parsing.", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new StandardizerException("Error occured during XML parsing.", e);
            }
        }
    }

    public void read(Element root, String dir) throws StandardizerException {
        this.dir = dir;
        this.read(root);
    }

    public void read(Element root) throws StandardizerException {
        Element element = (Element)root.selectSingleNode("Actions");
        if (element == null) {
            throw new StandardizerException("No standardizer actions defined.");
        }
        List actions = element.selectNodes("*");
        int size = actions.size();
        for (int i = 0; i < size; ++i) {
            Element actionNode = (Element)actions.get(i);
            StandardizerData record = null;
            String id = actionNode.attributeValue("ID");
            String name = actionNode.getName();
            HashSet groups = StandardizerConfiguration.getGroups(actionNode.attributeValue("Groups"));
            boolean optional = "true".equalsIgnoreCase(actionNode.attributeValue("Optional"));
            if (optional) {
                groups = Standardizer.SET_TARGET;
            }
            if (name.equalsIgnoreCase("Reaction") || name.equalsIgnoreCase("Transformation")) {
                Reaction reaction = null;
                try {
                    reaction = this.getReaction(actionNode, true);
                    if (reaction.rjep != null || reaction.sjep != null) {
                        throw new StandardizerException("Reaction rules are not supported by Standardizer.\nUse Reactor to process reactions with rules.");
                    }
                }
                catch (ReactionException e) {
                    throw new StandardizerException(e);
                }
                boolean exact = actionNode.attributeValue("Exact", "").equalsIgnoreCase("true");
                String searchOptions = actionNode.attributeValue("SearchOptions");
                record = this.createReactionRecord(id, reaction, searchOptions, exact, groups);
            } else if (name.equalsIgnoreCase("Action")) {
                String act = actionNode.attributeValue("Act", "");
                if (act.equalsIgnoreCase("dehydrogenize")) {
                    record = new StandardizerData(4, id, 0, groups);
                } else {
                    if (act.equalsIgnoreCase("aromatize")) {
                        String param = actionNode.attributeValue("Type", "");
                        if (param.equalsIgnoreCase("basic") || param.equalsIgnoreCase("chemaxon") || param.equals("1")) {
                            act = "aromatize:b";
                        }
                        if (param.equalsIgnoreCase("loose")) {
                            act = "aromatize:l";
                        }
                    }
                    record = new StandardizerData(1, id, act, groups);
                }
            } else if (name.equalsIgnoreCase("Aromatize")) {
                String act = "aromatize";
                String param = actionNode.attributeValue("Type", "");
                if (param.equalsIgnoreCase("basic") || param.equalsIgnoreCase("chemaxon") || param.equals("1")) {
                    act = "aromatize:b";
                }
                if (param.equalsIgnoreCase("loose")) {
                    act = "aromatize:l";
                }
                record = new StandardizerData(1, id, act, groups);
            } else if (name.equalsIgnoreCase("Dearomatize") || name.equalsIgnoreCase("Hydrogenize") || name.equalsIgnoreCase("AddExplicitH")) {
                record = new StandardizerData(1, id, name, groups);
            } else if (name.equalsIgnoreCase("Removal")) {
                int rmethod = 2;
                String str = actionNode.attributeValue("Method", "");
                if (str.equalsIgnoreCase("removeSmallest")) {
                    rmethod = 1;
                } else if (str.equalsIgnoreCase("removeLargest")) {
                    rmethod = 3;
                } else if (str.equalsIgnoreCase("keepSmallest")) {
                    rmethod = 4;
                } else if (str.equalsIgnoreCase("rgroups")) {
                    rmethod = 5;
                }
                int rmeasure = actionNode.attributeValue("Measure", "").equalsIgnoreCase("molMass") ? 2 : 1;
                record = new StandardizerData(2, id, rmethod, rmeasure, groups);
            } else if (name.equalsIgnoreCase("RemoveRGroupDefinitions")) {
                record = new StandardizerData(21, id, groups);
            } else if (name.equalsIgnoreCase("Tautomerize")) {
                record = new StandardizerData(9, id, groups);
            } else if (name.equalsIgnoreCase("Mesomerize")) {
                record = new StandardizerData(10, id, groups);
            } else if (name.equalsIgnoreCase("Clean")) {
                int dim = Integer.parseInt(actionNode.attributeValue("Dim", "-1"));
                if (dim != 2 && dim != 3 && dim != -1) {
                    throw new StandardizerException("Invalid clean dimension: " + dim);
                }
                int type = 1;
                String typestr = actionNode.attributeValue("Type", "partial");
                Molecule[] cleanTemplates = null;
                if (typestr.equalsIgnoreCase("full")) {
                    type = 2;
                } else if (typestr.equalsIgnoreCase("templatebased")) {
                    type = 3;
                    String templates = actionNode.attributeValue("Templates");
                    String file = actionNode.attributeValue("TemplateFile");
                    if (dim == 3) {
                        throw new StandardizerException("Template based clean is not available in 3D");
                    }
                    dim = 2;
                    if (templates != null) {
                        cleanTemplates = this.readCleanTemplatesFromString(templates);
                    } else if (file != null) {
                        cleanTemplates = this.readCleanTemplatesFromFile(file);
                    }
                } else if (typestr.equalsIgnoreCase("removeZCoordinate")) {
                    type = 4;
                } else {
                    if (dim == 3) {
                        throw new StandardizerException("Partial clean is not available in 3D");
                    }
                    dim = 2;
                }
                record = new StandardizerData(3, id, dim, type, cleanTemplates, groups);
            } else if (name.equalsIgnoreCase("ImplH") || name.equalsIgnoreCase("Dehydrogenize") || name.equalsIgnoreCase("RemoveExplicitH")) {
                int flags = 0;
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Lonely"))) {
                    flags |= 1;
                }
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Isotope"))) {
                    flags |= 2;
                }
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Charged"))) {
                    flags |= 4;
                }
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Radical"))) {
                    flags |= 8;
                }
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Mapped"))) {
                    flags |= 0x10;
                }
                if ("true".equalsIgnoreCase(actionNode.attributeValue("Wedged"))) {
                    flags |= 0x20;
                }
                record = new StandardizerData(4, id, flags, groups);
            } else if (name.equalsIgnoreCase("Sgroups")) {
                int flags = 0;
                String sgact = actionNode.attributeValue("Act");
                if ("Contract".equalsIgnoreCase(sgact)) {
                    flags = 1;
                } else if ("Expand".equalsIgnoreCase(sgact)) {
                    flags = 2;
                } else if ("Ungroup".equalsIgnoreCase(sgact)) {
                    flags = 3;
                } else {
                    throw new StandardizerException("Invalid sgroups action: " + sgact);
                }
                String exclude = actionNode.attributeValue("Exclude");
                HashSet<String> sgroupsToExclude = null;
                if (exclude != null && exclude.trim().length() != 0) {
                    sgroupsToExclude = new HashSet<String>();
                    String[] sgroupNames = exclude.split(",");
                    for (int j = 0; j < sgroupNames.length; ++j) {
                        sgroupsToExclude.add(sgroupNames[j].trim());
                    }
                }
                record = new StandardizerData(5, id, flags, sgroupsToExclude, groups);
            } else if (name.equalsIgnoreCase("ClearStereo")) {
                int flags = 0;
                String csact = actionNode.attributeValue("Type");
                if (csact == null || csact != null && "All".equalsIgnoreCase(csact) || "".equalsIgnoreCase(csact)) {
                    flags = 3;
                } else {
                    String[] types = csact.split(",");
                    for (int j = 0; j < types.length; ++j) {
                        String type = types[j].trim();
                        if ("Chirality".equalsIgnoreCase(type)) {
                            flags |= 1;
                            continue;
                        }
                        if ("DoubleBond".equalsIgnoreCase(type)) {
                            flags |= 2;
                            continue;
                        }
                        if ("SingleUpOrDownBond".equalsIgnoreCase(type)) {
                            flags |= 4;
                            continue;
                        }
                        throw new StandardizerException("Invalid ClearStereo action: " + csact);
                    }
                }
                record = new StandardizerData(6, id, flags, groups);
            } else if (name.equalsIgnoreCase("AbsoluteStereo")) {
                String act = actionNode.attributeValue("Act", "");
                int flags = 0;
                if ("Clear".equalsIgnoreCase(act)) {
                    flags = 1;
                } else if ("Set".equalsIgnoreCase(act)) {
                    flags = 2;
                } else {
                    throw new StandardizerException("Invalid AbsoluteStereo action: " + act);
                }
                record = new StandardizerData(7, id, flags, groups);
            } else if (name.equalsIgnoreCase("ConvertToEnhancedStereo")) {
                int flags = 0;
                if ("true".equalsIgnoreCase(actionNode.attributeValue("AbsStereo"))) {
                    flags |= 1;
                }
                if ("and".equalsIgnoreCase(actionNode.attributeValue("DefaultNonAbsStereoGroup", "and"))) {
                    flags |= 2;
                }
                if ("or".equalsIgnoreCase(actionNode.attributeValue("DefaultNonAbsStereoGroup", "and"))) {
                    flags |= 4;
                }
                record = new StandardizerData(22, id, flags, groups);
            } else if (name.equalsIgnoreCase("Expand")) {
                String data = actionNode.attributeValue("Data", "Stoichiometry");
                record = new StandardizerData(8, id, data, groups);
            } else if (name.equalsIgnoreCase("MapReaction")) {
                record = new StandardizerData(11, id, groups);
            } else if (name.equalsIgnoreCase("Map")) {
                record = new StandardizerData(12, id, groups);
            } else if (name.equalsIgnoreCase("Unmap") || name.equalsIgnoreCase("UnmapReaction")) {
                record = new StandardizerData(13, id, groups);
            } else if (name.equalsIgnoreCase("ConvertDoubleBonds")) {
                String typestr = actionNode.attributeValue("Type", "");
                int flags = 0;
                if ("Wiggly".equalsIgnoreCase(typestr)) {
                    flags = 1;
                } else if ("Crossed".equalsIgnoreCase(typestr)) {
                    flags = 2;
                } else {
                    throw new StandardizerException("Invalid ConvertDoubleBonds action: " + typestr);
                }
                record = new StandardizerData(14, id, flags, groups);
            } else if (name.equalsIgnoreCase("WedgeClean")) {
                record = new StandardizerData(15, id, groups);
            } else if (name.equalsIgnoreCase("ConvertWedgeInterpretation")) {
                record = new StandardizerData(16, id, groups);
            } else if (name.equalsIgnoreCase("Neutralize")) {
                record = new StandardizerData(17, id, groups);
            } else if (name.equalsIgnoreCase("ClearIsotopes")) {
                record = new StandardizerData(18, id, groups);
            } else if (name.equalsIgnoreCase("AliasToGroup")) {
                record = new StandardizerData(19, id, groups);
            } else if (name.equalsIgnoreCase("AliasToAtom")) {
                record = new StandardizerData(20, id, groups);
            } else if (name.equalsIgnoreCase("RemoveAtomValues")) {
                record = new StandardizerData(23, id, groups);
            } else if (name.equalsIgnoreCase("RemoveAttachedData")) {
                record = new StandardizerData(24, id, groups);
            } else if (name.equalsIgnoreCase("RemoveStereoCareBox")) {
                record = new StandardizerData(25, id, groups);
            } else if (name.equalsIgnoreCase("CreateGroup")) {
                GroupList list = new GroupList();
                list.parseXML(actionNode);
                record = new StandardizerData(26, list);
            } else {
                throw new StandardizerException("Invalid action element: " + name);
            }
            this.data.add(record);
        }
    }

    public void read(String[] items) throws StandardizerException {
        for (int i = 0; i < items.length; ++i) {
            String item = items[i].trim();
            if (item.length() == 0) continue;
            HashSet groups = null;
            int groupsEnd = item.indexOf("}");
            if (item.startsWith("{") && groupsEnd != -1) {
                groups = StandardizerConfiguration.getGroups(item.substring(1, groupsEnd));
                item = item.substring(groupsEnd + 1);
            }
            boolean optional = false;
            if (item.endsWith(":optional")) {
                groups = Standardizer.SET_TARGET;
                item = item.substring(0, item.length() - 9);
            }
            String origItem = item;
            item = item.toLowerCase();
            StandardizerData record = null;
            if (item.startsWith("aromatize") || item.equals("dearomatize") || item.equals("hydrogenize") || item.equals("addexplicith")) {
                record = new StandardizerData(1, item, item, groups);
            } else if (item.startsWith("implh") || item.startsWith("removeexplicith") || item.startsWith("dehydrogenize")) {
                int flags = 0;
                if (item.indexOf("lonely") != -1) {
                    flags |= 1;
                }
                if (item.indexOf("isotope") != -1) {
                    flags |= 2;
                }
                if (item.indexOf("charged") != -1) {
                    flags |= 4;
                }
                if (item.indexOf("radical") != -1) {
                    flags |= 8;
                }
                if (item.indexOf("mapped") != -1) {
                    flags |= 0x10;
                }
                if (item.indexOf("wedged") != -1) {
                    flags |= 0x20;
                }
                record = new StandardizerData(4, item, flags, groups);
            } else if (item.equals("tautomerize")) {
                record = new StandardizerData(9, item, groups);
            } else if (item.equals("mesomerize")) {
                record = new StandardizerData(10, item, groups);
            } else if (item.equals("clean")) {
                record = new StandardizerData(3, item, 2, 1, null, groups);
            } else if (item.equals("clean:full")) {
                record = new StandardizerData(3, item, 2, 2, null, groups);
            } else if (item.equals("clean:3")) {
                record = new StandardizerData(3, item, 3, 2, null, groups);
            } else if (item.equals("clean:tb")) {
                record = new StandardizerData(3, item, 2, 3, null, groups);
            } else if (item.equalsIgnoreCase("clean:removezcoordinate")) {
                record = new StandardizerData(3, item, 2, 4, null, groups);
            } else if (item.startsWith("clean:")) {
                int k = items[i].indexOf(":");
                String file = items[i].substring(k + 1);
                Molecule[] cleanTemplates = this.readCleanTemplatesFromFile(file);
                record = new StandardizerData(3, item, 2, 3, cleanTemplates, groups);
            } else if (item.equals("keepone")) {
                record = new StandardizerData(2, item, 2, 1, groups);
            } else if (item.equals("keepone:mass")) {
                record = new StandardizerData(2, item, 2, 2, groups);
            } else if (item.equals("removergroupdefinitions")) {
                record = new StandardizerData(21, item, groups);
            } else if (item.startsWith("sgroups")) {
                int flags = 0;
                if (item.indexOf("contract") != -1) {
                    flags = 1;
                } else if (item.indexOf("expand") != -1) {
                    flags = 2;
                } else if (item.indexOf("ungroup") != -1) {
                    flags = 3;
                } else {
                    throw new StandardizerException("Invalid Sgroup action: " + item);
                }
                record = new StandardizerData(5, item, flags, groups);
            } else if (item.startsWith("clearstereo")) {
                int flags = 3;
                if (item.indexOf("chirality") != -1) {
                    flags = 1;
                } else if (item.indexOf("doublebond") != -1) {
                    flags = 2;
                } else if (item.indexOf("singleupordownbond") != -1) {
                    flags = 4;
                }
                record = new StandardizerData(6, item, flags, groups);
            } else if (item.startsWith("absolutestereo")) {
                int flags = 0;
                if (item.indexOf("clear") != -1) {
                    flags = 1;
                } else if (item.indexOf("set") != -1) {
                    flags = 2;
                } else {
                    throw new StandardizerException("Invalid AbsoluteStereo action: " + item);
                }
                record = new StandardizerData(7, item, flags, groups);
            } else if (item.startsWith("converttoenhancedstereo")) {
                int flags = 0;
                if (item.indexOf("abs") != -1) {
                    flags |= 1;
                }
                flags = item.indexOf("or") != -1 ? (flags |= 4) : (flags |= 2);
                record = new StandardizerData(22, item, flags, groups);
            } else if (item.startsWith("expand")) {
                int k = items[i].indexOf(":");
                String data = k != -1 ? items[i].substring(k + 1) : "Stoichiometry";
                record = new StandardizerData(8, item, data, groups);
            } else if (item.startsWith("mapreaction")) {
                record = new StandardizerData(11, item, groups);
            } else if (item.equals("map")) {
                record = new StandardizerData(12, item, groups);
            } else if (item.startsWith("unmap")) {
                record = new StandardizerData(13, item, groups);
            } else if (!item.startsWith("mapping")) {
                if (item.startsWith("convertdoublebonds")) {
                    int flags = 0;
                    if (item.indexOf("wiggly") != -1) {
                        flags = 1;
                    } else if (item.indexOf("crossed") != -1) {
                        flags = 2;
                    } else {
                        throw new StandardizerException("Invalid ConverDoubleBonds action: " + item);
                    }
                    record = new StandardizerData(14, item, flags, groups);
                } else if (item.equals("wedgeclean")) {
                    record = new StandardizerData(15, item, groups);
                } else if (item.equals("convertwedgeinterpretation")) {
                    record = new StandardizerData(16, item, groups);
                } else if (item.equals("neutralize")) {
                    record = new StandardizerData(17, item, groups);
                } else if (item.equals("clearisotopes")) {
                    record = new StandardizerData(18, item, groups);
                } else if (item.equals("aliastogroup")) {
                    record = new StandardizerData(19, item, groups);
                } else if (item.equals("aliastoatom")) {
                    record = new StandardizerData(20, item, groups);
                } else if (item.equals("removeatomvalues")) {
                    record = new StandardizerData(23, item, groups);
                } else if (item.equals("removeattacheddata")) {
                    record = new StandardizerData(24, item, groups);
                } else if (item.equals("removestereocarebox")) {
                    record = new StandardizerData(25, item, groups);
                } else if (item.startsWith("creategroup")) {
                    GroupList definitions = null;
                    definitions = new GroupList();
                    if (items[i].indexOf(":") >= 0) {
                        String groupList = items[i].substring(items[i].indexOf(":") + 1);
                        definitions.parseString(groupList);
                    } else {
                        definitions.setAll();
                    }
                    record = new StandardizerData(26, definitions);
                } else {
                    item = origItem;
                    Molecule mol = null;
                    try {
                        mol = ConfigTools.getQueryMolecule(item, "string", this.dir);
                    }
                    catch (IOException e) {
                        throw new StandardizerException("Could not read reaction: " + item, e);
                    }
                    RxnMolecule rxn = RxnMolecule.getReaction(mol);
                    if (rxn == null) {
                        throw new StandardizerException("reaction is not in rxn format");
                    }
                    Reaction reaction = new Reaction(item);
                    try {
                        reaction.setReaction(rxn, true);
                    }
                    catch (ReactionException e) {
                        throw new StandardizerException(e);
                    }
                    record = this.createReactionRecord(item, reaction, null, false, groups);
                }
            }
            if (record == null) continue;
            this.data.add(record);
        }
    }

    private static HashSet getGroups(String str) {
        StringTokenizer st;
        int count;
        HashSet<String> groups = null;
        if (str != null && (count = (st = new StringTokenizer(str, ", \t")).countTokens()) > 0) {
            groups = new HashSet<String>(count);
            while (st.hasMoreTokens()) {
                groups.add(st.nextToken().toLowerCase());
            }
        }
        return groups;
    }

    private Molecule[] readCleanTemplatesFromFile(String file) throws StandardizerException {
        Molecule[] templates = null;
        try {
            templates = ConfigTools.getQueryMolecules(file, "path", this.dir);
        }
        catch (IOException e) {
            throw new StandardizerException("Could not read template file", e);
        }
        return templates;
    }

    private Molecule[] readCleanTemplatesFromString(String mols) throws StandardizerException {
        Molecule[] templates = null;
        try {
            templates = ConfigTools.getQueryMolecules(mols, "string", null);
        }
        catch (IOException e) {
            throw new StandardizerException("Could not read templates", e);
        }
        return templates;
    }

    private StandardizerData createReactionRecord(String id, Reaction reaction, String searchOptions, boolean exact, HashSet groups) throws StandardizerException {
        ReactionPerformer performer = new ReactionPerformer(reaction);
        performer.setTransform(true);
        performer.setDuplicateFiltering(0);
        SearchAttributes sa = this.getReactionSearchAttributes();
        if (sa == null) {
            sa = new SearchAttributes();
        }
        sa.setSubgraphSearch(!exact);
        performer.setSearchAttributes(sa);
        performer.setSearchOptions(searchOptions);
        return new StandardizerData(0, id, performer, groups);
    }
}

