/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerConfiguration;
import chemaxon.reaction.StandardizerData;
import chemaxon.reaction.StandardizerException;
import java.util.ArrayList;

public class StandardizerUtil {
    public static int[] getTaskIndexes(Standardizer standardizer, String actionString) throws StandardizerException {
        StandardizerData[] tasks = standardizer.getTaskList();
        StandardizerData task = StandardizerUtil.convertActionStringToStandardzierData(actionString);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < tasks.length; ++i) {
            if (!tasks[i].equals(task)) continue;
            indexList.add(i);
        }
        int[] indexes = new int[indexList.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)indexList.get(i);
        }
        return indexes;
    }

    public static int getLastIndexOfTask(Standardizer standardizer, String actionString) throws StandardizerException {
        int[] indexes = StandardizerUtil.getTaskIndexes(standardizer, actionString);
        if (indexes != null && indexes.length > 0) {
            return indexes[indexes.length - 1];
        }
        return -1;
    }

    public static int getTaskCount(Standardizer standardizer) {
        return standardizer.getTaskList().length;
    }

    private static StandardizerData convertActionStringToStandardzierData(String actionString) throws StandardizerException {
        StandardizerConfiguration config = new StandardizerConfiguration();
        config.read(actionString);
        StandardizerData[] stdata = config.getData();
        if (stdata.length > 0) {
            return stdata[0];
        }
        throw new StandardizerException("Invalid standardizer action string: " + actionString);
    }
}

