/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction.tester;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.MolHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class ReactionMapper {
    public static final int UNMAPPED_LEAVE = 0;
    public static final int UNMAPPED_REMOVE = 1;
    public static final int UNMAPPED_AGENT = 2;
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = "Reactor " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Reaction mapper." + lineSep + "Usage:" + lineSep + "  automap [options] [input file(s)/string(s)]" + lineSep + lineSep + "Options: " + lineSep + "  -h, --help                           this help message" + lineSep + "  -a, --mapping-style <style>          reaction mapping style:" + lineSep + "                                       changing for ChemAxon style" + lineSep + "                                          (map all changing atoms)" + lineSep + "                                       matching for Daylight style" + lineSep + "                                          (map all matching atoms)" + lineSep + "                                       partial for partial mapping" + lineSep + "                                          (map at least stereo and query atoms)" + lineSep + "                                       (default: changing)" + lineSep + "  -u, --unmapped <leave|remove|agent>  transform unmapped components" + lineSep + "                                       (only if input reaction mol is mapped):" + lineSep + "                                       leave: leave and map" + lineSep + "                                              (see --mapping-style)" + lineSep + "                                       remove: remove of unmapped components" + lineSep + "                                       agent: set unmapped components as agents" + lineSep + "                                       (default: leave)" + lineSep + "  -S, --standardize <file/string>      standardize input reactions" + lineSep + "                                       reaction according to configuration" + lineSep + "  -f, --format <format>                output file format (default: smiles)" + lineSep + "  -o, --output <filepath>              output file (default: standard output)" + lineSep + lineSep + "Examples:" + lineSep + "  automap -a partial reactions.smiles" + lineSep + "  automap -a matching -u agent -f rdf reactions.rdf" + lineSep;
    private int automap = 0;
    private int unmappedTransformType = 0;
    private Standardizer standardizer = null;
    private AutoMapper autoMapper = null;
    private AutoMapper completeMapper = new AutoMapper();

    public void setMappingStyle(int style) {
        this.automap = style;
        if (style != 0) {
            this.autoMapper = new AutoMapper();
            if (style == 1) {
                this.autoMapper.setMappingMode(1);
            } else if (style == 2) {
                this.autoMapper.setMappingMode(2);
            }
        }
    }

    public void setUnmappedTransformType(int type) {
        this.unmappedTransformType = type;
    }

    public void setStandardizer(Standardizer standardizer) {
        this.standardizer = standardizer;
    }

    public void map(RxnMolecule rxn) throws ReactionException {
        if (this.standardizer != null) {
            try {
                this.standardizer.standardize(rxn);
            }
            catch (SearchException e) {
                throw new ReactionException("Error during standardization.", e);
            }
        }
        if (ReactionUtil.isUnmapped(rxn)) {
            try {
                this.completeMapper.map(rxn);
            }
            catch (AutoMapperException e) {
                throw new ReactionException(e);
            }
        }
        this.transformUnmappedStructures(rxn, 0);
        this.transformUnmappedStructures(rxn, 1);
        if (this.automap != 0) {
            try {
                this.autoMapper.map(rxn);
            }
            catch (AutoMapperException e) {
                throw new ReactionException(e);
            }
        }
    }

    private void transformUnmappedStructures(RxnMolecule rxn, int type) {
        if (this.unmappedTransformType == 0) {
            return;
        }
        for (int i = rxn.getComponentCount(type) - 1; i >= 0; --i) {
            Molecule structure = rxn.getComponent(type, i);
            if (!ReactionUtil.isUnmapped(structure)) continue;
            rxn.removeComponent(type, i);
            if (this.unmappedTransformType != 2) continue;
            rxn.addComponent(structure, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean cleanNeeded;
        CLQ.Parameter pFormat;
        CLQ.Parameter pStandardize;
        CLQ.Parameter pUnmapped;
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return;
        }
        CLQ.Parameter pMappingStyle = clq.lookup("-a", "--mapping-style", "", 2, false, false);
        String sMappingStyle = pMappingStyle != null ? pMappingStyle.getString() : null;
        int automap = 0;
        if (sMappingStyle != null) {
            if (sMappingStyle.equalsIgnoreCase("changing")) {
                automap = 0;
            } else if (sMappingStyle.equalsIgnoreCase("matching")) {
                automap = 1;
            } else if (sMappingStyle.equalsIgnoreCase("partial")) {
                automap = 2;
            } else {
                System.out.println("Invalid mapping style: " + sMappingStyle + " - should be 'changing', 'matching' or 'partial'.");
                return;
            }
        }
        String sUnmapped = (pUnmapped = clq.lookup("-u", "--unmapped", "", 2, false, false)) != null ? pUnmapped.getString() : null;
        int transform = 0;
        if (sUnmapped != null) {
            if (sUnmapped.equalsIgnoreCase("leave")) {
                transform = 0;
            } else if (sUnmapped.equalsIgnoreCase("remove")) {
                transform = 1;
            } else if (sUnmapped.equalsIgnoreCase("agent")) {
                transform = 2;
            } else {
                System.out.println("Invalid unmapped transform value: " + sUnmapped + " - should be 'leave', 'remove' or 'agent'.");
                return;
            }
        }
        String stconfig = (pStandardize = clq.lookup("-S", "--standardize", "", 2, false, false)) == null ? null : pStandardize.getString();
        Standardizer standardizer = null;
        if (stconfig != null) {
            File file = new File(stconfig);
            standardizer = file.exists() ? new Standardizer(file) : new Standardizer(stconfig);
        }
        String format2 = (pFormat = clq.lookup("-f", "--format", "", 2, false, false)) == null ? "smiles" : pFormat.getString();
        boolean bl = cleanNeeded = !MolHandler.isDaylightFormat(format2);
        if (cleanNeeded && standardizer != null) {
            standardizer.setFinalClean();
        }
        ReactionMapper mapper = new ReactionMapper();
        mapper.setMappingStyle(automap);
        mapper.setUnmappedTransformType(transform);
        mapper.setStandardizer(standardizer);
        CLQ.Parameter pOutput = clq.lookup("-o", "--output", "", 2, false, false);
        PrintStream out = pOutput == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(pOutput.getString())));
        MolImporter[] in = ConfigTools.getTargetMolImporters(clq);
        MolExporter exporter = new MolExporter(out, format2);
        try {
            Molecule mol = null;
            for (int i = 0; i < in.length; ++i) {
                int k = 0;
                MolImporter importer = in[i];
                while ((mol = importer.read()) != null) {
                    ++k;
                    try {
                        RxnMolecule rxn = RxnMolecule.getReaction(mol);
                        if (rxn == null) {
                            throw new ReactionException("Not a reaction molecule.");
                        }
                        int agentCount = rxn.getAgentCount();
                        mapper.map(rxn);
                        if (cleanNeeded && agentCount < rxn.getAgentCount()) {
                            mol.clean(2, null);
                        }
                        exporter.write(mol);
                    }
                    catch (Exception e) {
                        System.err.println("Error at file " + (i + 1) + " molecule " + k + ": " + e);
                        e.printStackTrace();
                    }
                }
                importer.close();
            }
        }
        finally {
            exporter.close();
            if (out != System.out) {
                out.close();
            }
        }
    }
}

