/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.formula;

import chemaxon.sss.formula.FormulaDescriptor;
import chemaxon.sss.formula.FormulaMatchable;
import java.util.ArrayList;
import java.util.HashMap;

class FormulaComponent
extends FormulaMatchable {
    public float[] ratio = new float[2];
    public HashMap<Integer, int[]> atoms = new HashMap();
    public HashMap<int[], int[]> groups = new HashMap();
    public ArrayList<FormulaDescriptor> polymers = new ArrayList();
    int type;
    ArrayList<FormulaDescriptor> target;

    public void addAtom(int atNo, int[] limits) {
        if (!this.atoms.containsKey(atNo)) {
            this.atoms.put(atNo, limits);
        } else {
            int[] oldLimits = this.atoms.get(atNo);
            oldLimits[0] = oldLimits[0] + limits[0];
            oldLimits[1] = oldLimits[1] + limits[1];
        }
    }

    public boolean isAtoms() {
        return Float.isNaN(this.ratio[0]) && Float.isNaN(this.ratio[1]) && this.groups.size() == 0 && this.polymers.size() == 0;
    }

    public boolean isGroup() {
        return Float.isNaN(this.ratio[0]) && Float.isNaN(this.ratio[1]) && this.atoms.size() == 0 && this.polymers.size() == 0 && this.groups.size() == 1;
    }

    public boolean isValid() {
        return this.atoms.size() != 0 || this.groups.size() != 0 || this.polymers.size() != 0;
    }

    public boolean isExactMatch(FormulaComponent target) {
        if (!this.isRatioMatch(target)) {
            return false;
        }
        if (!this.isExactMatchAtoms(target)) {
            return false;
        }
        if (!this.isExactMatchGroups(target)) {
            return false;
        }
        return this.isExactMatchPolymers(target);
    }

    private boolean isRatioMatch(FormulaComponent target) {
        if (Float.isNaN(this.ratio[0]) && Float.isNaN(this.ratio[1])) {
            return true;
        }
        if (Float.isNaN(target.ratio[0]) && Float.isNaN(target.ratio[1])) {
            return false;
        }
        return Math.max(this.ratio[0], target.ratio[0]) <= Math.min(this.ratio[1], target.ratio[1]);
    }

    private boolean isExactMatchPolymers(FormulaComponent target) {
        this.queryCount = this.polymers.size();
        this.targetCount = target.polymers.size();
        if (this.queryCount != this.targetCount) {
            return false;
        }
        return this.isPolymerMatching(target.polymers, 1);
    }

    private boolean isExactMatchGroups(FormulaComponent target) {
        for (int[] group : this.groups.keySet()) {
            int[] qLimits = this.groups.get(group);
            int[] limits = new int[]{0, 0};
            for (int atNo : group) {
                int[] tLimits = target.atoms.get(atNo);
                if (tLimits == null) continue;
                limits[0] = limits[0] + tLimits[0];
                limits[1] = limits[1] + tLimits[1];
            }
            if (Math.max(qLimits[0], limits[0]) <= Math.min(qLimits[1], limits[1])) continue;
            return false;
        }
        return true;
    }

    private boolean isExactMatchAtoms(FormulaComponent target) {
        for (Integer atNo : this.atoms.keySet()) {
            int[] qLimits = this.atoms.get(atNo);
            int[] tLimits = target.atoms.get(atNo);
            if (!(qLimits[1] == 0 && tLimits != null ? tLimits[0] > 0 : (tLimits != null ? Math.max(qLimits[0], tLimits[0]) > Math.min(qLimits[1], tLimits[1]) : qLimits[0] > 0))) continue;
            return false;
        }
        for (Integer atNo : target.atoms.keySet()) {
            int[] tLimits = target.atoms.get(atNo);
            if (tLimits[0] <= 0 || this.atoms.containsKey(atNo)) continue;
            return false;
        }
        return true;
    }

    public boolean isExactSubformulaMatch(FormulaComponent target) {
        if (!this.isRatioMatch(target)) {
            return false;
        }
        if (!this.isExactSubFormulaMatchAtoms(target)) {
            return false;
        }
        if (!this.isExactMatchGroups(target)) {
            return false;
        }
        return this.isExactSubFormulaMatchPolymers(target);
    }

    private boolean isExactSubFormulaMatchPolymers(FormulaComponent target) {
        this.queryCount = this.polymers.size();
        this.targetCount = target.polymers.size();
        if (this.queryCount > this.targetCount) {
            return false;
        }
        return this.isPolymerMatching(target.polymers, 2);
    }

    private boolean isExactSubFormulaMatchAtoms(FormulaComponent target) {
        for (Integer atNo : this.atoms.keySet()) {
            int[] qLimits = this.atoms.get(atNo);
            int[] tLimits = target.atoms.get(atNo);
            if (!(qLimits[1] == 0 && tLimits != null ? tLimits[0] > 0 : (tLimits != null ? Math.max(qLimits[0], tLimits[0]) > Math.min(qLimits[1], tLimits[1]) : qLimits[0] > 0))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubformulaMatch(FormulaComponent target) {
        if (!this.isRatioMatch(target)) {
            return false;
        }
        if (!this.isSubFormulaMatchAtoms(target)) {
            return false;
        }
        if (!this.isSubFormulaMatchGroups(target)) {
            return false;
        }
        return this.isSubFormulaMatchPolymers(target);
    }

    private boolean isSubFormulaMatchPolymers(FormulaComponent target) {
        this.queryCount = this.polymers.size();
        this.targetCount = target.polymers.size();
        if (this.queryCount > this.targetCount) {
            return false;
        }
        return this.isPolymerMatching(target.polymers, 3);
    }

    private boolean isSubFormulaMatchGroups(FormulaComponent target) {
        for (int[] group : this.groups.keySet()) {
            int[] qLimits = this.groups.get(group);
            int limit = 0;
            for (int atNo : group) {
                int[] tLimits = target.atoms.get(atNo);
                if (tLimits == null) continue;
                limit += tLimits[1];
            }
            if ((qLimits[1] != 0 || limit <= 0) && qLimits[0] <= limit) continue;
            return false;
        }
        return true;
    }

    private boolean isSubFormulaMatchAtoms(FormulaComponent target) {
        int[] limits;
        boolean match = true;
        for (Integer atNo : this.atoms.keySet()) {
            if (atNo % 1000 == 0) continue;
            int[] qLimits = this.atoms.get(atNo);
            int[] tLimits = target.atoms.get(atNo);
            if (qLimits[1] == 0 && tLimits != null) {
                if (tLimits[0] <= 0) continue;
                match = false;
                continue;
            }
            if (tLimits != null) {
                if (qLimits[0] <= tLimits[1]) continue;
                match = false;
                continue;
            }
            if (qLimits[0] <= 0) continue;
            match = false;
        }
        HashMap<Integer, int[]> targetSummed = new HashMap<Integer, int[]>();
        for (Integer atNo : target.atoms.keySet()) {
            if (atNo % 1000 == 0) continue;
            int[] tLimit = target.atoms.get(atNo);
            if (!targetSummed.containsKey(atNo = Integer.valueOf(atNo / 1000 * 1000))) {
                targetSummed.put(atNo, new int[]{0, 0});
            }
            limits = (int[])targetSummed.get(atNo);
            limits[0] = limits[0] + tLimit[0];
            limits[1] = limits[1] + tLimit[1];
        }
        for (Integer atNo : this.atoms.keySet()) {
            int[] tLimit;
            if (atNo % 1000 != 0) continue;
            int[] qLimit = this.atoms.get(atNo);
            limits = new int[]{0, 0};
            if (target.atoms.containsKey(atNo)) {
                tLimit = target.atoms.get(atNo);
                limits[0] = limits[0] + tLimit[0];
                limits[1] = limits[1] + tLimit[1];
            }
            if (targetSummed.containsKey(atNo)) {
                tLimit = (int[])targetSummed.get(atNo);
                limits[0] = limits[0] + tLimit[0];
                limits[1] = limits[1] + tLimit[1];
            }
            if (qLimit[1] == 0 && limits[0] > 0) {
                match = false;
            }
            if (qLimit[0] <= limits[1]) continue;
            match = false;
        }
        if (!match) {
            FormulaDescriptor fdQuery = new FormulaDescriptor();
            FormulaComponent fcQuery = new FormulaComponent();
            fcQuery.ratio[1] = Float.NaN;
            fcQuery.ratio[0] = Float.NaN;
            fcQuery.atoms = this.atoms;
            fdQuery.addComponent(fcQuery);
            for (FormulaDescriptor fdTarget : target.polymers) {
                if (!fdQuery.isMatching(fdTarget, 3)) continue;
                return true;
            }
        }
        return match;
    }

    public boolean isPolymerMatching(ArrayList<FormulaDescriptor> target, int type) {
        int index;
        if (type == 0) {
            return true;
        }
        assert (target != null);
        this.target = target;
        this.type = type;
        this.queryPair = new int[this.queryCount];
        this.targetPair = new int[this.targetCount];
        this.isCalculated = new boolean[this.queryCount][];
        this.isMatching = new boolean[this.queryCount][];
        for (index = 0; index < this.queryCount; ++index) {
            this.queryPair[index] = -1;
            this.isCalculated[index] = new boolean[this.targetCount];
            this.isMatching[index] = new boolean[this.targetCount];
        }
        for (index = 0; index < this.targetCount; ++index) {
            this.targetPair[index] = -1;
        }
        int queryPaired = this.getQueriesPaired();
        return queryPaired == this.queryCount;
    }

    @Override
    protected void calculateMatch(int qIndex, int tIndex) {
        assert (!this.isCalculated[qIndex][tIndex]);
        this.isCalculated[qIndex][tIndex] = true;
        this.isMatching[qIndex][tIndex] = this.polymers.get(qIndex).isMatching(this.target.get(tIndex), this.type);
    }
}

