/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.formula;

import chemaxon.sss.formula.FormulaComponent;
import chemaxon.sss.formula.FormulaDescriptor;
import chemaxon.struc.PeriodicSystem;

class FormulaParser {
    private static final int BOUNDS = 2;
    private static final String PARSE_ERROR_MESSAGE = "Formula syntax error in %s at character %s!";
    private String formula;
    private char[] formulaChars;
    private int formulaIndex;
    private int formulaLength;

    FormulaParser() {
    }

    public FormulaDescriptor parseQuery(String formula) throws IllegalArgumentException {
        this.formula = formula;
        this.formulaChars = formula.toCharArray();
        this.formulaLength = this.formulaChars.length;
        this.formulaIndex = 0;
        return this.parseQueryFormula(0);
    }

    private FormulaDescriptor parseQueryFormula(int level) throws IllegalArgumentException {
        if (level > 1) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        FormulaDescriptor fd = new FormulaDescriptor();
        FormulaComponent fc = new FormulaComponent();
        boolean isGroup = false;
        int groupMemberCount = 0;
        fc.ratio = this.getRatio();
        while (this.formulaIndex < this.formulaLength) {
            int[] limits;
            if (this.formulaChars[this.formulaIndex] == '.') {
                if (!fc.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fd.addComponent(fc);
                fc = new FormulaComponent();
                ++this.formulaIndex;
                this.skipSpaces();
                fc.ratio = this.getRatio();
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == '(') {
                if (level != 0) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                ++this.formulaIndex;
                FormulaDescriptor subFd = this.parseQueryFormula(level + 1);
                if (this.formulaIndex >= this.formulaLength) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                if (subFd.getComponentCount() == 1 && !Character.isLetter(this.formulaChars[this.formulaIndex])) {
                    FormulaComponent subFc = subFd.getComponent(0);
                    limits = this.getLimits();
                    if (subFc.isAtoms()) {
                        for (Integer atNo : subFc.atoms.keySet()) {
                            int[] subLimits = subFc.atoms.get(atNo);
                            subLimits[0] = subLimits[0] * limits[0];
                            subLimits[1] = subLimits[1] * limits[1];
                            fc.addAtom(atNo, subLimits);
                        }
                        subFc.atoms = null;
                        subFc = null;
                        continue;
                    }
                    if (subFc.isGroup()) {
                        for (int[] group : subFc.groups.keySet()) {
                            fc.groups.put(group, limits);
                        }
                        subFc.groups = null;
                        subFc = null;
                        continue;
                    }
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                ++this.formulaIndex;
                if (!subFd.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                for (int compIndex = subFd.getComponentCount() - 1; compIndex >= 0; --compIndex) {
                    FormulaComponent subFc = subFd.getComponent(compIndex);
                    if (subFc.isAtoms()) continue;
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fc.polymers.add(subFd);
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == ')') {
                ++this.formulaIndex;
                this.skipSpaces();
                if (isGroup) {
                    int[] groupMembers = new int[fc.atoms.size()];
                    int index = 0;
                    for (Integer atNo : fc.atoms.keySet()) {
                        int[] limits2 = fc.atoms.get(atNo);
                        if (limits2[0] != 1 || limits2[1] != 1) {
                            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                        }
                        groupMembers[index++] = atNo;
                    }
                    limits = new int[]{1, 1};
                    fc.groups.put(groupMembers, limits);
                    fc.atoms.clear();
                    isGroup = false;
                }
                if (!fc.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fd.addComponent(fc);
                fc = null;
                return fd;
            }
            if (this.formulaChars[this.formulaIndex] == '[') {
                this.parseIsotope(fc);
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == '+' && level == 1) {
                if (!fc.isAtoms() && fc.atoms.size() != ++groupMemberCount) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                isGroup = true;
                ++this.formulaIndex;
                continue;
            }
            if (Character.isLetter(this.formulaChars[this.formulaIndex])) {
                this.parseAtom(fc);
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == ' ') {
                ++this.formulaIndex;
                continue;
            }
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        if (!fc.isValid()) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        fd.addComponent(fc);
        return fd;
    }

    private float[] getRatio() {
        float[] ratio = new float[]{Float.NaN, Float.NaN};
        boolean isInterval = false;
        this.skipSpaces();
        ratio[0] = this.getFloat();
        this.skipSpaces();
        if (this.formulaIndex < this.formulaLength && this.formulaChars[this.formulaIndex] == '-') {
            isInterval = true;
            ++this.formulaIndex;
            this.skipSpaces();
            ratio[1] = this.getFloat();
            if (Float.isNaN(ratio[0]) && Float.isNaN(ratio[1])) {
                throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
            }
            if (Float.isNaN(ratio[0])) {
                ratio[0] = Float.MIN_VALUE;
            } else if (Float.isNaN(ratio[1])) {
                ratio[1] = Float.MAX_VALUE;
            }
        } else {
            ratio[1] = ratio[0];
        }
        if (Float.isNaN(ratio[0]) && Float.isNaN(ratio[1]) && !isInterval && this.formulaChars[this.formulaIndex] == 'x') {
            ++this.formulaIndex;
            ratio[0] = Float.MIN_VALUE;
            ratio[1] = Float.MAX_VALUE;
        }
        return ratio;
    }

    private void skipSpaces() {
        while (this.formulaIndex < this.formulaLength && this.formulaChars[this.formulaIndex] == ' ') {
            ++this.formulaIndex;
        }
    }

    private void parseIsotope(FormulaComponent fc) {
        ++this.formulaIndex;
        int atNo = this.getIsotope();
        this.skipSpaces();
        int[] bounds = this.getLimits();
        fc.addAtom(atNo, bounds);
    }

    private void parseAtom(FormulaComponent fc) {
        int atNo = this.getElement();
        this.skipSpaces();
        int[] bounds = this.getLimits();
        fc.addAtom(atNo, bounds);
    }

    private int getIsotope() {
        StringBuffer sb = new StringBuffer();
        while (this.formulaIndex < this.formulaLength && Character.isDigit(this.formulaChars[this.formulaIndex])) {
            sb.append(this.formulaChars[this.formulaIndex++]);
        }
        int isotopeNumber = 0;
        try {
            isotopeNumber = Integer.parseInt(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        int atNo = this.getElement();
        if (atNo % 1000 != 0) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        if (this.formulaIndex < this.formulaLength && this.formulaChars[this.formulaIndex] == ']') {
            ++this.formulaIndex;
        } else {
            throw new IllegalArgumentException("Formula syntax error");
        }
        return atNo + isotopeNumber;
    }

    private int getElement() {
        StringBuffer sb = new StringBuffer();
        int atNo = 0;
        if (this.formulaIndex < this.formulaLength) {
            sb.append(this.formulaChars[this.formulaIndex++]);
            if (this.formulaIndex < this.formulaLength && Character.isLetter(this.formulaChars[this.formulaIndex]) && Character.isLowerCase(this.formulaChars[this.formulaIndex])) {
                sb.append(this.formulaChars[this.formulaIndex++]);
                if (sb.length() == 2 && PeriodicSystem.getAtomicNumber(sb.toString()) == -1) {
                    sb.deleteCharAt(1);
                    --this.formulaIndex;
                }
            }
        }
        String el = sb.toString();
        atNo = PeriodicSystem.getAtomicNumber(el);
        if ((atNo *= 1000) <= 0) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        if (el.equals("D")) {
            atNo += 2;
        } else if (el.equals("T")) {
            atNo += 3;
        }
        return atNo;
    }

    private int[] getLimits() {
        int[] limits = new int[2];
        boolean hasFirst = false;
        boolean hasSecond = false;
        boolean isInterval = false;
        StringBuffer sb = new StringBuffer();
        hasFirst = this.getInteger(sb);
        if (hasFirst) {
            try {
                limits[0] = Integer.parseInt(sb.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
            }
        }
        if (this.formulaIndex < this.formulaLength && this.formulaChars[this.formulaIndex] == '-') {
            ++this.formulaIndex;
            isInterval = true;
        }
        if (hasSecond = this.getInteger(sb = new StringBuffer())) {
            try {
                limits[1] = Integer.parseInt(sb.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
            }
        }
        if (!hasFirst && !hasSecond) {
            if (isInterval) {
                throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
            }
            limits[1] = 1;
            limits[0] = 1;
        } else if (!hasFirst) {
            limits[0] = 0;
        } else if (!hasSecond) {
            int n = limits[1] = isInterval ? Integer.MAX_VALUE : limits[0];
        }
        if (limits[0] > limits[1]) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        return limits;
    }

    private boolean getInteger(StringBuffer sb) {
        while (this.formulaIndex < this.formulaLength && Character.isDigit(this.formulaChars[this.formulaIndex])) {
            sb.append(this.formulaChars[this.formulaIndex++]);
        }
        return sb.length() > 0;
    }

    private float getFloat() {
        float first = 1.0f;
        float second = 1.0f;
        StringBuffer sb = new StringBuffer();
        boolean isInteger = this.getInteger(sb);
        if (!isInteger) {
            return Float.NaN;
        }
        first = Float.parseFloat(sb.toString());
        this.skipSpaces();
        if (this.formulaIndex < this.formulaLength && this.formulaChars[this.formulaIndex] == '/') {
            ++this.formulaIndex;
            this.skipSpaces();
            sb = new StringBuffer();
            isInteger = this.getInteger(sb);
            if (!isInteger) {
                throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
            }
            second = Float.parseFloat(sb.toString());
        }
        return first / second;
    }

    public FormulaDescriptor parseTarget(String formula) throws IllegalArgumentException {
        this.formula = formula;
        this.formulaChars = formula.toCharArray();
        this.formulaLength = this.formulaChars.length;
        this.formulaIndex = 0;
        return this.parseTargetFormula(0);
    }

    private FormulaDescriptor parseTargetFormula(int level) throws IllegalArgumentException {
        FormulaDescriptor fd = new FormulaDescriptor();
        FormulaComponent fc = new FormulaComponent();
        fc.ratio = this.getRatio();
        while (this.formulaIndex < this.formulaLength) {
            if (this.formulaChars[this.formulaIndex] == '.') {
                if (!fc.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fd.addComponent(fc);
                fc = new FormulaComponent();
                ++this.formulaIndex;
                fc.ratio = this.getRatio();
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == '(') {
                if (level != 0) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                ++this.formulaIndex;
                FormulaDescriptor subFd = this.parseQueryFormula(level + 1);
                if (this.formulaIndex >= this.formulaLength) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                if (subFd.getComponentCount() == 1 && !Character.isLetter(this.formulaChars[this.formulaIndex])) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                ++this.formulaIndex;
                if (!subFd.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                for (int compIndex = subFd.getComponentCount() - 1; compIndex >= 0; --compIndex) {
                    FormulaComponent subFc = subFd.getComponent(compIndex);
                    if (subFc.isAtoms()) continue;
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fc.polymers.add(subFd);
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == ')') {
                ++this.formulaIndex;
                this.skipSpaces();
                if (!fc.isValid()) {
                    throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
                }
                fd.addComponent(fc);
                fc = null;
                return fd;
            }
            if (this.formulaChars[this.formulaIndex] == '[') {
                this.parseIsotope(fc);
                continue;
            }
            if (Character.isLetter(this.formulaChars[this.formulaIndex])) {
                this.parseAtom(fc);
                continue;
            }
            if (this.formulaChars[this.formulaIndex] == ' ') {
                ++this.formulaIndex;
                continue;
            }
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        if (!fc.isValid()) {
            throw new IllegalArgumentException(String.format(PARSE_ERROR_MESSAGE, this.formula, this.formulaIndex));
        }
        fd.addComponent(fc);
        return fd;
    }
}

