/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.formula;

import chemaxon.sss.formula.FormulaDescriptor;
import chemaxon.sss.formula.FormulaParser;

public class FormulaSearch {
    private int type = 1;
    public static final int NONE = 0;
    public static final int EXACT = 1;
    public static final int EXACT_SUBFORMULA = 2;
    public static final int SUBFORMULA = 3;
    private String query;
    private boolean queryParsed;
    private FormulaDescriptor queryDescriptor;
    private String target;
    private boolean targetParsed;
    private FormulaDescriptor targetDescriptor;
    private FormulaParser parser = new FormulaParser();

    public void setSearchType(int value) {
        this.type = value;
    }

    public int getSearchType() {
        return this.type;
    }

    public void setQuery(String query) throws IllegalArgumentException {
        assert (query != null);
        if (!(this.type == 0 || this.queryParsed && this.query != null && this.query.equals(query))) {
            this.query = query;
            this.queryParsed = false;
            this.queryDescriptor = this.parser.parseQuery(query);
            this.queryParsed = true;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setTarget(String target) throws IllegalArgumentException {
        assert (target != null);
        if (!(this.type == 0 || this.targetParsed && this.target != null && this.target.equals(target))) {
            this.target = target;
            this.targetParsed = false;
            this.targetDescriptor = this.parser.parseTarget(target);
            this.targetParsed = true;
        }
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isMatching() {
        if (!this.queryParsed || !this.targetParsed) {
            return false;
        }
        return this.queryDescriptor.isMatching(this.targetDescriptor, this.type);
    }
}

