/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.sss.screen.ScreenMol;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Vector;

public class GenerFP {
    private static final String[] BITERTEK = new String[256];
    static final int[] BITSZAM;
    private static String usage;

    private static void checkBITSZAM() {
        boolean problem = false;
        for (int i = 0; i < 256; ++i) {
            int c2;
            byte b = (byte)i;
            int c1 = GenerFP.counter(b);
            if (c1 != (c2 = BITSZAM[b + 128])) {
                problem = true;
            }
            System.out.println(i + "  " + c1 + "  " + c2 + "  " + (problem ? "!!!!!!!!!" : ""));
        }
    }

    private static int counter(byte b) {
        boolean r = false;
        int c = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & 1) == 1) {
                ++c;
            }
            b = (byte)(b >>> 1);
        }
        return c;
    }

    private static String addSpc(String s, int maxChars) {
        int l = maxChars - s.length();
        String spc = "";
        for (int i = 0; i < l; ++i) {
            spc = spc + " ";
        }
        return spc + s;
    }

    public static void main(String[] args) {
        int fpLengthBytes = 64;
        int pathl = 5;
        int bitnu = 2;
        int format2 = 49;
        char sep = ',';
        int bsmax = 0;
        int bsmin = 999999999;
        double allsum = 0.0;
        int minmol = 0;
        int maxmol = 0;
        int[] at = new int[10];
        DecimalFormat percentForm = new DecimalFormat("#0.00");
        Vector nullv = new Vector();
        block11: for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            try {
                if (a.equals("-h")) {
                    System.out.println(usage);
                    return;
                }
                if (a.equals("-fl")) {
                    fpLengthBytes = new Integer(args[++i]);
                    continue;
                }
                if (a.equals("-pl")) {
                    pathl = new Integer(args[++i]);
                    continue;
                }
                if (a.equals("-bc")) {
                    bitnu = new Integer(args[++i]);
                    continue;
                }
                if (a.equals("-fb")) {
                    format2 = 98;
                    continue;
                }
                if (a.equals("-f1")) {
                    format2 = 49;
                    continue;
                }
                if (a.equals("-fd")) {
                    format2 = 100;
                    continue;
                }
                if (a.equals("-fh")) {
                    format2 = 104;
                    continue;
                }
                if (a.equals("-fi")) {
                    format2 = 105;
                    continue;
                }
                if (a.equals("-stat")) {
                    format2 = 116;
                    continue;
                }
                if (a.equals("-s")) {
                    switch (args[++i].charAt(0)) {
                        case 'n': {
                            sep = '0';
                            continue block11;
                        }
                        case 'c': {
                            sep = ',';
                            continue block11;
                        }
                        case 't': {
                            sep = '\t';
                            continue block11;
                        }
                        case 's': {
                            sep = ' ';
                            continue block11;
                        }
                        default: {
                            System.err.println("Missing character after -s");
                            System.err.println("Help: generfp -h");
                            return;
                        }
                    }
                }
                System.err.println("Error in option: " + a);
                System.err.println("Help: generfp -h");
                return;
            }
            catch (Exception e) {
                System.err.println("Error in option " + args[i - 1] + (i < args.length ? " " + args[i] : ""));
                System.err.println("Help: generfp -h");
                return;
            }
        }
        try {
            Molecule mol;
            int i;
            int[] occurence;
            MolImporter mi = new MolImporter(System.in);
            int n = 0;
            ScreenMol scr = new ScreenMol(fpLengthBytes);
            int fpLengthBits = scr.retPrim();
            int[] nArray = occurence = format2 == 116 ? new int[fpLengthBits] : null;
            if (occurence != null) {
                for (i = 0; i < occurence.length; ++i) {
                    occurence[i] = 0;
                }
            }
            while ((mol = mi.read()) != null) {
                int i2;
                int k;
                ++n;
                int[][][] r = mol.getAromaticAndAliphaticRings(2, false, true, 18, 1000);
                scr.setMol(mol);
                scr.setRings(r[1], r[0]);
                byte[] fp = scr.getFingerprint(pathl, bitnu);
                if (format2 == 98) {
                    System.out.write(fp);
                } else if (format2 == 49) {
                    for (k = 0; k < fp.length; ++k) {
                        for (int l = 0; l < 8; ++l) {
                            if (sep != '0' && (k > 0 || l > 0)) {
                                System.out.print(sep);
                            }
                            System.out.print(BITERTEK[fp[k] + 128].charAt(l));
                        }
                    }
                    System.out.println();
                } else if (format2 == 100) {
                    for (i2 = 0; i2 < fpLengthBytes; ++i2) {
                        if (sep != '0' && i2 > 0) {
                            System.out.print(sep);
                        }
                        System.out.print(fp[i2] < 0 ? fp[i2] + 256 : fp[i2]);
                    }
                    System.out.println();
                } else if (format2 == 105) {
                    int intNum = (int)Math.ceil((double)fpLengthBytes / 4.0);
                    for (int i3 = 0; i3 < intNum; ++i3) {
                        int rI = 0;
                        int b = 0;
                        for (int j = 0; j < 4; ++j) {
                            int m = 4 * i3 + j;
                            if (m >= fpLengthBytes) continue;
                            b = fp[m] < 0 ? fp[m] + 256 : fp[m];
                            rI |= (b <<= (3 - j) * 8);
                        }
                        if (sep != '0' && i3 > 0) {
                            System.out.print(sep);
                        }
                        System.out.print(rI);
                    }
                    System.out.println();
                } else if (format2 == 104) {
                    for (int i4 = 0; i4 < fpLengthBytes; ++i4) {
                        int h1 = (fp[i4] < 0 ? fp[i4] + 256 : fp[i4]) / 16;
                        int h2 = (fp[i4] < 0 ? fp[i4] + 256 : fp[i4]) % 16;
                        if (sep != '0' && i4 > 0) {
                            System.out.print(sep);
                        }
                        System.out.print(Character.forDigit(h1, 16));
                        if (sep != '0') {
                            System.out.print(sep);
                        }
                        System.out.print(Character.forDigit(h2, 16));
                    }
                    System.out.println();
                } else if (format2 == 116) {
                    double bsp;
                    int bs = 0;
                    for (k = 0; k < fpLengthBytes; ++k) {
                        bs += BITSZAM[fp[k] + 128];
                    }
                    allsum += (double)bs / (double)fpLengthBits;
                    if (bs >= bsmax) {
                        maxmol = n;
                        bsmax = bs;
                    }
                    if (bs <= bsmin) {
                        minmol = n;
                        bsmin = bs;
                    }
                    if ((bsp = (double)bs / (double)fpLengthBits * 100.0) >= 90.0) {
                        at[9] = at[9] + 1;
                    } else if (80.0 <= bsp && bsp < 90.0) {
                        at[8] = at[8] + 1;
                    } else if (70.0 <= bsp && bsp < 80.0) {
                        at[7] = at[7] + 1;
                    } else if (60.0 <= bsp && bsp < 70.0) {
                        at[6] = at[6] + 1;
                    } else if (50.0 <= bsp && bsp < 60.0) {
                        at[5] = at[5] + 1;
                    } else if (40.0 <= bsp && bsp < 50.0) {
                        at[4] = at[4] + 1;
                    } else if (30.0 <= bsp && bsp < 40.0) {
                        at[3] = at[3] + 1;
                    } else if (20.0 <= bsp && bsp < 30.0) {
                        at[2] = at[2] + 1;
                    } else if (10.0 <= bsp && bsp < 20.0) {
                        at[1] = at[1] + 1;
                    } else {
                        at[0] = at[0] + 1;
                    }
                    if (occurence != null) {
                        for (i2 = 0; i2 < occurence.length; ++i2) {
                            int j = i2 / 8;
                            byte b = fp[j];
                            int k2 = i2 % 8;
                            if ((b >>> 7 - k2 & 1) != 1) continue;
                            int n2 = i2;
                            occurence[n2] = occurence[n2] + 1;
                        }
                    }
                }
                if (n != 0) continue;
                System.err.println("No structures found");
            }
            if (format2 == 116) {
                System.out.println("Number of molecules = " + n);
                System.out.println("Number of bits set:\n    Average = " + percentForm.format(allsum / (double)n * 100.0) + "%\n" + "    Maximum = " + percentForm.format((double)bsmax / (double)fpLengthBits * 100.0) + "% (at molecule " + maxmol + ")\n" + "    Minimum = " + percentForm.format((double)bsmin / (double)fpLengthBits * 100.0) + "% (at molecule " + minmol + ")\n" + "Density function:");
                for (i = 0; i < 10; ++i) {
                    if (i == 0) {
                        System.out.println(" " + i * 10 + "%-" + (i * 10 + 10) + "%   " + GenerFP.addSpc(percentForm.format((float)at[i] * 100.0f / (float)n), 5) + "%");
                        continue;
                    }
                    if (i == 9) {
                        System.out.println(i * 10 + "%-" + (i * 10 + 10) + "%  " + GenerFP.addSpc(percentForm.format((float)at[i] * 100.0f / (float)n), 5) + "%");
                        continue;
                    }
                    System.out.println(i * 10 + "%-" + (i * 10 + 10) + "%   " + GenerFP.addSpc(percentForm.format((float)at[i] * 100.0f / (float)n), 5) + "%");
                }
                if (occurence != null) {
                    System.out.println("Occurences of bits:");
                    System.out.println(" bit    occ.   %");
                    int occ = 0;
                    for (int i5 = 0; i5 < occurence.length; ++i5) {
                        occ += occurence[i5];
                        String percent = GenerFP.addSpc(percentForm.format((float)occurence[i5] / (float)n * 100.0f), 5);
                        System.out.println(GenerFP.addSpc("" + (i5 + 1), 4) + " " + GenerFP.addSpc("" + occurence[i5], 7) + " " + percent);
                    }
                }
            }
        }
        catch (MolFormatException m) {
            System.err.println("Molecule file format error");
        }
        catch (IOException e) {
            System.err.println("Cannot read molfile");
        }
    }

    static {
        for (int s = -128; s < 128; ++s) {
            StringBuffer v = new StringBuffer(8);
            for (int k = 7; k > -1; --k) {
                v.append(s >> k & 1);
            }
            GenerFP.BITERTEK[s + 128] = v.toString();
        }
        BITSZAM = new int[256];
        GenerFP.BITSZAM[0] = 1;
        GenerFP.BITSZAM[1] = 2;
        GenerFP.BITSZAM[2] = 2;
        GenerFP.BITSZAM[3] = 3;
        GenerFP.BITSZAM[4] = 2;
        GenerFP.BITSZAM[5] = 3;
        GenerFP.BITSZAM[6] = 3;
        GenerFP.BITSZAM[7] = 4;
        GenerFP.BITSZAM[8] = 2;
        GenerFP.BITSZAM[9] = 3;
        GenerFP.BITSZAM[10] = 3;
        GenerFP.BITSZAM[11] = 4;
        GenerFP.BITSZAM[12] = 3;
        GenerFP.BITSZAM[13] = 4;
        GenerFP.BITSZAM[14] = 4;
        GenerFP.BITSZAM[15] = 5;
        GenerFP.BITSZAM[16] = 2;
        GenerFP.BITSZAM[17] = 3;
        GenerFP.BITSZAM[18] = 3;
        GenerFP.BITSZAM[19] = 4;
        GenerFP.BITSZAM[20] = 3;
        GenerFP.BITSZAM[21] = 4;
        GenerFP.BITSZAM[22] = 4;
        GenerFP.BITSZAM[23] = 5;
        GenerFP.BITSZAM[24] = 3;
        GenerFP.BITSZAM[25] = 4;
        GenerFP.BITSZAM[26] = 4;
        GenerFP.BITSZAM[27] = 5;
        GenerFP.BITSZAM[28] = 4;
        GenerFP.BITSZAM[29] = 5;
        GenerFP.BITSZAM[30] = 5;
        GenerFP.BITSZAM[31] = 6;
        GenerFP.BITSZAM[32] = 2;
        GenerFP.BITSZAM[33] = 3;
        GenerFP.BITSZAM[34] = 3;
        GenerFP.BITSZAM[35] = 4;
        GenerFP.BITSZAM[36] = 3;
        GenerFP.BITSZAM[37] = 4;
        GenerFP.BITSZAM[38] = 4;
        GenerFP.BITSZAM[39] = 5;
        GenerFP.BITSZAM[40] = 3;
        GenerFP.BITSZAM[41] = 4;
        GenerFP.BITSZAM[42] = 4;
        GenerFP.BITSZAM[43] = 5;
        GenerFP.BITSZAM[44] = 4;
        GenerFP.BITSZAM[45] = 5;
        GenerFP.BITSZAM[46] = 5;
        GenerFP.BITSZAM[47] = 6;
        GenerFP.BITSZAM[48] = 3;
        GenerFP.BITSZAM[49] = 4;
        GenerFP.BITSZAM[50] = 4;
        GenerFP.BITSZAM[51] = 5;
        GenerFP.BITSZAM[52] = 4;
        GenerFP.BITSZAM[53] = 5;
        GenerFP.BITSZAM[54] = 5;
        GenerFP.BITSZAM[55] = 6;
        GenerFP.BITSZAM[56] = 4;
        GenerFP.BITSZAM[57] = 5;
        GenerFP.BITSZAM[58] = 5;
        GenerFP.BITSZAM[59] = 6;
        GenerFP.BITSZAM[60] = 5;
        GenerFP.BITSZAM[61] = 6;
        GenerFP.BITSZAM[62] = 6;
        GenerFP.BITSZAM[63] = 7;
        GenerFP.BITSZAM[64] = 2;
        GenerFP.BITSZAM[65] = 3;
        GenerFP.BITSZAM[66] = 3;
        GenerFP.BITSZAM[67] = 4;
        GenerFP.BITSZAM[68] = 3;
        GenerFP.BITSZAM[69] = 4;
        GenerFP.BITSZAM[70] = 4;
        GenerFP.BITSZAM[71] = 5;
        GenerFP.BITSZAM[72] = 3;
        GenerFP.BITSZAM[73] = 4;
        GenerFP.BITSZAM[74] = 4;
        GenerFP.BITSZAM[75] = 5;
        GenerFP.BITSZAM[76] = 4;
        GenerFP.BITSZAM[77] = 5;
        GenerFP.BITSZAM[78] = 5;
        GenerFP.BITSZAM[79] = 6;
        GenerFP.BITSZAM[80] = 3;
        GenerFP.BITSZAM[81] = 4;
        GenerFP.BITSZAM[82] = 4;
        GenerFP.BITSZAM[83] = 5;
        GenerFP.BITSZAM[84] = 4;
        GenerFP.BITSZAM[85] = 5;
        GenerFP.BITSZAM[86] = 5;
        GenerFP.BITSZAM[87] = 6;
        GenerFP.BITSZAM[88] = 4;
        GenerFP.BITSZAM[89] = 5;
        GenerFP.BITSZAM[90] = 5;
        GenerFP.BITSZAM[91] = 6;
        GenerFP.BITSZAM[92] = 5;
        GenerFP.BITSZAM[93] = 6;
        GenerFP.BITSZAM[94] = 6;
        GenerFP.BITSZAM[95] = 7;
        GenerFP.BITSZAM[96] = 3;
        GenerFP.BITSZAM[97] = 4;
        GenerFP.BITSZAM[98] = 4;
        GenerFP.BITSZAM[99] = 5;
        GenerFP.BITSZAM[100] = 4;
        GenerFP.BITSZAM[101] = 5;
        GenerFP.BITSZAM[102] = 5;
        GenerFP.BITSZAM[103] = 6;
        GenerFP.BITSZAM[104] = 4;
        GenerFP.BITSZAM[105] = 5;
        GenerFP.BITSZAM[106] = 5;
        GenerFP.BITSZAM[107] = 6;
        GenerFP.BITSZAM[108] = 5;
        GenerFP.BITSZAM[109] = 6;
        GenerFP.BITSZAM[110] = 6;
        GenerFP.BITSZAM[111] = 7;
        GenerFP.BITSZAM[112] = 4;
        GenerFP.BITSZAM[113] = 5;
        GenerFP.BITSZAM[114] = 5;
        GenerFP.BITSZAM[115] = 6;
        GenerFP.BITSZAM[116] = 5;
        GenerFP.BITSZAM[117] = 6;
        GenerFP.BITSZAM[118] = 6;
        GenerFP.BITSZAM[119] = 7;
        GenerFP.BITSZAM[120] = 5;
        GenerFP.BITSZAM[121] = 6;
        GenerFP.BITSZAM[122] = 6;
        GenerFP.BITSZAM[123] = 7;
        GenerFP.BITSZAM[124] = 6;
        GenerFP.BITSZAM[125] = 7;
        GenerFP.BITSZAM[126] = 7;
        GenerFP.BITSZAM[127] = 8;
        GenerFP.BITSZAM[128] = 0;
        GenerFP.BITSZAM[129] = 1;
        GenerFP.BITSZAM[130] = 1;
        GenerFP.BITSZAM[131] = 2;
        GenerFP.BITSZAM[132] = 1;
        GenerFP.BITSZAM[133] = 2;
        GenerFP.BITSZAM[134] = 2;
        GenerFP.BITSZAM[135] = 3;
        GenerFP.BITSZAM[136] = 1;
        GenerFP.BITSZAM[137] = 2;
        GenerFP.BITSZAM[138] = 2;
        GenerFP.BITSZAM[139] = 3;
        GenerFP.BITSZAM[140] = 2;
        GenerFP.BITSZAM[141] = 3;
        GenerFP.BITSZAM[142] = 3;
        GenerFP.BITSZAM[143] = 4;
        GenerFP.BITSZAM[144] = 1;
        GenerFP.BITSZAM[145] = 2;
        GenerFP.BITSZAM[146] = 2;
        GenerFP.BITSZAM[147] = 3;
        GenerFP.BITSZAM[148] = 2;
        GenerFP.BITSZAM[149] = 3;
        GenerFP.BITSZAM[150] = 3;
        GenerFP.BITSZAM[151] = 4;
        GenerFP.BITSZAM[152] = 2;
        GenerFP.BITSZAM[153] = 3;
        GenerFP.BITSZAM[154] = 3;
        GenerFP.BITSZAM[155] = 4;
        GenerFP.BITSZAM[156] = 3;
        GenerFP.BITSZAM[157] = 4;
        GenerFP.BITSZAM[158] = 4;
        GenerFP.BITSZAM[159] = 5;
        GenerFP.BITSZAM[160] = 1;
        GenerFP.BITSZAM[161] = 2;
        GenerFP.BITSZAM[162] = 2;
        GenerFP.BITSZAM[163] = 3;
        GenerFP.BITSZAM[164] = 2;
        GenerFP.BITSZAM[165] = 3;
        GenerFP.BITSZAM[166] = 3;
        GenerFP.BITSZAM[167] = 4;
        GenerFP.BITSZAM[168] = 2;
        GenerFP.BITSZAM[169] = 3;
        GenerFP.BITSZAM[170] = 3;
        GenerFP.BITSZAM[171] = 4;
        GenerFP.BITSZAM[172] = 3;
        GenerFP.BITSZAM[173] = 4;
        GenerFP.BITSZAM[174] = 4;
        GenerFP.BITSZAM[175] = 5;
        GenerFP.BITSZAM[176] = 2;
        GenerFP.BITSZAM[177] = 3;
        GenerFP.BITSZAM[178] = 3;
        GenerFP.BITSZAM[179] = 4;
        GenerFP.BITSZAM[180] = 3;
        GenerFP.BITSZAM[181] = 4;
        GenerFP.BITSZAM[182] = 4;
        GenerFP.BITSZAM[183] = 5;
        GenerFP.BITSZAM[184] = 3;
        GenerFP.BITSZAM[185] = 4;
        GenerFP.BITSZAM[186] = 4;
        GenerFP.BITSZAM[187] = 5;
        GenerFP.BITSZAM[188] = 4;
        GenerFP.BITSZAM[189] = 5;
        GenerFP.BITSZAM[190] = 5;
        GenerFP.BITSZAM[191] = 6;
        GenerFP.BITSZAM[192] = 1;
        GenerFP.BITSZAM[193] = 2;
        GenerFP.BITSZAM[194] = 2;
        GenerFP.BITSZAM[195] = 3;
        GenerFP.BITSZAM[196] = 2;
        GenerFP.BITSZAM[197] = 3;
        GenerFP.BITSZAM[198] = 3;
        GenerFP.BITSZAM[199] = 4;
        GenerFP.BITSZAM[200] = 2;
        GenerFP.BITSZAM[201] = 3;
        GenerFP.BITSZAM[202] = 3;
        GenerFP.BITSZAM[203] = 4;
        GenerFP.BITSZAM[204] = 3;
        GenerFP.BITSZAM[205] = 4;
        GenerFP.BITSZAM[206] = 4;
        GenerFP.BITSZAM[207] = 5;
        GenerFP.BITSZAM[208] = 2;
        GenerFP.BITSZAM[209] = 3;
        GenerFP.BITSZAM[210] = 3;
        GenerFP.BITSZAM[211] = 4;
        GenerFP.BITSZAM[212] = 3;
        GenerFP.BITSZAM[213] = 4;
        GenerFP.BITSZAM[214] = 4;
        GenerFP.BITSZAM[215] = 5;
        GenerFP.BITSZAM[216] = 3;
        GenerFP.BITSZAM[217] = 4;
        GenerFP.BITSZAM[218] = 4;
        GenerFP.BITSZAM[219] = 5;
        GenerFP.BITSZAM[220] = 4;
        GenerFP.BITSZAM[221] = 5;
        GenerFP.BITSZAM[222] = 5;
        GenerFP.BITSZAM[223] = 6;
        GenerFP.BITSZAM[224] = 2;
        GenerFP.BITSZAM[225] = 3;
        GenerFP.BITSZAM[226] = 3;
        GenerFP.BITSZAM[227] = 4;
        GenerFP.BITSZAM[228] = 3;
        GenerFP.BITSZAM[229] = 4;
        GenerFP.BITSZAM[230] = 4;
        GenerFP.BITSZAM[231] = 5;
        GenerFP.BITSZAM[232] = 3;
        GenerFP.BITSZAM[233] = 4;
        GenerFP.BITSZAM[234] = 4;
        GenerFP.BITSZAM[235] = 5;
        GenerFP.BITSZAM[236] = 4;
        GenerFP.BITSZAM[237] = 5;
        GenerFP.BITSZAM[238] = 5;
        GenerFP.BITSZAM[239] = 6;
        GenerFP.BITSZAM[240] = 3;
        GenerFP.BITSZAM[241] = 4;
        GenerFP.BITSZAM[242] = 4;
        GenerFP.BITSZAM[243] = 5;
        GenerFP.BITSZAM[244] = 4;
        GenerFP.BITSZAM[245] = 5;
        GenerFP.BITSZAM[246] = 5;
        GenerFP.BITSZAM[247] = 6;
        GenerFP.BITSZAM[248] = 4;
        GenerFP.BITSZAM[249] = 5;
        GenerFP.BITSZAM[250] = 5;
        GenerFP.BITSZAM[251] = 6;
        GenerFP.BITSZAM[252] = 5;
        GenerFP.BITSZAM[253] = 6;
        GenerFP.BITSZAM[254] = 6;
        GenerFP.BITSZAM[255] = 7;
        usage = "GenerFP Chemical Hashed Fingerprint Generator " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd.\n" + "Usage: generfp [options] <inputfile >outputfile\n" + "Options:\n" + "  -h               display this help and exit\n" + "  -fl <length>     fingerprintlength length in bytes (default: 64)\n" + "  -pl <length>     maximum number of bonds in patterns (default: 5)\n" + "  -bc <bitcount>   number of bits to switch on for each pattern \n" + "                   in the structure (default:2)\n" + "  -f<format>       format of the output\n" + "     -fb              binary \n" + "     -f1              ones and zeros  (001011011...) (default)\n" + "     -fd              bytes in decimal format\n" + "     -fh              bytes in hexadecimal format\n" + "     -fi              integers in decimal format\n" + "  -stat            generate statistics\n" + "  -s <separator>   separator between numbers in case of text output\n" + "      Separators:     'n'o separator\n" + "                      'c'omma (default)\n" + "                      't'ab\n" + "                      's'pace\n";
    }
}

