/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.util.MulticenterTransform;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.StringTokenizer;

public final class HashCode {
    public static final int DEFAULT_RECURSION_LEVEL = 4;
    private static final int prime = 7919;
    private int recursionLevel = 0;
    private int atomCount = 0;
    private int[] atomTypes = null;
    private int[] bondTypes = null;
    private BondTable btab = null;
    private int[][] ctab = null;
    private int[] steps = new int[100];
    private int stepCount = 1;

    public int getHashCode(Molecule mol) {
        return this.getHashCode(mol, 4);
    }

    public int getHashCode(Molecule mol, int recursion) {
        this.initialize(mol);
        int code = 0;
        if (recursion < 1) {
            return code;
        }
        code *= 7919;
        this.recursionLevel = recursion;
        for (int x = 0; x < this.atomCount; ++x) {
            this.steps[0] = x;
            this.stepCount = 1;
            if (this.atomTypes[x] == 1) continue;
            code += 101 * this.calcGraphHash(x);
        }
        return code;
    }

    public int getHashCode(Molecule mol, int[] fp) {
        return this.getHashCode(mol, fp, 4);
    }

    public int getHashCode(Molecule mol, int[] fp, int recursion) {
        int code = this.getHashCode(mol, recursion);
        for (int x = 0; x < fp.length; ++x) {
            code += fp[x];
            code *= 7919;
        }
        return code;
    }

    private int calcGraphHash(int atomIndex) {
        int depth = this.stepCount;
        int graphHash = 0;
        graphHash += this.atomTypes[atomIndex];
        if (depth > this.recursionLevel) {
            return graphHash;
        }
        int[] neighbours = this.ctab[atomIndex];
        int neighbourCount = neighbours.length;
        this.steps[this.stepCount++] = atomIndex;
        for (int x = 0; x < neighbourCount; ++x) {
            int neighbour = neighbours[x];
            int bond = this.btab.getBondIndex(atomIndex, neighbour);
            if (this.atomTypes[neighbour] == 1) continue;
            graphHash += 7 * this.bondTypes[bond];
            if (this.contains(neighbour)) continue;
            graphHash += 23 * this.calcGraphHash(neighbour);
        }
        --this.stepCount;
        return graphHash * depth * this.atomTypes[this.steps[0]];
    }

    private boolean contains(int atomIndex) {
        for (int x = 0; x < this.stepCount; ++x) {
            if (this.steps[x] != atomIndex) continue;
            return true;
        }
        return false;
    }

    private void initialize(Molecule mol) {
        boolean isGuiContracted = mol.isGUIContracted();
        if (isGuiContracted) {
            mol.setGUIContracted(false);
        }
        MulticenterTransform mct = new MulticenterTransform();
        mct.transformMulticenters(mol);
        MoleculeGraph union = mol.getGraphUnion();
        this.atomCount = union.getAtomCount();
        this.atomTypes = new int[this.atomCount];
        for (int x = 0; x < this.atomCount; ++x) {
            this.atomTypes[x] = union.getAtom(x).getAtno();
        }
        int bondCount = union.getBondCount();
        this.bondTypes = new int[bondCount];
        for (int x = 0; x < bondCount; ++x) {
            this.bondTypes[x] = union.getBond(x).getType();
        }
        this.btab = union.getBondTable();
        this.ctab = union.getCtab();
        this.processTautomerRegions(mol, union);
        mct.restoreMulticenters(mol);
        if (isGuiContracted) {
            mol.setGUIContracted(isGuiContracted);
        }
    }

    private void processTautomerRegions(Molecule mol, MoleculeGraph union) {
        int sgroups = mol.getSgroupCount();
        for (int x = 0; x < sgroups; ++x) {
            DataSgroup dataGroup;
            String fieldName;
            Sgroup sg = mol.getSgroup(x);
            if (!(sg instanceof DataSgroup) || (fieldName = (dataGroup = (DataSgroup)sg).getFieldName()) == null || !fieldName.equals("BEC")) continue;
            String data = dataGroup.getData();
            StringTokenizer st = new StringTokenizer(data, "e");
            data = st.nextToken();
            int electrons = Integer.parseInt(data);
            MolAtom[] atoms = dataGroup.getAtomArray();
            for (int y = 0; y < atoms.length; ++y) {
                int index = union.indexOf(atoms[y]);
                this.atomTypes[index] = this.atomTypes[index] + 1493 * electrons;
            }
        }
    }
}

