/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.core.calculations.FindAllRings;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphFindAllRings;
import chemaxon.enumeration.supergraph.SupergraphPathFilter;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.marvin.modules.smarts.SmartsAtomTreeParser;
import chemaxon.marvin.util.MulticenterTransform;
import chemaxon.sss.screen.PathFilter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.MolHandler;
import java.io.StringReader;
import java.util.Arrays;
import java.util.BitSet;

public final class ScreenMol {
    public static final int MAX_RING_SIZE_FOR_FP = 14;
    private static final int AROM_ORIG = 0;
    private static final int AROM_ANY = 1;
    private static final int AROM_SAME = 2;
    private static final int AROM_IMPLIES_AROM = 3;
    private static final int NONAROM_IMPLIES_NONAROM = 4;
    private MoleculeGraph mol;
    MoleculeGraph graph;
    MulticenterTransform pspw = new MulticenterTransform();
    boolean partialFP = false;
    BitSet atomSet = null;
    byte[] fingerprint;
    public static final int MAX_CHAIN_LENGTH = 100;
    boolean ignoreH = true;
    private int prim;
    private int[][] nonaromrings;
    private int[][] aromrings;
    private PathFilter filter = null;
    private boolean debug = false;
    private boolean debugFP = false;
    private static final int ELEMENT_COUNT = 109;
    private static final int[] FACTOR;
    private static final int BOND_TYPES = 15;
    private static final int[] BONDFACTOR;
    private static final int[] POS;
    private static final int[] RND1;
    private static final int[] RND;
    boolean calculateRings = true;
    private static final int BRANCH_THREE = 653;
    private static final int BRANCH_FOUR = 659;
    private static final int AROMRING = 661;
    private static final int NONAROMRING = 673;
    private static final int CLOSED_CONNECTION = 677;
    private MolBond[] usedb = new MolBond[100];
    private MolAtom[] usedn = new MolAtom[100];
    private int usedb_count = 0;
    private int usedn_count = 0;

    public ScreenMol(MoleculeGraph m, int numberOfBytes, int[][] nr, int[][] ar) {
        this(numberOfBytes);
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        this.prim = ScreenMol.findPrim(numberOfBytes);
        this.nonaromrings = nr;
        this.aromrings = ar;
        if (m instanceof Supergraph) {
            this.setPathFilter(new SupergraphPathFilter((Supergraph)m));
        }
    }

    public ScreenMol(MoleculeGraph m, int numberOfBytes) {
        this(numberOfBytes);
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        this.prim = ScreenMol.findPrim(numberOfBytes);
        if (m instanceof Supergraph) {
            this.setPathFilter(new SupergraphPathFilter((Supergraph)m));
        }
    }

    public ScreenMol(MoleculeGraph m, int numberOfBytes, int[] aidxs) {
        this(numberOfBytes);
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        if (aidxs != null) {
            int ac = this.graph.getAtomCount();
            this.atomSet = new BitSet(ac);
            for (int i = 0; i < aidxs.length; ++i) {
                int idx = aidxs[i];
                if (idx < 0 || idx >= ac) continue;
                this.atomSet.set(idx);
                this.partialFP = true;
            }
        }
        this.prim = ScreenMol.findPrim(numberOfBytes);
        if (m instanceof Supergraph) {
            this.setPathFilter(new SupergraphPathFilter((Supergraph)m));
        }
    }

    public ScreenMol(MoleculeGraph m, int numberOfBytes, boolean ignH) {
        this(numberOfBytes);
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        this.prim = ScreenMol.findPrim(numberOfBytes);
        this.ignoreH = ignH;
        if (m instanceof Supergraph) {
            this.setPathFilter(new SupergraphPathFilter((Supergraph)m));
        }
    }

    public ScreenMol(MoleculeGraph m) {
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        this.prim = 1021;
        if (m instanceof Supergraph) {
            this.setPathFilter(new SupergraphPathFilter((Supergraph)m));
        }
    }

    public ScreenMol() {
        this(1024);
        this.prim = 1021;
    }

    public ScreenMol(int numberOfBytes) {
        this.fingerprint = new byte[numberOfBytes];
        this.prim = ScreenMol.findPrim(numberOfBytes);
        this.partialFP = false;
    }

    public ScreenMol(int numberOfBytes, boolean ignH) {
        this.fingerprint = new byte[numberOfBytes];
        this.ignoreH = ignH;
        this.prim = ScreenMol.findPrim(numberOfBytes);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public byte[] getFingerprint(int numberOfEdges, int numberOfOnes) {
        this.addPathInfo(numberOfEdges, numberOfOnes);
        this.addRecursiveFp(this.graph, this.fingerprint, numberOfOnes, numberOfEdges);
        if (this.calculateRings) {
            this.ringcalculation();
        }
        return this.fingerprint;
    }

    public byte[][] getFingerprints(int numberOfEdges, int numberOfOnes) {
        this.addPathInfo(numberOfEdges, numberOfOnes);
        this.addRecursiveFp(this.graph, this.fingerprint, numberOfOnes, numberOfEdges);
        byte[] ringlessFP = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, ringlessFP, 0, this.fingerprint.length);
        if (this.calculateRings) {
            this.ringcalculation();
        }
        byte[][] result = new byte[][]{ringlessFP, this.fingerprint};
        return result;
    }

    private void addPathInfo(int numberOfEdges, int numberOfOnes) {
        int count = this.graph.getAtomCount();
        for (int i = 0; i < count; ++i) {
            this.usedn_count = 0;
            this.usedb_count = 0;
            this.gWalk(this.graph.getAtom(i), numberOfEdges, numberOfOnes, 1L, 0L);
        }
    }

    private final void addRecursiveFp(MoleculeGraph cg, byte[] fp, int numberOfOnes, int numberOfEdges) {
        if (!(cg instanceof Molecule)) {
            return;
        }
        Molecule cgMol = (Molecule)cg;
        for (int i = 0; i < cgMol.getAtomCount(); ++i) {
            SimpleNode node;
            String querystr = cgMol.getAtom(i).getQuerystr();
            if (querystr == null) continue;
            StringReader sr = new StringReader(querystr);
            SmartsAtomTreeParser parser = new SmartsAtomTreeParser(sr);
            try {
                node = parser.parseSmartsAtomExpression();
            }
            catch (ParseException e) {
                node = null;
            }
            if (node == null) continue;
            this.addRecursiveFpFromExpression(node, fp, numberOfOnes, numberOfEdges);
        }
    }

    private final void addRecursiveFpFromExpression(SimpleNode node, byte[] fp, int numberOfOnes, int numberOfEdges) {
        switch (node.getId()) {
            case 8: {
                try {
                    MolHandler mh = new MolHandler(node.getValue(), true);
                    byte[] recFp = mh.generateFingerprintInBytes(fp.length / 4, numberOfOnes, numberOfEdges);
                    BinaryDataUtil.or(fp, recFp);
                }
                catch (MolFormatException e) {}
                break;
            }
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    this.addRecursiveFpFromExpression((SimpleNode)node.jjtGetChild(i), fp, numberOfOnes, numberOfEdges);
                }
                break;
            }
            case 2: {
                this.addRecursiveFpFromOrExpr(node, fp, numberOfOnes, numberOfEdges);
                break;
            }
        }
    }

    private void addRecursiveFpFromOrExpr(SimpleNode node, byte[] fp, int numberOfOnes, int numberOfEdges) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            if (child.getId() == 8) continue;
            return;
        }
        byte[] childFp = new byte[fp.length];
        Arrays.fill(childFp, (byte)-1);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            try {
                MolHandler mh = new MolHandler(child.getValue(), true);
                byte[] recFp = mh.generateFingerprintInBytes(fp.length / 4, numberOfOnes, numberOfEdges);
                BinaryDataUtil.and(childFp, recFp);
                continue;
            }
            catch (MolFormatException e) {
                // empty catch block
            }
        }
        BinaryDataUtil.or(fp, childFp);
    }

    private final void gWalk(MolAtom node, int edgeno, int numberOfOnes, long summa1, long summa2) {
        MolAtom nextnode = null;
        this.usedn[this.usedn_count++] = node;
        if (this.debug) {
            int i;
            System.err.println();
            for (i = 0; i < this.usedn_count; ++i) {
                System.err.print(this.usedn[i].getParent().indexOf(this.usedn[i]) + 1 + " ");
            }
            System.err.println();
            for (i = 0; i < this.usedb_count; ++i) {
                System.err.print(this.usedb[i].getType() + " ");
            }
            System.err.println();
        }
        if (ScreenMol.useNode(node, this.usedb_count > 0 ? this.usedb[this.usedb_count - 1] : null, this.ignoreH) && !ScreenMol.recurrency(this.usedn, this.usedn_count)) {
            boolean setbit;
            boolean bl = setbit = !this.partialFP || this.atomSet.get(this.graph.indexOf(node));
            if (setbit) {
                summa1 = ScreenMol.calcSumm1(this.usedn, this.usedn_count, this.usedb, this.usedb_count, this.debugFP);
                ScreenMol.setBit(summa1, this.fingerprint, this.prim);
            }
            if (setbit && numberOfOnes > 1 && edgeno > 1) {
                ScreenMol.calcBranchingType1(summa1, this.usedn, this.usedn_count, this.usedb, this.usedb_count, this.fingerprint, this.prim, this.ignoreH, this.debugFP);
            }
            if (setbit && numberOfOnes > 2) {
                summa2 = this.calcSumm2(summa2);
                ScreenMol.setBit(summa2, this.fingerprint, this.prim);
            }
            if (setbit && numberOfOnes > 3) {
                this.generateMoreBit(numberOfOnes - 2, summa1, summa2);
            }
            if (edgeno > 0) {
                int count = node.getBondCount();
                block9: for (int i = 0; i < count; ++i) {
                    MolBond bond = node.getBond(i);
                    if (this.contains(bond)) continue;
                    nextnode = bond.getOtherAtom(node);
                    if (this.filter != null && !this.filter.isCompatible(nextnode, this.usedn, this.usedn_count)) continue;
                    int logarom = 0;
                    if (this.filter != null) {
                        logarom = this.usedn_count < 2 ? (this.filter.isAmbiguousAromaticBond(bond) ? 1 : 0) : this.filter.getLogicalAromaticity(this.usedn[this.usedn_count - 2], node, nextnode, this.usedb[this.usedb_count - 1], bond);
                    }
                    if (this.debug) {
                        System.err.println("usedn_count: " + this.usedn_count + "  logarom: " + logarom);
                    }
                    switch (logarom) {
                        case 0: {
                            this.gWalk(bond, nextnode, edgeno, numberOfOnes, summa1, summa2);
                            continue block9;
                        }
                        case 1: {
                            this.gWalk(bond, 4, bond.getType(), nextnode, edgeno, numberOfOnes, summa1, summa2);
                            continue block9;
                        }
                        case 2: {
                            MolBond pbond = this.usedb[this.usedb_count - 1];
                            int type = -1;
                            int set = -1;
                            if (pbond.getSetSeq() == 63) {
                                type = bond.getType();
                                set = bond.getSetSeq();
                                ScreenMol.mySetType(bond, 4);
                                bond.setSetSeq(63);
                            }
                            this.gWalk(bond, nextnode, edgeno, numberOfOnes, summa1, summa2);
                            if (type == -1) continue block9;
                            ScreenMol.mySetType(bond, type);
                            bond.setSetSeq(set);
                            continue block9;
                        }
                        case 3: {
                            int set;
                            int type;
                            MolBond pbond = this.usedb[this.usedb_count - 1];
                            if (pbond.getSetSeq() == 63) {
                                type = bond.getType();
                                set = bond.getSetSeq();
                                ScreenMol.mySetType(bond, 4);
                                bond.setSetSeq(63);
                                this.gWalk(bond, nextnode, edgeno, numberOfOnes, summa1, summa2);
                                ScreenMol.mySetType(bond, type);
                                bond.setSetSeq(set);
                                continue block9;
                            }
                            this.gWalk(bond, 4, bond.getType(), nextnode, edgeno, numberOfOnes, summa1, summa2);
                            continue block9;
                        }
                        case 4: {
                            MolBond pbond = this.usedb[this.usedb_count - 1];
                            if (pbond.getSetSeq() == 63) {
                                this.gWalk(bond, 4, bond.getType(), nextnode, edgeno, numberOfOnes, summa1, summa2);
                                continue block9;
                            }
                            this.gWalk(bond, nextnode, edgeno, numberOfOnes, summa1, summa2);
                            continue block9;
                        }
                    }
                }
            }
        }
        --this.usedn_count;
    }

    private static final void mySetType(MolBond bond, int type) {
        int flags = bond.getFlags();
        bond.setFlags(flags & 0xFFFFFFF8 | type & 7);
    }

    private final void gWalk(MolBond bond, int type1, int type2, MolAtom node, int edgeno, int bitnb, long summa1, long summa2) {
        this.usedb[this.usedb_count++] = bond;
        int set = bond.getSetSeq();
        ScreenMol.mySetType(bond, type1);
        bond.setSetSeq(63);
        this.gWalk(node, edgeno - 1, bitnb, summa1, summa2);
        ScreenMol.mySetType(bond, type2);
        bond.setSetSeq(set);
        this.gWalk(node, edgeno - 1, bitnb, summa1, summa2);
        --this.usedb_count;
    }

    private final void gWalk(MolBond edge, MolAtom node, int edgeno, int bitnb, long summa1, long summa2) {
        this.usedb[this.usedb_count++] = edge;
        this.gWalk(node, edgeno - 1, bitnb, summa1, summa2);
        --this.usedb_count;
    }

    private final boolean contains(MolBond edge) {
        for (int x = 0; x < this.usedb_count; ++x) {
            if (this.usedb[x] != edge) continue;
            return true;
        }
        return false;
    }

    private static final int findPrim(int q) {
        int p = q * 8;
        switch (p) {
            case 32: {
                return 31;
            }
            case 64: {
                return 61;
            }
            case 128: {
                return 127;
            }
            case 256: {
                return 251;
            }
            case 512: {
                return 509;
            }
            case 1024: {
                return 1021;
            }
            case 2048: {
                return 2039;
            }
            case 4096: {
                return 4093;
            }
            case 8192: {
                return 8191;
            }
        }
        while (--p > 2) {
            boolean pr = true;
            int i = 2;
            while ((double)i <= Math.sqrt(p)) {
                if (p % i == 0) {
                    pr = false;
                    break;
                }
                ++i;
            }
            if (!pr) continue;
            return p;
        }
        return 2;
    }

    public int retPrim() {
        return this.prim;
    }

    public void setMol(MoleculeGraph m) {
        this.graph = this.getRootIfNeeded(m);
        this.mol = m;
        byte[] b = new byte[this.fingerprint.length];
        this.fingerprint = b;
    }

    public void setRings(int[][] nr, int[][] ar) {
        this.nonaromrings = nr;
        this.aromrings = ar;
    }

    public void setPathFilter(PathFilter filter) {
        this.filter = filter;
    }

    private static final long calcSumm1(MolAtom[] usedn, int usedn_count, MolBond[] usedb, int usedb_count, boolean debugFP) {
        long sum = 0L;
        if (debugFP) {
            int i;
            SelectionMolecule s = new SelectionMolecule();
            for (i = 0; i < usedn_count; ++i) {
                if (s.contains(usedn[i])) continue;
                s.add(usedn[i]);
            }
            for (i = 0; i < usedb_count; ++i) {
                if (s.contains(usedb[i])) continue;
                s.add(usedb[i]);
            }
            Molecule m = new Molecule();
            s.clonecopy(m);
            System.err.print(m.toFormat("smiles") + " summ1 ");
        }
        int nSize = usedn_count >= 100 ? 99 : usedn_count;
        for (int i = 0; i < nSize; ++i) {
            MolAtom a = usedn[i];
            int pos = i < (nSize + 1) / 2 ? i : nSize - 1 - i;
            int number = a.getAtno();
            sum += (long)(RND1[pos] * FACTOR[number]);
        }
        int bSize = usedb_count > 100 ? 100 : usedb_count;
        for (int i = 0; i < bSize; ++i) {
            MolBond b = usedb[i];
            int pos = i < (bSize + 1) / 2 ? i : bSize - 1 - i;
            int t = b.getType();
            sum += (long)(RND1[pos] * BONDFACTOR[t]);
        }
        return sum;
    }

    private final long calcSumm2(long sum2) {
        int bSize;
        int nSizeMinusOne = this.usedn_count - 1 >= 100 ? 99 : this.usedn_count - 1;
        MolAtom atom = this.usedn[nSizeMinusOne];
        int number = atom.getAtno();
        number = number >= 109 ? 0 : number;
        sum2 += (long)(RND[nSizeMinusOne] * FACTOR[number]);
        int n = bSize = this.usedb_count > 100 ? 100 : this.usedb_count;
        if (bSize > 0) {
            MolBond bond = this.usedb[bSize - 1];
            number = bond.getType();
            sum2 += (long)(RND[bSize - 1] * BONDFACTOR[number]);
        }
        return sum2;
    }

    private static final void calcBranchingType1(long sum1, MolAtom[] usedn, int usedn_count, MolBond[] usedb, int usedb_count, byte[] fingerprint, int prim, boolean ignoreH, boolean debugFP) {
        int atno0;
        if (usedn_count - 2 < 0) {
            return;
        }
        MolAtom center = usedn[usedn_count - 1];
        int l = center.getBondCount();
        MolAtom prev = usedn[usedn_count - 2];
        int prevNodeIdx = -1;
        for (int i = 0; i < l; ++i) {
            if (center.getLigand(i) != prev) continue;
            prevNodeIdx = i;
            break;
        }
        if (prevNodeIdx < 0) {
            return;
        }
        if (usedn_count == 2) {
            sum1 = 1L;
        }
        SelectionMolecule s = null;
        if (debugFP) {
            int i;
            s = new SelectionMolecule();
            for (i = 0; i < usedn_count; ++i) {
                if (s.contains(usedn[i])) continue;
                s.add(usedn[i]);
            }
            for (i = 0; i < usedb_count; ++i) {
                if (s.contains(usedb[i])) continue;
                s.add(usedb[i]);
            }
        }
        atno0 = (atno0 = center.getAtno()) >= 109 ? 0 : atno0;
        int atno3 = prev.getAtno();
        atno3 = atno3 >= 109 ? 0 : atno3;
        int bond3 = usedb[usedb_count - 1].getType();
        long fixedFactor = sum1 * 653L * (long)FACTOR[atno0] * (long)FACTOR[atno3] * (long)BONDFACTOR[bond3];
        for (int i = 1; i < l; ++i) {
            int idx1 = (i + prevNodeIdx) % l;
            MolAtom node1 = center.getLigand(idx1);
            int atno1 = node1.getAtno();
            atno1 = atno1 >= 109 ? 0 : atno1;
            MolBond bond1 = center.getBond(idx1);
            int bondType1 = bond1.getType();
            if (!ScreenMol.useNode(node1, bond1, ignoreH)) continue;
            for (int j = i + 1; j < l; ++j) {
                int idx2 = (j + prevNodeIdx) % l;
                MolAtom node2 = center.getLigand(idx2);
                int atno2 = node2.getAtno();
                atno2 = atno2 >= 109 ? 0 : atno2;
                MolBond bond2 = center.getBond(idx2);
                if (!ScreenMol.useNode(node2, bond2, ignoreH)) continue;
                int bondType2 = bond2.getType();
                long summa1 = fixedFactor * (long)FACTOR[atno1] * (long)FACTOR[atno2] * (long)BONDFACTOR[bondType1] * (long)BONDFACTOR[bondType2];
                if (debugFP) {
                    boolean b2 = false;
                    boolean b1 = false;
                    boolean n2 = false;
                    boolean n1 = false;
                    if (!s.contains(node1)) {
                        n1 = true;
                        s.add(node1);
                    }
                    if (!s.contains(node2)) {
                        n2 = true;
                        s.add(node2);
                    }
                    if (!s.contains(bond1)) {
                        b1 = true;
                        s.add(bond1);
                    }
                    if (!s.contains(bond2)) {
                        b2 = true;
                        s.add(bond2);
                    }
                    Molecule m = new Molecule();
                    s.clonecopy(m);
                    System.err.print(m.toFormat("smiles") + " branch ");
                    if (n1) {
                        s.removeAtom(node1);
                    }
                    if (n2) {
                        s.removeAtom(node2);
                    }
                    if (b1) {
                        s.removeBond(bond1);
                    }
                    if (b2) {
                        s.removeBond(bond2);
                    }
                }
                ScreenMol.setBit(summa1, fingerprint, prim);
            }
        }
    }

    private static boolean useNode(MolAtom node, MolBond bond, boolean ignoreH) {
        return ScreenMol.checkAny(node, bond) && (!ignoreH || node.getAtno() != 1);
    }

    private static boolean recurrency(MolAtom[] nodelist, int l) {
        MolAtom r = nodelist[l - 1];
        for (int i = l - 2; i >= 0; --i) {
            MolAtom n = nodelist[i];
            if (n != r) continue;
            return true;
        }
        return false;
    }

    private static final int abs(int a) {
        return a < 0 ? -a : a;
    }

    private static final long abs(long a) {
        return a < 0L ? -a : a;
    }

    private final void generateMoreBit(int numberOfOnes, long sum1, long sum2) {
        if (numberOfOnes > 0) {
            int i;
            long random = sum1;
            long random2 = sum2;
            for (i = 0; i < (numberOfOnes + 1) / 2; ++i) {
                ScreenMol.setBit(random, this.fingerprint, this.prim);
                random = ScreenMol.randq1(random);
            }
            for (i = 0; i < numberOfOnes / 2; ++i) {
                ScreenMol.setBit(random2, this.fingerprint, this.prim);
                random2 = ScreenMol.randq1(random2);
            }
        }
    }

    private static final void setBit(long b, byte[] fp, int l) {
        int remain = ScreenMol.abs((int)ScreenMol.abs(b % (long)l));
        int n = remain / 8;
        fp[n] = (byte)(fp[n] | (byte)(1 << 7 - remain % 8));
    }

    final void ringcalculation() {
        MolBond bond;
        int number;
        MolAtom atom;
        int p;
        boolean skipTopology;
        boolean skip;
        int[] ring;
        long sum;
        int i;
        if (this.aromrings == null || this.nonaromrings == null) {
            return;
        }
        for (i = 0; i < this.aromrings.length; ++i) {
            MolAtom atom2;
            sum = 1L;
            ring = this.aromrings[i];
            skip = false;
            skipTopology = false;
            boolean setbit = false;
            for (int j = 0; j < ring.length; ++j) {
                p = j == 0 ? ring.length - 1 : j - 1;
                int ringAtomIdx = ring[j];
                atom = this.mol.getAtom(ringAtomIdx);
                setbit = setbit || !this.partialFP || this.atomSet.get(ringAtomIdx);
                number = atom.getAtno();
                int n = number = number >= 109 ? 0 : number;
                if (number == 0) {
                    skip = true;
                    skipTopology = ScreenMol.isTopologyExclusion(atom);
                    break;
                }
                sum *= (long)FACTOR[number];
                atom2 = this.mol.getAtom(ring[p]);
                bond = atom.getBondTo(atom2);
                number = bond.getType();
                if (number != 4) {
                    skip = true;
                    break;
                }
                sum *= (long)BONDFACTOR[number];
            }
            if (setbit && !skip) {
                sum *= 661L;
                if (this.debugFP) {
                    SelectionMolecule s = new SelectionMolecule();
                    for (int j = 0; j < ring.length; ++j) {
                        atom = this.mol.getAtom(ring[j]);
                        s.add(atom);
                        p = j == 0 ? ring.length - 1 : j - 1;
                        atom2 = this.mol.getAtom(ring[p]);
                        bond = atom.getBondTo(atom2);
                        s.add(bond);
                    }
                    Molecule m = new Molecule();
                    s.clonecopy(m);
                    System.err.print(m.toFormat("smiles") + " aromR ");
                }
                ScreenMol.setBit(sum, this.fingerprint, this.prim);
            }
            if (this.debugFP) {
                System.err.print("ring_l " + ring.length + " ");
            }
            if (!setbit || skipTopology) continue;
            ScreenMol.setBit(444853 * POS[ring.length - 2], this.fingerprint, this.prim);
        }
        for (i = 0; i < this.nonaromrings.length; ++i) {
            sum = 1L;
            ring = this.nonaromrings[i];
            skip = false;
            skipTopology = false;
            for (int j = 0; j < ring.length; ++j) {
                p = j == 0 ? ring.length - 1 : j - 1;
                atom = this.mol.getAtom(ring[j]);
                number = atom.getAtno();
                int n = number = number >= 109 ? 0 : number;
                if (number == 0) {
                    skip = true;
                    skipTopology = ScreenMol.isTopologyExclusion(atom);
                    break;
                }
                sum *= (long)FACTOR[number];
                MolAtom atom2 = this.mol.getAtom(ring[p]);
                bond = atom.getBondTo(atom2);
                number = bond.getType();
                if (number < 1 || number > 4) {
                    skip = true;
                    break;
                }
                sum *= (long)BONDFACTOR[number];
            }
            if (!skip) {
                if (this.debugFP) {
                    SelectionMolecule s = new SelectionMolecule();
                    for (int j = 0; j < ring.length; ++j) {
                        atom = this.mol.getAtom(ring[j]);
                        s.add(atom);
                        p = j == 0 ? ring.length - 1 : j - 1;
                        MolAtom atom2 = this.mol.getAtom(ring[p]);
                        bond = atom.getBondTo(atom2);
                        s.add(bond);
                    }
                    Molecule m = new Molecule();
                    s.clonecopy(m);
                    System.err.print(m.toFormat("smiles") + " aliphR ");
                }
                ScreenMol.setBit(sum *= 673L, this.fingerprint, this.prim);
            }
            if (this.debugFP) {
                System.err.print("ring_l " + ring.length + " ");
            }
            if (skipTopology) continue;
            ScreenMol.setBit(444853 * POS[ring.length - 2], this.fingerprint, this.prim);
        }
    }

    static final long randq1(long seed) {
        return 1664525L * seed + 1013904223L;
    }

    static final boolean checkAny(MolAtom atom, MolBond bond) {
        int atno = atom.getAtno();
        if (atno >= 109 || atno < 1) {
            return false;
        }
        if (bond == null) {
            return true;
        }
        int bondtype = bond.getType();
        return bondtype <= 4 && bondtype >= 1;
    }

    static final boolean isTopologyExclusion(MolAtom a) {
        int atno = a.getAtno();
        if (atno == 134) {
            return true;
        }
        if (atno == 136) {
            boolean hom;
            String aliasStr = a.getAliasstr();
            boolean bl = hom = HomologyConstants.isHomology(aliasStr) && !HomologyConstants.isAtomicHomology(aliasStr);
            if (hom) {
                return true;
            }
        }
        return false;
    }

    public static byte[] Fingerprint(MoleculeGraph m, int numberOfBytes, int numberOfEdges, int numberOfOnes, boolean calcWithRings) {
        ScreenMol screen = new ScreenMol(m, numberOfBytes);
        if (calcWithRings) {
            m.aromatize(true);
            screen.setRings(m.getNonAromrings(), m.getAromrings());
        }
        return screen.getFingerprint(numberOfEdges, numberOfOnes);
    }

    public static byte[] fingerprint(MoleculeGraph m, int numberOfBytes, int numberOfEdges, int numberOfOnes, int aromatization, boolean calcWithRings) {
        ScreenMol screen = new ScreenMol(m, numberOfBytes);
        if (aromatization == 1) {
            m.aromatize(1);
            calcWithRings = true;
        } else if (aromatization == 2) {
            m.aromatize(2);
            calcWithRings = true;
        }
        if (calcWithRings) {
            SupergraphFindAllRings allRingsSearcher = new SupergraphFindAllRings();
            ((FindAllRings)allRingsSearcher).setGraph(m);
            allRingsSearcher.startRingSearch(14, false, 0);
            int[][][] r = allRingsSearcher.getAromaticAndAliphaticRings();
            screen.setRings(r[1], r[0]);
        }
        return screen.getFingerprint(numberOfEdges, numberOfOnes);
    }

    public static byte[] fingerprint(MoleculeGraph m, int[] aidxs, int numberOfBytes, int numberOfEdges, int numberOfOnes, int aromatization, boolean calcWithRings) {
        ScreenMol screen = new ScreenMol(m, numberOfBytes, aidxs);
        if (aromatization == 1) {
            m.aromatize(1);
            calcWithRings = true;
        } else if (aromatization == 2) {
            m.aromatize(2);
            calcWithRings = true;
        }
        if (calcWithRings) {
            SupergraphFindAllRings allRingsSearcher = new SupergraphFindAllRings();
            ((FindAllRings)allRingsSearcher).setGraph(m);
            allRingsSearcher.startRingSearch(14, false, 0);
            int[][][] r = allRingsSearcher.getAromaticAndAliphaticRings();
            screen.setRings(r[1], r[0]);
        }
        return screen.getFingerprint(numberOfEdges, numberOfOnes);
    }

    private final MoleculeGraph getRootIfNeeded(MoleculeGraph mol) {
        if (mol instanceof Molecule) {
            this.pspw.transformMulticenters((Molecule)mol);
        }
        if (mol instanceof RgMolecule) {
            return ((RgMolecule)mol).getRoot();
        }
        return mol;
    }

    static {
        int i;
        FACTOR = new int[109];
        ScreenMol.FACTOR[0] = 1;
        for (i = 106; i < 109; ++i) {
            ScreenMol.FACTOR[i] = 1;
        }
        ScreenMol.FACTOR[6] = 43;
        ScreenMol.FACTOR[1] = 47;
        ScreenMol.FACTOR[8] = 53;
        ScreenMol.FACTOR[7] = 59;
        ScreenMol.FACTOR[16] = 61;
        ScreenMol.FACTOR[17] = 67;
        ScreenMol.FACTOR[9] = 71;
        ScreenMol.FACTOR[35] = 73;
        ScreenMol.FACTOR[15] = 79;
        ScreenMol.FACTOR[53] = 83;
        ScreenMol.FACTOR[14] = 89;
        ScreenMol.FACTOR[5] = 97;
        ScreenMol.FACTOR[33] = 101;
        ScreenMol.FACTOR[50] = 103;
        ScreenMol.FACTOR[78] = 107;
        ScreenMol.FACTOR[34] = 109;
        ScreenMol.FACTOR[27] = 113;
        ScreenMol.FACTOR[80] = 127;
        ScreenMol.FACTOR[26] = 131;
        ScreenMol.FACTOR[29] = 137;
        ScreenMol.FACTOR[28] = 139;
        ScreenMol.FACTOR[32] = 149;
        ScreenMol.FACTOR[51] = 151;
        ScreenMol.FACTOR[46] = 157;
        ScreenMol.FACTOR[82] = 163;
        ScreenMol.FACTOR[30] = 167;
        ScreenMol.FACTOR[45] = 173;
        ScreenMol.FACTOR[24] = 179;
        ScreenMol.FACTOR[42] = 181;
        ScreenMol.FACTOR[25] = 191;
        ScreenMol.FACTOR[44] = 193;
        ScreenMol.FACTOR[74] = 197;
        ScreenMol.FACTOR[23] = 199;
        ScreenMol.FACTOR[13] = 211;
        ScreenMol.FACTOR[40] = 223;
        ScreenMol.FACTOR[83] = 227;
        ScreenMol.FACTOR[22] = 229;
        ScreenMol.FACTOR[48] = 233;
        ScreenMol.FACTOR[79] = 239;
        ScreenMol.FACTOR[52] = 241;
        ScreenMol.FACTOR[11] = 251;
        ScreenMol.FACTOR[63] = 257;
        ScreenMol.FACTOR[77] = 263;
        ScreenMol.FACTOR[75] = 269;
        ScreenMol.FACTOR[12] = 271;
        ScreenMol.FACTOR[47] = 277;
        ScreenMol.FACTOR[81] = 281;
        ScreenMol.FACTOR[31] = 283;
        ScreenMol.FACTOR[76] = 293;
        ScreenMol.FACTOR[72] = 307;
        ScreenMol.FACTOR[62] = 311;
        ScreenMol.FACTOR[59] = 313;
        ScreenMol.FACTOR[60] = 317;
        ScreenMol.FACTOR[57] = 331;
        ScreenMol.FACTOR[58] = 337;
        ScreenMol.FACTOR[20] = 347;
        ScreenMol.FACTOR[56] = 349;
        ScreenMol.FACTOR[90] = 353;
        ScreenMol.FACTOR[65] = 359;
        ScreenMol.FACTOR[64] = 367;
        ScreenMol.FACTOR[55] = 373;
        ScreenMol.FACTOR[73] = 379;
        ScreenMol.FACTOR[19] = 383;
        ScreenMol.FACTOR[49] = 389;
        ScreenMol.FACTOR[68] = 397;
        ScreenMol.FACTOR[39] = 401;
        ScreenMol.FACTOR[92] = 409;
        ScreenMol.FACTOR[41] = 419;
        ScreenMol.FACTOR[71] = 421;
        ScreenMol.FACTOR[67] = 431;
        ScreenMol.FACTOR[66] = 433;
        ScreenMol.FACTOR[4] = 439;
        ScreenMol.FACTOR[70] = 443;
        ScreenMol.FACTOR[69] = 449;
        ScreenMol.FACTOR[3] = 457;
        ScreenMol.FACTOR[21] = 461;
        ScreenMol.FACTOR[37] = 463;
        ScreenMol.FACTOR[2] = 467;
        ScreenMol.FACTOR[10] = 479;
        ScreenMol.FACTOR[18] = 487;
        ScreenMol.FACTOR[36] = 491;
        ScreenMol.FACTOR[38] = 499;
        ScreenMol.FACTOR[43] = 503;
        ScreenMol.FACTOR[54] = 509;
        ScreenMol.FACTOR[61] = 521;
        ScreenMol.FACTOR[84] = 523;
        ScreenMol.FACTOR[85] = 541;
        ScreenMol.FACTOR[86] = 547;
        ScreenMol.FACTOR[87] = 557;
        ScreenMol.FACTOR[88] = 563;
        ScreenMol.FACTOR[89] = 569;
        ScreenMol.FACTOR[91] = 571;
        ScreenMol.FACTOR[93] = 577;
        ScreenMol.FACTOR[94] = 587;
        ScreenMol.FACTOR[95] = 593;
        ScreenMol.FACTOR[96] = 599;
        ScreenMol.FACTOR[97] = 601;
        ScreenMol.FACTOR[98] = 607;
        ScreenMol.FACTOR[99] = 613;
        ScreenMol.FACTOR[100] = 617;
        ScreenMol.FACTOR[101] = 619;
        ScreenMol.FACTOR[102] = 631;
        ScreenMol.FACTOR[103] = 641;
        ScreenMol.FACTOR[104] = 643;
        ScreenMol.FACTOR[105] = 647;
        BONDFACTOR = new int[15];
        ScreenMol.BONDFACTOR[0] = 1;
        ScreenMol.BONDFACTOR[1] = 1;
        ScreenMol.BONDFACTOR[2] = 2;
        ScreenMol.BONDFACTOR[3] = 3;
        ScreenMol.BONDFACTOR[4] = 5;
        for (i = 5; i < 15; ++i) {
            ScreenMol.BONDFACTOR[i] = 1;
        }
        POS = new int[100];
        ScreenMol.POS[0] = 1;
        ScreenMol.POS[1] = 7;
        ScreenMol.POS[2] = 11;
        ScreenMol.POS[3] = 13;
        ScreenMol.POS[4] = 17;
        ScreenMol.POS[5] = 19;
        ScreenMol.POS[6] = 23;
        ScreenMol.POS[7] = 29;
        ScreenMol.POS[8] = 31;
        ScreenMol.POS[9] = 37;
        ScreenMol.POS[10] = 41;
        ScreenMol.POS[11] = 2743821;
        for (i = 12; i < 100; ++i) {
            ScreenMol.POS[i] = 1664525 * POS[i - 1] + 1013904223;
        }
        RND1 = new int[100];
        ScreenMol.RND1[0] = 2743821;
        for (i = 1; i < 100; ++i) {
            ScreenMol.RND1[i] = 1664525 * RND1[i - 1] + 1013904223;
        }
        RND = new int[100];
        ScreenMol.RND[0] = RND1[99];
        for (i = 1; i < 100; ++i) {
            ScreenMol.RND[i] = 1664525 * RND[i - 1] + 1013904223;
        }
    }
}

