/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.MolHandler;
import chemaxon.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class StrucFPConfig {
    private List<Molecule> molecules = null;
    private List<String> molStrings = null;
    private boolean smartsMode;
    private static final String SEPARATOR = "<#*%*#>";

    public List<Molecule> getMolecules() {
        return this.molecules;
    }

    public List<String> getMolStrings() {
        return this.molStrings;
    }

    public boolean getSmartsMode() {
        return this.smartsMode;
    }

    public void parseConfig(String config) throws MolFormatException {
        this.molStrings = new ArrayList<String>();
        this.molecules = new ArrayList<Molecule>();
        this.smartsMode = false;
        if (config == null) {
            return;
        }
        ArrayList tokens = StringUtil.tokenize(config, SEPARATOR);
        String settings = (String)tokens.get(0);
        StringTokenizer st = new StringTokenizer(settings, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(token, "=");
            String key = st2.nextToken();
            String value = st2.nextToken();
            if (key.equals("smartsMode") && value.equals("true")) {
                this.smartsMode = true;
                continue;
            }
            this.smartsMode = false;
        }
        for (int x = 1; x < tokens.size(); ++x) {
            String token = (String)tokens.get(x);
            this.molStrings.add(token);
            MolHandler mh = new MolHandler(token, this.smartsMode);
            this.molecules.add(mh.getMolecule());
        }
    }

    public String getConfig() {
        StringBuffer result = new StringBuffer();
        result.append("smartsMode=");
        result.append(this.smartsMode);
        for (int x = 0; x < this.molStrings.size(); ++x) {
            result.append(SEPARATOR);
            result.append(this.molStrings.get(x));
        }
        return result.toString();
    }

    public void setMolStrings(List<String> strings, boolean smartsMode) throws MolFormatException {
        this.molecules = new ArrayList<Molecule>();
        this.molStrings = new ArrayList<String>();
        this.smartsMode = smartsMode;
        for (int x = 0; x < strings.size(); ++x) {
            String molString = strings.get(x);
            Molecule mol = new MolHandler(molString).getMolecule();
            this.molecules.add(mol);
            this.molStrings.add(molString);
        }
    }

    public void readMolecules(InputStream input, boolean smartsMode) throws IOException {
        RgMolecule mol;
        this.molecules = new ArrayList<Molecule>();
        this.molStrings = new ArrayList<String>();
        this.smartsMode = smartsMode;
        MolInputStream mis = new MolInputStream(input);
        MolImporter molimp = new MolImporter(mis);
        molimp.setQueryMode(smartsMode);
        molimp.setGrabbingEnabled(true);
        while (molimp.read(mol = new RgMolecule())) {
            this.molecules.add(mol);
            this.molStrings.add(molimp.getGrabbedMoleculeString());
        }
        mis.close();
    }

    public int getNumberOfKeys() {
        return this.molecules.size();
    }

    public int getNumberOfIntegersNeeded() {
        int count = this.getNumberOfKeys();
        int integers = (int)Math.ceil((double)count / 32.0);
        return integers;
    }
}

