/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.maccs;

import chemaxon.sss.screen.composite.parts.maccs.MaccsGenerator;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.ScreenUtil;
import chemaxon.struc.Molecule;

public class MaccsSHBytes
implements ScreenHandlerBytes {
    private static MaccsGenerator generator = new MaccsGenerator();

    @Override
    public byte[] generateQueryDescriptor(Molecule query, ScreenOptions screenOptions) throws IllegalArgumentException, UnsupportedMoleculeException {
        try {
            return generator.generate(query, true);
        }
        catch (Exception e) {
            return new byte[30];
        }
    }

    @Override
    public byte[] generateTargetDescriptor(Molecule target) throws UnsupportedMoleculeException {
        try {
            return generator.generate(target, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[30];
        }
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, ScreenOptions screenOptions) throws IllegalArgumentException {
        return this.accept(queryDescr, targetDescr, 0, screenOptions);
    }

    private boolean accept(byte[] queryDescr, byte[] targetDescr, int startIndex, ScreenOptions screenOptions) {
        for (int i = 0; i < queryDescr.length; ++i) {
            if ((queryDescr[i] & targetDescr[startIndex + i]) == queryDescr[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, int start, int length, ScreenOptions screenOptions) throws IllegalArgumentException {
        if (length != MaccsGenerator.DESC_LENGTH) {
            throw new IllegalArgumentException(String.format("Descriptor length differs from expected length: %d <> %d", length, MaccsGenerator.DESC_LENGTH));
        }
        return this.accept(queryDescr, targetDescr, start, screenOptions);
    }

    @Override
    public void intersect(byte[] descr1, byte[] descr2) throws IllegalArgumentException {
        if (descr1.length != descr2.length) {
            throw new IllegalArgumentException("Different descriptor lengths for intersection");
        }
        ScreenUtil.intersectAnd(descr1, descr2, 0, descr1.length);
    }
}

