/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.ring;

import chemaxon.sss.screen.composite.parts.ring.RingScreenUtil;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.MatchingStrictnessOption;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.ScreenUtil;
import chemaxon.struc.Molecule;

public class RingScreenHandlerBytes
implements ScreenHandlerBytes {
    @Override
    public byte[] generateTargetDescriptor(Molecule targetMol) throws UnsupportedMoleculeException {
        return RingScreenUtil.calculateRingCountProperties(targetMol, false);
    }

    @Override
    public byte[] generateQueryDescriptor(Molecule queryMol, ScreenOptions screenOptions) throws IllegalArgumentException, UnsupportedMoleculeException {
        return RingScreenUtil.calculateRingCountProperties(queryMol, screenOptions.getBondMatchingOption() == MatchingStrictnessOption.NATURAL && screenOptions.getAtomMatchingOption() == MatchingStrictnessOption.NATURAL);
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescr, ScreenOptions screenOptions) throws IllegalArgumentException {
        return this.accept(queryDescr, targetDescr, 0, targetDescr.length, screenOptions);
    }

    @Override
    public boolean accept(byte[] queryDescr, byte[] targetDescrArray, int start, int length, ScreenOptions screenOptions) throws IllegalArgumentException {
        if (length != queryDescr.length) {
            throw new IllegalArgumentException(String.format("Query descriptor length differs from target: %d <> %d", queryDescr.length, length));
        }
        int end = start + length;
        int i = start;
        int j = 0;
        while (i < end) {
            if (queryDescr[j] > targetDescrArray[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    @Override
    public void intersect(byte[] descr1, byte[] descr2) throws IllegalArgumentException {
        if (descr1.length != descr2.length) {
            throw new IllegalArgumentException("Different descriptor lengths for intersection");
        }
        ScreenUtil.intersectMin(descr1, descr2, 0, descr1.length);
    }
}

