/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.composite.parts.ring;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class RingScreenUtil {
    static final int RING_ATOM_COUNT_LIMIT = 127;
    static final int MULTICONN_ATOM_COUNT_LIMIT = 127;
    public static final int DATA_LENGTH = 2;

    private static int calcRingBondCountTopo(Molecule mol, boolean isQPropConsidered, BondClassifier bc, int[][] ctab, int atomInd) {
        int ringBondCountTopo = 0;
        for (int neighBInd = 0; neighBInd < ctab[atomInd].length; ++neighBInd) {
            boolean isRing;
            int neighbour = ctab[atomInd][neighBInd];
            if (bc.isRingBond(atomInd, neighbour)) {
                ++ringBondCountTopo;
                continue;
            }
            if (!isQPropConsidered) continue;
            MolBond bond = mol.getAtom(atomInd).getBond(neighBInd);
            boolean bl = isRing = (bond.getFlags() & 0xC00) == 1024;
            if (!isRing) continue;
            ++ringBondCountTopo;
        }
        return ringBondCountTopo;
    }

    private static int calcRingFromAtomProperties(MolAtom atom) {
        int rb = atom.getQPropAsInt("rb");
        if (rb > -1) {
            return rb;
        }
        int R = atom.getQPropAsInt("R");
        if (R > -1) {
            if (R == 256) {
                return 2;
            }
            if (R > 2) {
                return 3;
            }
            return R > 0 ? 2 : 0;
        }
        int smallR = atom.getQPropAsInt("r");
        if (smallR > 2) {
            return 2;
        }
        return 0;
    }

    public static byte[] calculateRingCountProperties(Molecule mol, boolean isQPropConsidered) {
        BondClassifier bc = new BondClassifier();
        bc.classify(mol);
        int[][] ctab = mol.getCtab();
        int numOfRingAtoms = 0;
        int numOfMultiConnRingAtoms = 0;
        int atCount = ctab.length;
        for (int atomInd = 0; atomInd < atCount; ++atomInd) {
            int ringBondCountAtomic = 0;
            MolAtom atom = mol.getAtom(atomInd);
            if (isQPropConsidered) {
                ringBondCountAtomic = RingScreenUtil.calcRingFromAtomProperties(atom);
            }
            int ringBondCountTopo = 0;
            if (ringBondCountAtomic < 3) {
                ringBondCountTopo = RingScreenUtil.calcRingBondCountTopo(mol, isQPropConsidered, bc, ctab, atomInd);
            }
            if (ringBondCountAtomic > 2 || ringBondCountTopo > 2) {
                if (atom.getAtno() != 134 && !HomologyConstants.isHomology(atom.getAliasstr())) {
                    ++numOfMultiConnRingAtoms;
                }
                ++numOfRingAtoms;
                continue;
            }
            if (ringBondCountAtomic <= 1 && ringBondCountTopo <= 1) continue;
            ++numOfRingAtoms;
        }
        byte ringAtomCountToStore = (byte)Math.min(numOfRingAtoms, 127);
        byte multiConnToStore = (byte)Math.min(numOfMultiConnRingAtoms, 127);
        return new byte[]{ringAtomCountToStore, multiConnToStore};
    }
}

