/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.options;

import chemaxon.sss.screen.options.MatchingStrictnessOption;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.options.ScreenSearchType;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.options.AtomPropertyMatchingOption;
import chemaxon.sss.search.options.HomologyTranslationOption;

public class DefaultScreenOptions
implements ScreenOptions,
Cloneable {
    protected final ScreenSearchType searchType;
    protected HomologyTranslationOption broadTranslation;
    protected HomologyTranslationOption narrowTranslation;
    protected boolean completeHG;
    protected AtomPropertyMatchingOption radicalMatching;
    protected AtomPropertyMatchingOption chargeMatching;
    protected AtomPropertyMatchingOption isotopeMatching;
    protected MatchingStrictnessOption bondMatching;
    protected MatchingStrictnessOption atomMatching;

    public DefaultScreenOptions(SearchOptions searchOptions) throws IllegalArgumentException {
        this.searchType = ScreenSearchType.valueOf(searchOptions.getSearchType());
        this.broadTranslation = searchOptions.getHomologyBroadTranslation();
        this.narrowTranslation = searchOptions.getHomologyNarrowTranslation();
        this.completeHG = searchOptions.getCompleteHG();
        switch (searchOptions.getRadicalMatching()) {
            case 0: {
                this.radicalMatching = AtomPropertyMatchingOption.DEFAULT;
                break;
            }
            case 1: {
                this.radicalMatching = AtomPropertyMatchingOption.EXACT;
                break;
            }
            case 2: {
                this.radicalMatching = AtomPropertyMatchingOption.IGNORE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown radical matching option: " + searchOptions.getRadicalMatching());
            }
        }
        switch (searchOptions.getChargeMatching()) {
            case 0: {
                this.chargeMatching = AtomPropertyMatchingOption.DEFAULT;
                break;
            }
            case 1: {
                this.chargeMatching = AtomPropertyMatchingOption.EXACT;
                break;
            }
            case 2: {
                this.chargeMatching = AtomPropertyMatchingOption.IGNORE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown charge matching option: " + searchOptions.getChargeMatching());
            }
        }
        switch (searchOptions.getIsotopeMatching()) {
            case 0: {
                this.isotopeMatching = AtomPropertyMatchingOption.DEFAULT;
                break;
            }
            case 1: {
                this.isotopeMatching = AtomPropertyMatchingOption.EXACT;
                break;
            }
            case 2: {
                this.isotopeMatching = AtomPropertyMatchingOption.IGNORE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown isotope matching option: " + searchOptions.getIsotopeMatching());
            }
        }
        this.bondMatching = searchOptions.isExactBondMatching() ? MatchingStrictnessOption.EXACT : MatchingStrictnessOption.NATURAL;
        this.atomMatching = searchOptions.isExactQueryAtomMatching() ? MatchingStrictnessOption.EXACT : MatchingStrictnessOption.NATURAL;
    }

    public DefaultScreenOptions(ScreenOptions other) {
        this.searchType = other.getSearchType();
        this.broadTranslation = other.getHomologyBroadTranslation();
        this.narrowTranslation = other.getHomologyNarrowTranslation();
        this.completeHG = other.isCompleteHG();
        this.radicalMatching = other.getRadicalMatchingOption();
        this.chargeMatching = other.getChargeMatchingOption();
        this.isotopeMatching = other.getIsotopeMatchingOption();
        this.bondMatching = other.getBondMatchingOption();
        this.atomMatching = other.getAtomMatchingOption();
    }

    public DefaultScreenOptions(ScreenSearchType searchType) throws IllegalArgumentException {
        this(new SearchOptions(searchType.getSearchTypeConstant()));
    }

    @Override
    public final ScreenSearchType getSearchType() {
        return this.searchType;
    }

    @Override
    public final HomologyTranslationOption getHomologyBroadTranslation() {
        return this.broadTranslation;
    }

    @Override
    public final HomologyTranslationOption getHomologyNarrowTranslation() {
        return this.narrowTranslation;
    }

    @Override
    public final boolean isCompleteHG() {
        return this.completeHG;
    }

    @Override
    public AtomPropertyMatchingOption getRadicalMatchingOption() {
        return this.radicalMatching;
    }

    @Override
    public AtomPropertyMatchingOption getChargeMatchingOption() {
        return this.chargeMatching;
    }

    @Override
    public AtomPropertyMatchingOption getIsotopeMatchingOption() {
        return this.isotopeMatching;
    }

    @Override
    public MatchingStrictnessOption getBondMatchingOption() {
        return this.bondMatching;
    }

    @Override
    public MatchingStrictnessOption getAtomMatchingOption() {
        return this.atomMatching;
    }

    public String toString() {
        return "Screen Options:\n  searchType = " + (Object)((Object)this.searchType) + "\n" + "  radicalMatching = " + (Object)((Object)this.radicalMatching) + "\n" + "  chargeMatching = " + (Object)((Object)this.chargeMatching) + "\n" + "  isotopeMatching = " + (Object)((Object)this.isotopeMatching) + "\n" + "  bondMatching = " + (Object)((Object)this.bondMatching) + "\n" + "  atomMatching = " + (Object)((Object)this.atomMatching) + "\n" + "  broadTranslation = " + (Object)((Object)this.broadTranslation) + "\n" + "  narrowTranslation = " + (Object)((Object)this.narrowTranslation) + "\n" + "  completeHG = " + this.completeHG + "\n";
    }
}

