/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen.util;

import chemaxon.sss.screen.util.GenericQueryAtom;
import chemaxon.struc.PeriodicSystem;
import java.util.HashMap;
import java.util.Map;

public class GenericQueryAtomHandler {
    private static final Map<String, GenericQueryAtom> GENERIC_ATOMS;
    private static final GenericQueryAtom X;
    private static final GenericQueryAtom A;
    private static final GenericQueryAtom Q;
    private static final GenericQueryAtom M;
    private static final GenericQueryAtom XH;
    private static final GenericQueryAtom AH;
    private static final GenericQueryAtom QH;
    private static final GenericQueryAtom MH;

    public static GenericQueryAtom fromSymbol(String symbol) {
        if (symbol == null) {
            return null;
        }
        return GENERIC_ATOMS.get(symbol.toUpperCase());
    }

    static {
        X = new GenericQueryAtom("X"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return PeriodicSystem.isHalogen(t) && t != 85;
            }
        };
        A = new GenericQueryAtom("A"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return t > 1;
            }
        };
        Q = new GenericQueryAtom("Q"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return t > 0 && t != 1 && t != 6;
            }
        };
        M = new GenericQueryAtom("M"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return PeriodicSystem.isMetal(t);
            }
        };
        XH = new GenericQueryAtom("XH"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return PeriodicSystem.isHalogen(t) && t != 85 || t == 1;
            }
        };
        AH = new GenericQueryAtom("AH"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return t > 0;
            }
        };
        QH = new GenericQueryAtom("QH"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return t != 6 && t > 0;
            }
        };
        MH = new GenericQueryAtom("MH"){

            @Override
            public boolean isRepresentedAtomType(int t) {
                return PeriodicSystem.isMetal(t) || t == 1;
            }
        };
        GENERIC_ATOMS = new HashMap<String, GenericQueryAtom>(32);
        GENERIC_ATOMS.put(X.getSymbol(), X);
        GENERIC_ATOMS.put(A.getSymbol(), A);
        GENERIC_ATOMS.put(Q.getSymbol(), Q);
        GENERIC_ATOMS.put(M.getSymbol(), M);
        GENERIC_ATOMS.put(XH.getSymbol(), XH);
        GENERIC_ATOMS.put(AH.getSymbol(), AH);
        GENERIC_ATOMS.put(QH.getSymbol(), QH);
        GENERIC_ATOMS.put(MH.getSymbol(), MH);
        for (int groupId = 1; groupId <= 18; ++groupId) {
            GroupQueryAtom gqa = new GroupQueryAtom(groupId);
            GENERIC_ATOMS.put(gqa.getSymbol(), gqa);
        }
    }

    static class GroupQueryAtom
    extends GenericQueryAtom {
        private final int groupId;

        GroupQueryAtom(int groupId) {
            super("G_{" + groupId + "}");
            this.groupId = groupId;
        }

        @Override
        public boolean isRepresentedAtomType(int t) {
            return PeriodicSystem.getColumn(t) == this.groupId;
        }
    }
}

