/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.StereoConstants;
import chemaxon.util.AtomTypeConstants;
import chemaxon.util.MolHandler;

public final class AtomRearranger
implements AtomTypeConstants,
StereoConstants {
    public static final double NEIGHBOUR_MODIFIER = 100.0;
    private int[] oldToNew;
    private int[] newToOld;
    private double[] atomProbs;
    private final Molecule mol;
    private int nextAtom;

    public AtomRearranger(Molecule molp) {
        this.mol = molp;
    }

    public Molecule getRearrangedMolecule() {
        Molecule m = this.mol.getSimplifiedMolecule();
        if (m instanceof RgMolecule || m instanceof RxnMolecule || m.getSgroupCount() > 0 || m.getAtomCount() <= 1) {
            return this.mol;
        }
        this.calculateAtomProbabilities();
        this.modifyByNeighbourProbability();
        this.calcOrder();
        Molecule newMol = this.isRearrangable() ? this.rearrangeAtoms() : this.mol;
        return newMol;
    }

    private void modifyByNeighbourProbability() {
        double[] atomProbsTmp = new double[this.atomProbs.length];
        for (int i = 0; i < atomProbsTmp.length; ++i) {
            int[] neighIndV = this.mol.getCtab()[i];
            atomProbsTmp[i] = this.atomProbs[i] * this.atomProbs[i];
            for (int neigh : neighIndV) {
                int n = i;
                atomProbsTmp[n] = atomProbsTmp[n] * this.atomProbs[neigh];
            }
        }
        this.atomProbs = atomProbsTmp;
    }

    private void calcOrder() {
        this.newToOld = new int[this.mol.getAtomCount()];
        this.oldToNew = new int[this.newToOld.length];
        for (int i = 0; i < this.newToOld.length; ++i) {
            this.oldToNew[i] = -1;
        }
        this.nextAtom = 0;
        double absoluteMin = this.findMin();
        while (this.nextAtom < this.newToOld.length) {
            this.newToOld[this.nextAtom] = this.findMin();
            this.reduceChildrenProbs(this.newToOld[this.nextAtom], absoluteMin);
            this.registerOrder(this.nextAtom, this.newToOld[this.nextAtom]);
        }
    }

    private void reduceChildrenProbs(int oldParentIdx, double absoluteMin) {
        int[] oldChildren = this.mol.getCtab()[oldParentIdx];
        for (int i = 0; i < oldChildren.length; ++i) {
            this.atomProbs[oldChildren[i]] = this.calcChildrenProbMultByParent(oldParentIdx, oldChildren[i]);
        }
    }

    private final double calcChildrenProbMultByParent(int oldParentIdx, int childIdx) {
        return this.atomProbs[childIdx] * this.atomProbs[oldParentIdx];
    }

    private void registerOrder(int newAtom, int oldAtom) {
        this.newToOld[newAtom] = oldAtom;
        this.oldToNew[oldAtom] = newAtom;
        ++this.nextAtom;
    }

    private int findMin() {
        double min = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.atomProbs.length; ++i) {
            double atomProb = this.atomProbs[i];
            if (-1 != this.oldToNew[i] || !(min > atomProb)) continue;
            min = atomProb;
            minIndex = i;
        }
        return minIndex;
    }

    public int[] getNewToOld() {
        return this.newToOld;
    }

    public int[] getOldToNew() {
        return this.oldToNew;
    }

    private boolean isRearrangable() {
        for (int i = 0; i < this.newToOld.length - 1; ++i) {
            if (this.newToOld[i] + 1 == this.newToOld[i + 1]) continue;
            return true;
        }
        return false;
    }

    private Molecule rearrangeAtoms() {
        Molecule newMol = (Molecule)this.mol.clone();
        MolAtom[] newMolAtoms = newMol.getAtomArray();
        for (int iterCount = 0; iterCount < 2; ++iterCount) {
            for (int i = 0; i < newMolAtoms.length; ++i) {
                newMol.setAtom(i, newMolAtoms[this.newToOld[i]]);
            }
        }
        if (this.mol.getDim() == 0) {
            this.checkParities(newMolAtoms, newMol);
        }
        return newMol;
    }

    private void checkParities(MolAtom[] newMolAtoms, Molecule newMol) {
        for (int i = 0; i < newMolAtoms.length; ++i) {
            int parity = this.mol.getLocalParity(i) & 3;
            if (parity == 0 || parity == 3) continue;
            int[] oldNeighbours = new int[4];
            int[] oldNFromCtab = this.mol.getCtab()[i];
            for (int j = 0; j < oldNFromCtab.length; ++j) {
                oldNeighbours[j] = oldNFromCtab[j];
                MolAtom nAtom = this.mol.getAtom(oldNeighbours[j]);
                if (!MolHandler.isPlainH(nAtom)) continue;
                oldNeighbours[j] = Integer.MAX_VALUE;
            }
            if (oldNFromCtab.length == 3) {
                oldNeighbours[3] = Integer.MAX_VALUE;
            }
            int[] newNeighbours = new int[oldNeighbours.length];
            for (int j = 0; j < newNeighbours.length; ++j) {
                newNeighbours[j] = oldNeighbours[j] == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.oldToNew[oldNeighbours[j]];
            }
            if (MolAtom.isSameParityClass(oldNeighbours[0], oldNeighbours[1], oldNeighbours[2], oldNeighbours[3], newNeighbours[0], newNeighbours[1], newNeighbours[2], newNeighbours[3])) continue;
            this.flipNewMolChirality(newMol, this.oldToNew[i]);
        }
    }

    private void flipNewMolChirality(Molecule newMol, int i) {
        int parity = newMol.getLocalParity(i);
        int parityOddEven = parity & 3;
        if (parityOddEven == 2) {
            parity &= 0xFFFFFFFD;
            newMol.setParity(i, parity |= 1);
        } else {
            parity &= 0xFFFFFFFE;
            newMol.setParity(i, parity |= 2);
        }
    }

    private void calculateAtomProbabilities() {
        this.atomProbs = new double[this.mol.getAtomCount()];
        int i = 0;
        while (i < this.mol.getAtomCount()) {
            MolAtom atom = this.mol.getAtom(i);
            this.atomProbs[i] = this.getAtomTypeProb(atom.getAtno(), atom);
            int n = i;
            this.atomProbs[n] = this.atomProbs[n] * this.getQueryModifier(atom);
            int n2 = i++;
            this.atomProbs[n2] = this.atomProbs[n2] * this.getBondModifier(atom.getBondCount());
        }
    }

    private double getBondModifier(int bondCount) {
        double p;
        switch (bondCount) {
            case 0: {
                p = 1.0;
                break;
            }
            case 1: {
                p = 0.99;
                break;
            }
            case 2: {
                p = 0.9;
                break;
            }
            case 3: {
                p = 0.8;
                break;
            }
            case 4: {
                p = 0.3;
                break;
            }
            default: {
                p = 0.01;
            }
        }
        return p;
    }

    private double getQueryModifier(MolAtom atom) {
        int qSL;
        double XcMod;
        double rcMod;
        double RcMod;
        double hcMod;
        int ar;
        double chargeModifier;
        double prob = 1.0;
        int charge = atom.getCharge();
        switch (charge) {
            case 0: {
                chargeModifier = 1.0;
                break;
            }
            case -1: 
            case 1: {
                chargeModifier = 0.01;
                break;
            }
            case -2: 
            case 2: {
                chargeModifier = 2.0E-4;
                break;
            }
            case -3: 
            case 3: {
                chargeModifier = 1.0E-4;
                break;
            }
            default: {
                chargeModifier = 1.0E-5;
            }
        }
        prob *= chargeModifier;
        if (atom.getMassno() != 0) {
            prob *= 0.01;
        }
        if (atom.getRadical() != 0) {
            prob *= 0.01;
        }
        if (atom.getValenceProp() != -1) {
            prob *= 0.5;
        }
        if ((ar = atom.getQueryAromaticity()) == 2 || ar == 1) {
            prob *= 0.5;
        }
        int hc = atom.getQPropAsInt("H");
        switch (hc) {
            case -1: {
                hcMod = 1.0;
                break;
            }
            case 0: {
                hcMod = 0.5;
                break;
            }
            case 1: {
                hcMod = 0.5;
                break;
            }
            case 2: {
                hcMod = 0.2;
                break;
            }
            case 3: {
                hcMod = 0.07;
                break;
            }
            default: {
                hcMod = 0.01;
            }
        }
        prob *= hcMod;
        int Rc = atom.getQPropAsInt("R");
        switch (Rc) {
            case -1: {
                RcMod = 1.0;
                break;
            }
            case 0: 
            case 1: 
            case 256: {
                RcMod = 0.5;
                break;
            }
            case 2: {
                RcMod = 0.05;
                break;
            }
            default: {
                RcMod = 0.001;
            }
        }
        prob *= RcMod;
        int rc = atom.getQPropAsInt("r");
        switch (rc) {
            case -1: {
                rcMod = 1.0;
                break;
            }
            case 5: {
                rcMod = 0.08;
                break;
            }
            case 6: {
                rcMod = 0.5;
                break;
            }
            case 3: 
            case 7: {
                rcMod = 0.002;
                break;
            }
            default: {
                rcMod = 1.0E-4;
            }
        }
        prob *= rcMod;
        int Xc = atom.getQPropAsInt("X");
        switch (Xc) {
            case -1: {
                XcMod = 1.0;
                break;
            }
            case 1: 
            case 2: {
                XcMod = 0.1;
                break;
            }
            case 3: {
                XcMod = 0.5;
                break;
            }
            case 4: {
                XcMod = 0.25;
                break;
            }
            default: {
                XcMod = 2.0E-4;
            }
        }
        prob *= XcMod;
        String queryStr = atom.getQueryString();
        int n = qSL = queryStr == null ? 0 : queryStr.length();
        if (qSL > 0) {
            prob *= Math.pow(0.95, qSL);
        }
        return prob;
    }

    public double getAtomTypeProb(int atno, MolAtom ma) {
        switch (atno) {
            case 128: 
            case 129: {
                int[] list = ma.getList();
                double d = 0.0;
                for (int i = 0; i < list.length; ++i) {
                    d += this.getAtomTypeProb(list[i], null);
                }
                if (atno == 129) {
                    d = 1.0 - d;
                }
                return d;
            }
            case 130: 
            case 131: 
            case 134: {
                return 1.0;
            }
            case 132: {
                return 0.15;
            }
            case 135: {
                System.err.println("Hey, S-groups must be ungrouped before calling AtomRearranger!");
                return 1.0;
            }
            case 136: {
                if (HomologyConstants.isHandledHomology(ma.getAliasstr())) {
                    return AtomRearranger.getHomologyProbability(ma.getAliasstr());
                }
                return 0.05;
            }
            case 1: {
                return 0.33;
            }
            case 6: {
                return 0.48;
            }
            case 8: {
                return 0.08;
            }
            case 7: {
                return 0.05;
            }
            case 16: 
            case 17: {
                return 0.01;
            }
            case 9: 
            case 15: 
            case 35: 
            case 74: {
                return 0.005;
            }
            case 5: 
            case 11: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 46: 
            case 50: 
            case 53: 
            case 78: 
            case 80: {
                return 0.001;
            }
        }
        return 5.0E-4;
    }

    private static double getHomologyProbability(String pseudoStr) {
        if (HomologyConstants.isAlkyl(pseudoStr)) {
            return 0.85;
        }
        if (HomologyConstants.isAlkenyl(pseudoStr) || HomologyConstants.isAlkynyl(pseudoStr)) {
            return 0.75;
        }
        if (HomologyConstants.isAryl(pseudoStr) || HomologyConstants.isCycloAlkyl(pseudoStr)) {
            return 0.6;
        }
        if (HomologyConstants.isHeteroAryl(pseudoStr) || HomologyConstants.isAliphaticHeteroCyclyl(pseudoStr) || HomologyConstants.isFusedHetero(pseudoStr)) {
            return 0.5;
        }
        if (HomologyConstants.isMetal(pseudoStr) || HomologyConstants.isAlkaliMetal(pseudoStr) || HomologyConstants.isTransitionMetal(pseudoStr) || HomologyConstants.isOtherMetal(pseudoStr)) {
            return 0.003;
        }
        if (HomologyConstants.isLanthanide(pseudoStr) || HomologyConstants.isActinide(pseudoStr)) {
            return 7.0E-4;
        }
        if (HomologyConstants.isUnknown(pseudoStr) || HomologyConstants.isAnyAtom(pseudoStr)) {
            return 1.0;
        }
        return 0.0;
    }
}

