/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.sss.search.SearchMap;
import java.util.BitSet;

public class BitSetSearchMap
implements SearchMap {
    private int queryAtomCount;
    private int targetAtomCount;
    private BitSet[] map;
    private int[] zeroedMapRow;
    private int[] zeroedMapColumn;
    private int zeroedCount;
    private int[] zmapIdxPos;

    public BitSetSearchMap(int queryAtomCount, int targetAtomCount) {
        this.queryAtomCount = queryAtomCount;
        this.targetAtomCount = targetAtomCount;
        this.map = new BitSet[queryAtomCount];
        for (int row = 0; row < queryAtomCount; ++row) {
            this.map[row] = new BitSet(targetAtomCount);
            this.map[row].set(0, targetAtomCount);
        }
        this.initMapStack();
    }

    private void initMapStack() {
        this.zeroedMapRow = new int[this.queryAtomCount * this.targetAtomCount + 3 * this.queryAtomCount];
        this.zeroedMapColumn = new int[this.queryAtomCount * this.targetAtomCount + 3 * this.queryAtomCount];
        this.zeroedCount = 0;
        this.zmapIdxPos = new int[this.queryAtomCount];
    }

    @Override
    public void update(int queryAtomCount, int targetAtomCount) {
        if (queryAtomCount > this.queryAtomCount) {
            BitSet[] newMap = new BitSet[queryAtomCount];
            System.arraycopy(this.map, 0, newMap, 0, this.queryAtomCount);
            for (int queryIndex = this.queryAtomCount; queryIndex < queryAtomCount; ++queryIndex) {
                newMap[queryIndex] = new BitSet(this.targetAtomCount);
            }
            this.map = newMap;
        }
        this.queryAtomCount = queryAtomCount;
        this.targetAtomCount = targetAtomCount;
        for (int queryIndex = 0; queryIndex < queryAtomCount; ++queryIndex) {
            this.map[queryIndex].set(0, targetAtomCount);
            this.map[queryIndex].clear(targetAtomCount, this.map[queryIndex].length());
        }
        this.zeroedMapRow = ArrayTools.initArray(this.zeroedMapRow, queryAtomCount * targetAtomCount + 3 * queryAtomCount);
        this.zeroedMapColumn = ArrayTools.initArray(this.zeroedMapColumn, queryAtomCount * targetAtomCount + 3 * queryAtomCount);
        this.zeroedCount = 0;
        this.zmapIdxPos = ArrayTools.initArray(this.zmapIdxPos, queryAtomCount);
    }

    @Override
    public void clearRowExcept(int queryAtom, int targetAtomException) {
        boolean value = this.map[queryAtom].get(targetAtomException);
        this.map[queryAtom].clear(targetAtomException);
        int currentPos = this.map[queryAtom].nextSetBit(0);
        while (currentPos >= 0) {
            this.clear(queryAtom, currentPos);
            currentPos = this.map[queryAtom].nextSetBit(currentPos + 1);
        }
        this.map[queryAtom].set(targetAtomException, value);
    }

    @Override
    public void popMap(int depth) {
        while (this.zeroedCount > this.zmapIdxPos[depth]) {
            --this.zeroedCount;
            this.map[this.zeroedMapRow[this.zeroedCount]].set(this.zeroedMapColumn[this.zeroedCount]);
        }
    }

    @Override
    public void pushMap(int depth) {
        this.zmapIdxPos[depth] = this.zeroedCount;
    }

    @Override
    public int getNextTrue(int queryAtomIndex, int firstTargetAtomToCheck) {
        return this.map[queryAtomIndex].nextSetBit(firstTargetAtomToCheck);
    }

    @Override
    public final void clearMap(int queryAtom, int targetAtom) {
        if (this.map[queryAtom].get(targetAtom)) {
            this.clear(queryAtom, targetAtom);
        }
    }

    private final void clear(int queryAtom, int targetAtom) {
        this.zeroedMapRow[this.zeroedCount] = queryAtom;
        this.zeroedMapColumn[this.zeroedCount++] = targetAtom;
        this.map[queryAtom].clear(targetAtom);
    }

    @Override
    public final void clearMapWithoutStack(int queryAtom, int targetAtom) {
        this.map[queryAtom].clear(targetAtom);
    }

    @Override
    public void clearColumnExcept(int queryAtom, int targetAtom) {
        int row;
        for (row = 0; row < queryAtom; ++row) {
            this.clearMap(row, targetAtom);
        }
        for (row = queryAtom + 1; row < this.queryAtomCount; ++row) {
            this.clearMap(row, targetAtom);
        }
    }

    @Override
    public final boolean getMap(int queryAtom, int targetAtom) {
        return this.map[queryAtom].get(targetAtom);
    }

    @Override
    public void andRowNoLog(int qInd, BitSet bitSet) {
        this.map[qInd].and(bitSet);
    }
}

