/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.sss.search.SearchMap;
import java.util.Arrays;
import java.util.BitSet;

public class BooleanArraySearchMap
implements SearchMap {
    private boolean[] map;
    private IntVector zeroedMapIdx;
    private int[] zmapIdxPos;
    private int queryAtomCount;
    private int targetAtomCount;

    public BooleanArraySearchMap(int queryAtomNumber, int targetAtomNumber) {
        this.queryAtomCount = queryAtomNumber;
        this.targetAtomCount = targetAtomNumber;
        int mapLength = queryAtomNumber * targetAtomNumber;
        this.map = ArrayTools.initArray(this.map, mapLength);
        this.initMapStack();
        Arrays.fill(this.map, true);
    }

    private void initMapStack() {
        this.zeroedMapIdx = new IntVector(this.map.length + 3 * this.queryAtomCount);
        this.zmapIdxPos = ArrayTools.initArrayAndFill(this.zmapIdxPos, this.queryAtomCount, -1);
    }

    @Override
    public void update(int queryAtomCount, int targetAtomCount) {
        this.queryAtomCount = queryAtomCount;
        this.targetAtomCount = targetAtomCount;
        int mapLength = queryAtomCount * targetAtomCount;
        this.map = ArrayTools.initArray(this.map, mapLength);
        this.initMapStack();
        Arrays.fill(this.map, true);
    }

    @Override
    public boolean getMap(int q, int t) {
        return this.map[q * this.targetAtomCount + t];
    }

    @Override
    public void clearMap(int q, int t) {
        int pos = q * this.targetAtomCount + t;
        if (this.map[pos]) {
            this.map[q * this.targetAtomCount + t] = false;
            this.zeroedMapIdx.add(pos);
        }
    }

    @Override
    public void clearMapWithoutStack(int q, int t) {
        this.map[q * this.targetAtomCount + t] = false;
    }

    @Override
    public void pushMap(int depth) {
        this.zmapIdxPos[depth] = this.zeroedMapIdx.size();
    }

    @Override
    public void popMap(int depth) {
        int zeroedMapSize = this.zeroedMapIdx.size();
        for (int i = zeroedMapSize - 1; i >= this.zmapIdxPos[depth]; --i) {
            this.map[this.zeroedMapIdx.removeLast()] = true;
        }
    }

    @Override
    public int getNextTrue(int queryAtomIndex, int firstTargetAtomToCheck) {
        for (int targetInd = firstTargetAtomToCheck; targetInd < this.targetAtomCount; ++targetInd) {
            if (!this.getMap(queryAtomIndex, targetInd)) continue;
            return targetInd;
        }
        return -1;
    }

    @Override
    public void clearRowExcept(int qAtom, int tAtomException) {
        int tIndex;
        for (tIndex = 0; tIndex < tAtomException; ++tIndex) {
            this.clearMap(qAtom, tIndex);
        }
        for (tIndex = tAtomException + 1; tIndex < this.targetAtomCount; ++tIndex) {
            this.clearMap(qAtom, tIndex);
        }
    }

    @Override
    public void clearColumnExcept(int qAtomException, int tAtom) {
        int qIndex;
        for (qIndex = 0; qIndex < qAtomException; ++qIndex) {
            this.clearMap(qIndex, tAtom);
        }
        for (qIndex = qAtomException + 1; qIndex < this.queryAtomCount; ++qIndex) {
            this.clearMap(qIndex, tAtom);
        }
    }

    @Override
    public void andRowNoLog(int qInd, BitSet bitSet) {
        int tIndex = 0;
        while ((tIndex = bitSet.nextClearBit(tIndex)) > -1) {
            this.clearMapWithoutStack(qInd, tIndex);
        }
    }
}

