/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.bracket.MixtureUtil;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.sss.search.DataSgroupComparator;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.StructureSearch;
import chemaxon.sss.search.bracket.MixtureSearchUtil;
import chemaxon.sss.search.bracket.PolymerMatcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.ArrayList;

public class BracketComparator
extends MolComparator {
    protected int[][] qSgInd = null;
    private boolean isQInitialized = false;
    protected int[] qSgCom = null;
    protected int[][] tSgInd = null;
    private boolean isTInitialized = false;
    protected int[] tSgCom = null;
    private int[][] sgMap = null;
    private boolean checkMix = false;
    private boolean checkPoly = false;
    IntVector neededTypes = null;
    private boolean isPerfectSearch = false;

    boolean isUseful(Molecule q, StructureSearch s) {
        this.checkMix = s.getSearchOptions().isMixSgroupMatching();
        this.checkPoly = s.getSearchOptions().isPolymerMatching();
        return this.checkMix && MixtureUtil.hasComponentSgroup(q) || this.checkPoly && PolymerUtil.hasPolymerSgroup(q);
    }

    @Override
    public int isUsefulForQuery() {
        if (MixtureUtil.hasComponentSgroup(this.query) || PolymerUtil.hasPolymerSgroup(this.query)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int isUsefulForTarget() {
        if (MixtureUtil.hasComponentSgroup(this.target) || PolymerUtil.hasPolymerSgroup(this.target)) {
            return 0;
        }
        return 2;
    }

    @Override
    public void setQuery(Molecule q) {
        super.setQuery(q);
        this.isQInitialized = false;
    }

    @Override
    public void setTarget(Molecule t) {
        super.setTarget(t);
        this.isTInitialized = false;
    }

    final void initialize() {
        if (!this.isQInitialized || !this.isTInitialized) {
            this.checkMix = this.searcher.getSearchOptions().isMixSgroupMatching();
            this.checkPoly = this.searcher.getSearchOptions().isPolymerMatching();
            this.neededTypes = new IntVector();
            if (this.checkMix) {
                MixtureUtil.getRelevantTypes(this.neededTypes);
            }
            if (this.checkPoly) {
                PolymerUtil.getRelevantTypes(this.neededTypes);
            }
            this.sgMap = new int[this.query.getSgroupCount()][this.target.getSgroupCount()];
            for (int i = 0; i < this.sgMap.length; ++i) {
                this.sgMap[i] = ArrayTools.initArrayAndFill(this.sgMap[i], this.sgMap[i].length, -1);
            }
            this.isPerfectSearch = this.searcher.getSearchOptions().isPerfectSearchType();
        }
        if (!this.isQInitialized) {
            this.qSgInd = BracketComparator.initSgroupData(this.query, this.qSgInd, this.neededTypes);
            this.qSgCom = this.initComponentNum(this.query, this.qSgCom);
            this.isQInitialized = true;
        }
        if (!this.isTInitialized) {
            this.tSgInd = BracketComparator.initSgroupData(this.target, this.tSgInd, this.neededTypes);
            this.tSgCom = this.initComponentNum(this.target, this.tSgCom);
            this.isTInitialized = true;
        }
    }

    private int[] initComponentNum(Molecule m, int[] sgCom) {
        int sgNum = m.getSgroupCount();
        int[] compNum = new int[sgNum];
        for (int i = 0; i < sgNum; ++i) {
            Sgroup sg = m.getSgroup(i);
            compNum[i] = MixtureUtil.getComponentNum(sg);
        }
        return compNum;
    }

    public static int[][] initSgroupData(Molecule m, int[][] sgInd, IntVector types) {
        int i;
        int sgNum = m.getSgroupCount();
        int aNum = m.getGraphUnion().getAtomCount();
        boolean[] doneSg = new boolean[sgNum];
        doneSg = ArrayTools.initArray(doneSg, sgNum);
        IntVector[] tempInd = new IntVector[aNum];
        for (i = 0; i < aNum; ++i) {
            tempInd[i] = new IntVector();
        }
        for (i = 0; i < sgNum; ++i) {
            if (doneSg[i]) continue;
            BracketComparator.setAtomsSgData(m.getSgroup(i), tempInd, m, doneSg, types);
        }
        sgInd = new int[aNum][];
        for (i = 0; i < aNum; ++i) {
            sgInd[i] = tempInd[i].toArray();
        }
        return sgInd;
    }

    private static void setAtomsSgData(Sgroup sgroup, IntVector[] tempInd, Molecule m, boolean[] doneSg, IntVector types) {
        int i;
        int sgInd = -1;
        for (i = 0; i < m.getSgroupCount(); ++i) {
            if (m.getSgroup(i) != sgroup) continue;
            sgInd = i;
            break;
        }
        if (sgInd == -1) {
            throw new IllegalArgumentException("Bad sgroup structure.");
        }
        if (doneSg[sgInd]) {
            return;
        }
        doneSg[sgInd] = true;
        for (i = 0; i < sgroup.getChildSgroupCount(); ++i) {
            BracketComparator.setAtomsSgData(sgroup.getChildSgroup(i), tempInd, m, doneSg, types);
        }
        int type = sgroup.getType();
        if (!types.contains(type)) {
            return;
        }
        for (int i2 = 0; i2 < sgroup.getAtomCount(); ++i2) {
            MolAtom atom = sgroup.getAtom(i2);
            int aInd = m.indexOf(atom);
            tempInd[aInd].add(sgInd);
        }
    }

    @Override
    public boolean compareAtoms(int a1, int a2) {
        this.initialize();
        int oaq1 = this.getOrigQueryAtomOrNeighbour(a1);
        int oat1 = this.getOrigTargetAtomOrNeighbour(a2);
        if (oaq1 == -1 || oat1 == -1) {
            return true;
        }
        int[] qSgV = this.qSgInd[oaq1];
        int[] tSgV = this.tSgInd[oat1];
        if (qSgV.length > tSgV.length) {
            return false;
        }
        boolean matching = true;
        int level = 0;
        for (level = 0; level < qSgV.length && matching; ++level) {
            int qInd = qSgV[level];
            int tInd = tSgV[level];
            if (this.sgMap[qInd][tInd] == 1) continue;
            if (this.sgMap[qInd][tInd] == -1) {
                Sgroup qSg = this.query.getSgroup(qInd);
                Sgroup tSg = this.target.getSgroup(tInd);
                if (PolymerUtil.isPolymerSgroup(qSg)) {
                    this.sgMap[qInd][tInd] = PolymerMatcher.areMatching(qSg, tSg, this.searcher.getSearchOptions()) ? 1 : 0;
                } else if (MixtureUtil.isMixForSgroup(qSg)) {
                    int n = this.sgMap[qInd][tInd] = MixtureSearchUtil.areMatching(qSg, tSg, this.qSgCom[qInd], this.tSgCom[tInd]) ? 1 : 0;
                }
                if (this.sgMap[qInd][tInd] == 1 && !this.areMatchingAttachedData(qSg, tSg)) {
                    this.sgMap[qInd][tInd] = 0;
                }
            }
            matching = this.sgMap[qInd][tInd] != 0;
        }
        if (!matching) {
            for (int i = 0; i <= level - 1; ++i) {
                this.sgMap[qSgV[i]][tSgV[i]] = 0;
            }
        }
        if (this.searcher.polymerSU != null) {
            matching &= this.searcher.polymerSU.compareCrossings(oaq1, oat1);
        }
        return matching;
    }

    private boolean areMatchingAttachedData(Sgroup qSg, Sgroup tSg) {
        Sgroup ch;
        int i;
        int attMatching = this.searcher.getSearchOptions().getAttachedDataMatch();
        if (attMatching == 0) {
            return true;
        }
        boolean isExactMatch = attMatching == 2;
        ArrayList<DataSgroup> qList = new ArrayList<DataSgroup>();
        ArrayList<DataSgroup> tList = new ArrayList<DataSgroup>();
        for (i = 0; i < qSg.getChildSgroupCount(); ++i) {
            ch = qSg.getChildSgroup(i);
            if (!(ch instanceof DataSgroup)) continue;
            qList.add((DataSgroup)ch);
        }
        for (i = 0; i < tSg.getChildSgroupCount(); ++i) {
            ch = tSg.getChildSgroup(i);
            if (!(ch instanceof DataSgroup)) continue;
            tList.add((DataSgroup)ch);
        }
        return DataSgroupComparator.areCompatibleLists(qList, tList, isExactMatch);
    }

    private int getOrigTargetAtomOrNeighbour(int a2) {
        int oat1 = this.getOrigTargetAtom(a2);
        if (oat1 == -1) {
            oat1 = this.getOrigTargetNeighbour(a2);
        }
        return oat1;
    }

    private int getOrigQueryAtomOrNeighbour(int a1) {
        int oaq1 = this.getOrigQueryAtom(a1);
        if (oaq1 == -1) {
            oaq1 = this.getOrigQueryNeighbour(a1);
        }
        return oaq1;
    }

    public int getSearchIndOfAtom(int a1, boolean isQuery) {
        return isQuery ? this.searcher.sub.idxAtomInMatomArray[a1] : this.searcher.idxAtomInMatomArray[a1];
    }

    @Override
    public boolean compareHit(int[] internalHit, int internalHitLength) {
        this.initialize();
        int lqii = internalHitLength - 1;
        int ltii = internalHit[internalHitLength - 1] - 1;
        int lqmi = this.getOrigQueryAtomOrNeighbour(lqii);
        int ltmi = this.getOrigTargetAtomOrNeighbour(ltii);
        if (lqmi == -1 || ltmi == -1) {
            return true;
        }
        int lqbl = this.qSgInd[lqmi].length;
        int level = 0;
        for (int i = 0; i < internalHitLength - 1; ++i) {
            int cqmi = this.getOrigQueryAtomOrNeighbour(i);
            int ctii = internalHit[i] - 1;
            int ctmi = this.getOrigTargetAtomOrNeighbour(ctii);
            if (ctmi == -1 || cqmi == -1) continue;
            int cqbl = this.qSgInd[cqmi].length;
            if (!this.checkTargetUpperBrackets(cqmi, lqmi, ctmi, ltmi)) {
                return false;
            }
            for (int j = cqbl - 1 - level; j >= 0 && lqbl - cqbl + j >= 0; --j) {
                int cQSg = this.qSgInd[cqmi][j];
                int lastQBracketDepth = lqbl - cqbl + j;
                int lQSg = this.qSgInd[lqmi][lastQBracketDepth];
                int cTSg = this.tSgInd[ctmi][j];
                int lTSg = this.tSgInd[ltmi][lastQBracketDepth];
                if (cQSg == lQSg) {
                    if (cTSg == lTSg) {
                        ++level;
                        continue;
                    }
                    return false;
                }
                if (cTSg == lTSg) {
                    return false;
                }
                if (j >= cqbl - 1 || lastQBracketDepth >= lqbl - 1 || this.qSgInd[cqmi][j + 1] != this.qSgInd[lqmi][lastQBracketDepth + 1]) continue;
                int cQCom = this.qSgCom[cQSg];
                int lQCom = this.qSgCom[lQSg];
                int cTCom = this.tSgCom[cTSg];
                int lTCom = this.tSgCom[lTSg];
                if ((cQCom <= lQCom || cTCom >= lTCom) && (cQCom >= lQCom || cTCom <= lTCom)) continue;
                return false;
            }
        }
        return this.searcher.polymerSU == null || this.searcher.polymerSU.checkHit(internalHit, internalHitLength);
    }

    private boolean checkTargetUpperBrackets(int cqmi, int lqmi, int ctmi, int ltmi) {
        int currLen = this.qSgInd[cqmi].length;
        int lastLen = this.qSgInd[lqmi].length;
        if (this.tSgInd[ctmi].length <= currLen && this.tSgInd[ltmi].length <= lastLen) {
            return true;
        }
        if (this.tSgInd[ctmi].length > currLen && this.tSgInd[ltmi].length > lastLen) {
            return this.tSgInd[ctmi][currLen] == this.tSgInd[ltmi][lastLen];
        }
        return false;
    }
}

