/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.Molecule;

class ConvertibleHomologyEqualTranslationMatcher
implements MoleculeMatcher {
    private Supergraph target = null;
    private StructureSearch searcher;

    ConvertibleHomologyEqualTranslationMatcher() {
    }

    @Override
    public void setTarget(Molecule molecule) {
        if (molecule instanceof Supergraph) {
            this.target = (Supergraph)molecule;
        } else assert (false) : this.getClass().getName() + " wasn't set a Supergraph target.";
    }

    @Override
    public void setQuery(Molecule molecule) {
    }

    @Override
    public void setSearcher(StructureSearch searcher) {
        this.searcher = searcher;
    }

    @Override
    public void compareAllAtoms() {
        if (this.target == null) {
            return;
        }
        for (int matomInd = 0; matomInd < this.searcher.strAtoms; ++matomInd) {
            int sgInd = this.searcher.atomIdxInAtomsArray[matomInd];
            if (sgInd < 0 || this.target.getOrigAtomIndex(sgInd) == this.target.getHomologyConvertedIndex(sgInd) || HomologyConversionUtil.hasEqualTranslationProperty(this.target.getAtom(sgInd))) continue;
            this.searcher.clearColumn(matomInd);
        }
    }

    @Override
    public boolean isSpecialQueryH(int atomInd) {
        return false;
    }

    @Override
    public boolean isSpecialTargetH(int atomInd) {
        return false;
    }

    @Override
    public boolean refine() {
        return false;
    }
}

