/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.ratom.LigandHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Arrays;

public class Decomposition {
    public static final int ATTACHMENT_NONE = 0;
    public static final int ATTACHMENT_POINT = 1;
    public static final int ATTACHMENT_MAP = 2;
    public static final int ATTACHMENT_LABEL = 3;
    public static final int ATTACHMENT_RLABEL = 5;
    public static final int ATTACHMENT_ATOM = 4;
    private static final String SEPARATOR = ";";
    private Molecule origQuery;
    private Molecule origTarget;
    private Molecule query;
    private Molecule target;
    private int[][] groupHit;
    private Molecule[] ligands;
    private Molecule scaffold;
    private int attachmentType;
    private int[] qRoot = null;
    private int[] ligandIds = null;

    protected Decomposition(Molecule query, Molecule target, int[][] groupHit, Molecule[] ligands, Molecule scaffold, int attachmentType) {
        this.query = query;
        this.target = target;
        this.groupHit = groupHit;
        this.ligands = ligands;
        this.scaffold = scaffold;
        this.attachmentType = attachmentType;
        this.init();
    }

    private void init() {
        this.setQRoot();
        this.origQuery = this.query;
        this.origTarget = this.target;
        this.query = this.query.cloneMolecule();
        this.target = this.target.cloneMolecule();
        this.ligands = this.cloneLigands();
        this.scaffold = this.scaffold.cloneMolecule();
        LigandHandler.clearAttachQueryIndexes(this.scaffold);
        this.setLigandIds();
    }

    private void setQRoot() {
        this.qRoot = new int[this.query.getAtomCount()];
        block0: for (int i = 0; i < this.qRoot.length; ++i) {
            if (this.ligands[i] == null) {
                this.qRoot[i] = i;
                continue;
            }
            for (int j = 0; j <= i; ++j) {
                if (this.ligands[j] != this.ligands[i]) continue;
                this.qRoot[i] = j;
                continue block0;
            }
        }
    }

    private Molecule[] cloneLigands() {
        Molecule[] mols = new Molecule[this.ligands.length];
        for (int i = 0; i < mols.length; ++i) {
            if (this.ligands[i] == null) continue;
            if (this.qRoot[i] < i) {
                mols[i] = mols[this.qRoot[i]];
                continue;
            }
            mols[i] = this.ligands[i].cloneMolecule();
            LigandHandler.clearAttachQueryIndexes(mols[i]);
        }
        return mols;
    }

    private void setLigandIds() {
        this.ligandIds = new int[this.target.getAtomCount()];
        Arrays.fill(this.ligandIds, -2);
        for (int i = 0; i < this.groupHit.length; ++i) {
            if (this.query.getAtom(i).getAtno() != 134) {
                assert (this.groupHit[i].length == 1);
                if (this.groupHit[i][0] < 0) continue;
                this.ligandIds[this.groupHit[i][0]] = -1;
                continue;
            }
            for (int targetIndex : this.groupHit[i]) {
                if (targetIndex < 0 || this.ligandIds[targetIndex] != -2) continue;
                this.ligandIds[targetIndex] = i;
            }
        }
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Decomposition)) {
            return false;
        }
        Decomposition d = (Decomposition)o;
        if (this.origQuery != d.origQuery || this.origTarget != d.origTarget) {
            return false;
        }
        assert (this.ligandIds.length == d.ligandIds.length);
        for (int i2 = 0; i2 < this.ligandIds.length; ++i2) {
            if (!(this.ligandIds[i2] < 0 || d.ligandIds[i2] < 0 ? this.ligandIds[i2] != d.ligandIds[i2] : this.origQuery.getAtom(this.ligandIds[i2]).getRgroup() != this.origQuery.getAtom(d.ligandIds[i2]).getRgroup())) continue;
            return false;
        }
        int targetAtomCount = this.origTarget.getAtomCount();
        int h1 = 0;
        int h2 = 0;
        int[] implh2rmapdiff = new int[this.origQuery.getAtomCount()];
        for (i = 0; i < implh2rmapdiff.length; ++i) {
            int m;
            if (this.groupHit[i].length == 1 && (m = this.groupHit[i][0]) < 0 && (m == Integer.MIN_VALUE || m > -targetAtomCount)) {
                int n = i;
                implh2rmapdiff[n] = implh2rmapdiff[n] + this.origQuery.getAtom(i).getRgroup();
                ++h1;
            }
            if (d.groupHit[i].length != 1 || (m = d.groupHit[i][0]) >= 0 || m != Integer.MIN_VALUE && m <= -targetAtomCount) continue;
            int n = i;
            implh2rmapdiff[n] = implh2rmapdiff[n] - this.origQuery.getAtom(i).getRgroup();
            ++h2;
        }
        if (h1 != h2) {
            return false;
        }
        for (i = 0; i < implh2rmapdiff.length; ++i) {
            if (implh2rmapdiff[i] == 0) continue;
            for (int j = i + 1; j < implh2rmapdiff.length; ++j) {
                if (implh2rmapdiff[j] + implh2rmapdiff[i] != 0) continue;
                implh2rmapdiff[i] = 0;
                implh2rmapdiff[j] = 0;
                break;
            }
            if (implh2rmapdiff[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Molecule getQuery() {
        return this.query;
    }

    public Molecule getTarget() {
        return this.target;
    }

    public int[][] getGroupHit() {
        return this.groupHit;
    }

    public Molecule[] getLigands() {
        return this.ligands;
    }

    public Molecule getScaffold() {
        return this.scaffold;
    }

    public int[] getLigandIds() {
        return this.ligandIds;
    }

    private int getQIndex(int i) {
        if (this.ligands[i] == null) {
            return i;
        }
        for (int j = 0; j < i; ++j) {
            if (this.ligands[j] != this.ligands[i]) continue;
            return j;
        }
        return i;
    }

    public void color() {
        Decomposition.color(this.scaffold);
        Decomposition.color(this.query);
        for (int i = 0; i < this.groupHit.length; ++i) {
            Molecule ligand;
            int c = this.query.getAtom(this.qRoot[i]).getSetSeq();
            for (int t : this.groupHit[i]) {
                if (t < 0) continue;
                this.target.getAtom(t).setSetSeq(c);
            }
            if (this.qRoot[i] != i || (ligand = this.ligands[i]) == null) continue;
            for (int j = ligand.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom;
                atom.setSetSeq(LigandHandler.isAttachmentAtom(atom = ligand.getAtom(j)) ? 1 : c);
            }
        }
    }

    public static void color(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            atom.setSetSeq(atom.getRgroup() + 1);
        }
    }

    public void color(String colorTag) {
        Decomposition.color(this.scaffold, colorTag);
        Decomposition.color(this.query, colorTag);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.groupHit.length; ++i) {
            Molecule ligand;
            if (this.qRoot[i] != i || (ligand = this.ligands[i]) == null) continue;
            int c = this.query.getAtom(this.qRoot[i]).getRgroup();
            int count = ligand.getAtomCount();
            for (int j = 0; j < count; ++j) {
                MolAtom atom = ligand.getAtom(j);
                b.append("" + (LigandHandler.isAttachmentAtom(atom) ? 0 : c) + SEPARATOR);
            }
            if (b.length() > 0) {
                ligand.setProperty(colorTag, b.substring(0, b.length() - 1));
                b.setLength(0);
                continue;
            }
            ligand.setProperty(colorTag, null);
        }
        for (int m : this.ligandIds) {
            b.append(this.getCode(m) + SEPARATOR);
        }
        if (b.length() > 0) {
            this.target.setProperty(colorTag, b.substring(0, b.length() - 1));
        } else {
            this.target.setProperty(colorTag, null);
        }
    }

    private String getCode(int m) {
        switch (m) {
            case -2: {
                return "-";
            }
            case -1: {
                return "0";
            }
        }
        return "" + this.query.getAtom(m).getRgroup();
    }

    public static void color(Molecule mol, String colorTag) {
        StringBuffer b = new StringBuffer();
        int count = mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            b.append("" + mol.getAtom(i).getRgroup() + SEPARATOR);
        }
        if (b.length() > 0) {
            mol.setProperty(colorTag, b.substring(0, b.length() - 1));
        } else {
            mol.setProperty(colorTag, null);
        }
    }
}

