/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;

public class DuplicateCheck {
    private MolSearch search = new MolSearch();

    public DuplicateCheck() {
        this.search.setSearchOptions(new MolSearchOptions(5));
    }

    public void setSearchOptions(MolSearchOptions options) {
        this.search.setSearchOptions(options);
    }

    public MolSearchOptions getSearchOptions() {
        return this.search.getSearchOptions();
    }

    public boolean containsRgroupMember(RgMolecule rgmol, int rid, Molecule rgroup) throws SearchException {
        return this.getRgroupMember(rgmol, rid, rgroup) != null;
    }

    public Molecule getRgroupMember(RgMolecule rgmol, int rid, Molecule rgroup) throws SearchException {
        int rgindex = rgmol.findRgroupIndex(rid);
        if (rgindex == -1) {
            return null;
        }
        int memberIndex = this.getRgroupMemberIndex(rgmol, rgindex, rgroup);
        return memberIndex != -1 ? rgmol.getRgroupMember(rgindex, memberIndex) : null;
    }

    public int getRgroupMemberIndex(RgMolecule rgmol, int rgindex, Molecule rgroup) throws SearchException {
        this.search.setQuery(rgroup);
        for (int i = rgmol.getRgroupMemberCount(rgindex) - 1; i >= 0; --i) {
            this.search.setTarget(rgmol.getRgroupMember(rgindex, i));
            if (!this.search.isMatching()) continue;
            return i;
        }
        return -1;
    }
}

