/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.MatchCountOptions;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.options.HaltOnErrorOption;
import chemaxon.sss.search.options.MarkushScreeningType;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

public class JChemSearchOptions
extends SearchOptions
implements Serializable,
SearchConstants,
Cloneable {
    private static final String[] optionNames = new String[]{"absoluteStereo", "maxTime", "maxResults", "optimizeQueries", "dissimilarityMetric", "dissimilarityMetricParameters", "returnNonHits", "filterQuery", "descriptorConfig", "descriptorName", "matchCountOptions", "formulaSearchType", "formulaSearchQuery", "markushScreening", "haltOnError"};
    private int absoluteStereo = 0;
    private String filterQuery;
    private float dissimilarityThreshold = 0.3f;
    private boolean dissimilarityThresholdExcluded;
    private long maxTime;
    private int maxResultCount;
    private boolean returnsNonHits = false;
    private String dissimilarityMetric = null;
    private String dissimilarityMetricParameters = null;
    private String descriptorConfig = null;
    private String descriptorName = null;
    private int formulaSearchType;
    private String formulaSearchQuery = null;
    private MatchCountOptions matchCountOptions;
    private boolean optimizeQueries = true;
    private boolean cacheRegistrationNeeded = true;
    private Set<MarkushScreeningType> markushScreeningOptions = EnumSet.allOf(MarkushScreeningType.class);
    private HaltOnErrorOption haltOnError = HaltOnErrorOption.DEFAULT;

    @Deprecated
    public JChemSearchOptions() {
        super(2);
    }

    public JChemSearchOptions(int searchType) {
        super(searchType);
    }

    private void enableAllMarkushScreeningTypes() {
        for (MarkushScreeningType mso : MarkushScreeningType.values()) {
            this.markushScreeningOptions.add(mso);
        }
    }

    private void disableAllMarkushScreeningTypes() {
        this.markushScreeningOptions.clear();
    }

    public void setAbsoluteStereo(int absoluteStereo) {
        if (absoluteStereo != this.absoluteStereo) {
            this.absoluteStereo = absoluteStereo;
            this.setDirty(true);
        }
    }

    public int getAbsoluteStereo() {
        return this.absoluteStereo;
    }

    public void setFormulaSearchType(int formulaSearchType) {
        if (this.formulaSearchType != formulaSearchType) {
            this.formulaSearchType = formulaSearchType;
            this.setDirty(true);
        }
    }

    public int getFormulaSearchType() {
        return this.formulaSearchType;
    }

    public void setFormulaSearchQuery(String formulaSearchQuery) {
        if (this.formulaSearchQuery == null || formulaSearchQuery == null || !formulaSearchQuery.equals(this.formulaSearchQuery)) {
            this.formulaSearchQuery = formulaSearchQuery;
            this.setDirty(true);
        }
    }

    public String getFormulaSearchQuery() {
        return this.formulaSearchQuery;
    }

    public String getFilterQuery() {
        return this.filterQuery;
    }

    public void setFilterQuery(String filterQuery) {
        if (this.filterQuery == null || filterQuery == null || !this.filterQuery.equals(filterQuery)) {
            this.filterQuery = filterQuery;
            this.setDirty(true);
        }
    }

    public void setDissimilarityThreshold(float dissimilarityThreshold) {
        if (this.dissimilarityThreshold != dissimilarityThreshold) {
            this.dissimilarityThreshold = dissimilarityThreshold;
            this.setDirty(true);
        }
    }

    public float getDissimilarityThreshold() {
        return this.dissimilarityThreshold;
    }

    public void setDissimilarityThresholdExcluded(boolean thresholdExcluded) {
        if (this.dissimilarityThresholdExcluded != thresholdExcluded) {
            this.dissimilarityThresholdExcluded = thresholdExcluded;
            this.setDirty(true);
        }
    }

    public boolean isDissimilarityThresholdExcluded() {
        return this.dissimilarityThresholdExcluded;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        if (this.maxTime != maxTime) {
            this.maxTime = maxTime;
            this.setDirty(true);
        }
    }

    public int getMaxResultCount() {
        return this.maxResultCount;
    }

    public void setMaxResultCount(int maxResultCount) throws IllegalArgumentException {
        if (maxResultCount < 0) {
            throw new IllegalArgumentException("The maxResultCount cannot be negative number");
        }
        if (this.maxResultCount != maxResultCount) {
            this.maxResultCount = maxResultCount;
            this.setDirty(true);
        }
    }

    public void setReturnsNonHits(boolean returnsNonHits) {
        if (returnsNonHits != this.returnsNonHits) {
            this.returnsNonHits = returnsNonHits;
            this.setDirty(true);
        }
    }

    public boolean isReturnsNonHits() {
        return this.returnsNonHits;
    }

    public void setDissimilarityMetric(String dissimilarityMetric) {
        if (dissimilarityMetric == null || !dissimilarityMetric.equalsIgnoreCase(this.dissimilarityMetric)) {
            this.dissimilarityMetric = dissimilarityMetric;
            this.setDirty(true);
        }
    }

    public String getDissimilarityMetric() {
        return this.dissimilarityMetric;
    }

    public void setDissimilarityMetricParameters(String dissimilarityMetricParam) {
        if (dissimilarityMetricParam == null || !dissimilarityMetricParam.equalsIgnoreCase(this.dissimilarityMetricParameters)) {
            this.dissimilarityMetricParameters = dissimilarityMetricParam;
            this.setDirty(true);
        }
    }

    public String getDissimilarityMetricParameters() {
        return this.dissimilarityMetricParameters;
    }

    public void setDescriptorConfig(String descriptorConfig) {
        if (!descriptorConfig.equalsIgnoreCase(this.descriptorConfig)) {
            this.descriptorConfig = descriptorConfig;
            this.setDirty(true);
        }
    }

    public String getDescriptorConfig() {
        return this.descriptorConfig;
    }

    public void setDescriptorName(String descriptorName) {
        if (!descriptorName.equalsIgnoreCase(this.descriptorName)) {
            this.descriptorName = descriptorName;
            this.setDirty(true);
        }
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setMatchCountOptions(MatchCountOptions matchCountOptions) {
        this.matchCountOptions = matchCountOptions;
    }

    public MatchCountOptions getMatchCountOptions() {
        return this.matchCountOptions;
    }

    public boolean isOptimizeQueries() {
        return this.optimizeQueries;
    }

    public void setOptimizeQueries(boolean value) {
        if (this.optimizeQueries != value) {
            this.optimizeQueries = value;
            this.setDirty(true);
        }
    }

    public void setCacheRegistrationNeeded(boolean value) {
        this.cacheRegistrationNeeded = value;
    }

    public boolean isCacheRegistrationNeeded() {
        return this.cacheRegistrationNeeded;
    }

    public void setMarkushScreeningEnabled(boolean value) {
        if (value) {
            this.enableAllMarkushScreeningTypes();
        } else {
            this.disableAllMarkushScreeningTypes();
        }
    }

    public boolean isMarkushScreeningEnabled() {
        return this.markushScreeningOptions.size() > 0;
    }

    public void setMarkushScreeningType(MarkushScreeningType type, boolean enabled) {
        if (enabled) {
            this.markushScreeningOptions.add(type);
        } else {
            this.markushScreeningOptions.remove((Object)type);
        }
    }

    public void setMarkushScreeningTypes(String types) {
        this.disableAllMarkushScreeningTypes();
        if (types == null) {
            this.enableAllMarkushScreeningTypes();
        } else if (!types.equals("")) {
            String[] parts;
            for (String typeString : parts = types.split(",")) {
                this.markushScreeningOptions.add(MarkushScreeningType.fromString(typeString));
            }
        }
    }

    public boolean getMarkushScreeningType(MarkushScreeningType type) {
        return this.markushScreeningOptions.contains((Object)type);
    }

    public void setHaltOnError(HaltOnErrorOption value) {
        this.haltOnError = value;
    }

    public HaltOnErrorOption getHaltOnError() {
        return this.haltOnError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setOption(String name, String value) {
        if ("absoluteStereo".equalsIgnoreCase(name) || "DBAbsoluteStereo".equalsIgnoreCase(name)) {
            if (value.equalsIgnoreCase("T")) {
                this.setAbsoluteStereo(0);
                return;
            } else if (value.equalsIgnoreCase("C")) {
                this.setAbsoluteStereo(1);
                return;
            } else {
                if (!value.equalsIgnoreCase("A")) throw new IllegalArgumentException("Illegal value for option " + name + ": " + value);
                this.setAbsoluteStereo(2);
            }
            return;
        } else if ("maxTime".equalsIgnoreCase(name)) {
            this.setMaxTime(Long.parseLong(value));
            return;
        } else if ("maxResults".equalsIgnoreCase(name) || "maxHitCount".equalsIgnoreCase(name)) {
            this.setMaxResultCount(Integer.parseInt(value));
            return;
        } else if ("optimizeQueries".equalsIgnoreCase(name)) {
            this.setOptimizeQueries(JChemSearchOptions.getBoolean(value));
            return;
        } else if ("dissimilarityThreshold".equalsIgnoreCase(name) || "simThreshold".equalsIgnoreCase(name)) {
            this.setDissimilarityThreshold(Float.parseFloat(value));
            return;
        } else if ("dissimilarityThresholdExcluded".equalsIgnoreCase(name)) {
            this.setDissimilarityThresholdExcluded(JChemSearchOptions.getBoolean(value));
            return;
        } else if ("dissimilarityMetric".equalsIgnoreCase(name)) {
            this.setDissimilarityMetric(value);
            return;
        } else if ("dissimilarityMetricParameters".equalsIgnoreCase(name)) {
            this.setDissimilarityMetricParameters(value);
            return;
        } else if ("returnNonHits".equalsIgnoreCase(name)) {
            this.setReturnsNonHits(JChemSearchOptions.getBoolean(value));
            return;
        } else if ("filterQuery".equalsIgnoreCase(name)) {
            this.setFilterQuery(value);
            return;
        } else if ("descriptorConfig".equalsIgnoreCase(name)) {
            this.setDescriptorConfig(value);
            return;
        } else if ("descriptorName".equalsIgnoreCase(name)) {
            this.setDescriptorName(value);
            return;
        } else if ("formulaSearchType".equalsIgnoreCase(name)) {
            this.setFormulaSearchType(Integer.parseInt(value));
            return;
        } else if ("formulaSearchQuery".equalsIgnoreCase(name)) {
            this.setFormulaSearchQuery(value);
            return;
        } else if ("matchCountOptions".equalsIgnoreCase(name)) {
            String[] values = value.split(MatchCountOptions.optionSeparator);
            switch (values.length) {
                case 2: {
                    this.setMatchCountOptions(new MatchCountOptions(values[0], Integer.parseInt(values[1])));
                    return;
                }
                case 4: {
                    this.setMatchCountOptions(new MatchCountOptions(Integer.parseInt(values[0]), Boolean.parseBoolean(values[1]), Integer.parseInt(values[2]), Boolean.parseBoolean(values[3])));
                    return;
                }
                default: {
                    throw new InvalidParameterException("Invalid number of parameters!");
                }
            }
        } else if ("markushScreening".equalsIgnoreCase(name)) {
            String[] parts = (value + " ").split(":");
            if (parts.length != 2 && parts.length != 1) throw new IllegalArgumentException("Invalid markush screening option value");
            boolean enabled = JChemSearchOptions.getBoolean(parts[0].trim());
            this.setMarkushScreeningEnabled(enabled);
            if (!enabled || parts.length != 2) return;
            this.disableAllMarkushScreeningTypes();
            this.setMarkushScreeningTypes(parts[1].trim());
            return;
        } else if ("haltOnError".equalsIgnoreCase(name)) {
            this.setHaltOnError(HaltOnErrorOption.fromString(value));
            return;
        } else {
            super.setOption(name, value);
        }
    }

    @Override
    public String getOption(String name) {
        if ("absoluteStereo".equalsIgnoreCase(name) || "DBAbsoluteStereo".equalsIgnoreCase(name)) {
            int iValue = this.getAbsoluteStereo();
            if (iValue == 0) {
                return "T";
            }
            if (iValue == 1) {
                return "C";
            }
            if (iValue == 2) {
                return "A";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("maxTime".equalsIgnoreCase(name)) {
            return String.valueOf(this.getMaxTime());
        }
        if ("maxResults".equalsIgnoreCase(name) || "maxHitCount".equalsIgnoreCase(name)) {
            return String.valueOf(this.getMaxResultCount());
        }
        if ("optimizeQueries".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isOptimizeQueries());
        }
        if ("dissimilarityMetric".equalsIgnoreCase(name)) {
            return this.getDissimilarityMetric();
        }
        if ("dissimilarityMetricParameters".equalsIgnoreCase(name)) {
            return this.getDissimilarityMetricParameters();
        }
        if ("dissimilarityThreshold".equalsIgnoreCase(name) || "simThreshold".equalsIgnoreCase(name)) {
            return String.valueOf(this.getDissimilarityThreshold());
        }
        if ("dissimilarityThresholdExcluded".equalsIgnoreCase(name)) {
            return String.valueOf(this.isDissimilarityThresholdExcluded());
        }
        if ("returnNonHits".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isReturnsNonHits());
        }
        if ("filterQuery".equalsIgnoreCase(name)) {
            return this.getFilterQuery();
        }
        if ("descriptorConfig".equalsIgnoreCase(name)) {
            return this.getDescriptorConfig();
        }
        if ("descriptorName".equalsIgnoreCase(name)) {
            return this.getDescriptorName();
        }
        if ("formulaSearchQuery".equalsIgnoreCase(name)) {
            return this.getFormulaSearchQuery();
        }
        if ("formulaSearchType".equalsIgnoreCase(name)) {
            return Integer.toString(this.getFormulaSearchType());
        }
        if ("matchCountOptions".equalsIgnoreCase(name)) {
            if (this.matchCountOptions == null) {
                return null;
            }
            return this.matchCountOptions.toString();
        }
        if ("markushScreening".equalsIgnoreCase(name)) {
            StringBuilder sb = new StringBuilder();
            boolean markushScreeningEnabled = this.markushScreeningOptions.size() > 0;
            return (markushScreeningEnabled ? "y" : "n") + sb.toString();
        }
        if ("haltOnError".equalsIgnoreCase(name)) {
            return String.valueOf((Object)this.haltOnError);
        }
        return super.getOption(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JChemSearchOptions jso = (JChemSearchOptions)super.clone();
        this.clonecopy(jso);
        return jso;
    }

    @Override
    public void clonecopy(SearchOptions other) {
        super.clonecopy(other);
        this.copyOptions(other);
    }

    @Override
    public void clonecopyOptions(SearchOptions other) {
        super.clonecopyOptions(other);
        this.copyOptions(other);
    }

    private void copyOptions(SearchOptions other) {
        if (other instanceof JChemSearchOptions) {
            JChemSearchOptions jso = (JChemSearchOptions)other;
            jso.absoluteStereo = this.absoluteStereo;
            jso.filterQuery = this.filterQuery;
            jso.dissimilarityThreshold = this.dissimilarityThreshold;
            jso.dissimilarityThresholdExcluded = this.dissimilarityThresholdExcluded;
            jso.maxTime = this.maxTime;
            jso.maxResultCount = this.maxResultCount;
            jso.returnsNonHits = this.returnsNonHits;
            jso.dissimilarityMetric = this.dissimilarityMetric;
            jso.dissimilarityMetricParameters = this.dissimilarityMetricParameters;
            jso.descriptorConfig = this.descriptorConfig;
            jso.descriptorName = this.descriptorName;
            jso.matchCountOptions = this.matchCountOptions;
            jso.optimizeQueries = this.optimizeQueries;
            jso.cacheRegistrationNeeded = this.cacheRegistrationNeeded;
            jso.formulaSearchQuery = this.formulaSearchQuery;
            jso.formulaSearchType = this.formulaSearchType;
            jso.markushScreeningOptions = EnumSet.copyOf(this.markushScreeningOptions);
            jso.haltOnError = this.haltOnError;
        }
    }

    @Override
    public ArrayList<String> toList() {
        ArrayList<String> ret = new ArrayList<String>();
        JChemSearchOptions jso = new JChemSearchOptions(2);
        String searchType = this.getOption("t");
        if (!searchType.equalsIgnoreCase(jso.getOption("t"))) {
            ret.add("t:" + searchType);
            jso.setOption("t", searchType);
        }
        String dissimT = this.getOption("dissimilarityThreshold");
        if (searchType.equalsIgnoreCase("i") || !dissimT.equalsIgnoreCase(jso.getOption("dissimilarityThreshold"))) {
            ret.add("dissimilarityThreshold:" + dissimT);
        }
        this.fillOptionList(ret, jso);
        return ret;
    }

    @Override
    protected String[] getOptionNames() {
        return ArrayTools.concatArrays(super.getOptionNames(), optionNames);
    }
}

