/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.marvin.modules.MCES;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import chemaxon.util.MolHandler;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;

public class MCES
implements Licensable {
    public static final int DEFAULT_MIN_COMPONENT_SIZE = 5;
    private chemaxon.marvin.modules.MCES mces = new chemaxon.marvin.modules.MCES();
    private String licenseEnvironment = "";
    private static final String NL = System.getProperty("line.separator");
    private static final String PRG_HEADER = NL + "MCS - Maximum Common Structure Search " + VersionInfo.JCHEM_VERSION + ", (C) 2004-2012 ChemAxon Ltd." + NL;
    private static final String USAGE_INFO = PRG_HEADER + "Finds the largest common substructure of two molecules." + NL + "" + NL + "Usage: mcs [options] " + NL + "" + NL + "Options: " + NL + "  -h, --help                this help message" + NL + "  -v, --verbose             verbose mode" + NL + "  -q, --query <string>      query structure string or file name" + NL + "                              (multiple queries are allowed)" + NL + "  -t, --target <string>     target structure string or file name" + NL + "                              (multiple targets are allowed)" + NL + "  -o, --output <filepath>   output file path and name" + NL + "  -f, --format CSV          output format" + NL + "  -w, --view                display the molecules with the MCS highlighted" + NL + "  -g, --grid                display common substructures in a grid view" + NL + "                              (for multiple queries and/or targets)" + NL + "  -a, --atommaps            mark matching atoms with map numbers" + NL + "                              (only in -w mode)" + NL + "  -c, --check ( a[tomtype] | b[ondtype] | c[harge] | h[ybridization] |" + NL + "                i[sotopes] | m[apnumber] )" + NL + "                            atom and bond matching mode" + NL + "                              A + or - sign after each property indicates if it" + NL + "                              should be checked or not. By default, only atom" + NL + "                              and bond types are checked." + NL + "  -s, --size <size>         minimum required size of components" + NL + "                              (the default is " + 5 + ")" + NL + "  -l, --largest             keep only the largest component" + NL + "  -m, --mode ( f[ast] | s[tandard] | e[xhaustive] )" + NL + "                            search mode (controls speed and accuracy)" + NL + "" + NL;
    private static final String EXAMPLES = "" + NL + "Examples:" + NL + "  1) Search MCS of cyclohexane and the structure given in file struc.smiles" + NL + "     and display result:" + NL + "       mcs -q \"C1CCCCC1\" -t struc.smiles -w" + NL + "" + NL + "  2) Search MCS of the structures given in files q.smiles and struc.smiles" + NL + "     and print results to a file in CSV format:" + NL + "       mcs -q q.smiles -t struc.smiles -f csv -o output.csv" + NL + "" + NL + "  3) Search the above files by matching charges but without matching bond types" + NL + "     and keep only the largest component of MCS:" + NL + "       mcs -q q.smiles -t struc.smiles -c b- c+ -l -w" + NL + "" + NL + "  4) Search multiple queries against mutiple targets and display pairwise MCS" + NL + "     in a table (grid view):" + NL + "       mcs -q queries.smiles -t targets.smiles -g" + NL + "" + NL;
    private static final int OUTPUT_NORMAL = 0;
    private static final int OUTPUT_CSV = 1;
    private static final int DISPLAY_NONE = 0;
    private static final int DISPLAY_VIEW = 1;
    private static final int DISPLAY_GRID = 2;
    private static boolean clVerbose = false;
    private static int clOutputType = 0;
    private static int clDisplayType = 0;
    private static boolean clAtomMaps = false;
    private static PrintStream clOut = System.out;
    private static Locale clLocale = Locale.ENGLISH;
    private static List<Molecule> clQueries = null;
    private static List<Molecule> clTargets = null;
    private static List<String> clQueryStrings = null;
    private static List<String> clTargetStrings = null;
    private static int clQueryCount;
    private static int clTargetCount;
    private static int clPairCount;
    private static MViewPane clResultView;
    private static MCES clMCES;
    private static final Color NONHIT_COLOR;
    private static final Color HIT_COLOR;

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("MCES", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("MCES", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecules(Molecule query, Molecule target) {
        this.mces.setMolecules(query, target);
    }

    public void setQueryMolecule(Molecule query) {
        this.mces.setQueryMolecule(query);
    }

    public void setTargetMolecule(Molecule target) {
        this.mces.setTargetMolecule(target);
    }

    public Molecule getQueryMolecule() {
        return this.mces.getQueryMolecule();
    }

    public Molecule getTargetMolecule() {
        return this.mces.getTargetMolecule();
    }

    public void enableAromatization() {
        this.mces.enableAromatization();
    }

    public void enableAromatization(int method) {
        this.mces.enableAromatization(method);
    }

    public void disableAromatization() {
        this.mces.disableAromatization();
    }

    public int getAromatizationMethod() {
        return this.mces.getAromatizationMethod();
    }

    public void setSearchMode(SearchMode mode) {
        switch (mode) {
            case FAST: {
                this.mces.setSearchMode(MCES.SearchMode.FAST);
                break;
            }
            case STANDARD: {
                this.mces.setSearchMode(MCES.SearchMode.STANDARD);
                break;
            }
            case EXHAUSTIVE: {
                this.mces.setSearchMode(MCES.SearchMode.EXHAUSTIVE);
            }
        }
    }

    public SearchMode getSearchMode() {
        switch (this.mces.getSearchMode()) {
            case FAST: {
                return SearchMode.FAST;
            }
            case EXHAUSTIVE: {
                return SearchMode.EXHAUSTIVE;
            }
        }
        return SearchMode.STANDARD;
    }

    public void setAtomTypeMatch(boolean match) {
        this.mces.setAtomTypeMatch(match);
    }

    public void setBondTypeMatch(boolean match) {
        this.mces.setBondTypeMatch(match);
    }

    public void setChargeMatch(boolean match) {
        this.mces.setChargeMatch(match);
    }

    public void setHybridizationMatch(boolean match) {
        this.mces.setHybridizationMatch(match);
    }

    public void setIsotopeMatch(boolean match) {
        this.mces.setIsotopeMatch(match);
    }

    public void setAtomMapMatch(boolean match) {
        this.mces.setAtomMapMatch(match);
    }

    public boolean getAtomTypeMatch() {
        return this.mces.getAtomTypeMatch();
    }

    public boolean getBondTypeMatch() {
        return this.mces.getBondTypeMatch();
    }

    public boolean getChargeMatch() {
        return this.mces.getChargeMatch();
    }

    public boolean getHybridizationMatch() {
        return this.mces.getHybridizationMatch();
    }

    public boolean getIsotopeMatch() {
        return this.mces.getIsotopeMatch();
    }

    public boolean getAtomMapMatch() {
        return this.mces.getAtomMapMatch();
    }

    public void setMinComponentSize(int bondCount) {
        this.mces.setMinComponentSize(bondCount);
    }

    public int getMinComponentSize() {
        return this.mces.getMinComponentSize();
    }

    public void setKeepLargestComponent(boolean keepLargest) {
        this.mces.setKeepLargestComponent(keepLargest);
    }

    public boolean getKeepLargestComponent() {
        return this.mces.getKeepLargestComponent();
    }

    public void setStepCountLimit(int maxStepCount) {
        this.mces.setStepCountLimit(maxStepCount);
    }

    public int getStepCountLimit() {
        return this.mces.getStepCountLimit();
    }

    public void setTimeLimit(long maxMilliseconds) {
        this.mces.setTimeLimit(maxMilliseconds);
    }

    public long getTimeLimit() {
        return this.mces.getTimeLimit();
    }

    public boolean search() {
        this.checkLicense();
        return this.mces.search();
    }

    public int getAtomCount() {
        return this.mces.getAtomCount();
    }

    public int getBondCount() {
        return this.mces.getBondCount();
    }

    public int getComponentCount() {
        return this.mces.getComponentCount();
    }

    public int[] getAtomMapping() {
        return this.mces.getAtomMapping();
    }

    public int[] getAtomReverseMapping() {
        return this.mces.getAtomReverseMapping();
    }

    public int[] getBondMapping() {
        return this.mces.getBondMapping();
    }

    public int[] getBondReverseMapping() {
        return this.mces.getBondReverseMapping();
    }

    public MolAtom[] getMatchedQueryAtoms() {
        return this.mces.getMatchedQueryAtoms();
    }

    public MolBond[] getMatchedQueryBonds() {
        return this.mces.getMatchedQueryBonds();
    }

    public MolAtom[] getMatchedTargetAtoms() {
        return this.mces.getMatchedTargetAtoms();
    }

    public MolBond[] getMatchedTargetBonds() {
        return this.mces.getMatchedTargetBonds();
    }

    public MolAtom[] getUnmatchedQueryAtoms() {
        return this.mces.getUnmatchedQueryAtoms();
    }

    public MolBond[] getUnmatchedQueryBonds() {
        return this.mces.getUnmatchedQueryBonds();
    }

    public MolAtom[] getUnmatchedTargetAtoms() {
        return this.mces.getUnmatchedTargetAtoms();
    }

    public MolBond[] getUnmatchedTargetBonds() {
        return this.mces.getUnmatchedTargetBonds();
    }

    public Molecule getAsMolecule() {
        return this.mces.getAsMolecule();
    }

    public TerminationCause getTerminationCause() {
        switch (this.mces.getTerminationCause()) {
            case OPTIMAL: {
                return TerminationCause.OPTIMAL;
            }
            case TIME_LIMIT: {
                return TerminationCause.TIME_LIMIT;
            }
            case STEP_LIMIT: {
                return TerminationCause.STEP_LIMIT;
            }
        }
        return TerminationCause.FINISHED;
    }

    private static void setMatchProperty(String matchStr) {
        boolean flag = !matchStr.endsWith("-");
        char ch = matchStr.charAt(0);
        if (ch == 'a' || matchStr.startsWith("atomtype")) {
            clMCES.setAtomTypeMatch(flag);
        } else if (ch == 'b' || matchStr.startsWith("bondtype")) {
            clMCES.setBondTypeMatch(flag);
        } else if (ch == 'c' || matchStr.startsWith("charge")) {
            clMCES.setChargeMatch(flag);
        } else if (ch == 'h' || matchStr.startsWith("hybridization")) {
            clMCES.setHybridizationMatch(flag);
        } else if (ch == 'i' || matchStr.startsWith("isotope")) {
            clMCES.setIsotopeMatch(flag);
        } else if (ch == 'm' || matchStr.startsWith("map")) {
            clMCES.setAtomMapMatch(flag);
        } else {
            throw new RuntimeException("Invalid flag '" + matchStr + "' in --check option");
        }
    }

    private static void initDisplay() {
        if (clDisplayType != 0) {
            int i;
            StringBuilder bg;
            int i2;
            for (i2 = 0; i2 < clQueryCount; ++i2) {
                if (clQueries.get(i2).getDim() >= 2) continue;
                clQueries.get(i2).clean(2, "");
            }
            for (i2 = 0; i2 < clTargetCount; ++i2) {
                if (clTargets.get(i2).getDim() >= 2) continue;
                clTargets.get(i2).clean(2, "");
            }
            clResultView = new MViewPane();
            clResultView.setAtomSetColor(1, NONHIT_COLOR);
            clResultView.setAtomSetColor(2, HIT_COLOR);
            clResultView.setBondSetColor(1, NONHIT_COLOR);
            clResultView.setBondSetColor(2, HIT_COLOR);
            if (clDisplayType == 1) {
                clResultView.setParams("border:1");
                clResultView.setParams("layout: :2:2 :M:0:0:1:2:c:b:10:20 :L:1:0:1:1:c:h:0:10 :L:1:1:1:1:c:h:0:10");
                clResultView.setParams("param: :M:300:200 :L:12 :L:12");
                clResultView.setParams("rows:" + clPairCount);
                clResultView.setParams("cols:2");
                clResultView.setParams("visibleRows:" + Math.min(3, clPairCount));
                String labelColor = "#e0e0e0";
                String altColor = "#f0f0ff";
                bg = new StringBuilder();
                bg.append("molbg:#ffffff");
                for (i = 1; i < clQueryCount; i += 2) {
                    for (int j = 0; j < clTargetCount; ++j) {
                        bg.append(String.format(",%d:%s", 2 * (i * clTargetCount + j), "#f0f0ff"));
                        bg.append(String.format(",%d:%s", 2 * (i * clTargetCount + j) + 1, "#f0f0ff"));
                    }
                }
                clResultView.setParams(bg.toString());
                clResultView.setParams("background:#e0e0e0");
            }
            if (clDisplayType == 2) {
                int j;
                clResultView.setParams("border:1");
                clResultView.setParams("layout: :2:1 :M:0:0:1:1:c:b:10:10 :L:1:0:1:1:c:h:0:10");
                clResultView.setParams("param: :M:300:200 :L:11");
                clResultView.setParams("rows:" + (clTargetCount + 1));
                clResultView.setParams("cols:" + (clQueryCount + 1));
                clResultView.setParams("visibleRows:" + Math.min(8, clTargetCount + 1));
                String labelColor = "#e0e8ff";
                String headerColor = "#c8d0ff";
                bg = new StringBuilder();
                bg.append("molbg:#ffffff,0:#e0e8ff");
                for (i = 0; i < clQueryCount; ++i) {
                    bg.append(String.format(",%d:%s", i + 1, "#c8d0ff"));
                }
                for (j = 0; j < clTargetCount; ++j) {
                    bg.append(String.format(",%d:%s", (j + 1) * (clQueryCount + 1), "#c8d0ff"));
                }
                clResultView.setParams(bg.toString());
                clResultView.setParams("background:#e0e8ff");
                for (i = 0; i < clQueryCount; ++i) {
                    clResultView.setM(i + 1, clQueries.get(i));
                    clResultView.setParams(String.format("cell%d_1:Query %d", i + 1, i + 1));
                }
                for (j = 0; j < clTargetCount; ++j) {
                    int cid = (j + 1) * (clQueryCount + 1);
                    clResultView.setM(cid, clTargets.get(j));
                    clResultView.setParams(String.format("cell%d_1:Target %d", cid, j + 1));
                }
            }
        }
    }

    private static void initOutput() {
        if (clOutputType == 1) {
            clOut.println("Query ID,Query,Query atom count,Query bond count,Target ID,Target,Target atom count,Target bond count,MCS,Atom count,Bond count,Component count,Similarity to query,Similarity to target");
        }
    }

    private static void displayResults() {
        if (clDisplayType != 0) {
            JFrame frame = new JFrame("MCS - Search Results");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().add(clResultView);
            frame.pack();
            if (clDisplayType == 2) {
                frame.setSize(640, 560);
            }
            if (clDisplayType == 1) {
                if (clPairCount == 1) {
                    frame.setSize(560, 300);
                } else {
                    frame.setSize(560, 560);
                }
            }
            frame.setVisible(true);
        }
    }

    private static void outputResults(int qi, int ti) throws IOException {
        Molecule qmol = clQueries.get(qi);
        Molecule tmol = clTargets.get(ti);
        Molecule result = clMCES.getAsMolecule();
        float qSimilarity = (float)result.getBondCount() / (float)qmol.getBondCount();
        float tSimilarity = (float)result.getBondCount() / (float)tmol.getBondCount();
        if (clOutputType == 0) {
            boolean last;
            if (clQueryCount == 1) {
                clOut.println("Query:              \t" + clQueryStrings.get(qi));
            } else {
                clOut.println("Query " + (qi + 1) + ":            \t" + clQueryStrings.get(qi));
            }
            if (clTargetCount == 1) {
                clOut.println("Target:             \t" + clTargetStrings.get(ti));
            } else {
                clOut.println("Target " + (ti + 1) + ":           \t" + clTargetStrings.get(ti));
            }
            clOut.println();
            if (result.getBondCount() == 0) {
                clOut.println("No common substructure found");
                clOut.println();
            } else {
                clOut.println("MCS:                 \t" + MolExporter.exportToFormat(result, "smiles"));
                clOut.println("Atom count:          \t" + clMCES.getAtomCount());
                clOut.println("Bond count:          \t" + clMCES.getBondCount());
                clOut.println("Component count:     \t" + clMCES.getComponentCount());
                clOut.println(String.format(clLocale, "Similarity to query: \t%.4f", Float.valueOf(qSimilarity)));
                clOut.println(String.format(clLocale, "Similarity to target:\t%.4f", Float.valueOf(tSimilarity)));
                clOut.println();
                if (clVerbose || clPairCount == 1) {
                    clOut.println("Atom mapping (query -> target):");
                    int[] map = clMCES.getAtomMapping();
                    for (int i = 0; i < map.length; ++i) {
                        if (map[i] < 0) continue;
                        clOut.println(i + 1 + " -> " + (map[i] + 1));
                    }
                    clOut.println();
                    clOut.println("Query molecule bonds:");
                    MolBond[] qb = clMCES.getMatchedQueryBonds();
                    for (int j = 0; j < qb.length; ++j) {
                        clOut.println(qmol.indexOf(qb[j].getAtom1()) + 1 + "-" + (qmol.indexOf(qb[j].getAtom2()) + 1));
                    }
                    clOut.println();
                    clOut.println("Target molecule bonds:");
                    MolBond[] tb = clMCES.getMatchedTargetBonds();
                    for (int j = 0; j < tb.length; ++j) {
                        clOut.println(tmol.indexOf(tb[j].getAtom1()) + 1 + "-" + (tmol.indexOf(tb[j].getAtom2()) + 1));
                    }
                    clOut.println();
                }
            }
            boolean bl = last = qi == clQueryCount - 1 && ti == clTargetCount - 1;
            if (!last) {
                clOut.print("------------------------------------------------------------------------");
                clOut.println();
                clOut.println();
            }
        }
        if (clOutputType == 1) {
            clOut.print(qi + 1 + "," + clQueryStrings.get(qi) + "," + qmol.getAtomCount() + "," + qmol.getBondCount() + "," + (ti + 1) + "," + clTargetStrings.get(qi) + "," + tmol.getAtomCount() + "," + tmol.getBondCount() + "," + result.toFormat("smiles") + "," + clMCES.getAtomCount() + "," + clMCES.getBondCount() + "," + clMCES.getComponentCount() + ",");
            clOut.println(String.format(clLocale, "%.4f,%.4f", Float.valueOf(qSimilarity), Float.valueOf(tSimilarity)));
        }
    }

    private static void displayResults(int qi, int ti) {
        int i;
        int[] map;
        Molecule qmol = clQueries.get(qi);
        Molecule tmol = clTargets.get(ti);
        Molecule result = clMCES.getAsMolecule();
        float qSimilarity = (float)result.getBondCount() / (float)qmol.getBondCount();
        float tSimilarity = (float)result.getBondCount() / (float)tmol.getBondCount();
        if (clDisplayType == 1) {
            int i2;
            map = clMCES.getAtomMapping();
            MolHandler mh = new MolHandler(qmol);
            mh.align(tmol, map);
            for (i2 = 0; i2 < qmol.getAtomCount(); ++i2) {
                qmol.getAtom(i2).setSetSeq(1);
            }
            for (i2 = 0; i2 < tmol.getAtomCount(); ++i2) {
                tmol.getAtom(i2).setSetSeq(1);
            }
            for (i2 = 0; i2 < map.length; ++i2) {
                if (map[i2] < 0) continue;
                qmol.getAtom(i2).setSetSeq(2);
                tmol.getAtom(map[i2]).setSetSeq(2);
            }
            if (clAtomMaps) {
                int am = 1;
                for (i = 0; i < map.length; ++i) {
                    if (map[i] < 0) continue;
                    qmol.getAtom(i).setAtomMap(am);
                    tmol.getAtom(map[i]).setAtomMap(am);
                    ++am;
                }
            }
            for (i2 = 0; i2 < qmol.getBondCount(); ++i2) {
                qmol.getBond(i2).setSetSeq(1);
            }
            for (i2 = 0; i2 < tmol.getBondCount(); ++i2) {
                tmol.getBond(i2).setSetSeq(1);
            }
            int[] bmap = clMCES.getBondMapping();
            for (i = 0; i < qmol.getBondCount(); ++i) {
                if (bmap[i] <= -1) continue;
                qmol.getBond(i).setSetSeq(2);
                tmol.getBond(bmap[i]).setSetSeq(2);
            }
            int qpos = 2 * (qi * clTargetCount + ti);
            int tpos = qpos + 1;
            clResultView.setM(qpos, qmol);
            clResultView.setM(tpos, tmol);
            if (clQueryCount == 1) {
                clResultView.setParams("cell" + qpos + "_1:Query");
            } else {
                clResultView.setParams("cell" + qpos + "_1:Query " + (qi + 1));
            }
            clResultView.setParams(String.format(clLocale, "cell%d_2:Similarity: %.2f", qpos, Float.valueOf(qSimilarity)));
            if (clTargetCount == 1) {
                clResultView.setParams("cell" + tpos + "_1:Target");
            } else {
                clResultView.setParams("cell" + tpos + "_1:Target " + (ti + 1));
            }
            clResultView.setParams(String.format(clLocale, "cell%d_2:Similarity: %.2f", tpos, Float.valueOf(tSimilarity)));
        }
        if (clDisplayType == 2) {
            result.clean(2, "");
            map = new int[qmol.getAtomCount()];
            int[] rmap = clMCES.getAtomReverseMapping();
            Arrays.fill(map, -1);
            int cnt = 0;
            for (i = 0; i < rmap.length; ++i) {
                if (rmap[i] == -1) continue;
                map[rmap[i]] = cnt++;
            }
            MolHandler mh = new MolHandler(qmol);
            mh.align(result, map);
            int pos = (ti + 1) * (clQueryCount + 1) + (qi + 1);
            clResultView.setM(pos, result);
            clResultView.setParams(String.format("cell%d_1:Q%d-T%d  %.2f / %.2f", pos, qi + 1, ti + 1, Float.valueOf(qSimilarity), Float.valueOf(tSimilarity)));
        }
    }

    private static void addMoleculeAsString(List<String> list, Molecule mol) throws IOException {
        try {
            list.add(MolExporter.exportToFormat(mol, "smiles"));
        }
        catch (IOException ex) {
            list.add(MolExporter.exportToFormat(mol, "mrv"));
        }
    }

    public static void main(String[] args) {
        try {
            int formatPos;
            int outPos;
            int sizePos;
            Molecule mol;
            Molecule mol2;
            CmdLine cmdLine = new CmdLine(args);
            if (cmdLine.isEmpty() || cmdLine.exists('h', "help")) {
                clOut.println(USAGE_INFO + EXAMPLES);
                return;
            }
            String queryStr = cmdLine.getParamString('q', "query");
            if (queryStr == null) {
                throw new ArgumentException("Missing query structure.");
            }
            MolImporter queryImporter = null;
            clQueries = new ArrayList<Molecule>();
            clQueryStrings = new ArrayList<String>();
            try {
                MolHandler mh = new MolHandler(queryStr);
                mol2 = mh.getMolecule();
                clQueries.add(mol2);
                MCES.addMoleculeAsString(clQueryStrings, mol2);
            }
            catch (MolFormatException e) {
                try {
                    MolInputStream mis = new MolInputStream(new FileInputStream(queryStr));
                    queryImporter = new MolImporter(mis);
                }
                catch (FileNotFoundException fe) {
                    throw new RuntimeException("File not found: " + queryStr);
                }
                while ((mol2 = queryImporter.read()) != null) {
                    clQueries.add(mol2);
                    MCES.addMoleculeAsString(clQueryStrings, mol2);
                }
            }
            clQueryCount = clQueries.size();
            String targetStr = cmdLine.getParamString('t', "target");
            if (targetStr == null) {
                throw new ArgumentException("Missing target structure.");
            }
            MolImporter targetImporter = null;
            clTargets = new ArrayList<Molecule>();
            clTargetStrings = new ArrayList<String>();
            try {
                MolHandler mh = new MolHandler(targetStr);
                mol = mh.getMolecule();
                clTargets.add(mol);
                MCES.addMoleculeAsString(clTargetStrings, mol);
            }
            catch (MolFormatException e) {
                try {
                    MolInputStream mis = new MolInputStream(new FileInputStream(targetStr));
                    targetImporter = new MolImporter(mis);
                }
                catch (FileNotFoundException fe) {
                    throw new RuntimeException("File not found: " + targetStr);
                }
                while ((mol = targetImporter.read()) != null) {
                    clTargets.add(mol);
                    MCES.addMoleculeAsString(clTargetStrings, mol);
                }
            }
            clTargetCount = clTargets.size();
            clMCES = new MCES();
            int modePos = cmdLine.find('m', "mode", 1);
            if (modePos != -1) {
                String modeStr = cmdLine.getString(modePos + 1);
                if (modeStr.equalsIgnoreCase("exhaustive") || modeStr.equalsIgnoreCase("exact") || modeStr.equalsIgnoreCase("e")) {
                    clMCES.setSearchMode(SearchMode.EXHAUSTIVE);
                } else if (modeStr.equalsIgnoreCase("standard") || modeStr.equalsIgnoreCase("s")) {
                    clMCES.setSearchMode(SearchMode.STANDARD);
                } else if (modeStr.equalsIgnoreCase("fast") || modeStr.equalsIgnoreCase("turbo") || modeStr.equalsIgnoreCase("f")) {
                    clMCES.setSearchMode(SearchMode.FAST);
                } else {
                    throw new RuntimeException("Invalid flag '" + modeStr + "' in --mode option");
                }
            }
            int matchPos = cmdLine.find('c', "check", 1, -1);
            int ignorePos = cmdLine.find('i', "ignore", 1, -1);
            if (matchPos == -1 && ignorePos > -1) {
                matchPos = ignorePos;
            }
            if (matchPos != -1) {
                for (int i = 0; i < cmdLine.getParamCount(matchPos); ++i) {
                    MCES.setMatchProperty(cmdLine.getString(matchPos + i + 1));
                }
            }
            if ((sizePos = cmdLine.find('s', "size", 1)) != -1) {
                clMCES.setMinComponentSize(cmdLine.getInt(sizePos + 1));
            }
            if (cmdLine.find('l', "largest") != -1) {
                clMCES.setKeepLargestComponent(true);
            }
            if ((outPos = cmdLine.find('o', "output", 1)) != -1) {
                String outFileName = cmdLine.getString(outPos + 1);
                try {
                    clOut = new PrintStream(new FileOutputStream(outFileName));
                }
                catch (FileNotFoundException fe) {
                    throw new RuntimeException("Cannot open output file: " + outFileName);
                }
            }
            if ((formatPos = cmdLine.find('f', "format", 1)) != -1) {
                String formatStr = cmdLine.getString(formatPos + 1);
                if (formatStr.equalsIgnoreCase("csv")) {
                    clOutputType = 1;
                } else {
                    throw new RuntimeException("Invalid flag '" + formatStr + "' in --format option");
                }
            }
            clDisplayType = 0;
            if (cmdLine.find('g', "grid") != -1) {
                clDisplayType = 2;
            } else if (cmdLine.find('w', "view") != -1 || cmdLine.find('w', "viewResult") != -1) {
                clDisplayType = 1;
            }
            clAtomMaps = cmdLine.find('a', "atommaps") != -1;
            boolean bl = clVerbose = cmdLine.find('v', "verbose") != -1;
            if (clVerbose) {
                clOut.println(PRG_HEADER);
            }
            if ((clPairCount = clQueryCount * clTargetCount) > 0) {
                MCES.initOutput();
                MCES.initDisplay();
                for (int qi = 0; qi != clQueryCount; ++qi) {
                    clMCES.setQueryMolecule(clQueries.get(qi));
                    for (int ti = 0; ti != clTargetCount; ++ti) {
                        clMCES.setTargetMolecule(clTargets.get(ti));
                        clMCES.search();
                        MCES.outputResults(qi, ti);
                        MCES.displayResults(qi, ti);
                    }
                }
                MCES.displayResults();
                clOut.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        clResultView = null;
        clMCES = null;
        NONHIT_COLOR = Color.BLACK;
        HIT_COLOR = new Color(1.0f, 0.5f, 0.0f);
    }

    public static enum TerminationCause {
        FINISHED,
        OPTIMAL,
        STEP_LIMIT,
        TIME_LIMIT;

    }

    public static enum SearchMode {
        FAST,
        STANDARD,
        EXHAUSTIVE;

    }
}

