/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modules.MCES;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class MCS
implements Licensable {
    public static final int DEFAULT_MIN_COMMON_SIZE = 5;
    public static final int MODE_EXACT = 1;
    public static final int MODE_TURBO = 3;
    public static final int MODE_FAST = 2;
    private Molecule queryMol;
    private Molecule targetMol;
    private MCES mces = new MCES();
    private String licenseEnvironment = "";

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("MCES", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("MCES", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecules(Molecule query, Molecule target) {
        this.queryMol = query;
        this.targetMol = target;
        this.mces.setMolecules(query, target);
    }

    public void setQuery(Molecule query) {
        this.queryMol = query;
        this.mces.setQueryMolecule(query);
    }

    public void setTarget(Molecule target) {
        this.targetMol = target;
        this.mces.setTargetMolecule(target);
    }

    public void setMinimumCommonSize(int minMCSsize) {
        this.mces.setMinComponentSize(minMCSsize);
    }

    public void setIgnoreAtomType(boolean ignore) {
        this.mces.setAtomTypeMatch(!ignore);
    }

    public void setIgnoreBondType(boolean ignore) {
        this.mces.setBondTypeMatch(!ignore);
    }

    public void setIgnoreCharge(boolean ignore) {
        this.mces.setChargeMatch(!ignore);
    }

    public void setIgnoreHybridization(boolean ignore) {
        this.mces.setHybridizationMatch(!ignore);
    }

    public void setIgnoreIsotopes(boolean ignore) {
        this.mces.setIsotopeMatch(!ignore);
    }

    public void setIgnoreQueryProperties(boolean ignore) {
        throw new UnsupportedOperationException();
    }

    public void setDontBreakRingBonds(boolean dontBreakRingBond) {
        throw new UnsupportedOperationException();
    }

    public void setMCSMode(boolean mcsMode) {
        throw new UnsupportedOperationException();
    }

    public void setMCESMode(boolean mcesMode) {
        throw new UnsupportedOperationException();
    }

    public void setSSSMode(boolean sssMode) {
        throw new UnsupportedOperationException();
    }

    public void setMode(int mcsMode) {
        if (mcsMode == 3) {
            this.mces.setSearchMode(MCES.SearchMode.FAST);
        }
        if (mcsMode == 2) {
            this.mces.setSearchMode(MCES.SearchMode.STANDARD);
        }
        if (mcsMode == 1) {
            this.mces.setSearchMode(MCES.SearchMode.EXHAUSTIVE);
        }
    }

    public void setFastSearch(boolean fastSearch) {
        this.setMode(3);
    }

    public boolean search() {
        this.checkLicense();
        this.mces.setKeepLargestComponent(true);
        return this.mces.search();
    }

    public boolean findFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean findNext() {
        throw new UnsupportedOperationException();
    }

    public int[] getResult() {
        return this.mces.getAtomMapping();
    }

    public int getResultSize() {
        return this.mces.getAtomCount();
    }

    public String getResultAsSmiles(boolean unique) {
        return this.mces.getAsMolecule().toFormat("smiles");
    }

    public Molecule getResultAsMolecule() {
        return this.mces.getAsMolecule();
    }

    public int[] getResultQueryAtoms() {
        int[] indexes = new int[this.mces.getAtomCount()];
        MolAtom[] atoms = this.mces.getMatchedQueryAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            indexes[i] = this.queryMol.indexOf(atoms[i]);
        }
        return indexes;
    }

    public int[] getResultTargetAtoms() {
        int[] indexes = new int[this.mces.getAtomCount()];
        MolAtom[] atoms = this.mces.getMatchedTargetAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            indexes[i] = this.targetMol.indexOf(atoms[i]);
        }
        return indexes;
    }

    public MolBond[] getResultQueryBonds() {
        return this.mces.getMatchedQueryBonds();
    }

    public MolBond[] getResultTargetBonds() {
        return this.mces.getMatchedTargetBonds();
    }
}

